Rem
Rem $Header: catcap.sql 27-jul-2004.16:30:02 mtao Exp $
Rem
Rem catcap.sql
Rem
Rem Copyright (c) 2001, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      catcap.sql - streams capture views
Rem
Rem    DESCRIPTION
Rem      This file contains all the views for streams capture
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mtao        06/28/04 - bug 3725878: modify dba_capture 
Rem    sbalaram    06/17/02 - Fix bug 2395423
Rem    nshodhan    03/19/02 - fix dba_capture.start_scn
Rem    narora      01/11/02 - add captured_scn, applied_scn
Rem    wesmith     01/09/02 - Streams export/import support
Rem    sbalaram    12/10/01 - use create or replace synonym
Rem    sbalaram    11/16/01 - Fix comments on some views
Rem    alakshmi    11/08/01 - Merged alakshmi_apicleanup
Rem    masubram    11/01/01 - modify views accessing  streams$_capture_object
Rem    sbalaram    10/29/01 - add views
Rem    apadmana    10/26/01 - Created
Rem

----------------------------------------------------------------------------
-- view to get capture process details
----------------------------------------------------------------------------

-- Private view select to all columns from streams$_capture_process
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_CAPTURE"
as select 
  queue_oid, queue_owner, queue_name, capture#, capture_name,
  status, ruleset_owner, ruleset_name, logmnr_sid, predumpscn,
  dumpseqbeg, dumpseqend, postdumpscn, flags, start_scn, capture_userid,
  spare1, spare2, spare3
from sys.streams$_capture_process
/
grant select on "_DBA_CAPTURE" to exp_full_database
/

create or replace view DBA_CAPTURE
  (CAPTURE_NAME, QUEUE_NAME, QUEUE_OWNER, RULE_SET_NAME,
  RULE_SET_OWNER, START_SCN, STATUS, CAPTURED_SCN, APPLIED_SCN,
  REQUIRED_CHECKPOINT_SCN, LOGMINER_ID)
as
select cp.capture_name, q.name, u.name, cp.ruleset_name,
       cp.ruleset_owner, cp.start_scn,
       decode(cp.status, 1, 'DISABLED',
                         2, 'ENABLED',
                         4, 'ABORTED', 'UNKNOWN'),
       cp.spare1, cp.spare2,
       least(nvl(cp.spare2,0), 
             dbms_logrep_util.get_req_ckpt_scn(cp.logmnr_sid)),
      cp.logmnr_sid
  from system.aq$_queues q, "_DBA_CAPTURE" cp,
       system.aq$_queue_tables t, sys.user$ u
 where cp.queue_oid = q.oid
   and q.table_objno = t.objno
   and u.name  = t.schema
/
comment on table DBA_CAPTURE is
'Details about the capture process'
/
comment on column DBA_CAPTURE.CAPTURE_NAME is
'Name of the capture process'
/
comment on column DBA_CAPTURE.QUEUE_NAME is
'Name of queue used for holding captured changes'
/
comment on column DBA_CAPTURE.QUEUE_OWNER is
'Owner of the queue used for holding captured changes'
/
comment on column DBA_CAPTURE.RULE_SET_NAME is
'Rule set used by capture process for filtering'
/
comment on column DBA_CAPTURE.RULE_SET_OWNER is
'Owner of the rule set'
/
comment on column DBA_CAPTURE.START_SCN is
'The SCN from which capturing will be resumed'
/
comment on column DBA_CAPTURE.STATUS is
'Status of the capture process: DISABLED, ENABLED, ABORTED'
/
comment on column DBA_CAPTURE.CAPTURED_SCN is
'Everything up to this SCN has been captured'
/
comment on column DBA_CAPTURE.APPLIED_SCN is
'Everything up to this SCN has been applied'
/
create or replace public synonym DBA_CAPTURE for DBA_CAPTURE
/
comment on column DBA_CAPTURE.REQUIRED_CHECKPOINT_SCN is
'the safe SCN at which the meta-data for the capture process can be purged'
/
comment on column DBA_CAPTURE.LOGMINER_ID is
'Session ID of LogMiner session associated with the capture process'
/
grant select on DBA_CAPTURE to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_CAPTURE
  (CAPTURE_NAME, QUEUE_NAME, QUEUE_OWNER, RULE_SET_NAME,
   RULE_SET_OWNER, START_SCN, STATUS)
as
select c.capture_name, c.queue_name, c.queue_owner, c.rule_set_name,
       c.rule_set_owner, c.start_scn, c.status
  from dba_capture c, all_queues q
 where c.queue_name = q.name
   and c.queue_owner = q.owner
   and c.rule_set_name is null
   and c.rule_set_owner is null
union all
select c.capture_name, c.queue_name, c.queue_owner, c.rule_set_name,
       c.rule_set_owner, c.start_scn, c.status
  from dba_capture c, all_queues q, all_rule_sets r
 where c.queue_name = q.name
   and c.queue_owner = q.owner
   and c.rule_set_name is not null
   and c.rule_set_name = r.rule_set_name
   and c.rule_set_owner is not null
   and c.rule_set_owner = r.rule_set_owner
/
comment on table ALL_CAPTURE is
'Details about each capture process that stores the captured changes in a queue visible to the current user'
/
comment on column ALL_CAPTURE.CAPTURE_NAME is
'Name of the capture process'
/
comment on column ALL_CAPTURE.QUEUE_NAME is
'Name of queue used for holding captured changes'
/
comment on column ALL_CAPTURE.QUEUE_OWNER is
'Owner of the queue used for holding captured changes'
/
comment on column ALL_CAPTURE.RULE_SET_NAME is
'Rule set used by capture process for filtering'
/
comment on column ALL_CAPTURE.RULE_SET_OWNER is
'Owner of the rule set'
/
comment on column ALL_CAPTURE.START_SCN is
'The SCN from which capturing will be resumed'
/
comment on column ALL_CAPTURE.STATUS is
'Status of the capture process: DISABLED, ENABLED, ABORTED'
/
create or replace public synonym ALL_CAPTURE for ALL_CAPTURE
/
grant select on ALL_CAPTURE to public with grant option
/

----------------------------------------------------------------------------
-- view to get capture process parameters
--
--  Note: process_type = 2 corresponds to the package variable
--        dbms_streams_adm_utl.streams_type_capture (prvtbsdm.sql)
--        and the macro KNLU_CAPTURE_PROC (knlu.h). This *must* be
--        kept in sync with both of these.
----------------------------------------------------------------------------
create or replace view DBA_CAPTURE_PARAMETERS
  (CAPTURE_NAME, PARAMETER, VALUE, SET_BY_USER)
as
select q.capture_name, p.name, p.value,
       decode(p.user_changed_flag, 1, 'YES', 'NO')
  from sys.streams$_process_params p, sys.streams$_capture_process q
 where p.process_type = 2
   and p.process# = q.capture#
   and /* display internal parameters if the user changed them */
       (p.internal_flag = 0
        or
        (p.internal_flag = 1 and p.user_changed_flag = 1)
       )
/
comment on table DBA_CAPTURE_PARAMETERS is
'All parameters for capture process'
/
comment on column DBA_CAPTURE_PARAMETERS.CAPTURE_NAME is
'Name of the capture process'
/
comment on column DBA_CAPTURE_PARAMETERS.PARAMETER is
'Name of the parameter'
/
comment on column DBA_CAPTURE_PARAMETERS.VALUE is
'Either the default value or the value set by the user for the parameter'
/
comment on column DBA_CAPTURE_PARAMETERS.SET_BY_USER is
'YES if the value is set by the user, NO otherwise'
/
create or replace public synonym DBA_CAPTURE_PARAMETERS
  for DBA_CAPTURE_PARAMETERS
/
grant select on DBA_CAPTURE_PARAMETERS to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_CAPTURE_PARAMETERS
  (CAPTURE_NAME, PARAMETER, VALUE, SET_BY_USER)
as
select cp.capture_name, cp.parameter, cp.value, cp.set_by_user
  from dba_capture_parameters cp, all_capture ac
 where cp.capture_name = ac.capture_name
/

comment on table ALL_CAPTURE_PARAMETERS is
'Details about parameters for each capture process that stores the captured changes in a queue visible to the current user'
/
/
comment on column ALL_CAPTURE_PARAMETERS.CAPTURE_NAME is
'Name of the capture process'
/
comment on column ALL_CAPTURE_PARAMETERS.PARAMETER is
'Name of the parameter'
/
comment on column ALL_CAPTURE_PARAMETERS.VALUE is
'Either the default value or the value set by the user for the parameter'
/
comment on column ALL_CAPTURE_PARAMETERS.SET_BY_USER is
'YES if the value is set by the user, NO otherwise'
/
create or replace public synonym ALL_CAPTURE_PARAMETERS
  for ALL_CAPTURE_PARAMETERS
/
grant select on ALL_CAPTURE_PARAMETERS to public with grant option
/

----------------------------------------------------------------------------
-- view to check if a database is prepared for instantiation
----------------------------------------------------------------------------
create or replace view DBA_CAPTURE_PREPARED_DATABASE (TIMESTAMP)
as
select timestamp from streams$_prepare_ddl
 where usrid is NULL
   and global_flag = 1
/
comment on table DBA_CAPTURE_PREPARED_DATABASE is
'Is the local database prepared for instantiation?'
/
comment on column DBA_CAPTURE_PREPARED_DATABASE.TIMESTAMP is
'Time at which the database was ready to be instantiated'
/
create or replace public synonym DBA_CAPTURE_PREPARED_DATABASE
  for DBA_CAPTURE_PREPARED_DATABASE
/
grant select on DBA_CAPTURE_PREPARED_DATABASE to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_CAPTURE_PREPARED_DATABASE (TIMESTAMP)
as
select * from DBA_CAPTURE_PREPARED_DATABASE
/
comment on table ALL_CAPTURE_PREPARED_DATABASE is
'Is the local database prepared for instantiation?'
/
comment on column ALL_CAPTURE_PREPARED_DATABASE.TIMESTAMP is
'Time at which the database was ready to be instantiated'
/
create or replace public synonym ALL_CAPTURE_PREPARED_DATABASE
  for ALL_CAPTURE_PREPARED_DATABASE
/
grant select on ALL_CAPTURE_PREPARED_DATABASE to public with grant option
/

----------------------------------------------------------------------------
-- view to get the schemas prepared for instantiation
----------------------------------------------------------------------------
create or replace view DBA_CAPTURE_PREPARED_SCHEMAS
  (SCHEMA_NAME, TIMESTAMP)
as
select u.username, pd.timestamp
  from streams$_prepare_ddl pd, dba_users u
 where u.user_id = pd.usrid
/
comment on table DBA_CAPTURE_PREPARED_SCHEMAS is
'All schemas at the local database that are prepared for instantiation'
/
comment on column DBA_CAPTURE_PREPARED_SCHEMAS.SCHEMA_NAME is
'Name of schema prepared for instantiation'
/
comment on column DBA_CAPTURE_PREPARED_SCHEMAS.TIMESTAMP is
'Time at which the schema was ready to be instantiated'
/
create or replace public synonym DBA_CAPTURE_PREPARED_SCHEMAS
  for DBA_CAPTURE_PREPARED_SCHEMAS
/
grant select on DBA_CAPTURE_PREPARED_SCHEMAS to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_CAPTURE_PREPARED_SCHEMAS
  (SCHEMA_NAME, TIMESTAMP)
as
select s.schema_name, s.timestamp
  from dba_capture_prepared_schemas s, all_users u
 where s.schema_name = u.username
/

comment on table ALL_CAPTURE_PREPARED_SCHEMAS is
'All user schemas at the local database that are prepared for instantiation'
/
comment on column ALL_CAPTURE_PREPARED_SCHEMAS.SCHEMA_NAME is
'Name of schema prepared for instantiation'
/
comment on column ALL_CAPTURE_PREPARED_SCHEMAS.TIMESTAMP is
'Time at which the schema was ready to be instantiated'
/
create or replace public synonym ALL_CAPTURE_PREPARED_SCHEMAS
  for ALL_CAPTURE_PREPARED_SCHEMAS
/
grant select on ALL_CAPTURE_PREPARED_SCHEMAS to public with grant option
/

----------------------------------------------------------------------------
-- view to get the tables prepared for instantiation
----------------------------------------------------------------------------
create or replace view DBA_CAPTURE_PREPARED_TABLES
  (TABLE_OWNER, TABLE_NAME, SCN, TIMESTAMP)
as
select o.owner, substr(o.object_name, 1, 30), co.ignore_scn, co.timestamp
  from streams$_prepare_object co, dba_objects o
 where o.object_id = co.obj#
/
comment on table DBA_CAPTURE_PREPARED_TABLES is
'All tables prepared for instantiation'
/
comment on column DBA_CAPTURE_PREPARED_TABLES.TABLE_OWNER is
'Owner of the table prepared for instantiation'
/
comment on column DBA_CAPTURE_PREPARED_TABLES.TABLE_NAME is
'Name of the table prepared for instantiation'
/
comment on column DBA_CAPTURE_PREPARED_TABLES.SCN is
'SCN from which changes can be captured'
/
comment on column DBA_CAPTURE_PREPARED_TABLES.TIMESTAMP is
'Time at which the table was ready to be instantiated'
/
create or replace public synonym DBA_CAPTURE_PREPARED_TABLES
  for DBA_CAPTURE_PREPARED_TABLES
/
grant select on DBA_CAPTURE_PREPARED_TABLES to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_CAPTURE_PREPARED_TABLES
  (TABLE_OWNER, TABLE_NAME, SCN, TIMESTAMP)
as
select pt.table_owner, pt.table_name, pt.scn, pt.timestamp
  from dba_capture_prepared_tables pt, all_tables at
 where pt.table_name = at.table_name
   and pt.table_owner = at.owner
/

comment on table ALL_CAPTURE_PREPARED_TABLES is
'All tables visible to the current user that are prepared for instantiation'
/
comment on column ALL_CAPTURE_PREPARED_TABLES.TABLE_OWNER is
'Owner of the table prepared for instantiation'
/
comment on column ALL_CAPTURE_PREPARED_TABLES.TABLE_NAME is
'Name of the table prepared for instantiation'
/
comment on column ALL_CAPTURE_PREPARED_TABLES.SCN is
'SCN from which changes can be captured'
/
comment on column ALL_CAPTURE_PREPARED_TABLES.TIMESTAMP is
'Time at which the table was ready to be instantiated'
/
create or replace public synonym ALL_CAPTURE_PREPARED_TABLES
  for ALL_CAPTURE_PREPARED_TABLES
/
grant select on ALL_CAPTURE_PREPARED_TABLES to public with grant option
/

----------------------------------------------------------------------------
create or replace view "_DBA_REGISTERED_ARCHIVED_LOG"
  (consumer_name, thread#,
   sequence#, first_scn, next_scn, first_time, next_time,
   name, modified_time, dictionary_begin,
   dictionary_end, purgeable)
as
select cp.capture_name, 
       l.thread#, l.sequence#, l.first_change#,
       l.next_change#, l.first_time, l.next_time,
       l.file_name, l.timestamp,
       l.dict_begin, l.dict_end,  
       decode(bitand(l.status, 2), 2, 'YES', 'NO') 
  from system.logmnr_log$ l, sys.streams$_capture_process cp
  where l.session# = cp.logmnr_sid
/

 ---------------------------------------------------------------------------

create or replace view GV_$STREAMS_CAPTURE
as
select * from gv$streams_capture;
create or replace public synonym GV$STREAMS_CAPTURE for GV_$STREAMS_CAPTURE;
grant select on GV_$STREAMS_CAPTURE to select_catalog_role;

----------------------------------------------------------------------------

create or replace view V_$STREAMS_CAPTURE
as
select * from v$streams_capture;
create or replace public synonym V$STREAMS_CAPTURE for V_$STREAMS_CAPTURE;
grant select on V_$STREAMS_CAPTURE to select_catalog_role;

