Rem
Rem $Header: catcdc.sql 29-apr-2002.03:23:41 desinha Exp $
Rem
Rem catcdc.sql
Rem
Rem Copyright (c) 2000, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catcdc.sql - catalog views FOR change data capture
Rem
Rem    DESCRIPTION
Rem      defines publisher- AND susbscriber-side views FOR change data Capture
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    desinha     04/29/02 - #2303866: change user => userenv('SCHEMAID')
Rem    wnorcott    01/15/02 - user_source_tab_columns.
Rem    wnorcott    01/04/02 - bug-2170929 fix USER_SOURCE_TAB_COLUMNS view.
Rem    wnorcott    09/06/01 - bug 1973738.
Rem    gviswana    05/24/01 - CREATE OR REPLACE SYNONYM
Rem    wnorcott    06/28/00 - rid logmnr_dict view
Rem    wnorcott    06/27/00 - Add view sys.logmnr_dict
Rem    aime        06/21/00 - resolve tkzdicz1.dif
Rem    wnorcott    06/08/00 - Change Data Capture catalog views
Rem    wnorcott    06/08/00 - Created
Rem
REM Views for Change Data Capture  
CREATE OR REPLACE VIEW change_sources 
  (source_name, dbid, log_directory, logfile_pattern, 
  source_description, created)
  AS 
  SELECT 
  s.source_name, s.dbid, s.logfile_location, s.logfile_suffix, 
    s.source_description, s.created
    FROM sys.cdc_change_sources$ s
/
CREATE OR REPLACE public synonym change_sources for change_sources
/
GRANT select on change_sources to select_catalog_role
/
CREATE OR REPLACE VIEW change_sets
  (set_name, change_source_name, begin_date, end_date, begin_scn, 
  end_scn, freshness_date, freshness_scn, advance_enabled, 
  ignore_ddl, created,
  rollback_segment_name, advancing, purging, lowest_scn, tablespace)
  AS 
  SELECT
  s.set_name, s.change_source_name, s.begin_date, s.end_date, 
    s.begin_scn, s.end_scn, s.freshness_date, s.freshness_scn,
    s.advance_enabled, s.ignore_ddl, s.created,
    s.rollback_segment_name, s.advancing, s.purging, s.lowest_scn, 
    s.tablespace  
    FROM sys.cdc_change_sets$ s
/
CREATE OR REPLACE public synonym change_sets for change_sets
/
GRANT select on change_sets to select_catalog_role
/
CREATE OR REPLACE VIEW change_tables
  (change_table_schema, change_table_name, 
  change_set_name, source_schema_name, 
  source_table_name, created, created_scn, captured_values)
  AS 
  SELECT
  s.change_table_schema, s.change_table_name, 
    s.change_set_name, s.source_schema_name, 
    s.source_table_name, s.created, s.created_scn, s.captured_values
    FROM sys.cdc_change_tables$ s
/
CREATE OR REPLACE public synonym change_tables for change_tables
/
GRANT select on change_tables to select_catalog_role
/

    
CREATE OR REPLACE VIEW all_source_tables
  (source_schema_name, source_table_name)
  AS 
  SELECT
  distinct s.source_schema_name, s.source_table_name
    FROM sys.cdc_change_tables$ s, all_tables t
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
/
CREATE OR REPLACE public synonym all_source_tables for all_source_tables
/
GRANT select on all_source_tables to public
/
CREATE OR REPLACE public synonym dba_source_tables for all_source_tables
/
GRANT select on dba_source_tables to public
/
    
CREATE OR REPLACE VIEW dba_source_tables
  (source_schema_name, source_table_name)
  AS 
  SELECT
  distinct s.source_schema_name, s.source_table_name
    FROM sys.cdc_change_tables$ s, all_tables t
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
/
CREATE OR REPLACE public synonym dba_source_tables for dba_source_tables
/
GRANT select on dba_source_tables to select_catalog_role
/
    
        
CREATE OR REPLACE VIEW user_source_tables
  (source_schema_name, source_table_name)
  AS 
  SELECT
  distinct s.source_schema_name, s.source_table_name
    FROM sys.cdc_change_tables$ s, all_tables t
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
/
CREATE OR REPLACE public synonym user_source_tables for user_source_tables
/
GRANT select on user_source_tables to public
/

CREATE OR REPLACE VIEW all_source_tab_columns
  (source_schema_name, source_table_name, column_name,
  data_type, data_length, data_precision, data_scale, nullable)
  AS 
  SELECT
  s.source_schema_name, s.source_table_name, c.column_name,
    c.data_type, c.data_length, c.data_precision, c.data_scale, c.nullable
    FROM sys.cdc_change_tables$ s, all_tables t, all_tab_columns c
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
    AND c.owner=s.change_table_schema
    AND c.table_name=s.change_table_name
    AND c.column_name NOT LIKE '%$'
/
CREATE OR REPLACE public synonym all_source_tab_columns
   for all_source_tab_columns
/
GRANT select on all_source_tab_columns to public
/
    
CREATE OR REPLACE VIEW dba_source_tab_columns
  (source_schema_name, source_table_name, column_name,
  data_type, data_length, data_precision, data_scale, nullable)
  AS 
  SELECT
  s.source_schema_name, s.source_table_name, c.column_name,
    c.data_type, c.data_length, c.data_precision, c.data_scale, c.nullable
    FROM sys.cdc_change_tables$ s, all_tables t, all_tab_columns c
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
    AND c.owner=s.change_table_schema
    AND c.table_name=s.change_table_name
    AND c.column_name NOT LIKE '%$'
/
CREATE OR REPLACE public synonym dba_source_tab_columns
   for dba_source_tab_columns
/
GRANT select on dba_source_tab_columns to select_catalog_role
/
    
CREATE OR REPLACE VIEW user_source_tab_columns
  (source_schema_name, source_table_name, column_name,
  data_type, data_length, data_precision, data_scale, nullable)
  AS 
  SELECT
  s.source_schema_name, s.source_table_name, c.column_name,
    c.data_type, c.data_length, c.data_precision, c.data_scale, c.nullable
    FROM sys.cdc_change_tables$ s, all_tables t, all_tab_columns c
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
    AND c.owner=s.change_table_schema
    AND c.table_name=s.change_table_name
    AND c.column_name NOT LIKE '%$'
/
CREATE OR REPLACE public synonym user_source_tab_columns
   for user_source_tab_columns
/
GRANT select on user_source_tab_columns to public
/

Rem    Bill Norcott    09/06/01 - bug 1973738.  Was missing *_published_columns    
Rem William.Norcott@oracle.com
Rem
CREATE OR REPLACE VIEW all_published_columns
  (change_set_name, source_schema_name, source_table_name, 
  pub_id, column_name,
  data_type, data_length, data_precision, data_scale, nullable)
  AS 
  SELECT
  s.change_set_name, s.source_schema_name, s.source_table_name, 
    s.obj#, c.column_name,
    c.data_type, c.data_length, c.data_precision, c.data_scale, c.nullable
    FROM sys.cdc_change_tables$ s, all_tables t, all_tab_columns c
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
    AND c.owner=s.change_table_schema
    AND c.table_name=s.change_table_name
    AND c.column_name NOT LIKE '%$'
/
CREATE OR REPLACE public synonym all_published_columns
   for all_published_columns
/
GRANT select on all_published_columns to public
/
CREATE OR REPLACE VIEW dba_published_columns
  (change_set_name, change_table_schema, change_table_name, pub_id, 
  source_schema_name, source_table_name, column_name,
  data_type, data_length, data_precision, data_scale, nullable)
  AS 
  SELECT
  s.change_set_name, s.change_table_schema, s.change_table_name, s.obj#,
    s.source_schema_name, s.source_table_name, c.column_name,
    c.data_type, c.data_length, c.data_precision, c.data_scale, c.nullable
    FROM sys.cdc_change_tables$ s, all_tables t, all_tab_columns c
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
    AND c.owner=s.change_table_schema
    AND c.table_name=s.change_table_name
    AND c.column_name NOT LIKE '%$'
/
CREATE OR REPLACE public synonym dba_published_columns
   for dba_published_columns
/
GRANT select on dba_published_columns to public
/
CREATE OR REPLACE VIEW user_published_columns
  (source_schema_name, source_table_name, column_name,
  data_type, data_length, data_precision, data_scale, nullable)
  AS 
  SELECT
    c.owner, c.table_name, c.column_name,
    c.data_type, c.data_length, c.data_precision, c.data_scale, c.nullable
    FROM sys.cdc_change_tables$ s, all_tables t, all_tab_columns c
    WHERE s.change_table_schema=t.owner 
    AND s.change_table_name=t.table_name
    AND c.owner=s.change_table_schema
    AND c.table_name=s.change_table_name
    AND c.column_name NOT LIKE '%$'
/
CREATE OR REPLACE public synonym user_published_columns
   for user_published_columns
/
GRANT select on user_published_columns to public
/
    
    
    
CREATE OR REPLACE VIEW all_subscriptions
      (handle, set_name, username, created, status, earliest_scn, 
      latest_scn, description, last_purged, last_extended)
  AS
  SELECT s.handle, s.set_name, s.username, s.created, 
    s.status, s.earliest_scn,
    s.latest_scn, s.description, s.last_purged, s.last_extended
    FROM sys.cdc_subscribers$ s
/
CREATE OR REPLACE public synonym all_subscriptions for all_subscriptions
/
GRANT select on all_subscriptions to public
/
      
CREATE OR REPLACE VIEW dba_subscriptions
  (handle, set_name, username, created, status, earliest_scn, 
  latest_scn, description, last_purged, last_extended)
  AS
  SELECT s.handle, s.set_name, s.username, s.created, s.status, 
    s.earliest_scn,
    s.latest_scn, s.description, s.last_purged, s.last_extended
    FROM sys.cdc_subscribers$ s
/
CREATE OR REPLACE public synonym dba_subscriptions for dba_subscriptions
/
GRANT select on dba_subscriptions to select_catalog_role
/
      
CREATE OR REPLACE VIEW user_subscriptions
  (handle, set_name, username, created, status, earliest_scn, 
  latest_scn, description, last_purged, last_extended)
  AS
  SELECT s.handle, s.set_name, s.username, s.created, 
    s.status, s.earliest_scn,
    s.latest_scn, s.description, s.last_purged, s.last_extended
    FROM sys.cdc_subscribers$ s, sys.user$ u
    WHERE s.username= u.name
    and   u.user#   = USERENV('SCHEMAID')
/
CREATE OR REPLACE public synonym user_subscriptions for user_subscriptions
/
GRANT select on user_subscriptions to public
/
      
CREATE OR REPLACE VIEW all_subscribed_tables
  (handle, source_schema_name, source_table_name, 
  view_name, change_set_name)
  AS 
  SELECT
  s.handle, t.source_schema_name, t.source_table_name,
    s.view_name, t.change_set_name
    FROM sys.cdc_subscribed_tables$ s, sys.cdc_change_tables$ t
    WHERE s.change_table_obj#=t.obj#
/
CREATE OR REPLACE public synonym all_subscribed_tables
   for all_subscribed_tables
/
GRANT select on all_subscribed_tables to public
/

CREATE OR REPLACE VIEW dba_subscribed_tables
  (handle, source_schema_name, source_table_name, 
  view_name, change_set_name)
  AS 
  SELECT
  s.handle, t.source_schema_name, t.source_table_name,
    s.view_name, t.change_set_name
    FROM sys.cdc_subscribed_tables$ s, sys.cdc_change_tables$ t
    WHERE s.change_table_obj#=t.obj#
/
CREATE OR REPLACE public synonym dba_subscribed_tables
   for dba_subscribed_tables
/
GRANT select on dba_subscribed_tables to select_catalog_role
/


CREATE OR REPLACE VIEW user_subscribed_tables
  (handle, source_schema_name, source_table_name, 
  view_name, change_set_name)
  AS 
  SELECT
  s.handle, t.source_schema_name, t.source_table_name,
    s.view_name, t.change_set_name
    FROM sys.cdc_subscribed_tables$ s, sys.cdc_change_tables$ t,
    sys.cdc_subscribers$ u, sys.user$ su
    WHERE s.change_table_obj#=t.obj#
    AND s.handle=u.handle
    AND u.username= su.name
    AND su.user#= USERENV('SCHEMAID')
/
CREATE OR REPLACE public synonym user_subscribed_tables
   for user_subscribed_tables
/
GRANT select on user_subscribed_tables to public
/

CREATE OR REPLACE VIEW all_subscribed_columns
  (handle, source_schema_name, source_table_name, column_name)
  AS
  SELECT
  s.handle, t.source_schema_name, t.source_table_name,
    s.column_name
    FROM sys.cdc_subscribed_columns$ s, sys.cdc_change_tables$ t  
    WHERE s.change_table_obj#=t.obj#
/
CREATE OR REPLACE public synonym all_subscribed_columns
   for all_subscribed_columns
/
GRANT select on all_subscribed_columns to public
/
    

CREATE OR REPLACE VIEW dba_subscribed_columns
  (handle, source_schema_name, source_table_name, column_name)
  AS
  SELECT
  s.handle, t.source_schema_name, t.source_table_name,
    s.column_name
    FROM sys.cdc_subscribed_columns$ s, sys.cdc_change_tables$ t  
    WHERE s.change_table_obj#=t.obj#
/
CREATE OR REPLACE public synonym dba_subscribed_columns
   for dba_subscribed_columns
/
GRANT select on dba_subscribed_columns to select_catalog_role
/
    

CREATE OR REPLACE VIEW user_subscribed_columns
  (handle, source_schema_name, source_table_name, column_name)
  AS
  SELECT
  s.handle, t.source_schema_name, t.source_table_name,
    s.column_name
    FROM sys.cdc_subscribed_columns$ s, sys.cdc_change_tables$ t,
    sys.cdc_subscribers$ u, sys.user$ su
    WHERE s.change_table_obj#=t.obj#
    AND s.handle=u.handle
    AND u.username = su.name
    AND su.user#   = userenv('SCHEMAID')
/
CREATE OR REPLACE public synonym user_subscribed_columns
   for user_subscribed_columns
/
GRANT select on user_subscribed_columns to public
/
