Rem
Rem $Header: catjava.sql 13-jun-2002.10:21:45 rburns Exp $
Rem
Rem catjava.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catjava.sql - CATalog scripts for JAVA
Rem
Rem    DESCRIPTION
Rem      This script loads the java classes for RDBMS features; it
Rem      should be run after JAVA is loaded into the database.  The
Rem      CATNOJAV.SQL script should be used to remove these java 
Rem      classes prior to removing JAVA from the database.
Rem
Rem    NOTES
Rem      Use SQL*Plus when connected AS SYSDBA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      06/13/02 - comments for catnojav.sql
Rem    rburns      04/05/02 - continue even if Jserver not valid
Rem    rburns      02/11/02 - add registry version
Rem    rburns      01/12/02 - Merged rburns_catjava
Rem    rburns      12/03/01 - Created
Rem

/* ##########################################################################
   ##########################################################################
   If the following PL/SQL block fails, then JServer is not operational.
   ##########################################################################
   ##########################################################################
*/

BEGIN
   IF dbms_registry.is_loaded('JAVAVM') != 1 THEN
      RAISE_APPLICATION_ERROR(-20000,
           'JServer has not been correctly loaded into the database.');   
   END IF;
END;
/

BEGIN
   dbms_registry.loading('CATJAVA','Oracle9i Java Packages',
        'DBMS_REGISTRY_SYS.validate_catjava');
END;
/

VARIABLE initfile VARCHAR2(12)
COLUMN :initfile NEW_VALUE init_file NOPRINT;

Rem =====================================================================
Rem Change Data Capture
Rem =====================================================================

BEGIN
  IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
     :initfile := 'initcdc.sql';
  ELSE
     :initfile := 'nothing.sql';
  END IF;
END;
/
SELECT :initfile FROM DUAL;
@@&init_file

Rem =====================================================================
Rem Summary Advisor
Rem =====================================================================

BEGIN
  IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
     :initfile := 'initqsma.sql';
  ELSE
     :initfile := 'nothing.sql';
  END IF;
END;
/
SELECT :initfile FROM DUAL;
@@&init_file

Rem =====================================================================
Rem SQLJTYPE
Rem =====================================================================

BEGIN
  IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
     :initfile := 'initsjty.sql';
  ELSE
     :initfile := 'nothing.sql';
  END IF;
END;
/
SELECT :initfile FROM DUAL;
@@&init_file

Rem =====================================================================
Rem AQ JMS
Rem =====================================================================

BEGIN
  IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
     :initfile := 'initjms.sql';
  ELSE
     :initfile := 'nothing.sql';
  END IF;
END;
/
SELECT :initfile FROM DUAL;
@@&init_file

Rem =====================================================================
Rem Application Context
Rem =====================================================================

BEGIN
  IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
     :initfile := 'initapcx.sql';
  ELSE
     :initfile := 'nothing.sql';
  END IF;
END;
/
SELECT :initfile FROM DUAL;
@@&init_file

Rem =====================================================================
Rem ODCI and Cartridge Services
Rem =====================================================================

BEGIN
  IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
     :initfile := 'initsoxx.sql';
  ELSE
     :initfile := 'nothing.sql';
  END IF;
END;
/
SELECT :initfile FROM DUAL;
@@&init_file


Rem =====================================================================
Rem Only set status to LOADED if JServer is loaded
Rem =====================================================================

BEGIN
   IF dbms_registry.is_loaded('JAVAVM') = 1 THEN
      dbms_registry.loaded('CATJAVA',dbms_registry.release_version,
                'Oracle9i Java Packages Release ' ||
                dbms_registry.release_version || 
                ' - ' || dbms_registry.release_status);
      dbms_registry_sys.validate_catjava;
   END IF;
END;
/

Rem *********************************************************************
/*
 END CATJAVA.SQL */
Rem *********************************************************************
