Rem
Rem $Header: catlsby.sql 03-jun-2004.16:30:14 raguzman Exp $
Rem
Rem catlsby.sql
Rem
Rem Copyright (c) 2000, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      catlsby.sql - Logical Standby tables and views
Rem
Rem    DESCRIPTION
Rem      This file implements the following:
Rem      Tables:
Rem         logstdby$parameters
Rem         logstdby$events
Rem         logstdby$apply_progress
Rem         logstdby$apply_milestone
Rem         logstdby$event_options
Rem         logstdby$scn
Rem         logstdby$skip_transaction
Rem         logstdby$skip
Rem         logstdby$skip_support
Rem
Rem    NOTES
Rem      Must be run when connected to SYS or INTERNAL
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    raguzman    06/03/04 - do not show type 2 parameters in 
Rem                           dba_logstdby_parameters 
Rem    smangala    05/20/03 - fix bug#2691312: ignore gaps for newest_scn
Rem    raguzman    01/06/03 - fix unsupported views
Rem    rguzman     08/13/02 - Virtual columns (functional index) unsupported
Rem    rguzman     07/19/02 - update views for data type support
Rem    rguzman     07/19/02 - do not drop tables, needed for upgrades
Rem    jmzhang     06/26/02 - UPdate DBA_LOGSTDBY_PROGRESS
Rem    jmzhang     06/26/02 - Update DBA_LOGSTDBY_LOG
Rem    rguzman     07/07/02 - DBA_LOGSTDBY_PROGRESS must work on RAC
Rem    rguzman     04/13/02 - Update DBA_LOGSTDBY_UNSUPPORTED
Rem    gviswana    01/29/02 - CREATE OR REPLACE SYNONYM
Rem    narora      01/17/02 - milestone.spare1 = oldest scn,
Rem                         - spare2=primary syncpoint scn
Rem    rguzman     01/24/02 - Modify UNSUPPORTED view, no ADTs
Rem    cfreiwal    11/14/01 - move logstby views to catlsby.sql
Rem    rguzman     10/12/01 - New columns for logstdby$paramters.
Rem    narora      09/21/01 - remove logstdby_coordinator/slave
Rem    dcassine    08/27/01 - 
Rem    rguzman     09/12/01 - PROGRESS view to report better progress
Rem    dcassine    08/27/01 - LOGSTDBY$APPLY_MILESTONE.PROCESSED_SCN
Rem    jnesheiw    08/02/01 - skip_transaction spare1 name change.
Rem    rguzman     05/18/01 - Fix skip default.
Rem    rguzman     05/17/01 - No Long/Lob support for Alpha kit.
Rem    sslim       05/11/01 - Drop tables before creating them
Rem    jdavison    10/12/00 - Change varchar sizes to 2000.
Rem    narora      08/01/00 - make apply progress a partitioned table
Rem    rguzman     08/11/00 - Views: synonyms, snapshot logs & functional index
Rem    narora      06/20/00 - grant select on v$logstdby_coordinator, 
Rem                         - v$logstdby_apply
Rem    rguzman     05/26/00 - Add views
Rem    rguzman     04/11/00 - Created
Rem

-- This is needed so that SYS can later grant select_catalog to the views.
grant select any table to sys with admin option
/

create table system.logstdby$parameters (
  name            varchar2(30),			/* The name of the parameter */
  value           varchar2(2000),	       /* The value of the parameter */
  type            number,                 /* null = internal, 1 = persistent */
  scn             number,                          /* null or meaningful scn */
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

create table system.logstdby$events (
  event_time	  date,			   /* The time the event took effect */
  current_scn     number,	     /* The change vector SCN for the change */
  commit_scn      number,     /* SCN of commit record for failed transaction */
  xidusn          number,      /* Trans id component of a failed transaction */
  xidslt          number,      /* Trans id component of a failed transaction */
  xidsqn          number,      /* Trans id component of a failed transaction */
  errval          number,				     /* Error number */
  event           varchar2(2000),      /* first 2000 characters of statement */
  full_event      clob,				   /* The complete statement */
  error           varchar2(2000),      /* error text associated with failure */
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)				 /* Future expansion */
)
/


-- Turns off partition check --
alter session set events  '14524 trace name context forever, level 1';

create table system.logstdby$apply_progress (
  xidusn          number,    /* Trans id component of an applied transaction */
  xidslt          number,    /* Trans id component of an applied transaction */
  xidsqn          number,    /* Trans id component of an applied transaction */
  commit_scn      number,    /* SCN of commit record for applied transaction */
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)				 /* Future expansion */
)
partition by range (commit_scn) (partition P0 values less than (0))
/

create table system.logstdby$apply_milestone (
  session_id      number not null,		     /* Log miner session id */
  commit_scn      number not null,			   /* low-water mark */
  synch_scn       number not null,			 /* Synch-point SCN. */
  epoch           number not null,    /* Incarnation number for apply engine */
  processed_scn   number not null, /* all comp txn<processed_scn are applied */
  spare1          number,				 /* oldest_scn       */
  spare2          number,		            /* primary syncpoint scn */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

Rem   Logical Instantiation, beginning scn for each table.
create table system.logstdby$scn
(
  obj#	    number,
  scn	    number,
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

create table system.logstdby$plsql (
  session_id      number,		/* Id of session issuing the command */
  start_finish    number,	 /* Boolean, 0 = 1st record, 1 = last record */
  call_text       clob,			  /* Text of call to pl/sql routine. */
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

create table system.logstdby$skip_transaction (
  xidusn          number,    /* Trans id component of an applied transaction */
  xidslt          number,    /* Trans id component of an applied transaction */
  xidsqn          number,    /* Trans id component of an applied transaction */
  active          number,	    /* Boolean to indicate current or active */
  commit_scn      number,		     /* SCN at which tx commited at  */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

create table system.logstdby$skip (
  error		  number,	     /* Should statement or error be skipped */
  statement_opt	  varchar2(30), /* name from audit_actions or logstdby$skip_support */
  schema	  varchar2(30),	     /* schema name for object being skipped */
  name		  varchar2(30),		     /* name of object being skipped */
  proc		  varchar2(98),	     /* schema.package.proc to call for skip */
  active          number,	    /* Boolean to indicate current or active */
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

Rem   Statement auditting options for objects encoded here for skip support
Rem   It's ok to drop this table, contains only these rows ever
drop table system.logstdby$skip_support
/
create table system.logstdby$skip_support (
  action	  number not null,    /* number as seen in sys.audit_actions */
  name		  varchar2(27) not null,		   /* action to skip */
  spare1          number,				 /* Future expansion */
  spare2          number,				 /* Future expansion */
  spare3          varchar2(2000)			 /* Future expansion */
)
/

insert into system.logstdby$skip_support			   /* INSERT */
             (action, name) values (2, 'DML');
insert into system.logstdby$skip_support			   /* UPDATE */
             (action, name) values (6, 'DML');
insert into system.logstdby$skip_support			   /* DELETE */
             (action, name) values (7, 'DML');

		      /* SCHEMA_DDL & NONSCHEMA_DDL computed during start up */

insert into system.logstdby$skip_support		   /* CREATE CLUSTER */
             (action, name) values (4, 'CLUSTER');
insert into system.logstdby$skip_support		    /* ALTER CLUSTER */
             (action, name) values (5, 'CLUSTER');
insert into system.logstdby$skip_support		     /* DROP CLUSTER */
             (action, name) values (8, 'CLUSTER');
insert into system.logstdby$skip_support		 /* TRUNCATE CLUSTER */
             (action, name) values (86, 'CLUSTER');

insert into system.logstdby$skip_support		   /* CREATE CONTEXT */
             (action, name) values (177, 'CONTEXT');
insert into system.logstdby$skip_support		     /* DROP CONTEXT */
             (action, name) values (178, 'CONTEXT');

insert into system.logstdby$skip_support	     /* CREATE DATABASE LINK */
             (action, name) values (32, 'DATABASE LINK');
insert into system.logstdby$skip_support	       /* DROP DATABASE LINK */
             (action, name) values (33, 'DATABASE LINK');

insert into system.logstdby$skip_support		 /* CREATE DIMENSION */
             (action, name) values (174, 'DIMENSION');
insert into system.logstdby$skip_support		  /* ALTER DIMENSION */
             (action, name) values (175, 'DIMENSION');
insert into system.logstdby$skip_support		   /* DROP DIMENSION */
             (action, name) values (176, 'DIMENSION');

insert into system.logstdby$skip_support		 /* CREATE DIRECTORY */
             (action, name) values (157, 'DIRECTORY');
insert into system.logstdby$skip_support		   /* DROP DIRECTORY */
             (action, name) values (158, 'DIRECTORY');

insert into system.logstdby$skip_support		     /* CREATE INDEX */
             (action, name) values (9, 'INDEX');
insert into system.logstdby$skip_support		      /* ALTER INDEX */
             (action, name) values (11, 'INDEX');
insert into system.logstdby$skip_support		       /* DROP INDEX */
             (action, name) values (10, 'INDEX');

insert into system.logstdby$skip_support		 /* CREATE PROCEDURE */
             (action, name) values (24, 'PROCEDURE');
insert into system.logstdby$skip_support		  /* ALTER PROCEDURE */
             (action, name) values (25, 'PROCEDURE');
insert into system.logstdby$skip_support		   /* DROP PROCEDURE */
             (action, name) values (68, 'PROCEDURE');
insert into system.logstdby$skip_support		  /* CREATE FUNCTION */
             (action, name) values (91, 'PROCEDURE');
insert into system.logstdby$skip_support		   /* ALTER FUNCTION */
             (action, name) values (92, 'PROCEDURE');
insert into system.logstdby$skip_support		    /* DROP FUNCTION */
             (action, name) values (93, 'PROCEDURE');
insert into system.logstdby$skip_support		   /* CREATE PACKAGE */
             (action, name) values (94, 'PROCEDURE');
insert into system.logstdby$skip_support		    /* ALTER PACKAGE */
             (action, name) values (95, 'PROCEDURE');
insert into system.logstdby$skip_support		     /* DROP PACKAGE */
             (action, name) values (96, 'PROCEDURE');
insert into system.logstdby$skip_support	      /* CREATE PACKAGE BODY */
             (action, name) values (97, 'PROCEDURE');
insert into system.logstdby$skip_support	       /* ALTER PACKAGE BODY */
             (action, name) values (98, 'PROCEDURE');
insert into system.logstdby$skip_support		/* DROP PACKAGE BODY */
             (action, name) values (99, 'PROCEDURE');

insert into system.logstdby$skip_support		   /* CREATE PROFILE */
             (action, name) values (65, 'PROFILE');
insert into system.logstdby$skip_support		    /* ALTER PROFILE */
             (action, name) values (67, 'PROFILE');
insert into system.logstdby$skip_support		     /* DROP PROFILE */
             (action, name) values (66, 'PROFILE');

insert into system.logstdby$skip_support      /* CREATE PUBLIC DATABASE LINK */
             (action, name) values (112, 'PUBLIC DATABASE LINK');
insert into system.logstdby$skip_support	/* DROP PUBLIC DATABASE LINK */
             (action, name) values (113, 'PUBLIC DATABASE LINK');

insert into system.logstdby$skip_support	    /* CREATE PUBLIC SYNONYM */
             (action, name) values (110, 'PUBLIC SYNONYM');
insert into system.logstdby$skip_support	      /* DROP PUBLIC SYNONYM */
             (action, name) values (111, 'PUBLIC SYNONYM');

insert into system.logstdby$skip_support		      /* CREATE ROLE */
             (action, name) values (52, 'ROLE');
insert into system.logstdby$skip_support		       /* ALTER ROLE */
             (action, name) values (79, 'ROLE');
insert into system.logstdby$skip_support			/* DROP ROLE */
             (action, name) values (54, 'ROLE');
insert into system.logstdby$skip_support			 /* SET ROLE */
             (action, name) values (55, 'ROLE');

insert into system.logstdby$skip_support	  /* CREATE ROLLBACK SEGMENT */
             (action, name) values (36, 'ROLLBACK STATEMENT');
insert into system.logstdby$skip_support	   /* ALTER ROLLBACK SEGMENT */
             (action, name) values (37, 'ROLLBACK STATEMENT');
insert into system.logstdby$skip_support	    /* DROP ROLLBACK SEGMENT */
             (action, name) values (38, 'ROLLBACK STATEMENT');

			 /* SYSTEM AUDIT & SYSTEM GRANT options not included */

insert into system.logstdby$skip_support		  /* CREATE SEQUENCE */
             (action, name) values (13, 'SEQUENCE');
insert into system.logstdby$skip_support		   /* ALTER SEQUENCE */
             (action, name) values (14, 'SEQUENCE');
insert into system.logstdby$skip_support		    /* DROP SEQUENCE */
             (action, name) values (16, 'SEQUENCE');

insert into system.logstdby$skip_support		   /* CREATE SYNONYM */
             (action, name) values (19, 'SYNONYM');
insert into system.logstdby$skip_support		     /* DROP SYNONYM */
             (action, name) values (20, 'SYNONYM');

insert into system.logstdby$skip_support		     /* CREATE TABLE */
             (action, name) values (1, 'TABLE');
insert into system.logstdby$skip_support		      /* ALTER TABLE */
             (action, name) values (15, 'TABLE');
insert into system.logstdby$skip_support		       /* DROP TABLE */
             (action, name) values (12, 'TABLE');
			  /* COMMENT ON TABLE & DELETE ON TABLE not included */

insert into system.logstdby$skip_support		/* CREATE TABLESPACE */
             (action, name) values (39, 'TABLESPACE');
insert into system.logstdby$skip_support		 /* ALTER TABLESPACE */
             (action, name) values (40, 'TABLESPACE');
insert into system.logstdby$skip_support		  /* DROP TABLESPACE */
             (action, name) values (41, 'TABLESPACE');

insert into system.logstdby$skip_support		   /* CREATE TRIGGER */
             (action, name) values (59, 'TRIGGER');
insert into system.logstdby$skip_support		    /* ALTER TRIGGER */
             (action, name) values (60, 'TRIGGER');
insert into system.logstdby$skip_support		     /* DROP TRIGGER */
             (action, name) values (61, 'TRIGGER');
insert into system.logstdby$skip_support		   /* ENABLE TRIGGER */
             (action, name) values (118, 'TRIGGER');
insert into system.logstdby$skip_support		  /* DISABLE TRIGGER */
             (action, name) values (119, 'TRIGGER');
insert into system.logstdby$skip_support	      /* ENABLE ALL TRIGGERS */
             (action, name) values (120, 'TRIGGER');
insert into system.logstdby$skip_support	     /* DISABLE ALL TRIGGERS */
             (action, name) values (121, 'TRIGGER');

insert into system.logstdby$skip_support		      /* CREATE TYPE */
             (action, name) values (77, 'TYPE');
insert into system.logstdby$skip_support			/* DROP TYPE */
             (action, name) values (78, 'TYPE');
insert into system.logstdby$skip_support		       /* ALTER TYPE */
             (action, name) values (80, 'TYPE');
insert into system.logstdby$skip_support		 /* CREATE TYPE BODY */
             (action, name) values (81, 'TYPE');
insert into system.logstdby$skip_support		  /* ALTER TYPE BODY */
             (action, name) values (82, 'TYPE');
insert into system.logstdby$skip_support		   /* DROP TYPE BODY */
             (action, name) values (83, 'TYPE');

insert into system.logstdby$skip_support		      /* CREATE USER */
             (action, name) values (51, 'USER');
insert into system.logstdby$skip_support		       /* ALTER USER */
             (action, name) values (43, 'USER');
insert into system.logstdby$skip_support			/* DROP USER */
             (action, name) values (53, 'USER');

insert into system.logstdby$skip_support		      /* CREATE VIEW */
             (action, name) values (21, 'VIEW');
insert into system.logstdby$skip_support			/* DROP VIEW */
             (action, name) values (22, 'VIEW');
commit;

Rem
Rem  Create views over the metadata tables.
Rem

-- The DBA_LOGSTDBY_UNSUPPORTED view, the DBA_LOGSTDBY_NOT_UNIQUE view
-- and the KRVS_LOGSTDBY_SUPPORT macro in krvs.c (a view in 10i) all share
-- common code.  If you change any of these, you may need to change the
-- others.
create or replace view dba_logstdby_unsupported
as
  select tc.owner, tc.table_name, tc.column_name, tc.data_type
  from
(select u.name owner, o.name table_name, c.name column_name, c.type#,
  o.obj#, t.property tprop, t.flags tflags, nvl(s.spare1,0) segspare1, 
/* BEGIN SECTION 1 COMMON CODE: LOGSTDBY_SUPPORT - DBA_LOGSTDBY_UNSUPPORTED */
 (case
  when u.name = 'SYS'
    or u.name = 'SYSTEM'
    or u.name = 'OUTLN'
    or u.name = 'DBSNMP'
    or bitand(o.flags,
                2                                      /* temporary object */
              + 4                               /* system generated object */
              + 16                                     /* secondary object */
              + 32                                 /* in-memory temp table */
              + 128                          /* dropped table (RecycleBin) */
             ) != 0
    or bitand(t.flags,
                262144     /* 0x00040000       Summary Container Table, MV */
              + 134217728  /* 0x08000000         in-memory temporary table */
             ) != 0
    or bitand(t.property,
                512        /* 0x00000200              iot OVeRflow segment */
              + 8192       /* 0x00002000                      nested table */
              + 131072     /* 0x00020000   table is used as AQ queue table */
              + 4194304    /* 0x00400000            global temporary table */
              + 8388608    /* 0x00800000  session-specific temporary table */
              + 33554432   /* 0x02000000       Read Only Materialized View */
              + 67108864   /* 0x04000000           Materialized View table */
              + 134217728  /* 0x08000000                   Is a Sub object */
              + 2147483648 /* 0x80000000                    eXternal TaBle */
             ) != 0
    or exists                                               /* MVLOG table */
       (select 1
        from sys.mlog$ ml where ml.mowner = u.name and ml.log = o.name)
  then -1
  when bitand(t.property,
                 64       /* 0x00000040                          IOT table */
              + 128       /* 0x00000080              IOT with row overflow */
              + 256       /* 0x00000100            IOT with row clustering */
             ) != 0
    or bitand(t.flags,
                268435456  /* 0x10000000   IOT with Phys Rowid/mapping tab */
              + 536870912  /* 0x20000000 Mapping Tab for Phys rowid of IOT */
             ) != 0
    or bitand(t.property, 262208) = 262208  /* 0x40+0x40000 IOT + user LOB */
    or bitand(t.property, 2112) = 2112    /* 0x40+0x800 IOT + internal LOB */
    or                                          /* IOT with Row Movement */
       (bitand(t.property, 64) = 64 and bitand(t.flags, 131072) = 131072)
    or                                                      /* Compression */
      (bitand(nvl(s.spare1,0), 2048) = 2048 and bitand(t.property, 32) != 32)
    or o.oid$ is not null
/* END SECTION 1 COMMON CODE */
   or 
/* BEGIN SECTION 2 COMMON CODE: LOGSTDBY_SUPPORT - DBA_LOGSTDBY_UNSUPPORTED */
 (c.type# not in (
                  1,                             /* VARCHAR2 */
                  2,                               /* NUMBER */
                  12,                                /* DATE */
                  96,                                /* CHAR */
                  113,                               /* BLOB */
                  180,                     /* TIMESTAMP (..) */
                  181,       /* TIMESTAMP(..) WITH TIME ZONE */
                  182,         /* INTERVAL YEAR(..) TO MONTH */
                  183,     /* INTERVAL DAY(..) TO SECOND(..) */
                  231) /* TIMESTAMP(..) WITH LOCAL TIME ZONE */
  and (c.type# != 112                      /* CLOB not NCLOB */
       or (c.type# = 112 and c.charsetform = 2))
  and (c.type# != 23                      /* RAW not RAW OID */
       or (c.type# = 23 and bitand(c.property, 2) = 2)))
/* END SECTION 2 COMMON CODE */
  or (c.segcol# = 0 or     /* virtual column, segcol#=0 is bad */
       bitand(c.property, 32768) = 32768)   /* unused col, bad */
   then 0 else 1 end) gensby
 from sys.obj$ o, sys.user$ u, sys.tab$ t, sys.seg$ s, sys.col$ c
where o.owner# = u.user#
  and o.obj# = t.obj#
  and o.obj# = c.obj#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.obj# = o.obj#
  and (c.segcol# = 0 or     /* virtual column, segcol#=0 is bad */
       bitand(c.property, 32768) = 32768 or  /* unused col, bad */
       bitand(c.property, 32) != 32)              /* not hidden */
) l, dba_tab_cols tc
  where l.owner = tc.owner
    and l.table_name = tc.table_name
    and l.column_name = tc.column_name 
    and l.gensby = 0 
/
create or replace public synonym dba_logstdby_unsupported
   for dba_logstdby_unsupported
/
grant select on dba_logstdby_unsupported to select_catalog_role
/
comment on table dba_logstdby_unsupported is 
'List of all the columns that are not supported by Logical Standby'
/
comment on column dba_logstdby_unsupported.owner is 
'Schema name of unsupported column'
/
comment on column dba_logstdby_unsupported.table_name is 
'Table name of unsupported column'
/
comment on column dba_logstdby_unsupported.column_name is 
'Column name of unsupported column'
/
comment on column dba_logstdby_unsupported.data_type is
'Datatype of unsupported column'
/


create or replace view dba_logstdby_not_unique
as
  select owner, name table_name, 
         decode((select count(c.obj#)
                 from sys.col$ c
                 where c.obj# = l.obj#
                     and c.type# in (8,                              /* LONG */
                                     24,                         /* LONG RAW */
                                     112,                            /* CLOB */
                                     113)),                          /* BLOB */
                 0, 'N', 'Y') bad_column
  from
(/* BEGIN LOGSTDBY_SUPPORT View */
select owner, name, type#, obj#, current_sby,
   (case
     when supposed_sby = 1 and not exists
     (select 1
      from system.logstdby$skip sk
      where statement_opt = 'DML' and proc is null 
        and error is null 
        and l.owner like sk.schema and l.name like sk.name)
     then 1
     else 0 end) generated_sby
 from
  (select owner, name, type#, obj#,
          decode(gensby, 1, 1, 0) supposed_sby,
          decode(bitand(tflags, 1073741824), 1073741824, 1, 0) current_sby
   from
     (select u.name owner, o.name name, o.type#,
             o.obj#, t.property tprop, t.flags tflags, 
/* BEGIN SECTION 1 COMMON CODE: LOGSTDBY_SUPPORT - DBA_LOGSTDBY_UNSUPPORTED */
 (case
  when u.name = 'SYS'
    or u.name = 'SYSTEM'
    or u.name = 'OUTLN'
    or u.name = 'DBSNMP'
    or bitand(o.flags,
                2                                      /* temporary object */
              + 4                               /* system generated object */
              + 16                                     /* secondary object */
              + 32                                 /* in-memory temp table */
              + 128                          /* dropped table (RecycleBin) */
             ) != 0
    or bitand(t.flags,
                262144     /* 0x00040000       Summary Container Table, MV */
              + 134217728  /* 0x08000000         in-memory temporary table */
             ) != 0
    or bitand(t.property,
                512        /* 0x00000200              iot OVeRflow segment */
              + 8192       /* 0x00002000                      nested table */
              + 131072     /* 0x00020000   table is used as AQ queue table */
              + 4194304    /* 0x00400000            global temporary table */
              + 8388608    /* 0x00800000  session-specific temporary table */
              + 33554432   /* 0x02000000       Read Only Materialized View */
              + 67108864   /* 0x04000000           Materialized View table */
              + 134217728  /* 0x08000000                   Is a Sub object */
              + 2147483648 /* 0x80000000                    eXternal TaBle */
             ) != 0
    or exists                                               /* MVLOG table */
       (select 1
        from sys.mlog$ ml where ml.mowner = u.name and ml.log = o.name)
  then -1
  when bitand(t.property,
                 64       /* 0x00000040                          IOT table */
              + 128       /* 0x00000080              IOT with row overflow */
              + 256       /* 0x00000100            IOT with row clustering */
             ) != 0
    or bitand(t.flags,
                268435456  /* 0x10000000   IOT with Phys Rowid/mapping tab */
              + 536870912  /* 0x20000000 Mapping Tab for Phys rowid of IOT */
             ) != 0
    or bitand(t.property, 262208) = 262208  /* 0x40+0x40000 IOT + user LOB */
    or bitand(t.property, 2112) = 2112    /* 0x40+0x800 IOT + internal LOB */
    or                                          /* IOT with "Row Movement" */
       (bitand(t.property, 64) = 64 and bitand(t.flags, 131072) = 131072)
    or                                                      /* Compression */
      (bitand(nvl(s.spare1,0), 2048) = 2048 and bitand(t.property, 32) != 32)
    or o.oid$ is not null
/* END SECTION 1 COMMON CODE */
       or exists
           (select 1 from sys.col$ c 
            where t.obj# = c.obj# 
              and (c.segcol# = 0 or     /* virtual column, segcol#=0 is bad */
                   bitand(c.property, 32768) = 32768 or  /* unused col, bad */
                   (bitand(c.property, 32) != 32              /* not hidden */
                    and 
/* BEGIN SECTION 2 COMMON CODE: LOGSTDBY_SUPPORT - DBA_LOGSTDBY_UNSUPPORTED */
 (c.type# not in (
                  1,                             /* VARCHAR2 */
                  2,                               /* NUMBER */
                  12,                                /* DATE */
                  96,                                /* CHAR */
                  113,                               /* BLOB */
                  180,                     /* TIMESTAMP (..) */
                  181,       /* TIMESTAMP(..) WITH TIME ZONE */
                  182,         /* INTERVAL YEAR(..) TO MONTH */
                  183,     /* INTERVAL DAY(..) TO SECOND(..) */
                  231) /* TIMESTAMP(..) WITH LOCAL TIME ZONE */
  and (c.type# != 112                      /* CLOB not NCLOB */
       or (c.type# = 112 and c.charsetform = 2))
  and (c.type# != 23                      /* RAW not RAW OID */
       or (c.type# = 23 and bitand(c.property, 2) = 2)))
/* END SECTION 2 COMMON CODE */
      ))) then 0 else 1 end) gensby
      from sys.obj$ o, sys.user$ u, sys.tab$ t, sys.seg$ s
      where o.owner# = u.user#
        and o.obj# = t.obj#
        and t.file# = s.file# (+)
        and t.block# = s.block# (+)
        and t.obj# = o.obj#) ltabs
   union all
   select u.name owner, o.name name, o.type#, o.obj#,
        (case when u.name = 'SYS'
                or u.name = 'SYSTEM'
                or u.name = 'OUTLN'
                or u.name = 'DBSNMP'
              then 0
              else 1 end) supposed_sby,
          decode(bitand(s.flags, 8), 8, 1, 0) current_sby
   from obj$ o, user$ u, seq$ s
   where o.owner# = u.user#
     and o.obj# = s.obj#) l
/* END LOGSTDBY_SUPPORT View */ ) l
  where generated_sby = 1
    and type# = 2
    and not exists                                    /* not null unique key */
       (select null
        from ind$ i, icol$ ic, col$ c
        where i.bo# = l.obj#
          and ic.obj# = i.obj#
          and c.col# = ic.col#
          and c.obj# = i.bo#
          and c.null$ > 0
          and i.type# = 1
          and bitand(i.property, 1) = 1)
    and not exists                            /* primary key rely constraint */
       (select null
        from cdef$ cd
        where cd.obj# = l.obj#
          and cd.type# = 2 
          and bitand(cd.defer, 32) = 32)
/
create or replace public synonym dba_logstdby_not_unique
   for dba_logstdby_not_unique
/
grant select on dba_logstdby_not_unique to select_catalog_role
/
comment on table dba_logstdby_not_unique is 
'List of all the tables with out primary or unique key not null constraints'
/
comment on column dba_logstdby_not_unique.owner is 
'Schema name of the non-unique table'
/
comment on column dba_logstdby_not_unique.table_name is 
'Table name of the non-unique table'
/
comment on column dba_logstdby_not_unique.bad_column is 
'Indicates that the table has a column not useful in the where clause'
/

create or replace view dba_logstdby_parameters
as
  select name, value from system.logstdby$parameters
  where name != 'SHUTDOWN'
    and name != 'SEED_PRIMARY_DBID'
    and name != 'SEED_FIRST_SCN'
    and (type < 2 or type is null)
/
create or replace public synonym dba_logstdby_parameters
   for dba_logstdby_parameters
/
grant select on dba_logstdby_parameters to select_catalog_role
/
comment on table dba_logstdby_parameters is 
'Miscellaneous options and settings for Logical Standby'
/
comment on column dba_logstdby_parameters.name is 
'Name of the parameter'
/
comment on column dba_logstdby_parameters.value is 
'Optional value of the parameter'
/

-- DBA_LOGSTDBY_PROGRESS view
-- Looks complicated but is really just a collection of inline views and
-- subqueries.  Each of the *_SCN columns has a subquery that is part of
-- an inline view X.  Each of *_TIME columns are subqueries, all the same,
-- using the respective *_SCN column to calculate an approximate time.
-- Logmnr tables aren't created yet so FORCE was necessary
create or replace force view dba_logstdby_progress
as
  select
    applied_scn,
    (select max(first_time +
        ((next_time - first_time) / (next_change# - first_change#) *
         (applied_scn - first_change#)))
     from system.logmnr_log$ l
     where applied_scn >= first_change# and applied_scn <= next_change#
       and l.session# = x.session#) applied_time,
    read_scn,
    (select min(first_time +
        ((next_time - first_time) / (next_change# - first_change#) *
         (read_scn - first_change#)))
     from system.logmnr_log$ l
     where read_scn >= first_change# and read_scn <= next_change#
       and l.session# = x.session#) read_time,
    newest_scn,
    (select max(first_time +
        ((next_time - first_time) / (next_change# - first_change#) *
         (newest_scn - first_change#)))
     from system.logmnr_log$ l
     where newest_scn >= first_change# and newest_scn <= next_change#
       and l.session# = x.session#) newest_time
  from
    (select
      greatest(
         (select max(a.processed_scn) - 1
          from system.logstdby$apply_milestone a),
         (select max(a.commit_scn)
          from system.logstdby$apply_milestone a) ) applied_scn,
      spill_scn read_scn,
      (select max(next_change#)-1 from system.logmnr_log$) newest_scn,
      s.session#
     from system.logmnr_session$ s
     where s.session# =
      (select value from system.logstdby$parameters where name = 'LMNR_SID')) x
/
create or replace public synonym dba_logstdby_progress
   for dba_logstdby_progress
/
-- This must be done in catproc, since that's where logmnr tables are created
-- grant select on dba_logstdby_progress to select_catalog_role
-- /
comment on table dba_logstdby_progress is 
'List the SCN values describing read and apply progress'
/
comment on column dba_logstdby_progress.applied_scn is 
'All transactions with a commit SCN <= this value have been applied'
/
comment on column dba_logstdby_progress.applied_time is 
'Estimate of the time the applied_scn was generated'
/
comment on column dba_logstdby_progress.read_scn is 
'All log data less than this SCN has been preserved in the database'
/
comment on column dba_logstdby_progress.read_time is 
'Estimate of the time the read_scn was generated'
/
comment on column dba_logstdby_progress.newest_scn is 
'The most recent SCN available on standby.'
/
comment on column dba_logstdby_progress.newest_time is 
'Estimate of the time the newest_scn was generated'
/

-- Logmnr tables aren't created yet so FORCE was necessary --
create or replace force view dba_logstdby_log
as
  select thread#, sequence#, first_change#, next_change#, 
         first_time, next_time, file_name, timestamp, dict_begin, dict_end
  from system.logmnr_log$ 
  where session# =
        (select value from system.logstdby$parameters where name = 'LMNR_SID')
/
create or replace public synonym dba_logstdby_log for dba_logstdby_log
/
-- This must be done in catproc, since that's where logmnr tables are created
-- grant select on dba_logstdby_log to select_catalog_role
-- /

comment on table dba_logstdby_log is
'List the information about received logs from the primary'
/
comment on column dba_logstdby_log.thread# is 
'Redo thread number'
/
comment on column dba_logstdby_log.sequence# is 
'Redo log sequence number'
/
comment on column dba_logstdby_log.first_change# is 
'First change# in the archived log'
/
comment on column dba_logstdby_log.next_change# is 
'First change in the next log'
/
comment on column dba_logstdby_log.first_time is 
'Timestamp of the first change'
/
comment on column dba_logstdby_log.next_time is 
'Timestamp of the next change'
/
comment on column dba_logstdby_log.file_name is 
'Archived log file name'
/
comment on column dba_logstdby_log.timestamp is 
'Time when the archiving completed'
/
comment on column dba_logstdby_log.dict_begin is 
'Contains beginning of Log Miner Dictionary'
/
comment on column dba_logstdby_log.dict_end is 
'Contains end of Log Miner Dictionary'
/

create or replace view dba_logstdby_skip_transaction
as
  select xidusn, xidslt, xidsqn
  from system.logstdby$skip_transaction
/
create or replace public synonym dba_logstdby_skip_transaction 
   for dba_logstdby_skip_transaction
/
grant select on dba_logstdby_skip_transaction to select_catalog_role
/
comment on table dba_logstdby_skip_transaction is 
'List the transactions to be skipped'
/
comment on column dba_logstdby_skip_transaction.xidusn is 
'Transaction id, component 1 of 3'
/
comment on column dba_logstdby_skip_transaction.xidslt is 
'Transaction id, component 2 of 3'
/
comment on column dba_logstdby_skip_transaction.xidsqn is 
'Transaction id, component 3 of 3'
/

create or replace view dba_logstdby_skip
as
  select decode(error, 1, 'Y', 'N') error,
	 statement_opt, schema owner, name, proc
  from system.logstdby$skip
/
create or replace public synonym dba_logstdby_skip for dba_logstdby_skip
/
grant select on dba_logstdby_skip to select_catalog_role
/
comment on table dba_logstdby_skip is 
'List the skip settings choosen'
/
comment on column dba_logstdby_skip.error is 
'Does this skip setting only apply to failed attempts'
/
comment on column dba_logstdby_skip.statement_opt is 
'The statement option choosen to skip'
/
comment on column dba_logstdby_skip.owner is 
'Schema name under which this skip option should be applied'
/
comment on column dba_logstdby_skip.name is 
'Object name under which this skip option should be applied'
/
comment on column dba_logstdby_skip.proc is 
'The stored procedure to call for this skip setting.  DDL only'
/


create or replace view dba_logstdby_events
as
  select event_time, current_scn, commit_scn,
         xidusn, xidslt, xidsqn, full_event event, 
	 errval status_code, error status
  from system.logstdby$events
/
create or replace public synonym dba_logstdby_events for dba_logstdby_events
/
grant select on dba_logstdby_events to select_catalog_role
/
comment on table dba_logstdby_events is 
'Information on why logical standby events'
/
comment on column dba_logstdby_events.event_time is
'Time the event took place'
/
comment on column dba_logstdby_events.current_scn is
'Change vector SCN for the change'
/
comment on column dba_logstdby_events.commit_scn is
'SCN for the commit record of the transaction'
/
comment on column dba_logstdby_events.xidusn is
'Transaction id, part 1 of 3'
/
comment on column dba_logstdby_events.xidslt is
'Transaction id, part 2 of 3'
/
comment on column dba_logstdby_events.xidsqn is
'Transaction id, part 3 of 3'
/
comment on column dba_logstdby_events.event is
'A SQL statement or other text describing the event'
/
comment on column dba_logstdby_events.status is
'A text string describing the event'
/
comment on column dba_logstdby_events.status_code is
'A number describing the event'
/


Rem Fix (Virtual) Views

create or replace view v_$logstdby as
  select * from v$logstdby;
create or replace public synonym v$logstdby for v_$logstdby;
grant select on v_$logstdby to select_catalog_role;

create or replace view v_$logstdby_stats as
  select * from v$logstdby_stats;
create or replace public synonym v$logstdby_stats for v_$logstdby_stats;
grant select on v_$logstdby_stats to select_catalog_role;


Rem Create synonyms for the global fixed views

create or replace view gv_$logstdby as
  select * from gv$logstdby;
create or replace public synonym gv$logstdby for gv_$logstdby;
grant select on gv_$logstdby to select_catalog_role;

create or replace view gv_$logstdby_stats as
  select * from gv$logstdby_stats;
create or replace public synonym gv$logstdby_stats for gv_$logstdby_stats;
grant select on gv_$logstdby_stats to select_catalog_role;


Rem Add logstdby$ tables to noexp$
delete from noexp$ where name like 'LOGSTDBY$%';

insert into noexp$ (owner, name, obj_type)
values('SYSTEM', 'LOGSTDBY$SKIP_SUPPORT', 2);
