Rem
Rem $Header: catmetx.sql 09-aug-2002.11:11:54 bmccarth Exp $
Rem
Rem catmetx.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catmetx.sql - Metadata API: Real definitions for XDB object views.
Rem
Rem    DESCRIPTION
Rem      Metadata API object views for XDB objects
Rem
Rem    NOTES
Rem	For reasons having to do with compatibility, the XDB objects
Rem	can't be created by catproc.sql; they must instead be created
Rem	by a separate script catqm.sql.  Since catmeta.sql is run
Rem	by catproc.sql, it contains fake object views for XDB objects.
Rem	The real object views are defined in this file which is
Rem	invoked by catxdbv.sql (which is invoked by catqm.sql).
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bmccarth    08/08/02 - fix xmlschema_view 
Rem    lbarton     07/24/02 - get stripped and unstripped val
Rem    bmccarth    03/01/02 - add schemaoid to xmlschema
Rem    lbarton     01/16/02 - Merged lbarton_mdapi_xdb
Rem    lbarton     01/15/02 - fix comment
Rem    lbarton     12/03/01 - debug
Rem    lbarton     11/21/01 - Created
Rem

create or replace force view sys.ku$_xmlschema_view of sys.ku$_xmlschema_t
  with object identifier (owner_name, url) as
  select '1','0',
        u.user#, u.name, extractvalue(VALUE(s), '/schema/@schemaURL'),
        s.sys_nc_oid$,
           case when under_path(value(r), '/sys/schemas/PUBLIC') = 1
                then 0 else 1 end,
	s.getclobval(),						  -- unstripped
	xdb.dbms_xdbutil_int.XMLSchemaStripUsername(XMLTYPE(s.getClobVal()),
                                                    u.name)         -- stripped
    from sys.user$ u, xdb.xdb$schema s, xdb.xdb$resource r
    where extractvalue(VALUE(r), '/Resource/XMLRef') = ref(s)
    and u.user# = sys_op_rawtonum(extractvalue(VALUE(r),'/Resource/OwnerID'))
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR
                EXISTS ( SELECT * FROM session_roles
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_xmlschema_view to public
/
create or replace force view sys.ku$_xmlschema_elmt_view
  of sys.ku$_xmlschema_elmt_t with object identifier(schemaoid, elemnum) as
  select schm.sys_nc_oid$, extractValue(value(schm), '/schema/@schemaURL'),
            extractValue(value(xel), '/element/@propNumber'),
            extractValue(value(xel), '/element/@name')
  from xdb.xdb$element xel, xdb.xdb$schema schm
  where ref(schm) = extractValue(value(xel), '/element/@parentSchema')
/
grant select on sys.ku$_xmlschema_elmt_view to select_catalog_role
/


