Rem
Rem $Header: catpatch.sql 08-apr-2004.22:36:25 arithikr Exp $
Rem
Rem catpatch.sql
Rem
Rem Copyright (c) 2001, 2004, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catpatch.sql - Script to apply CATalog PATCH set to a database
Rem
Rem    DESCRIPTION
Rem      This script encapsulates the "post install" steps necessary
Rem      to migrate the dictionary to the new patchset version.
Rem      It runs the new patchset versions of catalog.sql and catproc.sql
Rem      and calls the component patch scripts.
Rem
Rem    NOTES
Rem      Use SQLPLUS and connect AS SYSDBA to run this script.
Rem      The database must be open for MIGRATE
Rem      
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      03/25/04 - bug 3430486: special patch script 
Rem    ajadams     09/21/04 - Add 9.2.0.* warning for bug 3785754 
Rem    arithikr    04/08/04 - 3531336 - create sys.ind_online$ 
Rem    nmukherj    02/02/04 - invalidate seg$ spare1 flag
Rem    arithikr    12/08/03 - Backport 3249260: base bug 3121812 
Rem    rburns      07/01/03 - uncomment odmpatch
Rem    rburns      08/27/02 - add Ultra Search patch
Rem    rburns      08/21/02 - invalidate materialized views for bug 2475163
Rem    rburns      07/18/02 - comment components not in patch release
Rem    rburns      05/14/02 - convert for 9.2.0.2
Rem    rburns      10/15/01 - add scope argument
Rem    rburns      10/10/01 - Merged rburns_patchset_tests
Rem    rburns      09/26/01 - Version for 9.0.1.2.0 patchset
Rem    rburns      09/26/01 - Created
Rem

Rem *************************************************************************
/*
 BEGIN CATPATCH.SQL */
Rem *************************************************************************

Rem =======================================================================
Rem Verify server version and MIGRATE status
Rem =======================================================================

WHENEVER SQLERROR EXIT;

DECLARE
  openmigrate     VARCHAR2(30);
  vers            VARCHAR2(30); 
BEGIN
-- See if server version and script version match. Raise an error if no match.
   select substr(version,1,5) into vers from v$instance;
   if vers != '9.2.0' then
      RAISE_APPLICATION_ERROR(-20000,
        'Server version and script version do not match. ' ||
        'Shutdown and use a different script or a different server.');   
   end if;
-- verify open for migrate
   select status into openmigrate from v$instance;
   if openmigrate != 'OPEN MIGRATE' then
      RAISE_APPLICATION_ERROR(-20000,
        'Database is not open for MIGRATE. ' ||
        'Shutdown and restart using MIGRATE.');
   end if;

END;
/

Rem =======================================================================
Rem SET nls_length_semantics at session level (bug 1488174)
Rem =======================================================================

ALTER SESSION SET NLS_LENGTH_SEMANTICS=BYTE;

Rem =======================================================================
Rem Set event to avoid unnecessary re-compilations
Rem =======================================================================

ALTER SESSION SET EVENTS '10520 TRACE NAME CONTEXT FOREVER, LEVEL 10'; 

WHENEVER SQLERROR CONTINUE;

Rem =======================================================================
Rem Run catalog.sql and catproc.sql
Rem =======================================================================

Rem Remove any existing rows that would fire on DROP USER statements
delete from duc$;

Rem Invalidate materialized views for bug 2475163
update obj$ set status = 5 where type# = 42;
commit;

Rem Invalidate seg$ flag 
update seg$ set spare1 = spare1 - 131072 where bitand(spare1, 131072) = 131072;
commit;


Rem Add drop_segments column to mon_mods$ table
alter table sys.mon_mods$ add
(
   drop_segments number default 0
)
/

Rem create sys.ind_online$ table for bug 1486580
create table ind_online$
( obj#          number not null,
  type#         number not null,              /* what kind of index is this? */
                                                               /* normal : 1 */
                                                               /* bitmap : 2 */
                                                              /* cluster : 3 */
                                                            /* iot - top : 4 */
                                                         /* iot - nested : 5 */
                                                            /* secondary : 6 */
                                                                 /* ansi : 7 */
                                                                  /* lob : 8 */
                                             /* cooperative index method : 9 */
  flags         number not null
                                      /* index is being online built : 0x100 */
                                    /* index is being online rebuilt : 0x200 */
)
/

SELECT 'COMP_TIMESTAMP START      ' || SYSTIMESTAMP AS timestamp FROM DUAL;
@@catalog.sql
SELECT dbms_registry.time_stamp('CATALOG') AS timestamp FROM DUAL;
@@catproc.sql 
SELECT dbms_registry.time_stamp('CATPROC') AS timestamp FROM DUAL;

Rem *************************************************************************
/*
 START Component Patches */
Rem *************************************************************************

Rem Setup component script filename variable
COLUMN file_name NEW_VALUE comp_file NOPRINT;

Rem JServer
SELECT dbms_registry.patch_script('JAVAVM','?/javavm/install/jvmpatch.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('JAVAVM') AS timestamp FROM DUAL;

Rem XDK for Java
SELECT dbms_registry.patch_script('XML','?/xdk/admin/xmlpatch.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('XML') AS timestamp FROM DUAL;

Rem Java Supplied Packages
SELECT dbms_registry.patch_script('CATJAVA','?/rdbms/admin/catjava.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('CATJAVA') AS timestamp FROM DUAL;

Rem Oracle XML Database
SELECT dbms_registry.patch_script('XDB','?/rdbms/admin/xdbpatch.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('XDB') AS timestamp FROM DUAL;

Rem Real Application Clusters
SELECT dbms_registry.patch_script('RAC','?/rdbms/admin/catclust.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('RAC') AS timestamp FROM DUAL;

--OWM is not currently in the patch release
--Rem Oracle Workspace Manager
--SELECT dbms_registry.patch_script('OWM','?/rdbms/admin/owmpatch.sql')
--       AS file_name FROM DUAL;
--@&comp_file
--SELECT dbms_registry.time_stamp('OWM') AS timestamp FROM DUAL;

Rem Oracle Data Mining
SELECT dbms_registry.patch_script('ODM','?/dm/admin/odmpatch.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('ODM') AS timestamp FROM DUAL;

--MGW is not currently in the patch release
--Rem Messaging Gateway
--SELECT dbms_registry.patch_script('MGW','?/mgw/admin/mgwpatch.sql')
--       AS file_name FROM DUAL;
--@&comp_file
--SELECT dbms_registry.time_stamp('MGW') AS timestamp FROM DUAL;

Rem OLAP Catalog 
SELECT dbms_registry.patch_script('AMD','?/cwmlite/admin/amdpatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('AMD') AS timestamp FROM DUAL;

Rem OLAP Analytic Workspace
SELECT dbms_registry.patch_script('APS','?/olap/admin/apspatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('APS') AS timestamp FROM DUAL;

Rem OLAP API
SELECT dbms_registry.patch_script('XOQ','?/olap/admin/xoqpatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('XOQ') AS timestamp FROM DUAL;

Rem Intermedia
SELECT dbms_registry.patch_script('ORDIM','?/ord/im/admin/impatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('ORDIM') AS timestamp FROM DUAL;

Rem Spatial
SELECT dbms_registry.patch_script('SDO','?/md/admin/sdopatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('SDO') AS timestamp FROM DUAL;

Rem Text
SELECT dbms_registry.patch_script('CONTEXT','?/ctx/admin/ctxpatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('CONTEXT') AS timestamp FROM DUAL;

Rem Ultrasearch
SELECT dbms_registry.patch_script('WK','?/ultrasearch/admin/wkpatch.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('WK') AS timestamp FROM DUAL;

Rem Oracle Label Security
SELECT dbms_registry.patch_script('OLS','?/rdbms/admin/olspatch.sql') AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('OLS') AS timestamp FROM DUAL;

set serveroutput off

Rem *************************************************************************
/*
 END Component Patches */
Rem *************************************************************************

Rem =======================================================================
Rem Turn SESSION event off
Rem =======================================================================

ALTER SESSION SET EVENTS '10520 TRACE NAME CONTEXT OFF'; 

Rem =======================================================================
Rem Display new versions and status
Rem =======================================================================

column comp_name format a35
SELECT comp_name, status, substr(version,1,10) as version from dba_registry;
/*
================================================================
   The above query lists the components in the database, along
   with their current patchset version and status. 
================================================================
*/   

SET FEEDBACK OFF
SELECT '***WARNING*** At ' || TO_CHAR(o.ctime, 'DD-MON-YY HH24:MI:SS') ||
       ' problems related to bug 3785754 were            ' || 
       'encountered.  See Patch or Upgrade Notes.  ' ||
       'Call Oracle support.' as bug_3785754_status
FROM obj$ o, user$ u
WHERE o.owner# = u.user# AND
      o.name LIKE 'BUG$3785754_%' AND u.name = 'SYS';
SET FEEDBACK ON
Rem
Rem =================================================================
Rem   The above query writes a warning if evidence of bug 3785754
Rem   was detected.  For 9.2.0.* Oracle Support will need to assist
Rem   and advise how best to rectify the problem.
Rem =================================================================

Rem *************************************************************************
/*
 END CATPATCH.SQL */
Rem *************************************************************************
