rem 
rem $Header: catproc.sql 03-may-2006.09:02:38 ciyer Exp $ 
rem 
Rem Copyright (c) 1991, 2006, Oracle. All rights reserved.  
Rem    NAME
Rem      catproc.sql
Rem    DESCRIPTION
Rem	 Run all sql scripts for the procedural option
Rem    RETURNS
Rem 
Rem    NOTES
Rem      This script must be run while connected AS SYSDBA.
Rem    MODIFIED   (MM/DD/YY)
Rem     ciyer      05/03/06 - Add owapatch.sql 
Rem     rburns     01/18/06 - add prvtcr.plb 
Rem     rburns     09/13/04 - check for SYS user 
Rem     bmccarth   04/15/04 - move prvtplob up for dependancy with dbmsexp 
Rem     mtao       07/13/04 - move prvthlut from catpstr to catproc 
Rem     rbollu     11/22/03 - fix bug#3197595 
Rem     esoyleme   02/27/02 - remove xumuts.plb
Rem     rburns     02/20/02 - re-validate catalog
Rem     rburns     02/11/02 - add registry version
Rem     rpang      01/25/02 - add UTL_GDK
Rem     esoyleme   01/23/02 - bring in changes from oraolap
Rem     cchiappa   01/15/02 - cchiappa_txn100947
Rem     emagrath   01/09/02 - Elim. endian REF problem
Rem     rburns     10/26/01 - add registry validation
Rem     rdecker    11/02/01 - remove owa debug packages (installed BY iAS now)
Rem     skaluska   11/02/01 - add prvtreut.plb
Rem     sbalaram   11/02/02 - add catstr
Rem     wesmith    10/23/01 - remove catplrep.sql
Rem     liwong     10/23/01 - Add catpstr.sql
Rem     skmishra   10/19/01 - merge LOG inot MAIN
Rem     rguzman    09/13/01 - define dbmslsby early so prvtjob can reference it
Rem     weiwang    09/07/01 - add prvtreie
Rem     dvoss      07/25/01 - Load logminer files prvtlmc.plb and prvtlmrd.plb
Rem     skaluska   08/17/01 - move rules engine creation.
Rem     narora     06/28/01 - add catplrep
Rem     esoyleme   09/25/01 - call  catxs.sql.
Rem     ayoaz      10/12/01 - move catodci to before dbmsstat spec
Rem     rburns     10/05/01 - use 9.2.0 as current release
Rem     rdecker    09/18/01 - add owa_debug_jdwp support
Rem     eehrsam    09/28/01 - Move utl_raw above utl_file.
Rem     lbarton    09/05/01 - use mdAPI jacket script
Rem     rburns     08/22/01 - add component registry
Rem     dgagne     08/28/01 - add catnomet as first line for metadata api
Rem     wojeil     08/30/01 - adding prvtmap.plb.
Rem     dvoss      07/25/01 - Load logminer files prvtlmc.plb and prvtlmrd.plb
Rem     pravelin   08/13/01 - Run caths AFTER catrep.
Rem     pravelin   07/26/01 - Add caths for Heterogeneous Services.
Rem     kmuthukk   04/27/01 - conditionally install/upgrade owa pkgs
Rem     qiwang     04/30/01 - add logical standby procedures.
Rem     mkrishna   04/18/01 - add all XML components
Rem     rguzman    04/04/01 - Remove Logical Standby scripts until 9iR2.
Rem     yhu        03/08/01 - add dbms_odci package.
Rem     nle        02/24/01 - Change sql file for embedded gateway
Rem     eehrsam    02/05/01 - add utl_encode package
Rem     abrown     01/11/01 - split wrapped part of dbmslmd into prvtlmd
Rem     arrajara   01/06/01 - Install replication catalog
Rem     jgalanes   12/19/00 - Fix bug 1549046 by changing the order of 
Rem                           the CDC packages.
Rem     wnorcott   12/19/00 - re-order CDC packages.  bug 1549046
Rem     varora     12/15/00 - rename dbmssqljtype to dbmssjty
Rem     rpang      12/10/00 - Add dbmsjdcu.sql
Rem     aime       12/08/00 - move dbmslob before AQ
Rem     lbarton    12/01/00 - metadata api install
Rem     ctrezza    11/09/00 - Adding Data Guard support.
Rem     shihliu    10/23/00 - add dbms_resumable
Rem     ssvemuri   10/27/00 - Invoke dbmstran and prvttran correctly.
Rem     rdecker    04/26/00 - load packages FOR embedded plsql gateway
Rem     varora     09/26/00 - add prvtsqljtype
Rem     rpang      09/18/00 - Added utl_url
Rem     mthiyaga   09/22/00 - Add prvtxrmv.plb
Rem     ssvemuri   09/19/00 - dejaview file rename.
Rem     amganesh   09/13/00 - dejaview.
Rem     jstenois   08/30/00 - add datapump dml types
Rem     nbhatt     09/06/00 - add transformations catalog file
Rem     rpang      07/26/00 - move utl_http after utl_raw
Rem     thoang     07/15/00 - Add dbmstypu & prvttypu 
Rem     rvissapr   06/28/00 - adding prvtctx.sql
Rem     jdavison   07/25/00 - Add xmltype and anydata.
Rem     rpang      06/28/00 - Added prvthttp.plb
Rem     svivian    06/27/00 - move dbmslms.sql before dbmslsby
Rem     ajadams    06/20/00 - add logminer session scripts
Rem     gclaborn   06/20/00 - Add utlcxml.sql
Rem     mkrishna   06/08/00 - fix lrg 42798: backout XMLTYpe creation
Rem     jkundu     05/31/00 - change order of installation of dbmslm and dbmslm
Rem     jkundu     05/24/00 - changing where to call logminer package
Rem     mkrishna   05/23/00 - move dbmsxml packages before dbmsmeta
Rem     masubram   05/18/00 - add dbmshord.sql and prvtbord.plb
Rem     liwong     05/12/00 - Add prvthsye.plb
Rem     liwong     05/08/00 - Add prvthtxn.plb, prvthsye.plb
Rem     mkrishna   05/05/00 - add dbmsxml package to the catproc
Rem     njalali    05/03/00 - Backed out XDB changes
Rem     liwong     05/02/00 - Add prvthjob.plb
Rem     mkrishna   05/02/00 - add dbmsxml.sql to the created packages
Rem     mkrishna   05/02/00 - add dbmsxmlt to the created types
Rem     dmwong     04/24/00 - Catalog views for Fine Grained Auditing
Rem     dalpern    04/17/00 - argus debug
Rem     njalali    04/20/00 - Added catqm.sql
Rem     vvishwan   04/12/00 - Load dbmshias.sql, prvtbias.plb
Rem     svivian    04/10/00 - add logical standby scripts
Rem     wnorcott   03/08/00 - Add dbmscdcp, dbmscdcs
Rem     lbarton    03/01/00 - remove prvtmeta.plb
Rem     wnorcott   02/07/00 - Add dbmscdcu.sql / prvtcdcu.plb
Rem     rwessman   01/25/00 - Corrected omission of the obfuscation toolkit
Rem     rwessman   01/24/00 - Moved dbmsrand.sql from catoctk.sql to 
Rem                           catproc.sql so that all may use it
Rem     btao       01/12/00 - add prvtsms.plb for summary advisor
Rem     gclaborn   11/15/99 - Add dbmsmeta.sql / prvtmeta.plb
Rem     jarnett    09/23/99 - bug 951528 - correct dba_pending_transactions
Rem     rpang      08/13/99 - Added dbms_psp after dbms_sql and utl_raw
Rem     rpang      08/02/99 - Added utl_raw, utl_tcp, utl_smtp and utl_inaddr
Rem     bnainani   07/30/99 - Bug 915265 - change file names to 8 chars
Rem     jkundu     07/21/99 - Logminer sql filenames changed to 8.3 format
Rem     amozes     07/28/99 - add prvtstas.plb                                 
Rem     nshodhan   03/23/99 - add comments
Rem     nshodhan   02/26/99 - bug-789058: Remove obsolete files
Rem     ato        12/12/98 - add prvtzexp.plb
Rem     weiwang    11/16/98 - add system event attribute functions
Rem     slawande   11/04/98 - Load prvtsnap.plb before prvtsum.plb.
Rem     akalra     11/02/98 - get security helper functions for imp-exp
Rem     ato        11/02/98 - add prvtzhelp.plb                               
Rem     lcprice    11/02/98 - add dbms_repair package
Rem     rxgovind   10/14/98 - Remove RowType and RowSet install
Rem     dmwong     09/23/98 - add catactx for application context              
Rem     dmwong     09/22/98 - add views for application role
Rem     hasun      08/25/98 - Reorder <>snap and <>sum for dependencies        
Rem     rshaikh    06/22/98 - add catsvrmg after catspace
Rem     akalra     06/09/98 - catsched.sql -> catrm.sql
Rem     hasun      06/04/98 - Reorder prvtsnap and prvtsum to resolve depdencie
Rem     qiwang     05/28/98 - Add prvtsmv.plb
Rem     mcusson    05/11/98 - Name change: LogViewr -> LogMnr.
Rem     nle        05/13/98 - change file name: plspurity to plspur
Rem     rmurthy    05/04/98 - add catodci.sql
Rem     jwlee      05/18/98 - load catplug
Rem     nle        04/27/98 - execute plspurity
Rem     jwlee      04/05/98 - load prvtplts.plb
Rem     clei       03/09/98 - add catalog for row level security
Rem     sichandr   05/06/98 - make UTL_COLL package part of default installatio
Rem     svivian    04/16/98 - add stored outline metadata
Rem     doshaugh   04/13/98 - Add Logviewr packages
Rem     esoyleme   04/15/98 - add rules
Rem     rxgovind   04/12/98 - install SYS.RowType and SYS.RowSet
Rem     sramakri   04/08/98 - Add loading of prvtsma.plb (Summary Advisor packa
Rem     ciyer      03/30/98 - Load PL/SQL tracing packages
Rem     rxgovind   03/10/98 - make UTL_REF package part of default installation
Rem     clei       03/09/98 - add catalog for row level security
Rem     wnorcott   02/05/98 - Add prvtsum.sql
Rem     akalra     01/20/98 - Add catsched.sql
Rem     amozes     01/09/98 - add dbmsstat package
Rem     bhimatsi   02/27/98 - add call to catspace.sql
Rem     gclossma   09/09/97 - add .plb suffix to load of prvtpckl
Rem     gclossma   08/14/97 - add prvtpckl.plb for dbms_pickler
Rem     gdoherty   05/09/97 - add back catsnmp
Rem     gdoherty   04/29/97 - remove catsnmp.sql
Rem     rwessman   04/18/97 - Deleted catoctk.sql - it must be run after catpro
Rem     dalpern    04/16/97 - added on-disk rman packages
Rem     rwessman   04/15/97 - Add cryptographic toolkit interface
Rem     gclossma   04/14/97 - add pkg utlhttp for http callouts
Rem     gviswana   04/01/97 - Move prvtssql.plb down after dbmssql.sql
Rem     nlewis     03/20/97 - add prvttrst.sql - distributed trust admin
Rem     celsbern   01/07/97 - moved catsnap after catdefer and catqueue
Rem     ato        11/08/96 - add catqueue.sql
Rem     mchien     11/07/96 - fix '@' sign
Rem     wuling     11/07/96 - Add PITR Package
Rem     mchien     10/24/96 - add dbmslob to here
Rem     jmallory   10/22/96 - Load Probe packages
Rem     gdoherty   10/15/96 - move prvtssql.plb above other specs
Rem     mluong     10/14/96 - rearrange order for 'packages used for rdbms func
Rem     apareek    10/08/96 - New file for tspitr views (catpitr.sql)
Rem     sjain      09/09/96 - AQ conversion
Rem     nmichael   08/19/96 - New file for dynamic sql (prvtssql.sql)
Rem     asurpur    08/02/96 - Including prvtxpsw.sql to import password stuff
Rem     asurpur    05/06/96 - Dictionary Protection Implementation
Rem     ajasuja    04/25/96 -  merge OBJ to BIG_0423
Rem     wmaimone   01/04/96 -  7.3 merge
Rem     ldoo       12/10/95 -  Add dbmsitrg
Rem     tpystyne   04/09/96 - do not create standard since it is fixed now
Rem     emendez    09/29/95 -
Rem     dsdaniel   06/07/95 -  clean up .plb
Rem     dposner    04/26/95 -  Adding fileio packages
Rem     kmuthukk   03/13/95 -  add plitblm.sql for pl/sql index-table methods
Rem     wmaimone   05/06/94 -  #184921 run as sys/internal
Rem     dsdaniel   04/07/94 -  merge changes from branch 1.5.710.5
Rem     adowning   03/29/94 -  merge changes from branch 1.5.710.[6,7]
Rem     adowning   02/23/94 -  use prvt*.sql for non-replication
Rem     adowning   02/02/94 -  incorporate public/private file splits
Rem     dsdaniel   01/31/94 -  add dbmspexp.sql for export extensions
Rem     rjenkins   01/19/94 -  merge changes from branch 1.5.710.4
Rem     dsdaniel   01/18/94 -  merge changes from branch 1.5.710.2
Rem     rjenkins   12/08/93 -  un-merging dbmssyer
Rem     rjenkins   11/17/93 -  merge changes from branch 1.5.710.3
Rem     rjenkins   12/20/93 -  creating job queue
Rem     rjenkins   11/03/93 -  do dbmssnap after dbmssql
Rem     dsdaniel   10/30/93 -  add dbmssyer.sql
Rem     dsdaniel   10/29/93 -  run catdefr instead of dbmsdfrd
Rem     rjenkins   10/20/93 -  merge changes from branch 1.5.710.1
Rem     rjenkins   10/14/93 -  calling dbmsdfrd.sql
Rem     rjenkins   10/07/93 -  run dbmsdfrd.sql
Rem     hjakobss   07/09/93 -  add dbmssql
Rem     mmoore     11/03/92 -  add dbmsdesc 
Rem     glumpkin   10/26/92 -  Change catremot catrpc 
Rem     glumpkin   10/25/92 -  Change catstdx.sql to dbmsstdx.sql 
Rem     glumpkin   10/25/92 -  Creation 

WHENEVER SQLERROR EXIT;         
 
DOC 
###################################################################### 
###################################################################### 
    The following PL/SQL block will cause an ORA-20000 error and
    terminate the current SQLPLUS session if the user is not SYS. 
    Disconnect and reconnect with AS SYSDBA. 
###################################################################### 
###################################################################### 
# 
 
DECLARE
  p_user VARCHAR2(30);
BEGIN
    SELECT USER INTO p_user FROM DUAL; 
    IF p_user != 'SYS' THEN 
        RAISE_APPLICATION_ERROR (-20000, 
           'This script must be run AS SYSDBA'); 
    END IF; 
END;
/
WHENEVER SQLERROR CONTINUE;         

Rem indicate that catproc scripts are loading 

BEGIN
   dbms_registry.loading ('CATPROC','Oracle9i Packages and Types',
              'dbms_registry_sys.validate_catproc');
END;
/

Rem basic procedural views
@@catprc
@@catjobq

Rem Remote views
@@catrpc

Rem Setup for pl/sql
@@dbmsstdx
@@plitblm
@@plspur
@@pipidl
rem granting execute on the package created in pipidl.sql 
rem to execute_catalog_role...
grant execute on pidl to execute_catalog_role
/
@@pidian
rem granting execute on the package created in pidian.sql 
rem to execute_catalog_role...
grant execute on diana to execute_catalog_role
/
@@diutil
@@pistub
@@prvtpckl.plb
Rem PL/SQL packages
@@utlfile
@@prvtfile.plb
Rem more PL/SQL I/O packages
Rem  utlraw invocation moved to catalog.sql
@@prvtrawb.plb
@@utlfile
@@prvtfile.plb
@@utltcp
@@prvttcp.plb
@@utlinad
@@prvtinad.plb
@@utlsmtp
@@prvtsmtp.plb
@@utlhttp
@@prvthttp.plb
@@utlurl
@@prvturl.plb
@@utlenc
@@prvtenc.plb
@@utlgdk
@@prvtgdk.plb

Rem pl/sql packages for LOB
@@dbmslob.sql
@@prvtlob.plb

Rem include catspace.sql as it has space mgmt view and packages. we do it
Rem first as one of the following may have a reference to it
@@catspace

Rem Views for Application context ( dbmsutil and prvtutil depends on it )
@@catactx.sql

Rem Server Manager views -- depends on views created in catspace
@@catsvrmg

Rem pl/sql packages used for rdbms functionality
@@dbmsutil
@@prvthtxn.plb
@@dbmsapin
@@dbmssyer
@@dbmslock
@@dbmspipe
@@dbmsalrt
@@dbmsotpt
@@dbmsdesc
@@dbmssql
@@dbmspexp
@@dbmsjob
@@catodci.sql
@@dbmsstat
@@dbmslsby.sql
@@prvthddl.plb
@@prvthjob.plb
@@prvthsye.plb
@@prvthssq.plb
@@prvtutil.plb
@@prvtapin.plb
@@prvtsyer.plb
@@prvtlock.plb
@@prvtpipe.plb
@@prvtalrt.plb
@@prvtotpt.plb
@@prvtdesc.plb
@@prvtssql.plb
@@prvtsql.plb
@@prvtpexp.plb
@@prvtzhlp.plb
@@prvtzexp.plb
@@prvtjob.plb
@@prvtstas.plb
@@prvtstat.plb

Rem PL/SQL Server Pages package
@@dbmspsp
@@prvtpsp.plb
@@dbmstran
@@prvttran.plb

Rem Views for XA recovery
@@catxpend

Rem Transformations
@@cattrans.sql
@@dbmstxfm.sql
@@prvttxfm.plb

Rem AnyType creation
@@dbmsany.sql
@@prvtany.plb

Rem Rules engine
@@catrule.sql
@@dbmsread.sql
@@prvtread.plb
@@prvtreie.plb
@@prvtreut.plb

Rem STREAMS
Rem need to load prvthlut here because of dependency on bit,bis,bic
@@prvthlut.plb
  
Rem Tables, Views and Packages for AQ
@@catqueue

Rem Packages for DB Resource Manager
@@catrm

Rem Views and tables for deferred RPC and Materialized Views
@@catdefer
@@catsnap

Rem dbmsdfrd is replaced by dbmsdefr for the replication option
@@prvtdfrd.plb
@@prvtitrg.plb
@@prvtxpsw.plb

Rem Probe packages
@@dbmspb.sql
@@prvtpb.plb

REM packages for Summary Management and Materialized Views
@@dbmssum
@@dbmssnap
@@dbmshord
@@prvtxrmv.plb
@@prvtsnap.plb
@@prvtsum.plb
@@prvtsms.plb
@@prvtsmv.plb
@@prvtsma.plb

Rem iAS packages
@@dbmshias
@@prvtbias.plb  

@@prvtbord.plb
  
Rem PL/SQL trace packages
@@dbmspbt.sql
@@prvtpbt.plb

Rem Views for tablespace point in time recovery
@@catpitr
Rem dbms_pitr package spec and body
@@dbmspitr
@@prvtpitr.plb

Rem Views for transportable tablespace
@@catplug
@@dbmsplts
@@prvtplts.plb

Rem pl/sql package for REFs (UTL_REF)
@@utlrefld.sql

Rem pl/sql package for COLLs (UTL_COLL)
@@utlcoll.plb
@@prvtcoll.plb

Rem pl/sql package for distributed trust administration (trusted list admin)
@@dbmstrst
@@prvttrst.plb

Rem on-disk versions of rman support
@@dbmsrman.sql
@@prvtrmns.plb
@@dbmsbkrs.sql
@@prvtbkrs.plb

Rem SNMP catalog objects:  need to be here since script does a DROP USER
@@catsnmp.sql

Rem Row Level Security package and catalog views
@@catrls
@@dbmsrlsa
@@prvtrlsa.plb

Rem Global Context internal package
@@prvtctx.plb

Rem Stored outline package and catalog views
@@catol.sql
@@dbmsol.sql
@@prvtol.plb

Rem Script for Extensibility types
@@prvtodci.plb

Rem Script for Application Role
@@catar.sql

Rem Data/Index Repair Package
@@dbmsrpr.sql
@@prvtrpr.plb

Rem System event attribute functions
@@dbmstrig.sql

Rem Random number generator
@@dbmsrand.sql

Rem Obfuscation (encryption) toolkist
@@dbmsobtk.sql
@@prvtobtk.plb

REM packages for Redo LogMiner
REM Make sure these are always called after dbmstrig.sql has been installed
@@dbmslm.sql
@@prvtlm.plb
@@dbmslmd.sql
@@prvtlmc.plb
@@prvtlmd.plb
@@prvtlmrd.plb

Rem All XML related types creation
@@catxml.sql

Rem UTL_XML: PL/SQL wrapper around CORE's LPX facility: C-based XML/XSL parsing
@@utlcxml.sql
@@prvtcxml.plb

Rem DataPump's Metadata API: depends on dbmsxml and utlcxml
@@catmet.sql

REM change data capture packages
REM prvtcdcu calls into prvtcdcp
@@dbmscdcu.sql
@@dbmscdcp.sql
@@dbmscdcs.sql
@@prvtcdcu.plb
@@prvtcdcp.plb
@@prvtcdcs.plb

REM Script for Fine Grained Auditing
@@catfga.sql
@@dbmsfga.sql
@@prvtfga.plb

Rem XDB Schema creation
Rem Comment this out until catqm.sql is finalized.
Rem @@catqm.sql


REM package for LogMiner logmnr_session
@@dbmslms.sql
@@prvtlms.plb

Rem Logical Standby scripts
@@prvtlsby.plb

Rem Type Utility 
@@dbmstypu.sql
@@prvttypu.plb

Rem
Rem embedded plsql gateway/owa packages
Rem
drop package sys.wpiutl;
@@wpiutil.sql
@@dbmsepgc.sql
@@prvtepgc.plb
@@owapatch.sql
  
Rem Multi-language debug support
@@dbmsjdwp.sql
@@prvtjdwp.plb
@@dbmsjdcu.sql

Rem Datapump DML support
@@dbmspump.sql

Rem package for Resumable and ora_space_error_info attribute function
@@dbmsres.sql
@@prvtres.plb

Rem SQLJ Object Type support
@@dbmssjty.sql
@@prvtsjty.plb

Rem OLAP Services
@@catxs.sql
@@dbmsaw.plb
@@prvtaw.plb

Rem Data Guard recovery framework support (dbms_drs)
@@dbmsdrs.sql
@@prvtdrs.plb

Rem Replication catalog installation
@@catrep.sql

Rem STREAMS
Rem catstr is loaded here because of the dependency on queues
@@catstr.sql
@@catpstr.sql

Rem Heterogeneous Services:  Gateways and external procedures, dbms_hs package
@@caths.sql

Rem File Mapping package
@@dbmsmap.sql
@@prvtmap.plb

Rem DBMS_LDAP package
@@catldap.sql

Rem ADD NEW PACKAGES ABOVE THIS BLOCK
------------------------------------------------------------------------------
Rem Indicate CATPROC load complete and check validity

@@prvtcr.plb

BEGIN
   dbms_registry.loaded('CATPROC',dbms_registry.release_version,
                'Oracle9i Packages and Types Release ' ||
                 dbms_registry.release_version || 
                ' - ' || dbms_registry.release_status);
   dbms_registry_sys.validate_catproc;
   dbms_registry_sys.validate_catalog;
END;
/
