Rem
Rem $Header: catprp.sql 19-jun-2002.09:10:29 sbalaram Exp $
Rem
Rem catprp.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catprp.sql - Streams Propagation Views
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sbalaram    06/19/02 - Fix bug 2395423
Rem    weiwang     02/01/02 - fix [dba|all]_propagation views
Rem    wesmith     01/10/02 - add grants to propagation views
Rem    sbalaram    12/10/01 - use create or replace synonym
Rem    alakshmi    11/08/01 - Merged alakshmi_apicleanup
Rem    jingliu     11/06/01 - fix typo
Rem    wesmith     11/04/01 - add public synonym for all_propagation
Rem    liwong      11/04/01 - Add all_propagation
Rem    kmeiyyap    11/02/01 - Created
Rem

CREATE OR REPLACE VIEW DBA_PROPAGATION
(PROPAGATION_NAME, SOURCE_QUEUE_OWNER, SOURCE_QUEUE_NAME, 
 DESTINATION_QUEUE_OWNER, DESTINATION_QUEUE_NAME, DESTINATION_DBLINK,
 RULE_SET_OWNER, RULE_SET_NAME)
AS
SELECT p.propagation_name, p.source_queue_schema, p.source_queue,
       p.destination_queue_schema, p.destination_queue, p.destination_dblink,
       p.ruleset_schema, p.ruleset
  FROM sys.streams$_propagation_process p
/
COMMENT ON TABLE dba_propagation IS
'Streams propagation in the database'
/
COMMENT ON COLUMN dba_propagation.propagation_name IS
'name of the Streams propagation'
/
COMMENT ON COLUMN dba_propagation.source_queue_owner IS
'owner of the propgation source queue'
/
COMMENT ON COLUMN dba_propagation.source_queue_name IS
'name of the propagation source queue'
/
COMMENT ON COLUMN dba_propagation.destination_queue_owner IS
'owner of the propagation destination queue'
/
COMMENT ON COLUMN dba_propagation.destination_queue_name IS
'name of the propagation destination queue'
/
COMMENT ON COLUMN dba_propagation.destination_dblink IS
'database link to access the propagation destination queue'
/
COMMENT ON COLUMN dba_propagation.rule_set_owner IS
'propagation rule set owner'
/
COMMENT ON COLUMN dba_propagation.rule_set_name IS
'propagation rule set name'
/


CREATE OR REPLACE PUBLIC SYNONYM dba_propagation FOR dba_propagation
/
GRANT SELECT ON dba_propagation TO select_catalog_role
/


CREATE OR REPLACE VIEW ALL_PROPAGATION
(PROPAGATION_NAME, SOURCE_QUEUE_OWNER, SOURCE_QUEUE_NAME, 
 DESTINATION_QUEUE_OWNER, DESTINATION_QUEUE_NAME, DESTINATION_DBLINK,
 RULE_SET_OWNER, RULE_SET_NAME)
AS
SELECT p.propagation_name, p.source_queue_schema, p.source_queue,
       p.destination_queue_schema, p.destination_queue, p.destination_dblink,
       p.ruleset_schema, p.ruleset
FROM   sys.streams$_propagation_process p, all_queues q
WHERE  p.source_queue_schema = q.owner and p.source_queue = q.name
       and p.ruleset_schema IS NULL and p.ruleset IS NULL
UNION ALL
SELECT p.propagation_name, p.source_queue_schema, p.source_queue,
       p.destination_queue_schema, p.destination_queue, p.destination_dblink,
       p.ruleset_schema, p.ruleset
FROM   sys.streams$_propagation_process p, all_queues q, all_rule_sets r
WHERE  p.source_queue_schema = q.owner and p.source_queue = q.name
       and p.ruleset_schema IS NOT NULL and p.ruleset_schema = r.rule_set_owner
       and p.ruleset IS NOT NULL and p.ruleset = r.rule_set_name
/
COMMENT ON TABLE all_propagation IS
'Streams propagation seen by the user'
/
COMMENT ON COLUMN all_propagation.propagation_name IS
'name of the Streams propagation'
/
COMMENT ON COLUMN all_propagation.source_queue_owner IS
'owner of the propgation source queue'
/
COMMENT ON COLUMN all_propagation.source_queue_name IS
'name of the propagation source queue'
/
COMMENT ON COLUMN all_propagation.destination_queue_owner IS
'owner of the propagation destination queue'
/
COMMENT ON COLUMN all_propagation.destination_queue_name IS
'name of the propagation destination queue'
/
COMMENT ON COLUMN all_propagation.destination_dblink IS
'database link to access the propagation destination queue'
/
COMMENT ON COLUMN all_propagation.rule_set_owner IS
'propagation rule set owner'
/
COMMENT ON COLUMN all_propagation.rule_set_name IS
'propagation rule set name'
/

CREATE OR REPLACE PUBLIC SYNONYM all_propagation FOR all_propagation
/
GRANT SELECT ON all_propagation TO public with grant option
/
