Rem
Rem $Header: catrelod.sql 17-oct-2005.12:32:53 rburns Exp $
Rem
Rem catrelod.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      catrelod.sql - Script to apply CATalog RELOaD scripts to a database
Rem
Rem    DESCRIPTION
Rem      This script encapsulates the "post downgrade" steps necessary
Rem      to reload the PL/SQL and Java packages, types, and classes.
Rem      It runs the "old" versions of catalog.sql and catproc.sql
Rem      and calls the component reload scripts.
Rem
Rem    NOTES
Rem      Use SQLPLUS and connect AS SYSDBA to run this script.
Rem      The database must be open for MIGRATE
Rem      
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      10/17/05 - add ampersand 
Rem    srtata      10/16/02 - add olsrelod.sql
Rem    rburns      08/27/02 - Add Ultra Search, remove ORDVIR
Rem    rburns      06/12/02 - remove pl/sql usage
Rem    rburns      05/24/02 - Created
Rem

Rem *************************************************************************
/*
 BEGIN CATRELOD.SQL */
Rem *************************************************************************

Rem =======================================================================
Rem Verify server version and MIGRATE status (PL/SQL not available yet)
Rem =======================================================================

WHENEVER SQLERROR EXIT;

/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database server version is not 9.2.0.
  Shutdown ABORT and use a different script or a different server.
#######################################################################
#######################################################################

*/
SELECT TO_NUMBER('MUST_BE_920') FROM v$instance
WHERE substr(version,1,5) != '9.2.0';

/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database has not been opened for MIGRATE.  

  Perform a "SHUTDOWN ABORT"  and 
  restart using MIGRATE.
#######################################################################
#######################################################################
*/
SELECT TO_NUMBER(status) FROM v$instance
WHERE status != 'OPEN MIGRATE';

Rem =======================================================================
Rem SET nls_length_semantics at session level (bug 1488174)
Rem =======================================================================

ALTER SESSION SET NLS_LENGTH_SEMANTICS=BYTE;

Rem =======================================================================
Rem Invalidate all PL/SQL packages and types
Rem =======================================================================

@@utlip

WHENEVER SQLERROR CONTINUE;

Rem =======================================================================
Rem Run catalog.sql and catproc.sql
Rem =======================================================================

Rem Remove any existing rows that would fire on DROP USER statements
delete from duc$;

SELECT 'COMP_TIMESTAMP START      ' || SYSTIMESTAMP AS timestamp FROM DUAL;
@@catalog.sql
SELECT dbms_registry.time_stamp('CATALOG') AS timestamp FROM DUAL;
@@catproc.sql 
SELECT dbms_registry.time_stamp('CATPROC') AS timestamp FROM DUAL;

Rem *************************************************************************
/*
 START Component Reloads */
Rem *************************************************************************

Rem Setup component script filename variable
COLUMN file_name NEW_VALUE comp_file NOPRINT;

Rem JServer
SELECT dbms_registry.script('JAVAVM','?/javavm/install/jvmrelod.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('JAVAVM') AS timestamp FROM DUAL;

Rem XDK for Java
SELECT dbms_registry.script('XML','?/xdk/admin/xmlrelod.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('XML') AS timestamp FROM DUAL;

Rem Java Supplied Packages
SELECT dbms_registry.script('CATJAVA','?/rdbms/admin/catjava.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('CATJAVA') AS timestamp FROM DUAL;

Rem Oracle XML Database
SELECT dbms_registry.script('XDB','?/rdbms/admin/xdbrelod.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('XDB') AS timestamp FROM DUAL;

Rem Real Application Clusters
SELECT dbms_registry.script('RAC','?/rdbms/admin/catclust.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('RAC') AS timestamp FROM DUAL;

Rem Oracle Workspace Manager
SELECT dbms_registry.script('OWM','?/rdbms/admin/owmrelod.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('OWM') AS timestamp FROM DUAL;

Rem Oracle Data Mining
SELECT dbms_registry.script('ODM','?/dm/admin/odmrelod.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('ODM') AS timestamp FROM DUAL;

Rem Messaging Gateway
SELECT dbms_registry.script('MGW','?/mgw/admin/mgwrelod.sql')
       AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('MGW') AS timestamp FROM DUAL;

Rem OLAP Catalog 
SELECT dbms_registry.script('AMD','?/cwmlite/admin/amdrelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('AMD') AS timestamp FROM DUAL;

Rem OLAP Analytic Workspace
SELECT dbms_registry.script('APS','?/olap/admin/apsrelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('APS') AS timestamp FROM DUAL;

Rem OLAP API
SELECT dbms_registry.script('XOQ','?/olap/admin/xoqrelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('XOQ') AS timestamp FROM DUAL;

Rem Intermedia
SELECT dbms_registry.script('ORDIM','?/ord/im/admin/imrelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('ORDIM') AS timestamp FROM DUAL;

Rem Spatial
SELECT dbms_registry.script('SDO','?/md/admin/sdorelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('SDO') AS timestamp FROM DUAL;

Rem Text
SELECT dbms_registry.script('CONTEXT','?/ctx/admin/ctxrelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('CONTEXT') AS timestamp FROM DUAL;

Rem Ultrasearch
SELECT dbms_registry.script('WK','?/ultrasearch/admin/wkrelod.sql')
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('WK') AS timestamp FROM DUAL;

Rem Oracle Label Security
SELECT dbms_registry.script('OLS','?/rdbms/admin/olsrelod.sql') 
AS file_name FROM DUAL;
@&comp_file
SELECT dbms_registry.time_stamp('OLS') AS timestamp FROM DUAL;

set serveroutput off

Rem *************************************************************************
/*
 END Component Reloads */
Rem *************************************************************************

Rem =======================================================================
Rem Display new versions and status
Rem =======================================================================

column comp_name format a35
SELECT comp_name, status, substr(version,1,10) as version from dba_registry;
/*
================================================================
   The above query lists the components now loaded in the database, 
   along with their current version and status. Next, run utlrp.sql 
   to recompile stored application code and then shutdown and
   restart for normal operation.
================================================================
*/   

Rem *************************************************************************
/*
 END CATRELOD.SQL */
Rem *************************************************************************



