Rem
Rem $Header: catrls.sql 10-aug-2002.17:04:18 spannala Exp $
Rem
Rem catrls.sql
Rem
Rem Copyright (c) 1998, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catrls.sql - Catalog views for Row Level Security
Rem
Rem    DESCRIPTION
Rem      Creates data dictionary views for row level security policies
Rem
Rem    NOTES
Rem      Must be run while connected to SYS
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    najain      07/16/02 - correct definition of all_policies
Rem    clei        10/10/01 - add synonym rls_grp$, rls_ctx and comment cleanup 
Rem    clei        07/20/01 - add synonym support
Rem    gviswana    05/24/01 - CREATE OR REPLACE SYNONYM
Rem    clei        04/12/01 - add static policy flag
Rem    htseng      04/12/01 - eliminate execute twice (remove ;).
Rem    dmwong      03/01/01 - rename dict vws to be consistent with the rest.
Rem    dmwong      12/19/00 - add public synonyms.
Rem    dmwong      07/11/00 - add DBA_POLICY_GROUP and DBA_POLICY_CONTEXT.
Rem    rshaikh     02/24/99 - change create view to create or replace view
Rem    dmwong      06/16/98 - update all_policies to depend on all_table and al
Rem    clei        03/09/98 - Created
Rem

create or replace view DBA_POLICIES (OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP,
                          POLICY_NAME, PF_OWNER, PACKAGE, FUNCTION, SEL, INS,
			  UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY) 
as
select u.name, o.name, r.gname, r.pname, r.pfschma, r.ppname, r.pfname,
       decode(bitand(r.stmt_type,1), 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,2), 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,4), 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,8), 0, 'NO', 'YES'),
       decode(r.check_opt, 0, 'NO', 'YES'),
       decode(r.enable_flag, 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,16), 0, 'NO', 'YES')
from user$ u, obj$ o, rls$ r
where u.user# = o.owner# 
and r.obj# = o.obj# and r.ptype is null
union
select u.name, o.name, r.gname, r.pname, r.pfschma, r.ppname, r.pfname,
       decode(bitand(r.stmt_type,1), 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,2), 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,4), 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,8), 0, 'NO', 'YES'),
       decode(r.check_opt, 0, 'NO', 'YES'),
       decode(r.enable_flag, 0, 'NO', 'YES'),
       decode(bitand(r.stmt_type,16), 0, 'NO', 'YES')
from user$ u, obj$ o, rls$ r
where u.user# = o.owner#
and r.ptype = o.obj# and r.ptype is not null
/
comment on table DBA_POLICIES is
'All row level security policies in the database'
/
comment on column DBA_POLICIES.OBJECT_OWNER is
'Owner of the synonym, table, or view'
/
comment on column DBA_POLICIES.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column DBA_POLICIES.POLICY_GROUP is
'Name of the policy group'
/
comment on column DBA_POLICIES.POLICY_NAME is
'Name of the policy'
/
comment on column DBA_POLICIES.PF_OWNER is
'Owner of the policy function'
/
comment on column DBA_POLICIES.PACKAGE is
'Name of the package containing the policy function'
/
comment on column DBA_POLICIES.FUNCTION is
'Name of the policy function'
/
comment on column DBA_POLICIES.SEL is
'If YES, policy is applied to query on the object'
/
comment on column DBA_POLICIES.INS is
'If YES, policy is applied to insert on the object'
/
comment on column DBA_POLICIES.UPD is
'If YES, policy is applied to update on the object'
/
comment on column DBA_POLICIES.DEL is
'If YES, policy is applied to delete on the object'
/
comment on column DBA_POLICIES.CHK_OPTION is
'Is check option enforced for this policy?'
/
comment on column DBA_POLICIES.ENABLE is
'Is this policy is enabled?'
/
comment on column DBA_POLICIES.STATIC_POLICY is
'Is this policy is static?'
/
create or replace public synonym DBA_POLICIES for DBA_POLICIES
/
grant select on DBA_POLICIES to select_catalog_role
/
create or replace view ALL_POLICIES (OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP,
                          POLICY_NAME, PF_OWNER, PACKAGE, FUNCTION, SEL, INS,
			  UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY) 
as
SELECT OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP, POLICY_NAME, PF_OWNER, 
PACKAGE, FUNCTION, SEL, INS, UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY
FROM DBA_POLICIES, ALL_TABLES t
WHERE 
(OBJECT_OWNER = t.OWNER AND OBJECT_NAME = t.TABLE_NAME) 
union all
SELECT OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP, POLICY_NAME, PF_OWNER,
PACKAGE, FUNCTION, SEL, INS, UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY
FROM DBA_POLICIES, ALL_VIEWS v
WHERE
(OBJECT_OWNER = v.OWNER AND OBJECT_NAME = v.VIEW_NAME )
union all
SELECT OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP, POLICY_NAME, PF_OWNER,
PACKAGE, FUNCTION, SEL, INS, UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY
FROM DBA_POLICIES, ALL_SYNONYMS s
WHERE
(OBJECT_OWNER = s.OWNER AND OBJECT_NAME = s.SYNONYM_NAME)
/

comment on table ALL_POLICIES is
'All policies for objects if the user has system privileges or owns the objects'
/
comment on column ALL_POLICIES.OBJECT_OWNER is
'Owner of the synonym, table, or view'
/
comment on column ALL_POLICIES.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column ALL_POLICIES.POLICY_NAME is
'Name of the policy'
/
comment on column ALL_POLICIES.PF_OWNER is
'Owner of the policy function'
/
comment on column ALL_POLICIES.PACKAGE is
'Name of the package containing the policy function'
/
comment on column ALL_POLICIES.FUNCTION is
'Name of the policy function'
/
comment on column ALL_POLICIES.SEL is
'If YES, policy is applied to query on the object'
/
comment on column ALL_POLICIES.INS is
'If YES, policy is applied to insert on the object'
/
comment on column ALL_POLICIES.UPD is
'If YES, policy is applied to update on the object'
/
comment on column ALL_POLICIES.DEL is
'If YES, policy is applied to delete on the object'
/
comment on column ALL_POLICIES.CHK_OPTION is
'Is check option enforced for this policy?'
/
comment on column ALL_POLICIES.ENABLE is
'Is this policy is enabled?'
/
comment on column ALL_POLICIES.STATIC_POLICY is
'Is this policy is static?'
/
create or replace public synonym ALL_POLICIES for ALL_POLICIES
/
grant select on ALL_POLICIES to PUBLIC with grant option
/
create or replace view USER_POLICIES (OBJECT_NAME, POLICY_GROUP, POLICY_NAME, 
			  PF_OWNER, PACKAGE, FUNCTION, SEL, INS,
			  UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY) 
as
SELECT OBJECT_NAME, POLICY_GROUP, POLICY_NAME, PF_OWNER, PACKAGE, 
FUNCTION, SEL, INS, UPD, DEL, CHK_OPTION, ENABLE, STATIC_POLICY
FROM DBA_POLICIES
WHERE 
OBJECT_OWNER = SYS_CONTEXT('USERENV','CURRENT_USER')
/
comment on table USER_POLICIES is
'All row level security policies for synonyms, tables, or views owned by the user'
/
comment on column USER_POLICIES.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column USER_POLICIES.POLICY_NAME is
'Name of the policy'
/
comment on column USER_POLICIES.PF_OWNER is
'Owner of the policy function'
/
comment on column USER_POLICIES.PACKAGE is
'Name of the package containing the policy function'
/
comment on column USER_POLICIES.FUNCTION is
'Name of the policy function'
/
comment on column USER_POLICIES.SEL is
'If YES, policy is applied to query on the object'
/
comment on column USER_POLICIES.INS is
'If YES, policy is applied to insert on the object'
/
comment on column USER_POLICIES.UPD is
'If YES, policy is applied to update on the object'
/
comment on column USER_POLICIES.DEL is
'If YES, policy is applied to delete on the object'
/
comment on column USER_POLICIES.CHK_OPTION is
'Is check option enforced for this policy?'
/
comment on column USER_POLICIES.ENABLE is
'Is this policy is enabled?'
/
comment on column USER_POLICIES.STATIC_POLICY is
'Is this policy is static?'
/
create or replace public synonym USER_POLICIES for USER_POLICIES
/
grant select on USER_POLICIES to PUBLIC with grant option
/

create or replace view DBA_POLICY_GROUPS (OBJECT_OWNER, OBJECT_NAME,
                          POLICY_GROUP)
as
select u.name, o.name, g.gname
from user$ u, obj$ o, rls_grp$ g
where u.user# = o.owner#
and g.obj# = o.obj# and g.synid is null
union
select u.name, o.name, g.gname
from user$ u, obj$ o, rls_grp$ g
where u.user# = o.owner#
and g.synid = o.obj# and g.synid is not null
/
comment on table DBA_POLICY_GROUPS is
'All policy groups defined for any synonym, table, view in the database'
/
comment on column DBA_POLICY_GROUPS.OBJECT_OWNER is
'Schema of the synonym, table, or view'
/
comment on column DBA_POLICY_GROUPS.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column DBA_POLICY_GROUPS.POLICY_GROUP is
'Policy group defined'
/
create or replace public synonym DBA_POLICY_GROUPS for DBA_POLICY_GROUPS
/
grant select on DBA_POLICY_GROUPS to select_catalog_role
/

create or replace view ALL_POLICY_GROUPS (OBJECT_OWNER, OBJECT_NAME,
                          POLICY_GROUP)
as
SELECT OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP
FROM DBA_POLICY_GROUPS, ALL_TABLES t
WHERE
(OBJECT_OWNER = t.OWNER AND OBJECT_NAME = t.TABLE_NAME) 
union all
SELECT OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP
FROM DBA_POLICY_GROUPS, ALL_VIEWS v
WHERE
(OBJECT_OWNER = v.OWNER AND OBJECT_NAME = v.VIEW_NAME )
union all
SELECT OBJECT_OWNER, OBJECT_NAME, POLICY_GROUP
FROM DBA_POLICY_GROUPS, ALL_SYNONYMS s
WHERE
(OBJECT_OWNER = s.OWNER AND OBJECT_NAME = s.SYNONYM_NAME)
/

comment on table ALL_POLICY_GROUPS is
'All policy groups defined for any synonym, table or view accessable to the user'
/
comment on column ALL_POLICY_GROUPS.OBJECT_OWNER is
'Schema of the synonym, table, or view'
/
comment on column ALL_POLICY_GROUPS.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column ALL_POLICY_GROUPS.POLICY_GROUP is
'Policy group defined'
/
create or replace public synonym ALL_POLICY_GROUPS for ALL_POLICY_GROUPS
/
grant select on ALL_POLICY_GROUPS to public
/


create or replace view USER_POLICY_GROUPS (OBJECT_NAME, POLICY_GROUP)
as
SELECT OBJECT_NAME, POLICY_GROUP
FROM DBA_POLICY_GROUPS
WHERE OBJECT_OWNER = SYS_CONTEXT('USERENV','CURRENT_USER')
/

comment on table USER_POLICY_GROUPS is
'All policy groups defined for any synonym, table, or view'
/
comment on column USER_POLICY_GROUPS.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column USER_POLICY_GROUPS.POLICY_GROUP is
'Policy group defined'
/
create or replace public synonym USER_POLICY_GROUPS for USER_POLICY_GROUPS
/
grant select on USER_POLICY_GROUPS to public
/


create or replace view DBA_POLICY_CONTEXTS (OBJECT_OWNER, OBJECT_NAME,
                          NAMESPACE,ATTRIBUTE)
as
select u.name, o.name, c.ns, c.attr
from user$ u, obj$ o, rls_ctx$ c
where u.user# = o.owner#
and c.obj# = o.obj# and c.synid is null
union
select u.name, o.name, c.ns, c.attr
from user$ u, obj$ o, rls_ctx$ c
where u.user# = o.owner#
and c.synid = o.obj# and c.synid is not null
/
comment on table DBA_POLICY_CONTEXTS is
'All policy driving context defined for any synonym, table, or view in the database'
/
comment on column DBA_POLICY_CONTEXTS.OBJECT_OWNER is
'Schema of the synonym, table, or view'
/
comment on column DBA_POLICY_CONTEXTS.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column DBA_POLICY_CONTEXTS.NAMESPACE is
'Namespace of the context'
/
comment on column DBA_POLICY_CONTEXTS.ATTRIBUTE is
'Attribute of the context'
/
create or replace public synonym DBA_POLICY_CONTEXTS for DBA_POLICY_CONTEXTS
/
grant select on DBA_POLICY_CONTEXTS to select_catalog_role
/

create or replace view ALL_POLICY_CONTEXTS (OBJECT_OWNER, OBJECT_NAME,
                          NAMESPACE,ATTRIBUTE)
as
SELECT OBJECT_OWNER, OBJECT_NAME,NAMESPACE,ATTRIBUTE
FROM DBA_POLICY_CONTEXTS, ALL_TABLES t
WHERE
(OBJECT_OWNER = t.OWNER AND OBJECT_NAME = t.TABLE_NAME)
union all
SELECT OBJECT_OWNER, OBJECT_NAME,NAMESPACE,ATTRIBUTE
FROM DBA_POLICY_CONTEXTS, ALL_VIEWS v
WHERE
(OBJECT_OWNER = v.OWNER AND OBJECT_NAME = v.VIEW_NAME )
union all
SELECT OBJECT_OWNER, OBJECT_NAME,NAMESPACE,ATTRIBUTE
FROM DBA_POLICY_CONTEXTS, ALL_SYNONYMS s
WHERE
(OBJECT_OWNER = s.OWNER AND OBJECT_NAME = s.SYNONYM_NAME )
/
/

comment on table ALL_POLICY_CONTEXTS is
'All policy driving context defined for all synonyms, tables, or views accessable to the user'
/
comment on column ALL_POLICY_CONTEXTS.OBJECT_OWNER is
'Schema of the synonym, table, or view'
/
comment on column ALL_POLICY_CONTEXTS.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column ALL_POLICY_CONTEXTS.NAMESPACE is
'Namespace of the context'
/
comment on column ALL_POLICY_CONTEXTS.ATTRIBUTE is
'Attribute of the context'
/
create or replace public synonym ALL_POLICY_CONTEXTS for ALL_POLICY_CONTEXTS
/
grant select on ALL_POLICY_CONTEXTS to public
/

create or replace view USER_POLICY_CONTEXTS (OBJECT_NAME,
                          NAMESPACE,ATTRIBUTE)
as
SELECT OBJECT_NAME,NAMESPACE,ATTRIBUTE
FROM DBA_POLICY_CONTEXTS
WHERE OBJECT_OWNER = SYS_CONTEXT('USERENV','CURRENT_USER')
/

comment on table USER_POLICY_CONTEXTS is
'All policy driving context defined for synonyms, tables, or views in current schema'
/
comment on column USER_POLICY_CONTEXTS.OBJECT_NAME is
'Name of the synonym, table, or view'
/
comment on column USER_POLICY_CONTEXTS.NAMESPACE is
'Namespace of the context'
/
comment on column USER_POLICY_CONTEXTS.ATTRIBUTE is
'Attribute of the context'
/
create or replace public synonym USER_POLICY_CONTEXTS for USER_POLICY_CONTEXTS
/
grant select on USER_POLICY_CONTEXTS to public
/

