Rem 
Rem NAME
Rem    CATSNMP.SQL
Rem  FUNCTION
Rem    Creates an SNMPAgent role to access the v$ tables
Rem  NOTES
Rem  MODIFIED
Rem     jaysmith   08/18/02 - suppress error from create user
Rem     jaysmith   08/16/02 - do not recreate DBSNMP user each time run
Rem     xxu        02/01/02 - add function OemGetNextExtend
Rem     glavash    01/03/02 - remove superfluos privs
Rem     rburns     10/28/01 - wrap drop role statement
Rem     gviswana   05/24/01 - CREATE OR REPLACE SYNONYM
Rem	jaysmith   04/11/01 - restore views, oemagent roles
Rem	jaysmith   03/08/01 - pull back grants for dbsnmp user
Rem	glavash    02/16/01 - add select access to sys.obj$ user and ts
Rem	glavash    10/23/00 - add statspack views 
Rem     dholail    04/12/99 - Adding Events role OEM_MONITOR
Rem     cluo       07/15/96 -
Rem     dnakos     removed creation of backup script tables
Rem     dnakos     removed creation of obsolete history tables
Rem     dnakos     removed references to obsolete DBA_LOCKS
Rem
Rem  OWNER
Rem    ebosco
Rem

BEGIN
  EXECUTE IMMEDIATE 'drop role SNMPAGENT';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE = -1919 THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

Rem
Rem  Create X$views as a temporary workaround to externalizing these objects
Rem  through V$views

create or replace view           X_$KCBFWAIT as select * from  X$KCBFWAIT;
create or replace public synonym  X$KCBFWAIT for              X_$KCBFWAIT;

create or replace view           X_$KSPPSV   as select * from  X$KSPPSV;
create or replace public synonym  X$KSPPSV   for              X_$KSPPSV;

create or replace view           X_$KSPPI    as select * from  X$KSPPI;
create or replace public synonym  X$KSPPI    for              X_$KSPPI;

create or replace view           X_$KSQST    as select * from  X$KSQST;
create or replace public synonym  X$KSQST    for              X_$KSQST;

create or replace view            X_$KSLLT  as select * from X$KSLLT;
create or replace public synonym X$KSLLT     for              X_$KSLLT;

create or replace view V_$FILESTATXS as
select ts.name      tsname
     , df.name	    filename
     , fs.phyrds
     , fs.phywrts
     , fs.readtim
     , fs.writetim
     , fs.phyblkrd
     , fs.phyblkwrt
     , fw.count     wait_count
     , fw.time      time
  from x$kcbfwait   fw
     , v$filestat   fs
     , v$tablespace ts
     , v$datafile   df
 where ts.ts#    = df.ts#
   and fs.file#  = df.file#
   and fw.indx+1 = df.file#;

create or replace public synonym  V$FILESTATXS for V_$FILESTATXS;

create or replace view V_$TEMPSTATXS as
select ts.name      tsname
     , tf.name	    filename
     , tm.phyrds
     , tm.phywrts
     , tm.readtim
     , tm.writetim
     , tm.phyblkrd
     , tm.phyblkwrt
     , fw.count     wait_count
     , fw.time      time
  from x$kcbfwait   fw
     , v$tempstat   tm
     , v$tablespace ts
     , v$tempfile   tf
 where ts.ts#     = tf.ts#
   and tm.file#   = tf.file#
   and fw.indx+1  = tf.file#;

create or replace public synonym  V$TEMPSTATXS for V_$TEMPSTATXS;

create or replace view V_$SQLXS as 
select max(sql_text)        sql_text
     , sum(sharable_mem)    sharable_mem
     , sum(sorts)           sorts
     , min(module)          module
     , sum(loaded_versions) loaded_versions
     , sum(executions)      executions
     , sum(loads)           loads
     , sum(invalidations)   invalidations
     , sum(parse_calls)     parse_calls
     , sum(disk_reads)      disk_reads
     , sum(buffer_gets)     buffer_gets
     , sum(rows_processed)  rows_processed
     , address              address
     , hash_value           hash_value
     , count(1)             version_count
  from v$sql
  group by hash_value, address;

create or replace public synonym V$SQLXS for V_$SQLXS; 


rem xxu: following function is for chunk small event

CREATE OR REPLACE FUNCTION OemGetNextExtend
  (ext IN NUMBER, pct_inc IN NUMBER, blksize IN NUMBER, ntimes IN NUMBER)

  RETURN NUMBER IS

  blocks NUMBER;
  retval NUMBER;
  factor NUMBER;
  niter  NUMBER;

BEGIN
  blocks  := CEIL(ext / blksize);
  retval  := blocks * blksize;
  factor  := 1 + (pct_inc / 100);
  niter   := ntimes;

  WHILE niter > 1 LOOP
    blocks := CEIL(blocks * factor);
    retval := retval + blocks * blksize;
    niter  := niter - 1;
  END LOOP;

  RETURN retval;
END;
/

create role OEM_MONITOR;
grant connect to OEM_MONITOR;
grant analyze any to OEM_MONITOR;
grant resource to OEM_MONITOR;
grant create table to OEM_MONITOR;
grant select any DICTIONARY to OEM_MONITOR;
grant execute on SYS.DBMS_SYSTEM to OEM_MONITOR;
grant execute on OemGetNextExtend to OEM_MONITOR;

BEGIN
  EXECUTE IMMEDIATE 'create user DBSNMP identified by DBSNMP';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE = -1920 THEN NULL;
      ELSE RAISE;
      END IF;
END;
/


grant CONNECT, SELECT ANY DICTIONARY to DBSNMP;
