Rem
Rem $Header: catspc2.sql 23-apr-2003.12:36:59 nireland Exp $
Rem
Rem catspc2.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catspc2.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nireland    04/23/03 - nireland_backport_9.2.0.3.0_2670946
Rem    nireland    02/04/03 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

create or replace view SYS_DBA_SEGS_2
    (OWNER, SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE, SEGMENT_TYPE_ID,
     TABLESPACE_ID,
     HEADER_BLOCK,
     BLOCKS, EXTENTS, 
     INITIAL_EXTENT_BLOCKS, NEXT_EXTENT_BLOCKS,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, FREELISTS, FREELIST_GROUPS,
     RELATIVE_FNO, BUFFER_POOL_ID, SEGMENT_FLAGS, SEGMENT_OBJD, OWNER_ID)
as
select u.name, o.name, o.subname,
       decode(bitand(t.property, 8192), 8192, 'NESTED TABLE', 'TABLE'), s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.tab$ t, sys.seg$ s
where s.file# = t.file#
  and s.block# = t.block#
  and s.ts# = t.ts#
  and o.obj# = t.obj#
  and o.owner# = u.user#
  and s.type# = 5
  and o.type# = 2
  and bitand(t.property, 1024) = 0               /* exclude clustered tables */
union all
select u.name, o.name, o.subname,
       'TABLE PARTITION', s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.tabpart$ tp, sys.seg$ s
where s.file# = tp.file#
  and s.block# = tp.block#
  and s.ts# = tp.ts#
  and o.obj# = tp.obj#
  and o.owner# = u.user#
  and s.type# = 5
  and o.type# = 19
union all
select u.name, o.name, o.subname,
       'CLUSTER', s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.clu$ c, sys.seg$ s
where s.file# = c.file#
  and s.block# = c.block#
  and s.ts# = c.ts#
  and o.obj# = c.obj#
  and o.owner# = u.user#
  and s.type# = 5
  and o.type# = 3
union all
select u.name, o.name, o.subname,
       decode(i.type#, 8, 'LOBINDEX', 'INDEX'), s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.ind$ i, sys.seg$ s
where s.file# = i.file#
  and s.block# = i.block#
  and s.ts# = i.ts#
  and o.obj# = i.obj#
  and o.owner# = u.user#
  and s.type# = 6
  and o.type# = 1
  and i.type# in (1, 2, 3, 4, 6, 7, 8, 9)
union all
select u.name, o.name, o.subname,
       'INDEX PARTITION', s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.indpart$ ip, sys.seg$ s
where s.file# = ip.file#
  and s.block# = ip.block#
  and s.ts# = ip.ts#
  and o.obj# = ip.obj#
  and o.owner# = u.user#
  and s.type# = 6
  and o.type# = 20
union all
select u.name, o.name, o.subname,
       'LOBSEGMENT', s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.lob$ l, sys.seg$ s
where s.file# = l.file#
  and s.block# = l.block#
  and s.ts# = l.ts#
  and o.obj# = l.lobj#
  and o.owner# = u.user#
  and s.type# = 8
  and o.type# = 21
  and ((bitand(l.property, 64) = 0) or
      (bitand(l.property, 128) = 128))
union all
select u.name, o.name, o.subname,
       'TABLE SUBPARTITION', s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.tabsubpart$ tsp, sys.seg$ s
where s.file# = tsp.file#
  and s.block# = tsp.block#
  and s.ts# = tsp.ts#
  and o.obj# = tsp.obj#
  and o.owner# = u.user#
  and s.type# = 5
  and o.type# = 34
union all
select u.name, o.name, o.subname,
       'INDEX SUBPARTITION', s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.indsubpart$ isp, sys.seg$ s
where s.file# = isp.file#
  and s.block# = isp.block#
  and s.ts# = isp.ts#
  and o.obj# = isp.obj#
  and o.owner# = u.user#
  and s.type# = 6
  and o.type# = 35
union all
select u.name, o.name, o.subname,
       decode(lf.fragtype$, 'P', 'LOB PARTITION', 'LOB SUBPARTITION'), s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents, 
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), o.dataobj#, o.owner#
from sys.user$ u, sys.obj$ o, sys.lobfrag$ lf, sys.seg$ s
where s.file# = lf.file#
  and s.block# = lf.block#
  and s.ts# = lf.ts#
  and o.obj# = lf.fragobj#
  and o.owner# = u.user#
  and s.type# = 8
  and o.type# = decode(lf.fragtype$, 'P', 40, 41)
union all
select u.name, un.name, NULL,
       decode(s.type#, 1, 'ROLLBACK', 10, 'TYPE2 UNDO'), s.type#,
       s.ts#, s.block#,
       s.blocks, s.extents,
       s.iniexts, s.extsize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups), 
       s.file#, s.cachehint, NVL(s.spare1,0), un.us#, s.user#
from sys.user$ u, sys.undo$ un, sys.seg$ s
where s.file# = un.file#
  and s.block# = un.block#
  and s.ts# = un.ts#
  and s.user# = u.user#
  and s.type# in (1, 10)
  and un.status$ != 1
union all
select u.name, to_char(f.file#) || '.' || to_char(s.block#), NULL,
       decode(s.type#, 2, 'DEFERRED ROLLBACK', 3, 'TEMPORARY',
                      4, 'CACHE', 9, 'SPACE HEADER', 'UNDEFINED'), s.type#,
       s.ts#,
       s.block#,
       s.blocks, s.extents,
       s.iniexts, 
       s.extsize, 
       s.minexts, s.maxexts, 
       s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#, s.cachehint, NVL(s.spare1,0), s.hwmincr, s.user#
from sys.user$ u, sys.seg$ s, sys.file$ f
where s.user# = u.user#
  and s.type# not in (1, 5, 6, 8, 10)
  and s.ts# = f.ts#
  and s.file# = f.relfile#
/
grant select on SYS_DBA_SEGS_2 to select_catalog_role
/
create or replace view DBA_SEGMENTS_2
    (OWNER, SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE,
     TABLESPACE_NAME,
     HEADER_FILE, HEADER_BLOCK,
     BYTES, BLOCKS, EXTENTS, 
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, FREELISTS, FREELIST_GROUPS,
     RELATIVE_FNO, BUFFER_POOL)
as
select /*+ use_concat */
       s.owner, s.segment_name, s.partition_name, s.segment_type, ts.name,
       f.file#, s.header_block,
       dbms_space_admin.segment_number_blocks(s.tablespace_id, s.relative_fno,
       s.header_block, s.segment_type_id, s.buffer_pool_id, s.segment_flags,
       s.segment_objd, s.blocks) * ts.blocksize,
       dbms_space_admin.segment_number_blocks(s.tablespace_id, s.relative_fno,
       s.header_block, s.segment_type_id, s.buffer_pool_id, s.segment_flags,
       s.segment_objd, s.blocks),
       dbms_space_admin.segment_number_extents(s.tablespace_id, s.relative_fno,
       s.header_block, s.segment_type_id, s.buffer_pool_id, s.segment_flags,
       s.segment_objd, s.extents),
       s.initial_extent_blocks * ts.blocksize, 
       decode(bitand(ts.flags, 3), 1, to_number(NULL),
                                      s.next_extent_blocks) *ts.blocksize,
       min_extents, s.max_extents, 
       decode(bitand(ts.flags, 3), 1, to_number(NULL),
                                      s.pct_increase),
       decode(bitand(ts.flags, 32), 32, to_number(NULL), s.freelists), 
       decode(bitand(ts.flags, 32), 32, to_number(NULL), freelist_groups), 
       relative_fno,
       decode(s.buffer_pool_id, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from  sys.file$ f, sys.ts$ ts, sys_dba_segs_2 s
where s.TABLESPACE_ID = ts.ts#
  and s.TABLESPACE_ID = f.ts#
  and s.relative_fno = f.relfile#
/
create or replace public synonym DBA_SEGMENTS_2 for DBA_SEGMENTS_2
/
grant select on DBA_SEGMENTS_2 to PUBLIC with grant option
/
create or replace view USER_SEGMENTS_2
    (SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE,
     TABLESPACE_NAME,
     BYTES, BLOCKS, EXTENTS, 
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, FREELISTS, FREELIST_GROUPS,
     BUFFER_POOL)
as
select /*+ use_concat */
       s.segment_name, s.partition_name, s.segment_type, ts.name,
       dbms_space_admin.segment_number_blocks(s.tablespace_id, s.relative_fno,
       s.header_block, s.segment_type_id, s.buffer_pool_id, s.segment_flags,
       s.segment_objd, s.blocks) * ts.blocksize,
       dbms_space_admin.segment_number_blocks(s.tablespace_id, s.relative_fno,
       s.header_block, s.segment_type_id, s.buffer_pool_id, s.segment_flags,
       s.segment_objd, s.blocks),
       dbms_space_admin.segment_number_extents(s.tablespace_id, s.relative_fno,
       s.header_block, s.segment_type_id, s.buffer_pool_id, s.segment_flags,
       s.segment_objd, s.extents),
       s.initial_extent_blocks * ts.blocksize, 
       decode(bitand(ts.flags, 3), 1, to_number(NULL),
                                      s.next_extent_blocks) * ts.blocksize,
       min_extents, s.max_extents, 
       decode(bitand(ts.flags, 3), 1, to_number(NULL),
                                      s.pct_increase),
       decode(bitand(ts.flags, 32), 32, to_number(NULL), s.freelists), 
       decode(bitand(ts.flags, 32), 32, to_number(NULL), freelist_groups), 
       decode(s.buffer_pool_id, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from  sys.ts$ ts, sys_dba_segs_2 s
where s.TABLESPACE_ID = ts.ts#
  and s.owner_id = userenv('SCHEMAID')
/
create or replace public synonym USER_SEGMENTS_2 for USER_SEGMENTS_2
/
grant select on USER_SEGMENTS_2 to PUBLIC with grant option
/
create or replace view DBA_EXTENTS_2
    (OWNER, SEGMENT_NAME, PARTITION_NAME, SEGMENT_TYPE, TABLESPACE_NAME,
     EXTENT_ID, FILE_ID, BLOCK_ID,
     BYTES, BLOCKS, RELATIVE_FNO)
as
select /*+ ordered use_nl(e1) use_nl(f1) use_nl(e2) use_nl(f2) */
       ds.owner, ds.segment_name, ds.partition_name, ds.segment_type, 
       ts.name,
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbueextno, e2.ext#),
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, f1.file#, f2.file#),
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbuebno, e2.block#),
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbueblks, e2.length) * ts.blocksize, 
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbueblks, e2.length),
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbuefno, e2.file#)
from sys.ts$ ts, sys.sys_dba_segs_2 ds, sys.x$ktfbue e1, sys.file$ f1, 
     sys.uet$ e2, sys.file$ f2
where e1.ktfbuesegfno (+) = ds.relative_fno
  and e1.ktfbuesegbno (+) = ds.header_block
  and e1.ktfbuesegtsn (+) = ds.tablespace_id
  and e1.ktfbuesegtsn = f1.ts# (+)
  and e1.ktfbuefno = f1.relfile# (+)
  and e2.segfile# (+) = ds.relative_fno
  and e2.segblock# (+) = ds.header_block
  and e2.ts# (+) = ds.tablespace_id
  and e2.ts# = f2.ts# (+)
  and e2.file# = f2.relfile# (+)
  and ds.tablespace_id = ts.ts#
/
create or replace public synonym DBA_EXTENTS_2 for DBA_EXTENTS_2
/
grant select on DBA_EXTENTS_2 to PUBLIC with grant option
/
create or replace view USER_EXTENTS_2
    (SEGMENT_NAME, PARTITION_NAME, SEGMENT_TYPE, TABLESPACE_NAME,
     EXTENT_ID, BYTES, BLOCKS)
as
select /*+ ordered use_nl(e1) use_nl(f1) use_nl(e2) use_nl(f2) */
       ds.segment_name, ds.partition_name, ds.segment_type, 
       ts.name,
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbueextno, e2.ext#),
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbueblks, e2.length) * ts.blocksize, 
       decode (bitand(NVL(ds.segment_flags, 0), 1), 1, e1.ktfbueblks, e2.length)
from sys.ts$ ts, sys.sys_dba_segs_2 ds, sys.x$ktfbue e1, sys.uet$ e2
where e1.ktfbuesegfno (+) = ds.relative_fno
  and e1.ktfbuesegbno (+) = ds.header_block
  and e1.ktfbuesegtsn (+) = ds.tablespace_id
  and e2.segfile# (+) = ds.relative_fno
  and e2.segblock# (+) = ds.header_block
  and e2.ts# (+) = ds.tablespace_id
  and ds.tablespace_id = ts.ts#
  and ds.owner_id = userenv('SCHEMAID')
/
create or replace public synonym USER_EXTENTS_2 for USER_EXTENTS_2
/
grant select on USER_EXTENTS_2 to PUBLIC with grant option
/
