Rem
Rem $Header: catstr.sql 11-sep-2003.17:59:52 bpwang Exp $
Rem
Rem catstr.sql
Rem
Rem Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catstr.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bpwang      09/11/03 - xbranchmerge to 'st_rdbms_9.2.0.1' 
Rem    sbalaram    06/17/02 - Fix bug 2395423
Rem    sbalaram    01/25/02 - Fix all_streams_*_rules views
Rem    wesmith     01/09/02 - Streams export/import support
Rem    sbalaram    12/10/01 - use create or replace synonym
Rem    sbalaram    12/04/01 - decode subsetting_operation
Rem    sbalaram    11/16/01 - Fix comments on some views
Rem    alakshmi    11/08/01 - Merged alakshmi_apicleanup
Rem    sbalaram    10/29/01 - add views
Rem    apadmana    10/26/01 - Created
Rem

@@catcap
@@catapp
@@catprp

-------------------------------------------------------------------------------
-- Views on streams tables
-------------------------------------------------------------------------------
Rem Views on streams$_process_params

REM streams$_rule_name_s sequence is used to generate rule names for 
REM automatic creation of rule names.

CREATE SEQUENCE streams$_rule_name_s START WITH 1 NOCACHE
/

----------------------------------------------------------------------------
-- Views on streams$_rules table
----------------------------------------------------------------------------

-- Private view select to all columns from streams$_rules
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_STREAMS_RULES"
as select 
  streams_name, streams_type, rule_type, include_tagged_lcr, 
  source_database, rule_owner, rule_name, rule_condition, dml_condition, 
  subsetting_operation, schema_name, object_name, object_type,
  spare1, spare2, spare3
from sys.streams$_rules
/
grant select on "_DBA_STREAMS_RULES" to exp_full_database
/

create or replace view DBA_STREAMS_GLOBAL_RULES
  (STREAMS_NAME, STREAMS_TYPE, RULE_TYPE, INCLUDE_TAGGED_LCR,
   SOURCE_DATABASE, RULE_NAME, RULE_OWNER, RULE_CONDITION) 
as
select streams_name, decode(streams_type, 1, 'CAPTURE',
                                          2, 'PROPAGATION',
                                          3, 'APPLY', 'UNDEFINED'),
       decode(rule_type, 1, 'DML',
                         2, 'DDL', 'UNKNOWN'),
       decode(include_tagged_lcr, 0, 'NO',
                                  1, 'YES'),
       source_database, rule_name, rule_owner, rule_condition
  from "_DBA_STREAMS_RULES"
 where object_type = 3
/

comment on table DBA_STREAMS_GLOBAL_RULES is
'Global rules created by streams administrative APIs'
/
comment on column DBA_STREAMS_GLOBAL_RULES.STREAMS_NAME is
'Name of the streams process: capture/propagation/apply process'
/
comment on column DBA_STREAMS_GLOBAL_RULES.STREAMS_TYPE is
'Type of the streams process: CAPTURE, PROPAGATION or APPLY'
/
comment on column DBA_STREAMS_GLOBAL_RULES.RULE_TYPE is
'Type of rule: DML or DDL'
/
comment on column DBA_STREAMS_GLOBAL_RULES.INCLUDE_TAGGED_LCR is
'Whether or not to include tagged LCR'
/
comment on column DBA_STREAMS_GLOBAL_RULES.SOURCE_DATABASE is
'Name of the database where the LCRs originated'
/
comment on column DBA_STREAMS_GLOBAL_RULES.RULE_OWNER is
'Owner of the rule'
/
comment on column DBA_STREAMS_GLOBAL_RULES.RULE_NAME is
'Name of the rule to be applied'
/
comment on column DBA_STREAMS_GLOBAL_RULES.RULE_CONDITION is
'Generated rule condition evaluated by the rules engine'
/
create or replace public synonym DBA_STREAMS_GLOBAL_RULES
  for DBA_STREAMS_GLOBAL_RULES
/
grant select on DBA_STREAMS_GLOBAL_RULES to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_STREAMS_GLOBAL_RULES
  (STREAMS_NAME, STREAMS_TYPE, RULE_TYPE, INCLUDE_TAGGED_LCR,
   SOURCE_DATABASE, RULE_NAME, RULE_OWNER, RULE_CONDITION)
as
select r.streams_name, r.streams_type, r.rule_type, r.include_tagged_lcr,
       r.source_database, r.rule_name, r.rule_owner, r.rule_condition
  from dba_streams_global_rules r, all_capture c, all_rules ar
 where r.streams_name = c.capture_name
   and r.streams_type = 'CAPTURE'
   and ar.rule_owner = r.rule_owner
   and ar.rule_name = r.rule_name
union all
select r.streams_name, r.streams_type, r.rule_type, r.include_tagged_lcr,
       r.source_database, r.rule_name, r.rule_owner, r.rule_condition
  from dba_streams_global_rules r, all_apply a, all_rules ar
 where r.streams_name = a.apply_name
   and r.streams_type = 'APPLY'
   and ar.rule_owner = r.rule_owner
   and ar.rule_name = r.rule_name
union all
select r.streams_name, r.streams_type, r.rule_type, r.include_tagged_lcr,
       r.source_database, r.rule_name, r.rule_owner, r.rule_condition
  from dba_streams_global_rules r, all_propagation p, all_rules ar
 where r.streams_name = p.propagation_name
   and r.streams_type = 'PROPAGATION'
   and ar.rule_owner = r.rule_owner
   and ar.rule_name = r.rule_name
/

comment on table ALL_STREAMS_GLOBAL_RULES is
'Global rules created on the streams capture/apply/propagation process that interact with the queue visible to the current user'
/
comment on column ALL_STREAMS_GLOBAL_RULES.STREAMS_NAME is
'Name of the streams process: capture/propagation/apply process'
/
comment on column ALL_STREAMS_GLOBAL_RULES.STREAMS_TYPE is
'Type of the streams process: CAPTURE, PROPAGATION or APPLY'
/
comment on column ALL_STREAMS_GLOBAL_RULES.RULE_TYPE is
'Type of rule: DML or DDL'
/
comment on column ALL_STREAMS_GLOBAL_RULES.INCLUDE_TAGGED_LCR is
'Whether or not to include tagged LCR'
/
comment on column ALL_STREAMS_GLOBAL_RULES.SOURCE_DATABASE is
'Name of the database where the LCRs originated'
/
comment on column ALL_STREAMS_GLOBAL_RULES.RULE_NAME is
'Name of the rule to be applied'
/
comment on column ALL_STREAMS_GLOBAL_RULES.RULE_OWNER is
'Owner of the rule'
/
comment on column ALL_STREAMS_GLOBAL_RULES.RULE_CONDITION is
'Generated rule condition evaluated by the rules engine'
/
create or replace public synonym ALL_STREAMS_GLOBAL_RULES
  for ALL_STREAMS_GLOBAL_RULES
/
grant select on ALL_STREAMS_GLOBAL_RULES to public with grant option
/

----------------------------------------------------------------------------

create or replace view DBA_STREAMS_SCHEMA_RULES
  (STREAMS_NAME, STREAMS_TYPE, SCHEMA_NAME, RULE_TYPE,
   INCLUDE_TAGGED_LCR, SOURCE_DATABASE, RULE_NAME, RULE_OWNER, RULE_CONDITION)
as
select streams_name, decode(streams_type, 1, 'CAPTURE',
                                          2, 'PROPAGATION',
                                          3, 'APPLY', 'UNDEFINED'),
       schema_name, decode(rule_type, 1, 'DML',
                                      2, 'DDL', 'UNKNOWN'),
       decode(include_tagged_lcr, 0, 'NO',
                                  1, 'YES'),
       source_database, rule_name, rule_owner, rule_condition
  from "_DBA_STREAMS_RULES"
 where object_type = 2
/

comment on table DBA_STREAMS_SCHEMA_RULES is
'Schema rules created by streams administrative APIs'
/
comment on column DBA_STREAMS_SCHEMA_RULES.STREAMS_NAME is
'Name of the streams process: capture/propagation/apply process'
/
comment on column DBA_STREAMS_SCHEMA_RULES.STREAMS_TYPE is
'Type of the streams process: CAPTURE, PROPAGATION or APPLY'
/
comment on column DBA_STREAMS_SCHEMA_RULES.SCHEMA_NAME is
'Name of the schema selected by this rule'
/
comment on column DBA_STREAMS_SCHEMA_RULES.RULE_TYPE is
'Type of rule: DML or DDL'
/
comment on column DBA_STREAMS_SCHEMA_RULES.INCLUDE_TAGGED_LCR is
'Whether or not to include tagged LCR'
/
comment on column DBA_STREAMS_SCHEMA_RULES.SOURCE_DATABASE is
'Name of the database where the LCRs originated'
/
comment on column DBA_STREAMS_SCHEMA_RULES.RULE_NAME is
'Name of the rule to be applied'
/
comment on column DBA_STREAMS_SCHEMA_RULES.RULE_OWNER is
'Owner of the rule'
/
comment on column DBA_STREAMS_SCHEMA_RULES.RULE_CONDITION is
'Generated rule condition evaluated by the rules engine'
/
create or replace public synonym DBA_STREAMS_SCHEMA_RULES
  for DBA_STREAMS_SCHEMA_RULES
/
grant select on DBA_STREAMS_SCHEMA_RULES to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_STREAMS_SCHEMA_RULES
  (STREAMS_NAME, STREAMS_TYPE, SCHEMA_NAME, RULE_TYPE,
   INCLUDE_TAGGED_LCR, SOURCE_DATABASE, RULE_NAME, RULE_OWNER, RULE_CONDITION)
as
select streams_name, streams_type, schema_name, rule_type,
       include_tagged_lcr, source_database, sr.rule_name, sr.rule_owner,
       sr.rule_condition
  from dba_streams_schema_rules sr, all_rules r, all_capture c
 where sr.rule_owner = r.rule_owner
   and sr.rule_name = r.rule_name
   and sr.streams_name = c.capture_name
   and sr.streams_type = 'CAPTURE'
union all
select streams_name, streams_type, schema_name, rule_type,
       include_tagged_lcr, source_database, sr.rule_name, sr.rule_owner,
       sr.rule_condition
  from dba_streams_schema_rules sr, all_rules r, all_apply a
 where sr.rule_owner = r.rule_owner
   and sr.rule_name = r.rule_name
   and sr.streams_name = a.apply_name
   and sr.streams_type = 'APPLY'
union all
select streams_name, streams_type, schema_name, rule_type,
       include_tagged_lcr, source_database, sr.rule_name, sr.rule_owner,
       sr.rule_condition
  from dba_streams_schema_rules sr, all_rules r, all_propagation p
 where sr.rule_owner = r.rule_owner
   and sr.rule_name = r.rule_name
   and sr.streams_name = p.propagation_name
   and sr.streams_type = 'PROPAGATION'
/

comment on table ALL_STREAMS_SCHEMA_RULES is
'Rules created by streams administrative APIs on all user schemas'
/
comment on column ALL_STREAMS_SCHEMA_RULES.STREAMS_NAME is
'Name of the streams process: capture/propagation/apply process'
/
comment on column ALL_STREAMS_SCHEMA_RULES.STREAMS_TYPE is
'Type of the streams process: CAPTURE, PROPAGATION or APPLY'
/
comment on column ALL_STREAMS_SCHEMA_RULES.SCHEMA_NAME is
'Name of the schema selected by this rule'
/
comment on column ALL_STREAMS_SCHEMA_RULES.RULE_TYPE is
'Type of rule: DML or DDL'
/
comment on column ALL_STREAMS_SCHEMA_RULES.INCLUDE_TAGGED_LCR is
'Whether or not to include tagged LCR'
/
comment on column ALL_STREAMS_SCHEMA_RULES.SOURCE_DATABASE is
'Name of the database where the LCRs originated'
/
comment on column ALL_STREAMS_SCHEMA_RULES.RULE_NAME is
'Name of the rule to be applied'
/
comment on column ALL_STREAMS_SCHEMA_RULES.RULE_OWNER is
'Owner of the rule'
/
comment on column ALL_STREAMS_SCHEMA_RULES.RULE_CONDITION is
'Generated rule condition evaluated by the rules engine'
/
create or replace public synonym ALL_STREAMS_SCHEMA_RULES
  for ALL_STREAMS_SCHEMA_RULES
/
grant select on ALL_STREAMS_SCHEMA_RULES to public with grant option
/

----------------------------------------------------------------------------

create or replace view DBA_STREAMS_TABLE_RULES
  (STREAMS_NAME, STREAMS_TYPE, TABLE_OWNER, TABLE_NAME, RULE_TYPE,
   DML_CONDITION, SUBSETTING_OPERATION, INCLUDE_TAGGED_LCR,
   SOURCE_DATABASE, RULE_NAME, RULE_OWNER, RULE_CONDITION)
as
select streams_name, decode(streams_type, 1, 'CAPTURE',
                                          2, 'PROPAGATION',
                                          3, 'APPLY', 'UNDEFINED'),
       schema_name, object_name, decode(rule_type, 1, 'DML',
                                                   2, 'DDL', 'UNKNOWN'),
       dml_condition, decode(subsetting_operation, 1, 'INSERT',
                                                   2, 'UPDATE',
                                                   3, 'DELETE'),
       decode(include_tagged_lcr, 0, 'NO',
                                  1, 'YES'),
       source_database, rule_name, rule_owner, rule_condition
  from "_DBA_STREAMS_RULES"
 where object_type = 1
/

comment on table DBA_STREAMS_TABLE_RULES is
'Table rules created by streams administrative APIs'
/
comment on column DBA_STREAMS_TABLE_RULES.STREAMS_NAME is
'Name of the streams process: capture/propagation/apply process'
/
comment on column DBA_STREAMS_TABLE_RULES.STREAMS_TYPE is
'Type of the streams process: CAPTURE, PROPAGATION or APPLY'
/
comment on column DBA_STREAMS_TABLE_RULES.TABLE_OWNER is
'Owner of the table selected by this rule'
/
comment on column DBA_STREAMS_TABLE_RULES.TABLE_NAME is
'Name of the table selected by this rule'
/
comment on column DBA_STREAMS_TABLE_RULES.RULE_TYPE is
'Type of rule: DML or DDL'
/
comment on column DBA_STREAMS_TABLE_RULES.DML_CONDITION is
'Row subsetting condition'
/
comment on column DBA_STREAMS_TABLE_RULES.SUBSETTING_OPERATION is
'DML operation for row subsetting'
/
comment on column DBA_STREAMS_TABLE_RULES.INCLUDE_TAGGED_LCR is
'Whether or not to include tagged LCR'
/
comment on column DBA_STREAMS_TABLE_RULES.SOURCE_DATABASE is
'Name of the database where the LCRs originated'
/
comment on column DBA_STREAMS_TABLE_RULES.RULE_NAME is
'Name of the rule to be applied'
/
comment on column DBA_STREAMS_TABLE_RULES.RULE_OWNER is
'Owner of the rule'
/
comment on column DBA_STREAMS_TABLE_RULES.RULE_CONDITION is
'Generated rule condition evaluated by the rules engine'
/
create or replace public synonym DBA_STREAMS_TABLE_RULES
  for DBA_STREAMS_TABLE_RULES
/
grant select on DBA_STREAMS_TABLE_RULES to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_STREAMS_TABLE_RULES
  (STREAMS_NAME, STREAMS_TYPE, TABLE_OWNER, TABLE_NAME, RULE_TYPE,
   DML_CONDITION, SUBSETTING_OPERATION, INCLUDE_TAGGED_LCR,
   SOURCE_DATABASE, RULE_NAME, RULE_OWNER, RULE_CONDITION)
as
select tr.streams_name, tr.streams_type, tr.table_owner, tr.table_name,
       tr.rule_type, tr.dml_condition, tr.subsetting_operation,
       tr.include_tagged_lcr, tr.source_database, tr.rule_name,
       tr.rule_owner, tr.rule_condition
  from dba_streams_table_rules tr, all_rules ar, all_capture c
 where tr.rule_owner = ar.rule_owner
   and tr.rule_name = ar.rule_name
   and tr.streams_name = c.capture_name
   and tr.streams_type = 'CAPTURE'
union all
select tr.streams_name, tr.streams_type, tr.table_owner, tr.table_name,
       tr.rule_type, tr.dml_condition, tr.subsetting_operation,
       tr.include_tagged_lcr, tr.source_database, tr.rule_name,
       tr.rule_owner, tr.rule_condition
  from dba_streams_table_rules tr, all_rules ar, all_apply a
 where tr.rule_owner = ar.rule_owner
   and tr.rule_name = ar.rule_name
   and tr.streams_name = a.apply_name
   and tr.streams_type = 'APPLY'
union all
select tr.streams_name, tr.streams_type, tr.table_owner, tr.table_name,
       tr.rule_type, tr.dml_condition, tr.subsetting_operation,
       tr.include_tagged_lcr, tr.source_database, tr.rule_name,
       tr.rule_owner, tr.rule_condition
  from dba_streams_table_rules tr, all_rules ar, all_propagation p
 where tr.rule_owner = ar.rule_owner
   and tr.rule_name = ar.rule_name
   and tr.streams_name = p.propagation_name
   and tr.streams_type = 'PROPAGATION'
/

comment on table ALL_STREAMS_TABLE_RULES is
'Rules created by streams administrative APIs on tables visible to the current user'
/
comment on column ALL_STREAMS_TABLE_RULES.STREAMS_NAME is
'Name of the streams process: capture/propagation/apply process'
/
comment on column ALL_STREAMS_TABLE_RULES.STREAMS_TYPE is
'Type of the streams process: CAPTURE, PROPAGATION or APPLY'
/
comment on column ALL_STREAMS_TABLE_RULES.TABLE_OWNER is
'Owner of the table selected by this rule'
/
comment on column ALL_STREAMS_TABLE_RULES.TABLE_NAME is
'Name of the table selected by this rule'
/
comment on column ALL_STREAMS_TABLE_RULES.RULE_TYPE is
'Type of rule: DML or DDL'
/
comment on column ALL_STREAMS_TABLE_RULES.DML_CONDITION is
'Row subsetting condition'
/
comment on column ALL_STREAMS_TABLE_RULES.SUBSETTING_OPERATION is
'DML operation for row subsetting'
/
comment on column ALL_STREAMS_TABLE_RULES.INCLUDE_TAGGED_LCR is
'Whether or not to include tagged LCR'
/
comment on column ALL_STREAMS_TABLE_RULES.SOURCE_DATABASE is
'Name of the database where the LCRs originated'
/
comment on column ALL_STREAMS_TABLE_RULES.RULE_NAME is
'Name of the rule to be applied'
/
comment on column ALL_STREAMS_TABLE_RULES.RULE_OWNER is
'Owner of the rule'
/
comment on column ALL_STREAMS_TABLE_RULES.RULE_CONDITION is
'Generated rule condition evaluated by the rules engine'
/
create or replace public synonym ALL_STREAMS_TABLE_RULES
  for ALL_STREAMS_TABLE_RULES
/
grant select on ALL_STREAMS_TABLE_RULES to public with grant option
/

/* support drop user cascade */
DELETE FROM sys.duc$ WHERE owner='SYS' AND pack='DBMS_STREAMS_ADM_UTL' 
  AND proc='PROCESS_DROP_USER_CASCADE' AND operation#=1
/
INSERT INTO sys.duc$ (owner, pack, proc, operation#, seq, com)
  VALUES ('SYS', 'DBMS_STREAMS_ADM_UTL', 'PROCESS_DROP_USER_CASCADE', 1, 1,
          'Drop any capture or apply processes for this user')
/
commit;
           