Rem
Rem $Header: catxdbr.sql 06-sep-2002.15:56:04 fge Exp $
Rem
Rem catxdbr.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catxdbr.sql - XDB Resource View related schema objects
Rem
Rem    DESCRIPTION
Rem     This script creates the views, packages, index types, operators and 
Rem     indexes required for providing SQL access to resource data.
Rem
Rem    NOTES
Rem      This script should be run as "XDB".
Rem
Rem    TODO: Support ACLs in functional implementation of prim oper
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    fge         09/06/02 - fix bug 2540212
Rem    varora      08/26/02 - change scanctx in xdbhi_im to raw 8
Rem    njalali     07/31/02 - undo resid change
Rem    fge         07/09/02 - add resid to resource_view
Rem    fge         05/21/02 - add ancillary operator abspath
Rem    gviswana    01/29/02 - CREATE OR REPLACE SYNONYM
Rem    fge         01/21/02 - move implementation to prvtxdbr.sql
Rem    sichandr    01/17/02 - grant execute on xdb.path_array
Rem    ayoaz       01/10/02 - specify without dml option for xdbhi_idxtyp
Rem    spannala    12/27/01 - xdb setup should run as sys
Rem    spannala    01/11/02 - making all systems types have standard TOIDs
Rem    spannala    12/13/01 - removing connect
Rem    nagarwal    11/05/01 - grant DML privileges to resource view
Rem    nagarwal    11/08/01 - invoke prvtxdbpi
Rem    tsingh      11/17/01 - remove connection string
Rem    vnimani     10/01/01 - add contentschemais function
Rem    nle         09/20/01 - move versioning package
Rem    nagarwal    09/12/01 - add catxdbvr.sql
Rem    nagarwal    09/08/01 - add PATH VIEW definition
Rem    nagarwal    09/05/01 - privileges fix
Rem    nagarwal    08/29/01 - add support for ALL_PATH operator
Rem    nagarwal    08/22/01 - functional implementation for EQUALS_PATH operator
Rem    nagarwal    08/14/01 - grant priv on indextype
Rem    nagarwal    08/03/01 - add without column data to indextype
Rem    nagarwal    07/26/01 - changes wrt resource->xmltype
Rem    tsingh      06/30/01 - XDB: XML Database merge
Rem    nagarwal    05/20/01 - overload operators
Rem    nagarwal    04/30/01 - Support for DML on resource view
Rem    nagarwal    04/24/01 - Add functional implementation for operators
Rem    nagarwal    04/15/01 - Add start, fetch, close routines for ext idx
Rem    nagarwal    04/03/01 - Created
Rem

/* drop objects */
drop view xdb.xdb$resource_view;
drop view xdb.xdb$rv;
drop index xdb.xdbhi_idx;
drop indextype xdb.xdbhi_idxtyp force;
drop operator xdb.path force;
drop operator xdb.depth force;
drop operator xdb.abspath force;
drop operator xdb.under_path force;
drop operator xdb.equals_path force;
drop package xdb.xdb_ancop;
drop package xdb.xdb_funcimpl;
drop type xdb.xdbhi_im;
drop type xdb.path_array;

/*-----------------------------------------------------------------------*/
/*  LIBRARY                                                              */
/*-----------------------------------------------------------------------*/
create or replace library xdb.resource_view_lib trusted as static;
/
create or replace library xdb.path_view_lib trusted as static;
/
-- Information about each link
create or replace type xdb.path_linkinfo OID '00000000000000000000000000020117'
as object
(
  path      varchar2(1024),
  linkoid   raw(16)
)
/
create or replace type xdb.path_array OID '00000000000000000000000000020154'
as varray(32000) of xdb.path_linkinfo
/
show errors;
grant execute on xdb.path_linkinfo to public;
grant execute on xdb.path_array to public;

/*-----------------------------------------------------------------------*/
/*  IMPLEMENTATION TYPE                                                  */
/*-----------------------------------------------------------------------*/
create or replace type xdb.xdbhi_im OID '00000000000000000000000000020118'
  authid definer as object(
  scanctx    RAW(8),

  static function ODCIGetInterfaces (ilist OUT sys.ODCIObjectList) return number,

  static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2,
      env sys.odcienv)  return number, 

  static function ODCIIndexDrop(ia sys.odciindexinfo, env sys.ODCIEnv)
    return number, 

  static function ODCIIndexInsert(ia sys.ODCIIndexInfo, rid varchar2, 
        newval sys.xmltype, env sys.ODCIEnv) return number,

  static function ODCIIndexDelete(ia sys.ODCIIndexInfo, rid varchar2, 
    oldval sys.xmltype, env sys.ODCIEnv) return number,

  static function ODCIIndexUpdate(ia sys.ODCIIndexInfo, rid varchar2, 
    oldval sys.xmltype, newval sys.xmltype, env sys.ODCIEnv) 
    return number, 

  static function ODCIIndexStart(sctx IN OUT xdb.xdbhi_im, 
       ia sys.odciindexinfo, op sys.odcipredinfo, qi sys.odciqueryinfo,
       strt number, stop number, depth number, pathstr varchar2, 
       env sys.odcienv)  return number
      is language C name "START_XDBHI" library XDB.RESOURCE_VIEW_LIB
      with context parameters (
       context,
       sctx,
       sctx INDICATOR struct,
       ia, ia INDICATOR struct,
       op, op INDICATOR struct,
       qi, qi INDICATOR struct,
       strt, strt INDICATOR, 
       stop, stop INDICATOR,
       pathstr, pathstr LENGTH,
       depth OCINUMBER, depth INDICATOR,
       env, env INDICATOR struct,
       return OCINUMBER),

  static function ODCIIndexStart(sctx IN OUT xdb.xdbhi_im, 
      ia sys.odciindexinfo, op sys.odcipredinfo, qi sys.odciqueryinfo,
      strt number, stop number, pathstr varchar2, env sys.odcienv)  
      return number
      is language C name "START_XDBHI1" library XDB.RESOURCE_VIEW_LIB
      with context parameters (
       context,
       sctx,
       sctx INDICATOR struct,
       ia, ia INDICATOR struct,
       op, op INDICATOR struct,
       qi, qi INDICATOR struct,
       strt, strt INDICATOR, 
       stop, stop INDICATOR,
       pathstr, pathstr LENGTH,
       env, env INDICATOR struct,
       return OCINUMBER),

  member function ODCIIndexFetch(nrows number, rids OUT sys.odciridlist, 
     env sys.odcienv) return number 
  is language C name "FETCH_XDBHI" library XDB.RESOURCE_VIEW_LIB
  with context parameters (
    context,  
    self,  self INDICATOR struct,
    nrows, nrows INDICATOR,
    rids,  rids INDICATOR,
    env, env INDICATOR struct,
    return OCINUMBER),

  member function ODCIIndexClose (env sys.odcienv) return number 
  is language C name "CLOSE_XDBHI" LIBRARY XDB.RESOURCE_VIEW_LIB
  with context parameters (
    context,
    self, self INDICATOR struct,
    env,  env INDICATOR struct,
    return OCINUMBER)
);
/
show errors;

create or replace type body xdb.xdbhi_im
is 
  static function ODCIGetInterfaces(ilist OUT sys.ODCIObjectList) 
    return number is 
  begin 
    ilist := sys.ODCIObjectList(sys.ODCIObject('SYS', 'ODCIINDEX2'));
    return ODCICONST.SUCCESS;
  end ODCIGetInterfaces;

  static function ODCIIndexCreate(ia sys.ODCIIndexInfo, parms varchar2,
    env sys.ODCIEnv) return number as 
  begin 
    -- insert into secobj$ 
    return ODCICONST.SUCCESS;
  end ODCIIndexCreate;

  static function ODCIIndexDrop(ia sys.ODCIIndexInfo, env sys.ODCIEnv) 
    return number
  is 
  begin 
    -- delete from secobj$ 
    return ODCICONST.SUCCESS;
  end ODCIIndexDrop;

  static function ODCIIndexInsert(ia sys.ODCIIndexInfo, rid varchar2,
    newval sys.xmltype, env sys.ODCIEnv) return number 
  is 
  begin 
    return ODCICONST.SUCCESS;
  end ODCIIndexInsert;

  static function ODCIIndexDelete(ia sys.ODCIIndexInfo, rid varchar2, 
    oldval sys.xmltype, env sys.ODCIEnv) return number
  is
  begin 
    return ODCICONST.SUCCESS;
  end ODCIIndexDelete;

  static function ODCIIndexUpdate(ia sys.ODCIIndexInfo, rid varchar2,
    oldval sys.xmltype, newval sys.xmltype, env sys.ODCIEnv)
    return number 
  is
  begin 
    return ODCICONST.SUCCESS;
  end ODCIIndexUpdate;
end;
/

show errors;
grant execute on xdb.xdbhi_im to public;

/*-----------------------------------------------------------------------*/
/* FUNCTIONAL  IMPLEMENTATION                                            */
/*-----------------------------------------------------------------------*/
/* primary operator */
create or replace package XDB.XDB_FUNCIMPL is
  function under_path_func(res sys.xmltype, depth number, pathstr varchar2, 
                           ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, 
                           sflg number)
  return number;

  function under_path_func1(res sys.xmltype, pathstr varchar2, 
                            ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, 
                            sflg number)
  return number;

  function equal_path_func(res sys.xmltype, pathstr varchar2, 
                            ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, 
                            sflg number)
  return number;
end XDB_FUNCIMPL;
/

show errors;
grant execute on XDB.XDB_FUNCIMPL to public ; 


/* ancillary operator */
create or replace package xdb.xdb_ancop as 
  function path_func(col sys.xmltype, depth number, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return varchar2;
  function path_func(col sys.xmltype, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return varchar2;
  function depth_func(col sys.xmltype, depth number, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return number;
  function depth_func(col sys.xmltype, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return number;
  function allpath_func(col sys.xmltype, depth number, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return XDB.PATH_ARRAY;
  function allpath_func(col sys.xmltype, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return XDB.PATH_ARRAY;
  function abspath_func(col sys.xmltype, depth number, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return varchar2;
  function abspath_func(col sys.xmltype, pathstr varchar2, 
                     ia sys.odciindexctx, sctx IN OUT xdb.xdbhi_im, sflg number)
  return varchar2;
end;
/
show errors;
grant execute on xdb.xdb_ancop to public ; 

/*------------------------------------------------------------------------*/
/*  OPERATORS and INDEXTYPES                                              */
/*------------------------------------------------------------------------*/
-- primary operator 
create operator xdb.under_path binding
  (sys.xmltype, number, varchar2) return number with index context, 
    scan context xdb.xdbhi_im compute ancillary data 
    without column data using XDB.XDB_FUNCIMPL.under_path_func,
  (sys.xmltype, varchar2) return number with index context, 
    scan context xdb.xdbhi_im compute ancillary data 
    without column data using XDB.XDB_FUNCIMPL.under_path_func1;

create operator xdb.equals_path binding 
  (sys.xmltype, varchar2) return number with index context, 
    scan context xdb.xdbhi_im compute ancillary data 
    without column data using XDB.XDB_FUNCIMPL.equal_path_func;

grant execute on xdb.under_path to public;
grant execute on xdb.equals_path to public;
create or replace public synonym under_path for xdb.under_path;
create or replace public synonym equals_path for xdb.equals_path;

-- ancillary operators
create operator xdb.path binding (number) return varchar2 ancillary to 
  xdb.under_path(sys.xmltype, number, varchar2),
  xdb.under_path(sys.xmltype, varchar2)
 without column data
using xdb.xdb_ancop.path_func;

create operator xdb.depth binding (number) return number ancillary to 
  xdb.under_path(sys.xmltype, varchar2),
  xdb.under_path(sys.xmltype, number, varchar2)
using xdb.xdb_ancop.depth_func;

create operator xdb.abspath binding (number) return varchar2 ancillary to 
  xdb.under_path(sys.xmltype, number, varchar2),
  xdb.under_path(sys.xmltype, varchar2)
 without column data
using xdb.xdb_ancop.abspath_func;

grant execute on xdb.path to public;
create or replace public synonym path for xdb.path;
grant execute on xdb.depth to public;
create or replace public synonym depth for xdb.depth;
grant execute on xdb.abspath to public;
create or replace public synonym abspath for xdb.abspath;

-- indextype 
create indextype xdb.xdbhi_idxtyp for 
  xdb.under_path(sys.xmltype, number, varchar2),
  xdb.under_path(sys.xmltype, varchar2),
  xdb.equals_path(sys.xmltype, varchar2)
  using xdb.xdbhi_im without dml;

--  using xdb.xdbhi_im   without column data;
grant execute on xdb.xdbhi_idxtyp to public;

/*------------------------------------------------------------------------*/
/*  INDEXES                                                               */
/*------------------------------------------------------------------------*/
create index xdb.xdbhi_idx on xdb.xdb$resource p (value(p)) indextype is xdb.xdbhi_idxtyp;

/*-----------------------------------------------------------------------*/
/*  VIEWS                                                                */
/*-----------------------------------------------------------------------*/
create or replace view xdb.resource_view as 
  select value(p) res, abspath(9999) any_path
  from xdb.xdb$resource p 
  where under_path(value(p), '/', 9999) = 1 ;


show errors;
create or replace public synonym resource_view for xdb.resource_view;
grant select on xdb.resource_view to public ; 
grant insert on xdb.resource_view to public;
grant delete on xdb.resource_view to public;
grant update on xdb.resource_view to public;

/*-----------------------------------------------------------------------*/
/* PACKAGES and FUNCTIONS for instead-of trigger                         */
/*-----------------------------------------------------------------------*/

create or replace package xdb.XDB_RVTRIG_PKG is 

  procedure rvtrig_ins(res sys.xmltype, path varchar2);

  procedure rvtrig_del(res sys.xmltype, path varchar2);

  procedure rvtrig_upd(o_res sys.xmltype, n_res sys.xmltype,  o_path varchar2, 
    n_path varchar2);

end XDB_RVTRIG_PKG;
/
show errors;

create or replace public synonym xdb_rvtrig_pkg for xdb.xdb_rvtrig_pkg;

grant execute on xdb.xdb_rvtrig_pkg to public;


/*-----------------------------------------------------------------------*/
/*  INSTEAD-OF TRIGGER                                                   */
/*-----------------------------------------------------------------------*/
create or replace trigger xdb.xdb_rv_trig INSTEAD OF insert or delete or update
on xdb.resource_view for each row 
begin 
  if inserting then 
    xdb_rvtrig_pkg.rvtrig_ins(:new.res, :new.any_path);

    /* check that either the REF or the BLOB columns are filled, not both */
  end if;

  if deleting then 
     xdb_rvtrig_pkg.rvtrig_del(:old.res, :old.any_path);

    /* check if we get the correct values from two tables in a view */
  end if;

  if updating then 
     xdb_rvtrig_pkg.rvtrig_upd(:old.res,    :new.res,
                               :old.any_path,   :new.any_path );
  end if;
end;
/
show errors;
