Rem
Rem $Header: d0801070.sql 13-nov-2002.12:10:53 arithikr Exp $
Rem
Rem d0801070.sql
Rem
Rem Copyright (c) 2000, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      d0801070.sql -  downgrade Oracle RDBMS from current release to 8.1.7
Rem
Rem    DESCRIPTION
Rem      See the README file and the Oracle Migration book for details.
Rem
Rem      This script is to be used for downgrading your database from the
Rem      current release you have installed to the 8.1.7 release.  This
Rem      script provides a direct downgrade path from your current installed
Rem      release to the 8.1.7 release.
Rem
Rem      This script performs the downgrade in the following stages:
Rem        STAGE 1: downgrade JAVA components
Rem        STAGE 2: downgrade the dictionary
Rem
Rem    NOTES
Rem      * This script needs to be run in the current release's environment
Rem        (before installing the release to which you want to downgrade).
Rem      * This script must be run using SQL*PLUS.
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smalathe    10/23/02 - Bug2629917: Check for NULL NCHAR columns
Rem    arithikr    11/13/02 - 2642848 - exit if components are not downgrades
Rem    rburns      04/07/02 - list components in log
Rem    tbgraves    02/04/02 - add server version check
Rem    rburns      12/10/01 - improve open error message
Rem    rburns      11/13/01 - rename registry package
Rem    rburns      10/17/01 - change order of udjvmrm
Rem    rburns      09/27/01 - Check OPEN MIGRATE
Rem    rburns      09/21/01 - check component downgrades
Rem    rburns      05/02/01 - revise NCHAR query and test for sqlplus bug
Rem    rburns      04/17/01 - alter NCHAR if no user data
Rem    rburns      01/26/01 - revise JAVA downgrade
Rem    rburns      12/06/00 - add csform downgrade as last actions
Rem    rburns      11/21/00 - check for AL16UTF16
Rem    jdavison    08/02/00 - Add JVM upgrade/downgrade scripts.
Rem    dpotapov    06/28/00 - Remove PDML ITL downgrade from here,
Rem                           move it to d820pitl.sql.
Rem    mkrishna    06/29/00 - fix opaque types in downgrade
Rem    spsundar    06/21/00 - Removal of indpart$ constraint
Rem    dpotapov    05/17/00 - PDML ITL.
Rem    gclaborn    11/22/99 - Drop dictionary tables for Metadata API
Rem    gclaborn    11/16/99 - Add removal of Metadata API
Rem    liwong      07/31/99 - replicated objects
Rem    jdavison    05/08/00 - Add e0801070.sql for downgrade - contents moved
Rem    spsundar    05/10/00 - add not null constraint to dataobj# in indpart$
Rem    liwong      07/25/99 - Created
Rem

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;
 
DECLARE
  openmigrate     VARCHAR2(30);
  vers            VARCHAR2(30);
BEGIN
-- See if server version and script version match. Raise an error if no match.
   select substr(version,1,5) into vers from v$instance;
   if vers != '9.2.0' then
      RAISE_APPLICATION_ERROR(-20000,
        'Server version and script version do not match. ' ||
        'Shutdown and use a different script or a different server.');   
   end if;
-- verify open for migrate
   select status into openmigrate from v$instance;
   if openmigrate != 'OPEN MIGRATE' then
      RAISE_APPLICATION_ERROR(-20000,
        'Database is not open for MIGRATE. ' ||
        'Shutdown and restart using MIGRATE.');
   end if;
END;
/
Rem =========================================================================
Rem If only SYS and SYSTEM NCHAR columns have been converted to 9i format and
Rem there are no rows in the replication tables with NCHAR columns,
Rem then alter the NCHAR character set to UTF8 for downgrade and drop the
Rem replication tables (to be re-created in 8i after the downgrade).
Rem
Rem Also verify that compatibility is not greater than 8.1.7.
Rem =========================================================================

DECLARE
  rows_exist      NUMBER(1);
  flag            BOOLEAN;
  ncharset        VARCHAR2(40);
  compat          VARCHAR2(30);
  no_table_found EXCEPTION;
  PRAGMA EXCEPTION_INIT(no_table_found, -942);
BEGIN

-- Check compatible parameter
   select value into compat from v$parameter
   where name='compatible';
   if substr(compat,1,5) > '8.1.7' then
      RAISE_APPLICATION_ERROR(-20000,
        'Compatibile parameter ' || compat || 
        ' too high for downgrade to 8.1.7');
   end if;

-- Check for use of 9i NCHAR formats
   BEGIN
      rows_exist:=0;
      flag := TRUE;
--    See if there is at least one column in a user table
      BEGIN
        select 1 into rows_exist
        from col$ c, user$ u, obj$ o
        where rownum =1 and c.charsetform = 2 and 
           c.type# in (1, 96) and bitand(c.property, 8388608) = 8388608 and
           c.obj#=o.obj# and o.type#=2 and
           o.owner#=u.user# and
           u.name not in ('SYS', 'SYSTEM');
      EXCEPTION
        when NO_DATA_FOUND then null;
      END;

      BEGIN
      select 1 into rows_exist
      from col$ c, user$ u, obj$ o
      where rownum =1 and c.charsetform = 2 and 
         c.type# = 112 and c.charsetid=2000 and
         c.obj#=o.obj# and o.type#=2 and
         o.owner#=u.user# and
         u.name not in ('SYS', 'SYSTEM');
      EXCEPTION
        when NO_DATA_FOUND then null;
      END;

--    If a row is found, then the database cannot be downgraded 
      IF rows_exist = 1 THEN
         RAISE_APPLICATION_ERROR(-20000,
          'New format NCHAR columns not supported for downgrade'); 
      END IF;

--    If no NCHAR columns exist then
--    Make sure there are no rows in the three replication tables
      BEGIN EXECUTE IMMEDIATE 
         'select 1 from system.DEF$_LOB where rownum =1' into rows_exist;
      EXCEPTION 
         WHEN NO_DATA_FOUND THEN NULL; 
         WHEN NO_TABLE_FOUND THEN NULL; 
      END;

      BEGIN EXECUTE IMMEDIATE
        'select 1 from system.DEF$_TEMP$LOB where rownum=1' into rows_exist;
      EXCEPTION 
         WHEN NO_DATA_FOUND THEN NULL; 
         WHEN NO_TABLE_FOUND THEN NULL; 
      END;

      BEGIN EXECUTE IMMEDIATE
         'select 1 from system.REPCAT$_PRIORITY where rownum =1'
               into rows_exist;
      EXCEPTION 
         WHEN NO_DATA_FOUND THEN NULL; 
         WHEN NO_TABLE_FOUND THEN NULL; 
      END;

      IF rows_exist = 0 THEN

--       Drop the replication tables that have NCHAR columns
--       They will be recreated by catrep in 8.1.7         
         BEGIN EXECUTE IMMEDIATE 'drop table system.DEF$_LOB';
         EXCEPTION WHEN NO_TABLE_FOUND THEN NULL; END;
         BEGIN EXECUTE IMMEDIATE 'drop table system.DEF$_TEMP$LOB';
         EXCEPTION WHEN NO_TABLE_FOUND THEN NULL; END;
         BEGIN EXECUTE IMMEDIATE 'drop table system.REPCAT$_PRIORITY';
         EXCEPTION WHEN NO_TABLE_FOUND THEN NULL; END;

      ELSE
--    #2629917: If the NCHAR column values are NULL, continue the
--    downgrade after changing national character set to UTF8
        BEGIN
          rows_exist := 0;

          BEGIN EXECUTE IMMEDIATE
             'select 1 from system.DEF$_LOB where
                   nclob_col IS NOT NULL and rownum = 1' into rows_exist;
          EXCEPTION
             WHEN NO_DATA_FOUND THEN NULL;
             WHEN NO_TABLE_FOUND THEN NULL;
          END;

          BEGIN EXECUTE IMMEDIATE
             'select 1 from system.DEF$_TEMP$LOB where
                   temp$nclob IS NOT NULL and rownum = 1' into rows_exist;
          EXCEPTION
             WHEN NO_DATA_FOUND THEN NULL;
             WHEN NO_TABLE_FOUND THEN NULL;
          END;

          BEGIN EXECUTE IMMEDIATE
             'select 1 from system.REPCAT$_PRIORITY where
                   (nchar_value IS NOT NULL OR nvarchar2_value IS NOT NULL)
                   AND rownum = 1' into rows_exist;
          EXCEPTION
             WHEN NO_DATA_FOUND THEN NULL;
             WHEN NO_TABLE_FOUND THEN NULL;
          END;

          IF rows_exist != 0 THEN
--        Check if NLS_NCHAR_CHARACTERSET is already UTF8
            BEGIN
              select value into ncharset from sys.NLS_DATABASE_PARAMETERS where
                   parameter='NLS_NCHAR_CHARACTERSET';
              IF ncharset != 'UTF8' THEN
                BEGIN
                  flag := TRUE;
                  RAISE_APPLICATION_ERROR(-20000,
                    'Replication NCHAR tables must be empty for downgrade');
                END;
              ELSE
                flag := FALSE;
              END IF;
            END;
          END IF;
        END;
      END IF;

      IF flag THEN
        EXECUTE IMMEDIATE
         'alter database national character set internal_use UTF8';
      END IF;
   END;
END;
/
     
Rem =========================================================================
Rem Check to make sure other components are already downgraded before proceed
Rem to downgrade the RDBMS and the rest.

SET SERVEROUTPUT ON;
DECLARE
  comp_count      NUMBER(1);
  cid             VARCHAR2(30);
  CURSOR cmpnt_id IS
     select comp_id from dba_registry
       where comp_id in ('CONTEXT','SDO','ORDIM','ORDVIR')
             and status NOT in ('DOWNGRADED','REMOVED');

BEGIN
   select count(*) into comp_count from dba_registry 
     where comp_id in ('CONTEXT','SDO','ORDIM','ORDVIR') 
           and status NOT in ('DOWNGRADED','REMOVED'); 
   If comp_count > 0 THEN

     DBMS_OUTPUT.PUT_LINE('The following components must be downgraded first:');
     OPEN cmpnt_id;
     LOOP
        FETCH cmpnt_id into cid;
        EXIT WHEN cmpnt_id%NOTFOUND;
        DBMS_OUTPUT.PUT_LINE('Component ID : ' || cid);
     END LOOP;
     CLOSE cmpnt_id;

     RAISE_APPLICATION_ERROR(-20000,
        'Downgrade components above before running this script.');
   end if;
END;
/
SET SERVEROUTPUT OFF;
Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade installed components
Rem =========================================================================

Rem Setup component script filename variable
COLUMN file_name NEW_VALUE comp_file NOPRINT;

Rem Run component downgrade scripts
@@f0801070.sql

Rem Remove Java system classes after components have been downgraded.
SELECT dbms_registry.script('JAVAVM','udjvmrm.sql') 
AS file_name FROM DUAL;
@@&comp_file

column comp_name format a35
SELECT comp_name, status, substr(version,1,10) as version from dba_registry
WHERE comp_id NOT IN ('CATPROC','CATALOG');

/*
 The query above lists all of the components that must be downgraded
 prior to downgrading the Oracle9i Data Dictionary.  If any components
 do not have a DOWNGRADED status, then the following check will get
 an ORA-20000 error.  Consult Oracle9i Database Migration for 
 instructions to downgrade any remaining components and then re-run
 this script.
*/

WHENEVER SQLERROR EXIT;
EXECUTE dbms_registry_sys.check_component_downgrades;
WHENEVER SQLERROR CONTINUE;

Rem =========================================================================
Rem END STAGE 1: downgrade installed components
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade dictionary from 9.0.1 to 8.1.7
Rem =========================================================================

@@e0801070.sql

Rem =========================================================================
Rem END STAGE 2: downgrade dictionary from 9.0.1 to 8.1.7
Rem =========================================================================

Rem *************************************************************************
Rem END d0801070.sql
Rem *************************************************************************
