Rem
Rem $Header: d0900010.sql 13-nov-2002.12:11:13 arithikr Exp $
Rem
Rem d0900010.sql
Rem
Rem Copyright (c) 2000, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      d0900010.sql -  downgrade Oracle RDBMS from current release to 9.0.1
Rem
Rem    DESCRIPTION
Rem
Rem      This script is to be used for downgrading your database from the
Rem      current release you have installed to the 9.0.1 release.  This
Rem      script provides a direct downgrade path from your current installed
Rem      release to the 9.0.1 release.
Rem
Rem      This script performs the downgrade in the following stages:
Rem        STAGE 1: downgrade installed components
Rem        STAGE 2: downgrade the dictionary
Rem
Rem    NOTES
Rem      * This script needs to be run in the current release's environment
Rem        (before installing the release to which you want to downgrade).
Rem      * This script must be run using SQL*PLUS.
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    arithikr    11/13/02 - 2642848 - exit if components are not downgrades
Rem    rburns      04/07/02 - list components in log
Rem    tbgraves    02/04/02 - add server version check
Rem    rburns      12/10/01 - improve open migrate error
Rem    rburns      11/13/01 - rename registry package
Rem    rburns      10/17/01 - change order of udjvmrm
Rem    rburns      09/27/01 - Check OPEN MIGRATE
Rem    rburns      09/20/01 - verify all components downgraded
Rem    rburns      06/07/01 - Merged rburns_setup_901_upgrade
Rem    rburns      06/06/01 - Created

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;

DECLARE
  openmigrate     VARCHAR2(30);
  vers            VARCHAR2(30); 
BEGIN
-- See if server version and script version match. Raise an error if no match.
   select substr(version,1,5) into vers from v$instance;
   if vers != '9.2.0' then
      RAISE_APPLICATION_ERROR(-20000,
        'Server version and script version do not match. ' ||
        'Shutdown and use a different script or a different server.');   
   end if;
-- verify open for migrate
   select status into openmigrate from v$instance;
   if openmigrate != 'OPEN MIGRATE' then
      RAISE_APPLICATION_ERROR(-20000,
        'Database is not open for MIGRATE. ' ||
        'Shutdown and restart using MIGRATE.');
   end if;

END;
/
Rem =========================================================================
Rem Verify that compatibility is not greater than 9.0.1.
Rem =========================================================================

DECLARE
  compat          VARCHAR2(30);
BEGIN
-- Check compatible parameter
   select value into compat from v$parameter
   where name='compatible';
   if substr(compat,1,5) > '9.0.1' then
      RAISE_APPLICATION_ERROR(-20000,
        'Compatibile parameter ' || compat || 
        ' too high for downgrade to 9.0.1');
   end if;
END;
/
Rem =========================================================================
Rem Check to make sure other components are already downgraded before proceed
Rem to downgrade the RDBMS and the rest.

SET SERVEROUTPUT ON;
DECLARE
  comp_count      NUMBER(1);
  cid             VARCHAR2(30);
  CURSOR cmpnt_id IS
     select comp_id from dba_registry
       where comp_id in ('CONTEXT','SDO','ORDIM','ORDVIR','WK','APS') 
             and status NOT in ('DOWNGRADED','REMOVED'); 

BEGIN
   select count(*) into comp_count from dba_registry 
     where comp_id in ('CONTEXT','SDO','ORDIM','ORDVIR','WK','APS') 
           and status NOT in ('DOWNGRADED','REMOVED'); 
   IF comp_count > 0 THEN

     DBMS_OUTPUT.PUT_LINE('The following components must be downgraded first:');
     OPEN cmpnt_id;
     LOOP
        FETCH cmpnt_id into cid;
        EXIT WHEN cmpnt_id%NOTFOUND;
        DBMS_OUTPUT.PUT_LINE('Component ID : ' || cid);
     END LOOP;
     CLOSE cmpnt_id;

     RAISE_APPLICATION_ERROR(-20000,
        'Downgrade components above before running this script.');
   END IF;
END;
/
SET SERVEROUTPUT OFF;
Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script 
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade installed components to 9.0.1
Rem =========================================================================

Rem Setup component script filename variable
COLUMN file_name NEW_VALUE comp_file NOPRINT;

Rem Run component downgrade scripts
@@f0900010.sql

Rem Remove Java system classes after components have been downgraded.
SELECT dbms_registry.script('JAVAVM','udjvmrm.sql') 
AS file_name FROM DUAL;
@@&comp_file

column comp_name format a35
SELECT comp_name, status, substr(version,1,10) as version from dba_registry
WHERE comp_id NOT IN ('CATPROC','CATALOG');

/*
 The query above lists all of the components that must be downgraded
 prior to downgrading the Oracle9i Data Dictionary.  If any components
 do not have a DOWNGRADED status, then the following check will get
 an ORA-20000 error.  Consult Oracle9i Database Migration for 
 instructions to downgrade any remaining components and then re-run
 this script.
*/

WHENEVER SQLERROR EXIT;
EXECUTE dbms_registry_sys.check_component_downgrades;
WHENEVER SQLERROR CONTINUE;

Rem =========================================================================
Rem END STAGE 1: downgrade installed components  to 9.0.1
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade dictionary to 9.0.1
Rem =========================================================================

@@e0900010.sql

Rem =========================================================================
Rem END STAGE 2: downgrade dictionary 9.0.1
Rem =========================================================================

Rem *************************************************************************
Rem END d0900010.sql
Rem *************************************************************************
