Rem
Rem $Header: dbmsapp.sql 07-feb-2006.21:59:12 thoang Exp $
Rem
Rem dbmsapp.sql
Rem
Rem Copyright (c) 2001, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      dbmsapp.sql - streams APPly 
Rem
Rem    DESCRIPTION
Rem      This package contains APIs for Streams apply administration
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    thoang      02/07/06 - Backport htran_bug-2837369 from main 
Rem    apadmana    02/01/02 - Change apply_dblink to apply_database_link
Rem    gviswana    01/29/02 - CREATE OR REPLACE SYNONYM
Rem    rgmani      01/19/02 - Code review comments
Rem    rgmani      01/08/02 - Modify package description for dbms_apply_adm
Rem    jingliu     11/27/01 - set_{table, schema, global}_instantiation_scn
Rem    wesmith     11/15/01 - make dbms_apply_adm invoker's rights pkg
Rem    sbalaram    11/21/01 - Add pragmas for exceptions
Rem    alakshmi    11/08/01 - Merged alakshmi_apicleanup
Rem    jingliu     11/06/01 - remove add{alter}_object_error_notifier
Rem    sbalaram    11/04/01 - Removed error_* - error handler constants
Rem    sbalaram    11/01/01 - Change parameter name for create_apply
Rem    lkaplan     10/29/01 -  API - dml hdlr, lcr.execute, set key options
Rem    wesmith     10/25/01 - new parameters for create_apply, alter_apply
Rem    wesmith     10/23/01 - Created
Rem

--
-- External package for apply administration
--
CREATE OR REPLACE PACKAGE dbms_apply_adm AUTHID CURRENT_USER AS

  invalidparam EXCEPTION;
    PRAGMA exception_init(invalidparam, -23605);
    invalidparam_num NUMBER := -23605;

  invalidobj EXCEPTION;
    PRAGMA exception_init(invalidobj, -23606);
    invalidobj_num NUMBER := -23606;

  invalidcol EXCEPTION;
    PRAGMA exception_init(invalidcol, -23607);
    invalidcol_num NUMBER := -23607;

  invalidrescol EXCEPTION;
    PRAGMA exception_init(invalidrescol, -23608);
    invalidrescol_num NUMBER := -23608;

  -- prototype procedure for starting an apply process
  PROCEDURE start_apply(apply_name IN VARCHAR2);

  -- prototype procedure for stopping an apply process
  PROCEDURE stop_apply(apply_name IN VARCHAR2,
                       force      IN BOOLEAN DEFAULT FALSE);

  -- procedure for setting apply process parameters
  PROCEDURE set_parameter(apply_name IN VARCHAR2,
                          parameter  IN VARCHAR2,
                          value      IN VARCHAR2);

  -- records the set of columns to be used as the "primary key"
  -- for an apply engine.
  -- If apply_name is NULL, this key will be used for all the
  -- apply engines, which are interested in LCRs for object_name.
  -- This includes apply engines for applying LCRs to non-Oracle
  -- store.
  -- The existence of object_name can not be verified since
  -- an apply engine for a non Oracle store may not have object_name
  -- locally.
  PROCEDURE set_key_columns(object_name           IN VARCHAR2, 
                            column_list           IN VARCHAR2,
                            apply_database_link   IN VARCHAR2 := NULL);
  -- column_list is a comma-separated list of columns, with no space
  -- between columns.

  PROCEDURE set_key_columns(object_name           IN VARCHAR2, 
                            column_table          IN dbms_utility.name_array,
                            apply_database_link   IN VARCHAR2 := NULL);
  -- Index for column_table is is 1-based, increasing, dense, and
  -- terminated by a NULL.

  -- sets the dml handler for a specified object
  PROCEDURE set_dml_handler(object_name IN VARCHAR2,
                            object_type IN VARCHAR2,
                            operation_name     IN VARCHAR2,
                            error_handler      IN BOOLEAN:= FALSE,
                            user_procedure     IN VARCHAR2,
                            apply_database_link   IN VARCHAR2 DEFAULT NULL);

  FUNCTION get_error_message(
    message_number          IN NUMBER,
    local_transaction_id    IN VARCHAR2) RETURN sys.anydata;
  -- Returns the logical change record from the error queue for the
  -- specified message number and deferred transaction id.
  -- message_id is the position of the message (logical change record)
  -- within the transaction.
  -- local_transaction_id is the id number of the error transaction.

  PROCEDURE delete_error(local_transaction_id IN VARCHAR2);
  -- Deletes the specified transaction from the error queue.
  -- local_transaction_id is the id number of the deferred transaction to
  -- delete. 

  PROCEDURE delete_all_errors(apply_name  IN VARCHAR2 DEFAULT NULL);
  -- Deletes all the error transactions for the given apply engine from the
  -- error queue.
  -- apply_name is the apply engine which raised the error. 
  -- If apply_name is NULL, the all error transactions, for all apply engines,
  -- will be deleted.

  PROCEDURE execute_error(
    local_transaction_id     IN VARCHAR2, 
    execute_as_user          IN BOOLEAN DEFAULT FALSE);
  -- Re-executes the specified transaction in the error queue.
  -- local_transaction_id is the id number of the deferred transaction to
  -- re-execute. 
  -- If execute_as_user is TRUE, then the transaction is re-executed in
  -- the security context of the connected user.

  PROCEDURE execute_all_errors(
    apply_name      IN VARCHAR2 DEFAULT NULL,
    execute_as_user IN BOOLEAN DEFAULT FALSE);
  -- Re-executes the error queue transactions for the specified apply
  -- engine.
  -- apply_name is the apply engine which raised the error.
  -- If apply_name is NULL, then then all error transactions, for all apply
  -- engines, will be re-executed.
  -- If execute_as_user is TRUE, then the transactions are re-executed in
  -- the security context of the connected user.

  PROCEDURE set_update_conflict_handler(
    object_name       IN VARCHAR2,
    method_name       IN VARCHAR2,
    resolution_column IN VARCHAR2,
    column_list       IN dbms_utility.name_array,
    apply_database_link      IN VARCHAR2 DEFAULT NULL);
  -- Adds a conflict handler to resolve update conflicts
  -- object_name - the schema and name of the table, specified as
  --   schema_name.object_name, for which the update conflict handler is being
  --   added. The schema will default to the current user if one isn't
  --   specified.
  -- method_name - type of update conflict handler to create/invoke. Users can
  --   specify one of the built-in methouds (MINIMUM, MAXIMUM, OVERWRITE,
  --   DISCARD), or USER FUNCTION for a user-defined method.
  -- resolution_column - name of the column used to resolve the conflict
  -- column_list - list of columns whose values will be updated in case
  --   of a conflict.

  PROCEDURE create_apply(
    queue_name          IN VARCHAR2,
    apply_name          IN VARCHAR2,
    rule_set_name       IN VARCHAR2 DEFAULT NULL,
    message_handler     IN VARCHAR2 DEFAULT NULL,
    ddl_handler         IN VARCHAR2 DEFAULT NULL,
    apply_user          IN VARCHAR2 DEFAULT NULL,
    apply_database_link IN VARCHAR2 DEFAULT NULL,
    apply_tag           IN RAW      DEFAULT '00',
    apply_captured      IN BOOLEAN  DEFAULT FALSE);

  PROCEDURE alter_apply(
    apply_name             IN VARCHAR2,
    rule_set_name          IN VARCHAR2 DEFAULT NULL,
    remove_rule_set        IN BOOLEAN  DEFAULT FALSE,
    message_handler        IN VARCHAR2 DEFAULT NULL,
    remove_message_handler IN BOOLEAN  DEFAULT FALSE,
    ddl_handler            IN VARCHAR2 DEFAULT NULL,
    remove_ddl_handler     IN BOOLEAN  DEFAULT FALSE,
    apply_user             IN VARCHAR2 DEFAULT NULL,
    apply_tag              IN RAW      DEFAULT NULL,
    remove_apply_tag       IN BOOLEAN  DEFAULT FALSE);

  PROCEDURE drop_apply(apply_name IN VARCHAR2);

  -- Records the specified instantiation SCN for the table given by the 
  -- source_object_name parameter from the source_database_name database
  -- if instantiation_scn is not NULL. Remove the instantiation SCN
  -- if instantiation_scn is NULL.

  PROCEDURE set_table_instantiation_scn(source_object_name   IN VARCHAR2, 
                                        source_database_name IN VARCHAR2, 
                                        instantiation_scn    IN NUMBER,
                                        apply_database_link IN VARCHAR2 DEFAULT NULL);

  -- Records the specified instantiation SCN for the schema
  -- from the source_database_name database if instantiation_scn is not NULL.
  -- Remove the instantiation SCN if instantiation_scn is NULL.
  -- If recursive = true then for all tables in this schema at the source db
  -- set the scn.
  PROCEDURE set_schema_instantiation_scn(source_schema_name   IN VARCHAR2,
                                         source_database_name IN VARCHAR2,
                                         instantiation_scn    IN NUMBER,
                                         apply_database_link IN VARCHAR2 DEFAULT
 NULL,
                                         recursive IN BOOLEAN DEFAULT FALSE);

  -- Records the specified instantiation SCN for the source_database_name
  -- database if instantiation_scn is not NULL
  -- Remove the instantiation SCN if instantiation_scn is NULL
  -- If recursive = true then for all tables and schemas at the source db
  -- set the scn.
  PROCEDURE set_global_instantiation_scn(source_database_name IN VARCHAR2,
                                         instantiation_scn    IN NUMBER,
                                         apply_database_link IN VARCHAR2 DEFAULT
 NULL,
                                         recursive IN BOOLEAN DEFAULT FALSE);

END dbms_apply_adm;
/
GRANT EXECUTE ON dbms_apply_adm TO execute_catalog_role
/
CREATE OR REPLACE PUBLIC SYNONYM dbms_apply_adm FOR dbms_apply_adm
/

