Rem
Rem $Header: dbmslsby.sql 10-aug-2005.17:28:53 gkulkarn Exp $
Rem
Rem dbmslsby.sql
Rem
Rem Copyright (c) 2000, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      dbmslsby.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmacnico    08/18/05 - 4527771: backport 4315344 LSBY security fixes
Rem    ajadams     09/17/04 - corrupted dictionary fixup support 
Rem    mtao        12/06/03 - add purge_session 
Rem    raguzman    07/01/03 - must default name in parupd
Rem    raguzman    04/07/03 - audins: tran_id to xid in 10i
Rem    jnesheiw    08/05/02 - create DBMS_LOGSTDBY_PUBLIC package
Rem    jnesheiw    07/23/02 - grant connect, resource to logstdby_administrator
Rem    jmzhang     06/25/02 - declare unskip(one para)
Rem    gviswana    01/29/02 - CREATE OR REPLACE SYNONYM
Rem    jnesheiw    10/31/01 - fix audins.
Rem    rguzman     10/11/01 - Using internal logmnr interface, drop some procs
Rem    sslim       09/25/01 - Logminer dictionary build as a background process
Rem    sslim       09/04/01 - Mods due new procedures with additional arguments
Rem    rguzman     08/31/01 - Add guard check
Rem    jnesheiw    09/13/01 - Add stop_on_ddl support.
Rem    jnesheiw    08/07/01 - change UTL_LOGSTDBY to DBMS_INTERNAL_LOGSTDBY.
Rem    rguzman     06/19/01 - Add verify_nosession.
Rem    sslim       04/11/01 - Add parins/parupd/pardel procedures
Rem    sslim       02/21/01 - Add procedure to prepare user statement for apply
Rem    jdavison    12/01/00 - Drop extra semicolons
Rem    rguzman     09/12/00 - Handle new flags column for sequences
Rem    svivian     07/27/00 - single table instantiation
Rem    svivian     06/01/00 - delete from job queue
Rem    svivian     05/31/00 - jobupd added
Rem    svivian     05/26/00 - add hidden columns to jobq
Rem    rguzman     05/19/00 - Adding apply_set/unset
Rem    svivian     04/20/00 - continue work on sequences
Rem    svivian     04/18/00 - add callout to set logical apply mode
Rem    svivian     03/31/00 - sequence support
Rem    svivian     03/22/00 - add test_jqc
Rem    svivian     03/13/00 - procedures for audit change record processing
Rem    svivian     02/25/00 - Created
Rem



CREATE OR REPLACE PACKAGE sys.dbms_logstdby_public IS
-- Skip procedure constants
SKIP_ACTION_SKIP    CONSTANT NUMBER :=  1;
SKIP_ACTION_APPLY   CONSTANT NUMBER :=  0;
SKIP_ACTION_REPLACE CONSTANT NUMBER := -1;
SKIP_ACTION_ERROR   CONSTANT NUMBER := -2;
SKIP_ACTION_NOPRIVS CONSTANT NUMBER := -3;

PROCEDURE stop_on_ddl  (statement      IN  VARCHAR2,
                                        statement_type IN  VARCHAR2,
                                        schema         IN  VARCHAR2,
                                        name           IN  VARCHAR2,
                                        xidusn         IN  NUMBER,
                                        xidslt         IN  NUMBER,
                                        xidsqn         IN  NUMBER,
                                        skip_action    OUT NUMBER,
                                        new_statement  OUT VARCHAR2);


END dbms_logstdby_public;
/
show errors

CREATE OR REPLACE PUBLIC SYNONYM dbms_logstdby_public 
  FOR sys.dbms_logstdby_public;
GRANT EXECUTE ON dbms_logstdby_public to public;

CREATE OR REPLACE PACKAGE sys.dbms_logstdby AUTHID CURRENT_USER IS
   
-- Skip procedure constants   
SKIP_ACTION_SKIP    CONSTANT NUMBER :=  1;
SKIP_ACTION_APPLY   CONSTANT NUMBER :=  0;
SKIP_ACTION_REPLACE CONSTANT NUMBER := -1;
SKIP_ACTION_ERROR   CONSTANT NUMBER := -2;
SKIP_ACTION_NOPRIVS CONSTANT NUMBER := -3;
   
PROCEDURE guard_bypass_on;

PROCEDURE guard_bypass_off;

PROCEDURE primary_dbid(dbid IN NUMBER);		    	     /* Undocumented */

PROCEDURE guard_check;

PROCEDURE apply_set(inname IN VARCHAR,
                    value  IN VARCHAR);

PROCEDURE apply_unset(inname IN VARCHAR);

PROCEDURE build;

--
-- NAME: stop_on_ddl
--
-- DESCRIPTION
--  This is a stored procedure that is defined as a callout
--  to implement stop on DDL.
--
PROCEDURE stop_on_ddl  (statement      IN  VARCHAR2,
                                        statement_type IN  VARCHAR2,
                                        schema         IN  VARCHAR2,
                                        name           IN  VARCHAR2,
                                        xidusn         IN  NUMBER,
                                        xidslt         IN  NUMBER,
                                        xidsqn         IN  NUMBER,
                                        skip_action    OUT NUMBER,
                                        new_statement  OUT VARCHAR2);

--
-- NAME: skip
--
-- DESCRIPTION:
--  This is a stored procedure that inserts a row in the skip table
--  according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE skip(stmt IN VARCHAR2,
               schema_name IN VARCHAR2,
               object_name IN VARCHAR2,
               proc_name IN VARCHAR2);

PROCEDURE skip(stmt IN VARCHAR2,
               schema_name IN VARCHAR2,
               object_name IN VARCHAR2);

PROCEDURE skip(stmt IN VARCHAR2);


--
-- NAME: skip_error
--
-- DESCRIPTION:
--  This is a stored procedure that inserts a row into the
--  skip table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE skip_error(stmt IN VARCHAR2,
                     schema_name IN VARCHAR2,
                     object_name IN VARCHAR2,
                     proc_name IN VARCHAR2);


--
-- NAME: skip_transaction
--
-- DESCRIPTION:
--  This is a stored procedure that inserts a row into the
--  skip transaction table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE skip_transaction(xidusn_p IN NUMBER,
                           xidslt_p IN NUMBER,
                           xidsqn_p IN NUMBER);

--
-- NAME: unskip
--
-- DESCRIPTION:
--  This is a stored procedure that deletes a row from the
--  skip table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE unskip(stmt IN VARCHAR2,
                 schema_name IN VARCHAR2,
                 object_name IN VARCHAR2);

PROCEDURE unskip(stmt IN VARCHAR2);

--
-- NAME: unskip_error
--
-- DESCRIPTION:
--  This is a stored procedure that deletes a row from the
--  skip table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE unskip_error(stmt IN VARCHAR2,
                       schema_name IN VARCHAR2,
                       object_name IN VARCHAR2);

--
-- NAME: unskip_transaction
--
-- DESCRIPTION:
--  This is a stored procedure that deletes a row from the
--  skip transaction table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
PROCEDURE unskip_transaction(xidusn_p IN NUMBER,
                             xidslt_p IN NUMBER,
                             xidsqn_p IN NUMBER);


--
-- NAME: validate_auth
--
-- DESCRIPTION
-- validate security aspects of skip procedures (sec bug 4315344)
-- this proc is here not dbms_logstdby_internal because
-- package is declared authid current_user while internal is
-- declared authid definer; we need roles to be active
--
FUNCTION validate_auth RETURN BOOLEAN;


--
-- NAME: instantiate_table
--
-- DESCRIPTION:
--	This procedure creates and populates a table and its
--	children from a table existing on a source database as
--	accessed via the dblink parameter.
--
--	If the table currently exists in the target database,
--	it will be dropped. Any constraint or index that exists
--	on the source table will also be created but physical 
--	storage characteristics will be omitted.
--
-- PARAMETERS
--
--	table_name 	Name of table to be instantiated
-- 	schema_name 	Schema name in which the table resides
--	dblink 		link to database in which the table resides
--
-- USAGE NOTES:
--	This procedure should be called on a logical standby database
--	whenever a table needs to be re-instantiated. If the apply
--	engine is currently running, and exception will be raised.
--	The target table will be dropped first if it currently exists.
--
PROCEDURE instantiate_table(schema_name IN VARCHAR2,
			    table_name IN VARCHAR2,
			    dblink IN VARCHAR2);

PROCEDURE prepare_instantiation(dblink IN VARCHAR2);
PROCEDURE end_instantiation(dblink IN VARCHAR2);
--
-- NAME: purge_session
--
-- DESCRIPTION:
--      This procedure purges the session metadata up to the latest
--      safe purge scn. This procedure can be called while the logical
--      standby apply is running
--
-- PARAMETERS
--
--      NONE
--
-- USAGE NOTES:
--      
--
PROCEDURE purge_session;

PROCEDURE apply;                                             /* Undocumented */
PROCEDURE apply_stop;                                        /* Undocumented */
PROCEDURE apply_abort;                                       /* Undocumented */

END DBMS_LOGSTDBY;
/
show errors

  
CREATE OR REPLACE PUBLIC SYNONYM dbms_logstdby FOR sys.dbms_logstdby;
GRANT EXECUTE ON dbms_logstdby TO dba;

CREATE ROLE logstdby_administrator;
GRANT EXECUTE ON dbms_logstdby TO logstdby_administrator;
GRANT CONNECT, RESOURCE TO logstdby_administrator;

-- Revoke execute on DBMS_LOGSTDBY from public.  If it has already
-- been revoked, do not throw an error. NOTE this is to accomodate
-- 9iR1 databases that formerly had the package executable to public. 

DECLARE
  already_revoked EXCEPTION;
  PRAGMA EXCEPTION_INIT(already_revoked,-01927);
BEGIN
   execute immediate 'REVOKE EXECUTE ON dbms_logstdby FROM public';
EXCEPTION WHEN already_revoked then null;
END;
/

CREATE OR REPLACE PACKAGE sys.dbms_internal_logstdby AUTHID DEFINER IS

PROCEDURE guard_bypass_on;

PROCEDURE guard_bypass_off;

PROCEDURE end_stream(dblink IN VARCHAR);		     /* Undocumented */

PROCEDURE build;

PROCEDURE verify_session;				     /* Undocumented */

PROCEDURE verify_nosession;				     /* Undocumented */

PROCEDURE primary_dbid(dbid IN NUMBER);		    	     /* Undocumented */

PROCEDURE apply_set(inname IN VARCHAR,
                    value  IN VARCHAR);

PROCEDURE apply_unset(inname IN VARCHAR);

PROCEDURE capture_scn;

PROCEDURE set_logical_instantiation;

PROCEDURE clear_logical_instantiation;

PROCEDURE lock_tables;


--
-- NAME: audins
--
-- DESCRIPTION:
--  This is a stored procedure that processes audit insert change records
--  for the log miner during logical apply. Those portions of the
--  audit record which are irrelevant to the standby system will
--  be NULL'd. The end result is that a massaged variant of the
--  record will be written to the standby's AUD$ table.
--
-- PARAMETERS
--  AUD$ column data
--
-- USAGE NOTES:
--  The data passed in is expected to reflect the constraints on
--  AUD$ so those fields with NOT NULL constraints will not be
--  checked for NULL.
--
-- PROCEDURE BODY:
--
PROCEDURE audins(sessionid_N          IN NUMBER DEFAULT 0,
                 entryid_N            IN NUMBER DEFAULT 0,
                 statement_N          IN NUMBER DEFAULT 0,
                 timestamp#_N         IN DATE DEFAULT SYSDATE,
                 userid_N             IN VARCHAR2 DEFAULT NULL,
                 userhost_N           IN VARCHAR2 DEFAULT NULL,
                 terminal_N           IN VARCHAR2 DEFAULT NULL,
                 action#_N            IN NUMBER DEFAULT 0,
                 returncode_N         IN NUMBER DEFAULT 0,
                 obj$creator_N        IN VARCHAR2 DEFAULT NULL,
                 obj$name_N           IN VARCHAR2 DEFAULT NULL,
                 auth$privileges_N    IN VARCHAR2 DEFAULT NULL,
                 auth$grantee_N       IN VARCHAR2 DEFAULT NULL,
                 new$owner_N          IN VARCHAR2 DEFAULT NULL,
                 new$name_N           IN VARCHAR2 DEFAULT NULL,
                 ses$actions_N        IN VARCHAR2 DEFAULT NULL,
                 ses$tid_N            IN NUMBER DEFAULT NULL,
                 logoff$lread_N       IN NUMBER DEFAULT NULL,
                 logoff$pread_N       IN NUMBER DEFAULT NULL,
                 logoff$lwrite_N      IN NUMBER DEFAULT NULL,
                 logoff$dead_N        IN NUMBER DEFAULT NULL,
                 logoff$time_N        IN DATE DEFAULT NULL,
                 comment$text_N       IN VARCHAR2 DEFAULT NULL,
                 clientid_N           IN VARCHAR2 DEFAULT NULL,
                 spare1_N             IN VARCHAR2 DEFAULT NULL,
                 spare2_N             IN NUMBER DEFAULT NULL,
                 obj$label_N          IN RAW DEFAULT NULL,
                 ses$label_N          IN RAW DEFAULT NULL,
                 priv$used_N          IN NUMBER DEFAULT NULL,
                 sessioncpu_N         IN NUMBER DEFAULT NULL,
                 ntimestamp#_N        IN TIMESTAMP DEFAULT NULL,
                 proxy$sid_N          IN NUMBER DEFAULT NULL,
                 user$guid_N          IN VARCHAR2 DEFAULT NULL,
                 instance#_N          IN NUMBER DEFAULT NULL,
                 process#_N           IN NUMBER DEFAULT NULL,
                 xid_N                IN VARCHAR2 DEFAULT NULL,
                 auditid_N            IN VARCHAR2 DEFAULT NULL,
                 scn_N                IN NUMBER DEFAULT NULL,
                 dbid_N               IN NUMBER DEFAULT NULL,
                 sqlbind_N            IN CLOB DEFAULT NULL,
                 sqltext_N            IN CLOB DEFAULT NULL);

--
-- NAME: audupd
--
-- DESCRIPTION:
--  This is a stored procedure that processes audit update change records
--  for the log miner during logical apply.
--
-- PARAMETERS
--  AUD$ column data
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE audupd(sessionid_N          IN NUMBER DEFAULT 0,
                 sessionid_I          IN NUMBER DEFAULT 0,
                 sessionid_O          IN NUMBER DEFAULT 0,
                 sessionid_OI         IN NUMBER DEFAULT 0,
                 entryid_N            IN NUMBER DEFAULT 0,
                 entryid_I            IN NUMBER DEFAULT 0,
                 entryid_O            IN NUMBER DEFAULT 0,
                 entryid_OI           IN NUMBER DEFAULT 0,
                 statement_N          IN NUMBER DEFAULT 0,
                 statement_I          IN NUMBER DEFAULT 0,
                 statement_O          IN NUMBER DEFAULT 0,
                 statement_OI         IN NUMBER DEFAULT 0,
                 timestamp#_N         IN DATE DEFAULT SYSDATE,
                 timestamp#_I         IN NUMBER DEFAULT 0,
                 timestamp#_O         IN DATE DEFAULT SYSDATE,
                 timestamp#_OI        IN NUMBER DEFAULT 0,
                 userid_N             IN VARCHAR2 DEFAULT NULL,
                 userid_I             IN NUMBER DEFAULT 0,
                 userid_O             IN VARCHAR2 DEFAULT NULL,
                 userid_OI            IN NUMBER DEFAULT 0,
                 userhost_N           IN VARCHAR2 DEFAULT NULL,
                 userhost_I           IN NUMBER DEFAULT 0,
                 userhost_O           IN VARCHAR2 DEFAULT NULL,
                 userhost_OI          IN NUMBER DEFAULT 0,
                 terminal_N           IN VARCHAR2 DEFAULT NULL,
                 terminal_I           IN NUMBER DEFAULT 0,
                 terminal_O           IN VARCHAR2 DEFAULT NULL,
                 terminal_OI          IN NUMBER DEFAULT 0,
                 action#_N            IN NUMBER DEFAULT 0,
                 action#_I            IN NUMBER DEFAULT 0,
                 action#_O            IN NUMBER DEFAULT 0,
                 action#_OI           IN NUMBER DEFAULT 0,
                 returncode_N         IN NUMBER DEFAULT 0,
                 returncode_I         IN NUMBER DEFAULT 0,
                 returncode_O         IN NUMBER DEFAULT 0,
                 returncode_OI        IN NUMBER DEFAULT 0,
                 obj$creator_N        IN VARCHAR2 DEFAULT NULL,
                 obj$creator_I        IN NUMBER DEFAULT 0,
                 obj$creator_O        IN VARCHAR2 DEFAULT NULL,
                 obj$creator_OI       IN NUMBER DEFAULT 0,
                 obj$name_N           IN VARCHAR2 DEFAULT NULL,
                 obj$name_I           IN NUMBER DEFAULT 0,
                 obj$name_O           IN VARCHAR2 DEFAULT NULL,
                 obj$name_OI          IN NUMBER DEFAULT 0,
                 auth$privileges_N    IN VARCHAR2 DEFAULT NULL,
                 auth$privileges_I    IN NUMBER DEFAULT 0,
                 auth$privileges_O    IN VARCHAR2 DEFAULT NULL,
                 auth$privileges_OI   IN NUMBER DEFAULT 0,
                 auth$grantee_N       IN VARCHAR2 DEFAULT NULL,
                 auth$grantee_I       IN NUMBER DEFAULT 0,
                 auth$grantee_O       IN VARCHAR2 DEFAULT NULL,
                 auth$grantee_OI      IN NUMBER DEFAULT 0,
                 new$owner_N          IN VARCHAR2 DEFAULT NULL,
                 new$owner_I          IN NUMBER DEFAULT 0,
                 new$owner_O          IN VARCHAR2 DEFAULT NULL,
                 new$owner_OI         IN NUMBER DEFAULT 0,
                 new$name_N           IN VARCHAR2 DEFAULT NULL,
                 new$name_I           IN NUMBER DEFAULT 0,
                 new$name_O           IN VARCHAR2 DEFAULT NULL,
                 new$name_OI          IN NUMBER DEFAULT 0,
                 ses$actions_N        IN VARCHAR2 DEFAULT NULL,
                 ses$actions_I        IN NUMBER DEFAULT 0,
                 ses$actions_O        IN VARCHAR2 DEFAULT NULL,
                 ses$actions_OI       IN NUMBER DEFAULT 0,
                 ses$tid_N            IN NUMBER DEFAULT NULL,
                 ses$tid_I            IN NUMBER DEFAULT 0,
                 ses$tid_O            IN NUMBER DEFAULT NULL,
                 ses$tid_OI           IN NUMBER DEFAULT 0,
                 logoff$lread_N       IN NUMBER DEFAULT NULL,
                 logoff$lread_I       IN NUMBER DEFAULT 0,
                 logoff$lread_O       IN NUMBER DEFAULT NULL,
                 logoff$lread_OI      IN NUMBER DEFAULT 0,
                 logoff$pread_N       IN NUMBER DEFAULT NULL,
                 logoff$pread_I       IN NUMBER DEFAULT 0,
                 logoff$pread_O       IN NUMBER DEFAULT NULL,
                 logoff$pread_OI      IN NUMBER DEFAULT 0,
                 logoff$lwrite_N      IN NUMBER DEFAULT NULL,
                 logoff$lwrite_I      IN NUMBER DEFAULT 0,
                 logoff$lwrite_O      IN NUMBER DEFAULT NULL,
                 logoff$lwrite_OI     IN NUMBER DEFAULT 0,
                 logoff$dead_N        IN NUMBER DEFAULT NULL,
                 logoff$dead_I        IN NUMBER DEFAULT 0,
                 logoff$dead_O        IN NUMBER DEFAULT NULL,
                 logoff$dead_OI       IN NUMBER DEFAULT 0,
                 logoff$time_N        IN DATE DEFAULT NULL,
                 logoff$time_I        IN NUMBER DEFAULT 0,
                 logoff$time_O        IN DATE DEFAULT NULL,
                 logoff$time_OI       IN NUMBER DEFAULT 0,
                 comment$text_N       IN VARCHAR2 DEFAULT NULL,
                 comment$text_I       IN NUMBER DEFAULT 0,
                 comment$text_O       IN VARCHAR2 DEFAULT NULL,
                 comment$text_OI      IN NUMBER DEFAULT 0,
                 clientid_N           IN VARCHAR2 DEFAULT NULL,
                 clientid_I           IN NUMBER DEFAULT 0,
                 clientid_O           IN VARCHAR2 DEFAULT NULL,
                 clientid_OI          IN NUMBER DEFAULT 0,
                 spare1_N             IN VARCHAR2 DEFAULT NULL,
                 spare1_I             IN NUMBER DEFAULT 0,
                 spare1_O             IN VARCHAR2 DEFAULT NULL,
                 spare1_OI            IN NUMBER DEFAULT 0,
                 spare2_N             IN NUMBER DEFAULT NULL,
                 spare2_I             IN NUMBER DEFAULT 0,
                 spare2_O             IN NUMBER DEFAULT NULL,
                 spare2_OI            IN NUMBER DEFAULT 0,
                 obj$label_N          IN RAW DEFAULT NULL,
                 obj$label_I          IN NUMBER DEFAULT 0,
                 obj$label_O          IN RAW DEFAULT NULL,
                 obj$label_OI         IN NUMBER DEFAULT 0,
                 ses$label_N          IN RAW DEFAULT NULL,
                 ses$label_I          IN NUMBER DEFAULT 0,
                 ses$label_O          IN RAW DEFAULT NULL,
                 ses$label_OI         IN NUMBER DEFAULT 0,
                 priv$used_N          IN NUMBER DEFAULT NULL,
                 priv$used_I          IN NUMBER DEFAULT 0,
                 priv$used_O          IN NUMBER DEFAULT NULL,
                 priv$used_OI         IN NUMBER DEFAULT 0,
                 sessioncpu_N         IN NUMBER DEFAULT NULL,
                 sessioncpu_I         IN NUMBER DEFAULT 0,
                 sessioncpu_O         IN NUMBER DEFAULT NULL,
                 sessioncpu_OI        IN NUMBER DEFAULT 0,
                 ntimestamp#_N        IN TIMESTAMP DEFAULT NULL,
                 ntimestamp#_I        IN NUMBER DEFAULT 0,
                 ntimestamp#_O        IN TIMESTAMP DEFAULT NULL,
                 ntimestamp#_OI       IN NUMBER DEFAULT 0,
                 proxy$sid_N          IN NUMBER DEFAULT NULL,
                 proxy$sid_I          IN NUMBER DEFAULT 0,
                 proxy$sid_O          IN NUMBER DEFAULT NULL,
                 proxy$sid_OI         IN NUMBER DEFAULT 0,
                 user$guid_N          IN VARCHAR2 DEFAULT NULL,
                 user$guid_I          IN NUMBER DEFAULT 0,
                 user$guid_O          IN VARCHAR2 DEFAULT NULL,
                 user$guid_OI         IN NUMBER DEFAULT 0,
                 instance#_N          IN NUMBER DEFAULT NULL,
                 instance#_I          IN NUMBER DEFAULT 0,
                 instance#_O          IN NUMBER DEFAULT NULL,
                 instance#_OI         IN NUMBER DEFAULT 0,
                 process#_N           IN NUMBER DEFAULT NULL,
                 process#_I           IN NUMBER DEFAULT 0,
                 process#_O           IN NUMBER DEFAULT NULL,
                 process#_OI          IN NUMBER DEFAULT 0,
                 xid_N                IN VARCHAR2 DEFAULT NULL,
                 xid_I                IN NUMBER DEFAULT 0,
                 xid_O                IN VARCHAR2 DEFAULT NULL,
                 xid_OI               IN NUMBER DEFAULT 0,
                 auditid_N            IN VARCHAR2 DEFAULT NULL,
                 auditid_I            IN NUMBER DEFAULT 0,
                 auditid_O            IN VARCHAR2 DEFAULT NULL,
                 auditid_OI           IN NUMBER DEFAULT 0,
                 scn_N                IN NUMBER DEFAULT NULL,
                 scn_I                IN NUMBER DEFAULT 0,
                 scn_O                IN NUMBER DEFAULT NULL,
                 scn_OI               IN NUMBER DEFAULT 0,
                 dbid_N               IN NUMBER DEFAULT NULL,
                 dbid_I               IN NUMBER DEFAULT 0,
                 dbid_O               IN NUMBER DEFAULT NULL,
                 dbid_OI              IN NUMBER DEFAULT 0,
                 sqlbind_N            IN CLOB DEFAULT NULL,
                 sqlbind_I            IN NUMBER DEFAULT 0,
                 sqlbind_O            IN CLOB DEFAULT NULL,
                 sqlbind_OI           IN NUMBER DEFAULT 0,
                 sqltext_N            IN CLOB DEFAULT NULL,
                 sqltext_I            IN NUMBER DEFAULT 0,
                 sqltext_O            IN CLOB DEFAULT NULL,
                 sqltext_OI           IN NUMBER DEFAULT 0);

--
-- NAME: auddel
--
-- DESCRIPTION:
--  This is a stored procedure that processes audit delete change records
--  for the log miner during logical apply.
--
-- PARAMETERS
--  AUD$ column data
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE auddel(sessionid_O          IN NUMBER DEFAULT 0,
                 entryid_O            IN NUMBER DEFAULT 0,
                 statement_O          IN NUMBER DEFAULT 0,
                 timestamp#_O         IN DATE DEFAULT SYSDATE,
                 userid_O             IN VARCHAR2 DEFAULT NULL,
                 userhost_O           IN VARCHAR2 DEFAULT NULL,
                 terminal_O           IN VARCHAR2 DEFAULT NULL,
                 action#_O            IN NUMBER DEFAULT 0,
                 returncode_O         IN NUMBER DEFAULT 0,
                 obj$creator_O        IN VARCHAR2 DEFAULT NULL,
                 obj$name_O           IN VARCHAR2 DEFAULT NULL,
                 auth$privileges_O    IN VARCHAR2 DEFAULT NULL,
                 auth$grantee_O       IN VARCHAR2 DEFAULT NULL,
                 new$owner_O          IN VARCHAR2 DEFAULT NULL,
                 new$name_O           IN VARCHAR2 DEFAULT NULL,
                 ses$actions_O        IN VARCHAR2 DEFAULT NULL,
                 ses$tid_O            IN NUMBER DEFAULT NULL,
                 logoff$lread_O       IN NUMBER DEFAULT NULL,
                 logoff$pread_O       IN NUMBER DEFAULT NULL,
                 logoff$lwrite_O      IN NUMBER DEFAULT NULL,
                 logoff$dead_O        IN NUMBER DEFAULT NULL,
                 logoff$time_O        IN DATE DEFAULT NULL,
                 comment$text_O       IN VARCHAR2 DEFAULT NULL,
                 clientid_O           IN VARCHAR2 DEFAULT NULL,
                 spare1_O             IN VARCHAR2 DEFAULT NULL,
                 spare2_O             IN NUMBER DEFAULT NULL,
                 obj$label_O          IN RAW DEFAULT NULL,
                 ses$label_O          IN RAW DEFAULT NULL,
                 priv$used_O          IN NUMBER DEFAULT NULL,
                 sessioncpu_O         IN NUMBER DEFAULT NULL,
                 ntimestamp#_O        IN TIMESTAMP DEFAULT NULL,
                 proxy$sid_O          IN NUMBER DEFAULT NULL,
                 user$guid_O          IN VARCHAR2 DEFAULT NULL,
                 instance#_O          IN NUMBER DEFAULT NULL,
                 process#_O           IN NUMBER DEFAULT NULL,
                 xid_O                IN VARCHAR2 DEFAULT NULL,
                 auditid_O            IN VARCHAR2 DEFAULT NULL,
                 scn_O                IN NUMBER DEFAULT NULL,
                 dbid_O               IN NUMBER DEFAULT NULL,
                 sqlbind_O            IN CLOB DEFAULT NULL,
                 sqltext_O            IN CLOB DEFAULT NULL);


--
-- NAME: jobins - procedure that performs the insert into job$
--
-- DESCRIPTION:
--  This is a stored procedure that processes job queue insert change 
--  records for the log miner during logical apply. Those portions of the
--  job queue record which are irrelevant to the standby system will
--  be NULL'd. The end result is that a massaged variant of the
--  record will be written to the standby's JOB$ table.
--
-- PARAMETERS
--  All JOB$ columns
--
-- USAGE NOTES:
--  The data passed in is expected to reflect the constraints on
--  JOB$ so those fields with NOT NULL constraints will not be
--  checked for NULL.
--
-- PROCEDURE BODY:
--
PROCEDURE jobins(job_N             IN NUMBER DEFAULT 0,
                 lowner_N          IN VARCHAR2 DEFAULT NULL,
                 powner_N          IN VARCHAR2 DEFAULT NULL,
                 cowner_N          IN VARCHAR2 DEFAULT NULL,
                 last_date_N       IN DATE DEFAULT NULL,
                 this_date_N       IN DATE DEFAULT SYSDATE,
                 next_date_N       IN DATE DEFAULT SYSDATE,
                 total_N           IN NUMBER DEFAULT 0,
                 interval#_N       IN VARCHAR2 DEFAULT NULL,
                 failures_N        IN NUMBER DEFAULT NULL,
                 flag_N            IN NUMBER DEFAULT 0,
                 what_N            IN VARCHAR2 DEFAULT NULL,
                 nlsenv_N          IN VARCHAR2 DEFAULT NULL,
                 env_N             IN RAW DEFAULT NULL,
                 cur_ses_label_N   IN MLSLABEL DEFAULT NULL,
                 clearance_hi_N    IN MLSLABEL DEFAULT NULL,
                 clearance_lo_N    IN MLSLABEL DEFAULT NULL,
                 charenv_N         IN VARCHAR2 DEFAULT NULL,
                 field1_N          IN NUMBER DEFAULT 0);

--
-- NAME: jobupd - procedure that performs the updates to job$
--
-- DESCRIPTION:
--  This is a stored procedure that processes job queue update change 
--  records for the log miner during logical apply. Those portions of the
--  job queue record which are irrelevant to the standby system will
--  be NULL'd. The end result is that a massaged variant of the
--  record will be written to the standby's JOB$ table.
--
-- PARAMETERS
--  All JOB$ columns. For columns for which no data passed in,
--  corresponding indicator parameters will be 0.
--
-- USAGE NOTES:
--  Obsolete fields will be ignored as they are not expected to change.
--
-- PROCEDURE BODY:
--
PROCEDURE jobupd(job_N             IN NUMBER DEFAULT 0,
                 job_I             IN NUMBER DEFAULT 0,
                 job_O             IN NUMBER DEFAULT 0,
                 job_OI            IN NUMBER DEFAULT 0,
                 lowner_N          IN VARCHAR2 DEFAULT NULL,
                 lowner_I          IN NUMBER DEFAULT 0,
                 lowner_O          IN VARCHAR2 DEFAULT NULL,
                 lowner_OI         IN NUMBER DEFAULT 0,
                 powner_N          IN VARCHAR2 DEFAULT NULL,
                 powner_I          IN NUMBER DEFAULT 0,
                 powner_O          IN VARCHAR2 DEFAULT NULL,
                 powner_OI         IN NUMBER DEFAULT 0,
                 cowner_N          IN VARCHAR2 DEFAULT NULL,
                 cowner_I          IN NUMBER DEFAULT 0,
                 cowner_O          IN VARCHAR2 DEFAULT NULL,
                 cowner_OI         IN NUMBER DEFAULT 0,
                 last_date_N       IN DATE DEFAULT NULL,
                 last_date_I       IN NUMBER DEFAULT 0,
                 last_date_O       IN DATE DEFAULT NULL,
                 last_date_OI      IN NUMBER DEFAULT 0,
                 this_date_N       IN DATE DEFAULT SYSDATE,
                 this_date_I       IN NUMBER DEFAULT 0,
                 this_date_O       IN DATE DEFAULT SYSDATE,
                 this_date_OI      IN NUMBER DEFAULT 0,
                 next_date_N       IN DATE DEFAULT SYSDATE,
                 next_date_I       IN NUMBER DEFAULT 0,
                 next_date_O       IN DATE DEFAULT SYSDATE,
                 next_date_OI      IN NUMBER DEFAULT 0,
                 total_N           IN NUMBER DEFAULT 0,
                 total_I           IN NUMBER DEFAULT 0,
                 total_O           IN NUMBER DEFAULT 0,
                 total_OI          IN NUMBER DEFAULT 0,
                 interval#_N       IN VARCHAR2 DEFAULT NULL,
                 interval#_I       IN NUMBER DEFAULT 0,
                 interval#_O       IN VARCHAR2 DEFAULT NULL,
                 interval#_OI      IN NUMBER DEFAULT 0,
                 failures_N        IN NUMBER DEFAULT NULL,
                 failures_I        IN NUMBER DEFAULT 0,
                 failures_O        IN NUMBER DEFAULT NULL,
                 failures_OI       IN NUMBER DEFAULT 0,
                 flag_N            IN NUMBER DEFAULT 0,
                 flag_I            IN NUMBER DEFAULT 0,
                 flag_O            IN NUMBER DEFAULT 0,
                 flag_OI           IN NUMBER DEFAULT 0,
                 what_N            IN VARCHAR2 DEFAULT NULL,
                 what_I            IN NUMBER DEFAULT 0,
                 what_O            IN VARCHAR2 DEFAULT NULL,
                 what_OI           IN NUMBER DEFAULT 0,
                 nlsenv_N          IN VARCHAR2 DEFAULT NULL,
                 nlsenv_I          IN NUMBER DEFAULT 0,
                 nlsenv_O          IN VARCHAR2 DEFAULT NULL,
                 nlsenv_OI         IN NUMBER DEFAULT 0,
                 env_N             IN RAW DEFAULT NULL,
                 env_I             IN NUMBER DEFAULT 0,
                 env_O             IN RAW DEFAULT NULL,
                 env_OI            IN NUMBER DEFAULT 0,
                 cur_ses_label_N   IN MLSLABEL DEFAULT NULL,
                 cur_ses_label_I   IN NUMBER DEFAULT 0,
                 cur_ses_label_O   IN MLSLABEL DEFAULT NULL,
                 cur_ses_label_OI  IN NUMBER DEFAULT 0,
                 clearance_hi_N    IN MLSLABEL DEFAULT NULL,
                 clearance_hi_I    IN NUMBER DEFAULT 0,
                 clearance_hi_O    IN MLSLABEL DEFAULT NULL,
                 clearance_hi_OI   IN NUMBER DEFAULT 0,
                 clearance_lo_N    IN MLSLABEL DEFAULT NULL,
                 clearance_lo_I    IN NUMBER DEFAULT 0,
                 clearance_lo_O    IN MLSLABEL DEFAULT NULL,
                 clearance_lo_OI   IN NUMBER DEFAULT 0,
                 charenv_N         IN VARCHAR2 DEFAULT NULL,
                 charenv_I         IN NUMBER DEFAULT 0,
                 charenv_O         IN VARCHAR2 DEFAULT NULL,
                 charenv_OI        IN NUMBER DEFAULT 0,
                 field1_N          IN NUMBER DEFAULT 0,
                 field1_I          IN NUMBER DEFAULT 0,
                 field1_O          IN NUMBER DEFAULT 0,
                 field1_OI         IN NUMBER DEFAULT 0);

--
-- NAME: jobdel - procedure that performs the delete from job$
--
-- DESCRIPTION:
--  This is a stored procedure that processes job queue delete change 
--  records for the log miner during logical apply.
--
-- PARAMETERS
--  All JOB$ columns
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE jobdel(job_O             IN NUMBER DEFAULT 0,
                 lowner_O          IN VARCHAR2 DEFAULT NULL,
                 powner_O          IN VARCHAR2 DEFAULT NULL,
                 cowner_O          IN VARCHAR2 DEFAULT NULL,
                 last_date_O       IN DATE DEFAULT NULL,
                 this_date_O       IN DATE DEFAULT SYSDATE,
                 next_date_O       IN DATE DEFAULT SYSDATE,
                 total_O           IN NUMBER DEFAULT 0,
                 interval#_O       IN VARCHAR2 DEFAULT NULL,
                 failures_O        IN NUMBER DEFAULT NULL,
                 flag_O            IN NUMBER DEFAULT 0,
                 what_O            IN VARCHAR2 DEFAULT NULL,
                 nlsenv_O          IN VARCHAR2 DEFAULT NULL,
                 env_O             IN RAW DEFAULT NULL,
                 cur_ses_label_O   IN MLSLABEL DEFAULT NULL,
                 clearance_hi_O    IN MLSLABEL DEFAULT NULL,
                 clearance_lo_O    IN MLSLABEL DEFAULT NULL,
                 charenv_O         IN VARCHAR2 DEFAULT NULL,
                 field1_O          IN NUMBER DEFAULT 0);

--
-- NAME: sequpd - procedure that calls an ICD to update the sequence.
--
-- DESCRIPTION:
--  This is a stored procedure that maintains the sequence via an ICD
--
-- PARAMETERS
--  All SEQ$ columns, old and new values.
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE sequpd(obj#_N         IN NUMBER DEFAULT NULL,
                obj#_I          IN NUMBER DEFAULT 0,
                obj#_O          IN NUMBER DEFAULT NULL,  
                obj#_OI         IN NUMBER DEFAULT 0,
                increment$_N    IN NUMBER DEFAULT NULL,
                increment$_I    IN NUMBER DEFAULT 0,
                increment$_O    IN NUMBER DEFAULT NULL, 
                increment$_OI   IN NUMBER DEFAULT 0,
                minvalue_N      IN NUMBER DEFAULT NULL,
                minvalue_I      IN NUMBER DEFAULT 0,
                minvalue_O      IN NUMBER DEFAULT NULL, 
                minvalue_OI     IN NUMBER DEFAULT 0,
                maxvalue_N      IN NUMBER DEFAULT NULL,
                maxvalue_I      IN NUMBER DEFAULT 0,
                maxvalue_O      IN NUMBER DEFAULT NULL, 
                maxvalue_OI     IN NUMBER DEFAULT 0,
                cycle#_N        IN NUMBER DEFAULT NULL,
                cycle#_I        IN NUMBER DEFAULT 0,
                cycle#_O        IN NUMBER DEFAULT NULL, 
                cycle#_OI       IN NUMBER DEFAULT 0,
                order$_N        IN NUMBER DEFAULT NULL,
                order$_I        IN NUMBER DEFAULT 0,
                order$_O        IN NUMBER DEFAULT NULL, 
                order$_OI       IN NUMBER DEFAULT 0,
                cache_N         IN NUMBER DEFAULT NULL,
                cache_I         IN NUMBER DEFAULT 0,
                cache_O         IN NUMBER DEFAULT NULL, 
                cache_OI        IN NUMBER DEFAULT 0,
                highwater_N     IN NUMBER DEFAULT NULL,
                highwater_I     IN NUMBER DEFAULT 0,
                highwater_O     IN NUMBER DEFAULT NULL, 
                highwater_OI    IN NUMBER DEFAULT 0,
                audit$_N        IN VARCHAR2 DEFAULT NULL,
                audit$_I        IN NUMBER DEFAULT 0,
                audit$_O        IN VARCHAR2 DEFAULT NULL,
                audit$_OI       IN NUMBER DEFAULT 0,
                flags_N         IN NUMBER DEFAULT NULL,
                flags_I         IN NUMBER DEFAULT 0,
                flags_O         IN NUMBER DEFAULT NULL,
                flags_OI        IN NUMBER DEFAULT 0);

--
-- NAME: parins -- Procedure that inserts records into the Logical Standby Parameters
--                 table.
--
-- DESCRIPTION:
--   This procedure is called on a logical standby system prior to applying an insert
--   into the system.logstdby$parameters table.  Inserts are permitted into this table
--   with the exception of END_PRIMARY (indicated in the NAME column) record.  This 
--   type of record is an indication that the primary system has declared itself a 
--   logical standby.  As a result, logical standby systems configured with the 
--   former primary are to stop applying logs.
--
-- PARAMETERS
--   All columns in system.logstdby$parameters.
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE parins(name_N     IN VARCHAR2,
                 value_N    IN VARCHAR2   DEFAULT NULL,
                 type_N     IN NUMBER     DEFAULT NULL,
                 scn_N      IN NUMBER     DEFAULT NULL,
                 spare1_N   IN NUMBER     DEFAULT NULL,
                 spare2_N   IN NUMBER     DEFAULT NULL,
                 spare3_N   IN VARCHAR2   DEFAULT NULL);

--
-- NAME: parupd -- Procedure that updates records in the Logical Standby Parameters
--                 Table.
--
-- DESCRIPTION:
--   This procedure is called on a logical standby system prior to applying an update
--   into the system.logstdby$parameters table.  Unlike the parins procedure, all
--   updates are permitted to this table.
--
-- PARAMETERS
--   All columns in system.logstdby$parameters.
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE parupd(name_N     IN VARCHAR2   DEFAULT NULL,
                 name_I     IN NUMBER DEFAULT 0,
                 name_O     IN VARCHAR2,
                 name_OI    IN NUMBER DEFAULT 0,
                 value_N    IN VARCHAR2   DEFAULT NULL,
                 value_I    IN NUMBER DEFAULT 0,
                 value_O    IN VARCHAR2   DEFAULT NULL,
                 value_OI   IN NUMBER DEFAULT 0,
                 type_N     IN NUMBER     DEFAULT NULL,
                 type_I     IN NUMBER DEFAULT 0,
                 type_O     IN NUMBER     DEFAULT NULL,
                 type_OI    IN NUMBER DEFAULT 0,
                 scn_N      IN NUMBER     DEFAULT NULL,
                 scn_I      IN NUMBER DEFAULT 0,
                 scn_O      IN NUMBER     DEFAULT NULL,
                 scn_OI     IN NUMBER DEFAULT 0,
                 spare1_N   IN NUMBER     DEFAULT NULL,
                 spare1_I   IN NUMBER DEFAULT 0,
                 spare1_O   IN NUMBER     DEFAULT NULL,
                 spare1_OI  IN NUMBER DEFAULT 0,
                 spare2_N   IN NUMBER     DEFAULT NULL,
                 spare2_I   IN NUMBER DEFAULT 0,
                 spare2_O   IN NUMBER     DEFAULT NULL,
                 spare2_OI  IN NUMBER DEFAULT 0,
                 spare3_N   IN VARCHAR2   DEFAULT NULL,
                 spare3_I   IN NUMBER DEFAULT 0,
                 spare3_O   IN VARCHAR2   DEFAULT NULL,
                 spare3_OI  IN NUMBER DEFAULT 0);


--
-- NAME: pardel -- Procedure that deletes records from the Logical Standby Parameters
--                 Table.  
--
-- DESCRIPTION:
--   This procedure is called on a logical standby system prior to applying a delete
--   from the system.logstdby$parameters table.  Unlike the parins procedure, all
--   deletes are permitted from this table.
--
-- PARAMETERS
--   All columns in system.logstdby$parameters.
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE pardel(name_O     IN VARCHAR2,
                 value_O    IN VARCHAR2   DEFAULT NULL,
                 type_O     IN NUMBER     DEFAULT NULL,
                 scn_O      IN NUMBER     DEFAULT NULL,
                 spare1_O   IN NUMBER     DEFAULT NULL,
                 spare2_O   IN NUMBER     DEFAULT NULL,
                 spare3_O   IN VARCHAR2   DEFAULT NULL);


PROCEDURE unsupported_dml(schema_name IN VARCHAR2,
                          object_name IN VARCHAR2);

PROCEDURE skip_support(drop_skip IN BOOLEAN,
                       errors IN NUMBER,
                       stmt IN VARCHAR2,
                       schema_name IN VARCHAR2,
                       object_name IN VARCHAR2,
                       proc_name IN VARCHAR2,
                       lsby_admin IN BOOLEAN);

--
-- NAME: skip
--
-- DESCRIPTION:
--  This is a stored procedure that inserts a row in the skip table
--  according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE skip(stmt IN VARCHAR2,
               schema_name IN VARCHAR2,
               object_name IN VARCHAR2,
               proc_name IN VARCHAR2,
               lsby_admin IN BOOLEAN);

--
-- NAME: skip_error
--
-- DESCRIPTION:
--  This is a stored procedure that inserts a row into the
--  skip table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE skip_error(stmt IN VARCHAR2,
                     schema_name IN VARCHAR2,
                     object_name IN VARCHAR2,
                     proc_name IN VARCHAR2,
                     lsby_admin IN BOOLEAN);


--
-- NAME: skip_transaction
--
-- DESCRIPTION:
--  This is a stored procedure that inserts a row into the
--  skip transaction table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE skip_transaction(xidusn_p IN NUMBER,
                           xidslt_p IN NUMBER,
                           xidsqn_p IN NUMBER,
                           lsby_admin IN BOOLEAN);

--
-- NAME: unskip
--
-- DESCRIPTION:
--  This is a stored procedure that deletes a row from the
--  skip table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE unskip(stmt IN VARCHAR2,
                 schema_name IN VARCHAR2,
                 object_name IN VARCHAR2,
                 lsby_admin IN BOOLEAN);

--
-- NAME: unskip_error
--
-- DESCRIPTION:
--  This is a stored procedure that deletes a row from the
--  skip table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
-- PROCEDURE BODY:
--
PROCEDURE unskip_error(stmt IN VARCHAR2,
                       schema_name IN VARCHAR2,
                       object_name IN VARCHAR2,
                       lsby_admin IN BOOLEAN);

--
-- NAME: unskip_transaction
--
-- DESCRIPTION:
--  This is a stored procedure that deletes a row from the
--  skip transaction table according to the data passed in.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
PROCEDURE unskip_transaction(xidusn_p IN NUMBER,
                             xidslt_p IN NUMBER,
                             xidsqn_p IN NUMBER,
                             lsby_admin IN BOOLEAN);

--
-- NAME: get_mtime
--
-- DESCRIPTION:
--  Get the mtime of the table identified by the parameters.
--
-- PARAMETERS
--
-- USAGE NOTES:
--
PROCEDURE get_mtime(table_name IN VARCHAR2,
		    schema_name IN VARCHAR2,
		    mtime OUT DATE);

--
-- NAME: instantiate_table
--
-- DESCRIPTION:
--	This procedure creates and populates a table and its
--	children from a table existing on a source database as
--	accessed via the dblink parameter.
--
--	If the table currently exists in the target database,
--	it will be dropped. Any constraint or index that exists
--	on the source table will also be created but physical 
--	storage characteristics will be omitted.
--
-- PARAMETERS
--
-- 	schema_name 	Schema name in which the table resides
--	table_name 	Name of table to be instantiated
--	dblink 		link to database in which the table resides
--
-- USAGE NOTES:
--	This procedure should be called on a logical standby database
--	whenever a table needs to be re-instantiated. If the apply
--	engine is currently running, and exception will be raised.
--	The target table will be dropped first if it currently exists.
--
PROCEDURE instantiate_table(schema_name IN VARCHAR2,
			    table_name IN VARCHAR2,
			    dblink IN VARCHAR2);


PROCEDURE prepare_instantiation(dblink IN VARCHAR2);
PROCEDURE end_instantiation(dblink IN VARCHAR2);
PROCEDURE report_error(exception_id   IN NUMBER);
PROCEDURE retrieve_statement(xidusn_in        IN     NUMBER,
			     xidslt_in        IN     NUMBER,
  			     xidsqn_in        IN     NUMBER,
			     errval_in        IN     NUMBER,
			     newstmt_out      OUT    VARCHAR2);

PROCEDURE validate_skip_authid(pname          IN     VARCHAR2,
                               schemaid       OUT    NUMBER);

PROCEDURE validate_skip_action(xidusn_in        IN     NUMBER,
			       xidslt_in        IN     NUMBER,
  			       xidsqn_in        IN     NUMBER,
			       newstmt_io       IN OUT VARCHAR2,
			       action_io        IN OUT NUMBER);
PROCEDURE replace_dictionary;

END DBMS_INTERNAL_LOGSTDBY;
/
show errors
  
GRANT EXECUTE ON dbms_internal_logstdby TO dba;


