rem
rem $Header: dbmsmeta.sql 03-jan-2005.10:24:36 lbarton Exp $ 
rem 
Rem    NAME
Rem     dbmsmeta.sql - Package header for DBMS_METADATA.
Rem	NOTE - Package body is in:
Rem	       /vobs/rdbms/src/server/datapump/ddl/prvtmeta.sql
Rem    DESCRIPTION
Rem     This file contains the public interface for the Metadata API.
Rem     The package body is to be released only in PL/SQL binary form.
Rem
Rem    PUBLIC FUNCTIONS / PROCEDURES
Rem	OPEN		- Establish object parameters 
Rem	SET_FILTER	- Specify filters.
Rem	SET_COUNT	- Specify object count.
Rem	GET_QUERY	- Get text of query (for debugging).
Rem	SET_PARSE_ITEM	- Enable output parsing 
Rem			  and specify an attribute to be parsed
Rem	ADD_TRANSFORM	- Specify transform.
Rem	SET_TRANSFORM_PARAM - Specify parameter to XSL stylesheet.
Rem	FETCH_XML	- Fetch selected DB objects as XML docs.
Rem	FETCH_DDL	- Fetch selected DB objects as DDL.
Rem			***** TEMPORARY API FOR LOGICAL STANDBY *****
Rem	FETCH_DDL_TEXT	- Fetch selected DB objects as DDL in a VARCHAR2
Rem			***** TEMPORARY API FOR LOGICAL STANDBY *****
Rem	FETCH_CLOB	- Fetch selected DB objects as CLOBs.
Rem	CLOSE		- Cleanup fetch context established by OPEN.
Rem	GET_XML		- Simple 1-step method for retrieving a single
Rem			  named object as an XML doc.
Rem	GET_DDL		- Simple 1-step method for retrieving DDL for a single
Rem			  named object.
Rem	GET_DEPENDENT_XML- Simple 1-step method for retrieving objects
Rem			  dependent on a base object as an XML doc.
Rem	GET_DEPENDENT_DDL- Simple 1-step method for retrieving DDL for
Rem			  objects dependent on a base object.
Rem	GET_GRANTED_XML	- Simple 1-step method for retrieving objects
Rem			  granted to a grantee.
Rem	GET_GRANTED_DDL	- Simple 1-step method for retrieving DDL for
Rem			  objects granted to a grantee.
Rem	PROCEDURE FETCH_CLOB - Same as above, but with IN/OUT NOCOPY for perf.
Rem	SET_DEBUG	- Set the internal debug switch.
Rem	FREE_CONTEXT_ENTRY - To be called *ONLY* by the definer's rights
Rem			  pkg. (dbms_metadata_int) error handling.
Rem	GET_DOMIDX_METADATA - Get PLSQL code from the ODCIIndexGetMetadata
Rem			  method of a domain index's implementation type.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     lbarton    01/03/05  - backport 3225530: move get_domidx_metadata to 
Rem                            dbms_metadata 
Rem     lbarton    11/27/01  - better error messages
Rem     lbarton    10/29/01  - rename ku$_parsed_item.'parent' to 'object_row'
Rem     lbarton    09/05/01  - split pkgs into separate files
Rem     gclaborn   12/20/00  - Add encoding param to ADD_TRANSFORM
Rem     lbarton    11/10/00  - add long2vcnt
Rem     lbarton    09/13/00 -  new exception; disable FETCH_XML variant
Rem     lbarton    08/16/00 -  make dbms_metadata invokers rights
Rem     jdavison   07/25/00 -  Uncomment use of XMLType.
Rem     lbarton    06/12/00 -  facility name change
Rem     lbarton    06/01/00 -  more api changes
Rem     gclaborn   05/23/00 -  Comment out ref. to XMLType until compatible
Rem			       issues fixed.
Rem     gclaborn   05/12/00 -  Reinstate functions returning XMLType since the
Rem			       real one is now checked in.
Rem     lbarton    04/28/00 -  new api
Rem     gclaborn   04/24/00 -  Remove global XMLType definition
Rem     lbarton    03/31/00 -  Add SET_XSL_BASE_DIR
Rem     gclaborn   03/22/00 -  Add procedure interfaces for fetch_xxx
Rem     lbarton    03/09/00 -  Error handling
Rem     lbarton    03/01/00 -  new functions, API changes
Rem     lbarton    12/03/99 -  combine into one package
Rem     gclaborn / lbarton  11/18/99 -  Creation
Rem

-- Types used by the mdAPI interface:
-------------------------------------
-- SET_PARSE_ITEM specifies that an attribute of an object be parsed from
-- the output and returned separately by FETCH_XML or FETCH_DDL.  Since
-- multiple items can be parsed, they are returned in a nested table,
-- ku$_parsed_items.

CREATE TYPE sys.ku$_parsed_item AS OBJECT
	(	item		VARCHAR2(30),	-- item to be parsed
		value		VARCHAR2(4000),	-- item's value
		object_row	NUMBER		-- object row of item
	)
/
GRANT EXECUTE ON sys.ku$_parsed_item TO PUBLIC;
CREATE PUBLIC SYNONYM ku$_parsed_item FOR sys.ku$_parsed_item;

CREATE TYPE sys.ku$_parsed_items IS TABLE OF sys.ku$_parsed_item;
/
GRANT EXECUTE ON sys.ku$_parsed_items TO PUBLIC;
CREATE PUBLIC SYNONYM ku$_parsed_items FOR sys.ku$_parsed_items;

-- The FETCH_DDL function returns creation DDL for an object.
-- Some database objects require multiple creation DDL statements, e.g.,
-- full types and packages (a header and a body) and tables (create plus alters
-- for constraints). ku$_ddl contains a single DDL statement.
-- ku$_ddls contains all the DDL statements returned by a call to FETCH_DDL.
-- Most object types will have only one row.
-- Each row of ku$_ddls itself contains a ku$_parsed_items nested table
-- for parsed items for that DDL statement.

CREATE TYPE sys.ku$_ddl AS OBJECT
	(	ddltext		CLOB,			-- The DDL text
		parsedItems	sys.ku$_parsed_items 	-- the parsed items
	)
/
GRANT EXECUTE ON sys.ku$_ddl TO PUBLIC;
CREATE PUBLIC SYNONYM ku$_ddl FOR sys.ku$_ddl;

CREATE TYPE sys.ku$_ddls IS TABLE OF sys.ku$_ddl;
/
GRANT EXECUTE ON sys.ku$_ddls TO PUBLIC;
CREATE PUBLIC SYNONYM ku$_ddls FOR sys.ku$_ddls;

-- ku$_vcnt (vcnt = VarChar2 Nested Table) is used to hold
--  large amounts of text data.
-- It is used for the PLSQL code returned by GET_DOMIDX_METADATA
-- and for LONG values whose length > 4000

CREATE TYPE sys.ku$_vcnt AS TABLE OF VARCHAR2(4000)
/
GRANT EXECUTE ON sys.ku$_vcnt TO PUBLIC;
CREATE PUBLIC SYNONYM ku$_vcnt FOR sys.ku$_vcnt;

CREATE OR REPLACE PACKAGE dbms_metadata AUTHID CURRENT_USER AS 
---------------------------------------------------------------------
-- Overview
-- This pkg implements the mdAPI, a means to retrieve the aggregated
-- definitions of database objects as either XML docs. or their creation DDL.
---------------------------------------------------------------------
-- SECURITY
-- This package is owned by SYS with execute access granted to PUBLIC.
-- It runs with invokers rights, i.e., with the security profile of
-- the caller.  It calls DBMS_METADATA_INT to perform privileged
-- functions.
-- The object views defined in catmeta.sql implement the package's security
-- policy via the WHERE clause on the public views which include syntax to
-- control user access to metadata: if the current user is SYS or has
-- SELECT_CATALOG_ROLE, then all objects are visible; otherwise, only
-- objects in the schema of the current user are visible.

--------------------
--  PUBLIC CONSTANT
--
  SESSION_TRANSFORM	CONSTANT BINARY_INTEGER := -1;

-------------
-- EXCEPTIONS
--
  invalid_argval EXCEPTION;
    PRAGMA EXCEPTION_INIT(invalid_argval, -31600);
    invalid_argval_num NUMBER := -31600;
-- "Invalid input value %s for parameter %s in function %s"
-- *Cause:  A NULL or invalid value was supplied for the parameter.
-- *Action: Correct the input value and try the call again.

  invalid_operation EXCEPTION;
    PRAGMA EXCEPTION_INIT(invalid_operation, -31601);
    invalid_operation_num NUMBER := -31601;
-- "Function %s cannot be called now that fetch has begun"
-- *Cause:  The function was called after the first call to FETCH_xxx.
-- *Action: Correct the program.

  inconsistent_args EXCEPTION;
    PRAGMA EXCEPTION_INIT(inconsistent_args, -31602);
    inconsistent_args_num NUMBER := -31602;
-- "parameter %s value \"%s\" in function %s inconsistent with %s"
-- "Value \"%s\" for parameter %s in function %s is inconsistent with %s"
-- *Cause:  The parameter value is inconsistent with another value specified
--          by the program.  It may be not valid for the the object type
--          associated with the OPEN context, or it may be of the wrong
--          datatype: a boolean rather than a text string or vice versa.
-- *Action: Correct the program.

  object_not_found EXCEPTION;
    PRAGMA EXCEPTION_INIT(object_not_found, -31603);
    object_not_found_num NUMBER := -31603;
-- "object \"%s\" of type %s not found in schema \"%s\""
-- *Cause:  The specified object was not found in the database.
-- *Action: Correct the object specification and try the call again.

  invalid_object_param EXCEPTION;
    PRAGMA EXCEPTION_INIT(invalid_object_param, -31604);
    invalid_object_param_num NUMBER := -31604;
-- "invalid %s parameter \"%s\" for object type %s in function %s"
-- *Cause:  The specified parameter value is not valid for this object type.
-- *Action: Correct the parameter and try the call again.

  inconsistent_operation EXCEPTION;
    PRAGMA EXCEPTION_INIT(inconsistent_operation, -31607);
    inconsistent_operation_num NUMBER := -31607;
-- "Function %s is inconsistent with transform."
-- *Cause:  Either (1) FETCH_XML was called when the "DDL" transform
--          was specified, or (2) FETCH_DDL was called when the
--          "DDL" transform was omitted.
-- *Action: Correct the program.

  object_not_found2 EXCEPTION;
    PRAGMA EXCEPTION_INIT(object_not_found2, -31608);
    object_not_found2_num NUMBER := -31608;
-- "specified object of type %s not found"
-- (Used by GET_DEPENDENT_xxx and GET_GRANTED_xxx.)
-- *Cause:  The specified object was not found in the database.
-- *Action: Correct the object specification and try the call again.

  stylesheet_load_error EXCEPTION;
    PRAGMA EXCEPTION_INIT(stylesheet_load_error, -31609);
    stylesheet_load_error_num NUMBER := -31609;
-- "error loading file %s from file system directory \'%s\'"
-- *Cause:  The installation script initmeta.sql failed to load
--          the named file from the file system directory into the database.
-- *Action: Examine the directory and see if the file is present
--          and can be read.

---------------------------
-- PROCEDURES AND FUNCTIONS
--
-- OPEN: Specifies the type of object whose metadata is to be retrieved.
-- PARAMETERS:
--	object_type	- Identifies the type of objects to be retrieved; i.e.,
--		TABLE, INDEX, etc. This determines which view is selected.
--	version		- The version of the objects' metadata to be fetched.
--		To be used in downgrade scenarios: Objects in the DB that are
--		incompatible with an older specified version are not returned.
--		Values can be 'COMPATIBLE' (default), 'LATEST' or a specific
--		version number.
--	model		- The view of the metadata, such as Oracle proprietary,
--		ANSI99, etc.  Currently only 'ORACLE' is supported.
--
-- RETURNS:
--	A handle to be used in subsequent calls to SET_FILTER, SET_COUNT,
--	ADD_TRANSFORM, GET_QUERY, SET_PARSE_ITEM, FETCH_xxx and CLOSE.
-- EXCEPTIONS:
--	INVALID_ARGVAL	- a NULL or invalid value was supplied for an input
--		parameter.

  FUNCTION open (
		object_type	IN  VARCHAR2,
		version		IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model		IN  VARCHAR2 DEFAULT 'ORACLE')
	RETURN NUMBER;


-- SET_FILTER: Specifies restrictions on the objects whose metadata 
--	is to be retrieved.
--	This function is overloaded: the filter value can be a varchar2
--	or a boolean.
-- PARAMETERS:
-- 	handle	- Context handle from previous OPEN call.
--	name	- Name of the filter.
--	value	- Value of the filter.

  PROCEDURE set_filter (
		handle		IN  NUMBER,
		name		IN  VARCHAR2,
		value		IN  VARCHAR2);

  PROCEDURE set_filter (
		handle		IN  NUMBER,
		name		IN  VARCHAR2,
		value		IN  BOOLEAN DEFAULT TRUE);


-- SET_COUNT: Specifies the number of objects to be returned in a single
--	FETCH_xxx call.
-- PARAMETERS:
-- 	handle	- Context handle from previous OPEN call.
--	value	- Number of objects to retrieve.

  PROCEDURE set_count (
		handle		IN  NUMBER,
		value		IN  NUMBER);


-- GET_QUERY:	Return the text of the query (or queries) that will be
-- 		used by FETCH_xxx.  This function is provided to aid
-- 		in debugging.
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
-- RETURNS:	Text of the query.

  FUNCTION get_query (
		handle		IN  NUMBER)
	RETURN VARCHAR2;


-- SET_PARSE_ITEM: Enables output parsing and specifies an object attribute
--	to be parsed and returned
-- PARAMETERS:
-- 	handle	- Context handle from previous OPEN call.
--	name	- Attribute name.

  PROCEDURE set_parse_item (
		handle		IN  NUMBER,
		name		IN  VARCHAR2);


-- ADD_TRANSFORM : Specify a transform to be applied to the XML representation
-- 		of objects returned by FETCH_xxx.
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
--		name	- The name of the transform: Can be 'DDL' to generate
--                        creation DDL or a URI pointing to a stylesheet,
--                        either external or internal to the DB (the latter
--                        being an Xpath spec. starting with '/oradb').
--              encoding- If name is a URI, this specifies the encoding of the
--                        target stylesheet. If left NULL, then if uri starts
--                        with  '/oradb', then the database char. set is used;
--                        otherwise, 'UTF-8'. Use 'US-ASCII' for better perf.
--                        if you can. May be any valid NLS char. set name.
--                        Ignored if name is an internal transform name (like
--                        DDL), not a URI.
-- NOTE: If name is an intra-DB uri (ie, /oradb) that points to an NCLOB
--       column or a CLOB with an encoding different from the database charset,
--       you must explicitly specify the encoding.
-- RETURNS:	An opaque handle to the tranform to be used in subsequent
--		calls to SET_TRANSFORM_PARAM.

  FUNCTION add_transform (
		handle		IN NUMBER,
		name		IN VARCHAR2,
		encoding        IN VARCHAR2 DEFAULT NULL)
	RETURN NUMBER;


-- SET_TRANSFORM_PARAM: Specifies a value for a parameter to the XSL-T
--	stylesheet identified by handle.
--	This procedure is overloaded: the parameter value can be a varchar2
--	or a boolean.
-- PARAMETERS:
-- 	transform_handle - Handle from previous ADD_TRANSFORM call.
--	name		 - Name of the parameter.
--	value		 - Value for the parameter.

  PROCEDURE set_transform_param (
		transform_handle	IN  NUMBER,
		name			IN  VARCHAR2,
		value			IN  VARCHAR2);

  PROCEDURE set_transform_param (
		transform_handle	IN  NUMBER,
		name			IN  VARCHAR2,
		value			IN  BOOLEAN DEFAULT TRUE);


-- FETCH_XML:	Return metadata for objects as XML documents. This version
-- 		of the interface returns just the XML, no separately parsed
-- 		schema or name.  (Compare the following function.) It
--		can return multiple objects per call (when the SET_COUNT
--		'value' parameter > 1).
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
-- RETURNS:	XML metadata for the objects as an XMLType, or NULL if all
--		objects have been fetched.
-- EXCEPTIONS:	Throws an exception if DDL transform has been added

  FUNCTION fetch_xml (handle	IN NUMBER)
	RETURN sys.XMLType;



-- FETCH_XML:	Overloaded function: This version returns the XML metadata for
--		a single object, plus a nested table of parsed items.
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
--		parsed_items - Table of parsed items.
-- RETURNS:	XML metadata for the objects as an XMLType, or NULL if all
--		objects have been fetched.
-- EXCEPTIONS:	Throws an exception if SET_COUNT 'value' parameter > 1
--		or if DDL transform has been added.

-- ************** POST-8.2 ***************

--  FUNCTION fetch_xml (
--		handle		IN  NUMBER,
--		parsed_items	OUT sys.ku$_parsed_items)
--	RETURN sys.XMLType;



-- FETCH_DDL:	Return metadata for one object as DDL.
--		More than one DDL statement may be returned.
-- RETURNS:	Metadata for the object as one or more DDL statements
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
-- EXCEPTIONS:	Throws an exception if DDL transform was not added.

  FUNCTION fetch_ddl (
		handle	IN NUMBER)
	RETURN sys.ku$_ddls;

--************* TEMPORARY ************************
-- FETCH_DDL_TEXT: Return DDL metadata as VARCHAR2.
--		NOTE: This is a temporary API for logical standby.
--		It is needed because LOBs and objects cannot
--		currently (8.2) be returned over dblinks.
-- RETURNS:	Metadata for the object as one DDL statement
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
--		partial - set to 1 if the statement was too long
--			to fit in the VARCHAR2; the next call will
--			return the next piece of the metadata.
-- EXCEPTIONS:	Throws an exception if DDL transform was not added.

  FUNCTION fetch_ddl_text (
		handle	IN  NUMBER,
		partial	OUT NUMBER)
	RETURN VARCHAR2;
--************* TEMPORARY ************************

-- FETCH_CLOB:	Return metadata for object (transformed or not) as a CLOB.
-- PARAMETERS:	handle	- Context handle from previous OPEN call.
-- RETURNS:	XML metadata for the objects as a CLOB, or NULL if all
--		objects have been fetched.

  FUNCTION fetch_clob (handle	IN NUMBER)
	RETURN CLOB;


-- PROCEDURE FETCH_CLOB: Same as above but with IN/OUT NOCOPY CLOB. CLOB
--		must be pre-created prior to call.

  PROCEDURE fetch_clob (
		handle	IN NUMBER,
		xmldoc	IN OUT NOCOPY CLOB);



-- CLOSE:	Cleanup all context associated with handle.
-- PARAMETERS:	handle	- Context handle from previous OPEN call.

  PROCEDURE CLOSE (handle IN NUMBER);


-- GET_XML:	Return the metadata for a single object as XML.
--	This interface is meant for casual browsing (e.g., from SQLPlus)
--	vs. the programmatic OPEN / FETCH / CLOSE interfaces above.
-- PARAMETERS:
--	object_type	- The type of object to be retrieved.
--	name		- Name of the object.
--	schema		- Schema containing the object.  Defaults to
--			  the caller's schema.
--	version		- The version of the objects' metadata.
--	model		- The object model for the metadata.
--	transform	- XSL-T transform to be applied.
-- RETURNS:	Metadata for the object as a CLOB.

  FUNCTION get_xml (
		object_type	IN  VARCHAR2,
		name		IN  VARCHAR2,
		schema		IN  VARCHAR2 DEFAULT NULL,
		version		IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model		IN  VARCHAR2 DEFAULT 'ORACLE',
		transform	IN  VARCHAR2 DEFAULT NULL)
	RETURN CLOB;


-- GET_DDL:	Return the metadata for a single object as DDL.
--	This interface is meant for casual browsing (e.g., from SQLPlus)
--	vs. the programmatic OPEN / FETCH / CLOSE interfaces above.
-- PARAMETERS:
--	object_type	- The type of object to be retrieved.
--	name		- Name of the object.
--	schema		- Schema containing the object.  Defaults to
--			  the caller's schema.
--	version		- The version of the objects' metadata.
--	model		- The object model for the metadata.
--	transform	- XSL-T transform to be applied.
-- RETURNS:	Metadata for the object transformed to DDL as a CLOB.

  FUNCTION get_ddl (
		object_type	IN  VARCHAR2,
		name		IN  VARCHAR2,
		schema		IN  VARCHAR2 DEFAULT NULL,
		version		IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model		IN  VARCHAR2 DEFAULT 'ORACLE',
		transform	IN  VARCHAR2 DEFAULT 'DDL')
	RETURN CLOB;

-- GET_DEPENDENT_XML:	Return the metadata for objects dependent on a
--	base object as XML.
--	This interface is meant for casual browsing (e.g., from SQLPlus)
--	vs. the programmatic OPEN / FETCH / CLOSE interfaces above.
-- PARAMETERS:
--	object_type	- The type of object to be retrieved.
--	base_object_name- Name of the base object.
--	base_object_schema- Schema containing the base object.  Defaults to
--			  the caller's schema.
--	version		- The version of the objects' metadata.
--	model		- The object model for the metadata.
--	transform	- XSL-T transform to be applied.
--	object_count	- maximum number of objects to return
-- RETURNS:	Metadata for the object as a CLOB.

  FUNCTION get_dependent_xml (
		object_type		IN  VARCHAR2,
		base_object_name	IN  VARCHAR2,
		base_object_schema	IN  VARCHAR2 DEFAULT NULL,
		version			IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model			IN  VARCHAR2 DEFAULT 'ORACLE',
		transform		IN  VARCHAR2 DEFAULT NULL,
		object_count		IN  NUMBER   DEFAULT 10000)
	RETURN CLOB;

-- GET_DEPENDENT_DDL:	Return the metadata for objects dependent on a
--	base object as DDL.
--	This interface is meant for casual browsing (e.g., from SQLPlus)
--	vs. the programmatic OPEN / FETCH / CLOSE interfaces above.
-- PARAMETERS:
--	object_type	- The type of object to be retrieved.
--	base_object_name- Name of the base object.
--	base_object_schema- Schema containing the base object.  Defaults to
--			  the caller's schema.
--	version		- The version of the objects' metadata.
--	model		- The object model for the metadata.
--	transform	- XSL-T transform to be applied.
--	object_count	- maximum number of objects to return
-- RETURNS:	Metadata for the object as a CLOB.

  FUNCTION get_dependent_ddl (
		object_type		IN  VARCHAR2,
		base_object_name	IN  VARCHAR2,
		base_object_schema	IN  VARCHAR2 DEFAULT NULL,
		version			IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model			IN  VARCHAR2 DEFAULT 'ORACLE',
		transform		IN  VARCHAR2 DEFAULT 'DDL',
		object_count		IN  NUMBER   DEFAULT 10000)
	RETURN CLOB;

-- GET_GRANTED_XML:	Return the metadata for objects granted to a
--	grantee as XML.
--	This interface is meant for casual browsing (e.g., from SQLPlus)
--	vs. the programmatic OPEN / FETCH / CLOSE interfaces above.
-- PARAMETERS:
--	object_type	- The type of object to be retrieved.
--	grantee		- Name of the grantee.
--	version		- The version of the objects' metadata.
--	model		- The object model for the metadata.
--	transform	- XSL-T transform to be applied.
--	object_count	- maximum number of objects to return
-- RETURNS:	Metadata for the object as a CLOB.

  FUNCTION get_granted_xml (
		object_type	IN  VARCHAR2,
		grantee		IN  VARCHAR2 DEFAULT NULL,
		version		IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model		IN  VARCHAR2 DEFAULT 'ORACLE',
		transform	IN  VARCHAR2 DEFAULT NULL,
		object_count	IN  NUMBER   DEFAULT 10000)
	RETURN CLOB;

-- GET_GRANTED_DDL:	Return the metadata for objects granted to a
--	grantee as DDL.
--	This interface is meant for casual browsing (e.g., from SQLPlus)
--	vs. the programmatic OPEN / FETCH / CLOSE interfaces above.
-- PARAMETERS:
--	object_type	- The type of object to be retrieved.
--	grantee		- Name of the grantee.
--	version		- The version of the objects' metadata.
--	model		- The object model for the metadata.
--	transform	- XSL-T transform to be applied.
--	object_count	- maximum number of objects to return
-- RETURNS:	Metadata for the object as a CLOB.

  FUNCTION get_granted_ddl (
		object_type	IN  VARCHAR2,
		grantee		IN  VARCHAR2 DEFAULT NULL,
		version		IN  VARCHAR2 DEFAULT 'COMPATIBLE',
		model		IN  VARCHAR2 DEFAULT 'ORACLE',
		transform	IN  VARCHAR2 DEFAULT 'DDL',
		object_count	IN  NUMBER   DEFAULT 10000)
	RETURN CLOB;

-- SET_DEBUG: Set the internal debug switch.
-- PARAMETERS:
--	on_off		- new switch state.

  PROCEDURE set_debug(
		on_off		IN BOOLEAN);

-- FREE_CONTEXT_ENTRY: free the entry in context_list corresponding to 'ind'
--		Should only be called by pkg. dbms_metadata_int.
-- PARAMETERS:
--      ind		- index of entry to free

  PROCEDURE free_context_entry (
		ind		IN  NUMBER );


-- GET_DOMIDX_METADATA: Get PLSQL code from the ODCIIndexGetMetadata
-- method of a domain index's implementation type.
-- PARAMETERS:
--	index_name	- name of the domain index
--	index_schema	- schema of the domain index
--	type_name	- name of the index's implementation type
--	type_schema	- schema of the index's implementation type
--      flags           - flags
-- RETURNS:	Collection of VARCHAR2 containing a PL/SQL block
--	that creates the index metadata.

  FUNCTION get_domidx_metadata(
		index_name	IN  VARCHAR2,
		index_schema	IN  VARCHAR2,
		type_name	IN  VARCHAR2,
                type_schema     IN  VARCHAR2,
                flags           IN  NUMBER)
	RETURN sys.ku$_vcnt;


END DBMS_METADATA;
/
GRANT EXECUTE ON sys.dbms_metadata TO PUBLIC; 
CREATE PUBLIC SYNONYM dbms_metadata FOR sys.dbms_metadata;

