Rem
Rem $Header: dbmsmetu.sql 30-mar-2005.10:02:25 lbarton Exp $
Rem
Rem dbmsmetu.sql
Rem
Rem Copyright (c) 2001, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem     dbmsmetu.sql - Package header for DBMS_METADATA_UTIL.
Rem	NOTE - Package body is in:
Rem	       /vobs/rdbms/src/server/datapump/ddl/prvtmetu.sql
Rem    DESCRIPTION
Rem	This file contains the package header for DBMS_METADATA_UTIL,
Rem	a definer's rights package that implements functions used by
Rem	both DBMS_METADATA and DBMS_METADATA_INT
Rem
Rem    FUNCTIONS / PROCEDURES
Rem	PUT_LINE	- Write debugging output.
Rem	PUT_BOOL	- Write debugging output.
Rem	VSN2NUM		- Convert version string to number.
Rem	GET_COMPAT_VSN	- Return the compatibility version number as a number.
Rem	GET_DB_VSN	- Return the database version number as a string
Rem     GET_CANONICAL_VSN - Convert user's VERSION param to canonical form.
Rem	GET_LATEST_VSN  - Return a number for the latest version number.
Rem	LONG2VARCHAR	- Convert a table LONG value to a VARCHAR2.
Rem     LONG2VCMAX      - Convert a table LONG value to a VARCHAR2 and each
Rem                       line max length is 2000.
Rem	LONG2VCNT	- Convert a table LONG value to a nested table of
Rem			   VARCHAR2.
Rem	LONG2CLOB	- Convert a table LONG value to a CLOB.
Rem     GET_SOURCE_LINES- Fetch/annotate lines from source$.
Rem	GET_DOMIDX_METADATA - Get PLSQL code from the ODCIIndexGetMetadata
Rem			  method of a domain index's implementation type.
Rem	GET_AUDIT	- Return audit information for a schema object.
Rem	LOAD_STYLESHEETS- Load the XSL stylesheets into the database
Rem	SET_DEBUG	- Set the internal debug switch.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lbarton     03/30/05 - backport bug 2844111: get_source_lines 
Rem    lbarton     01/03/05 - backport 3225530: move get_domidx_metadata to 
Rem                           dbms_metadata; add get_canonical_vsn
Rem    htseng      10/01/03 - backport 3116063,3056720 
Rem			      change long2clob interface 
Rem    lbarton     05/14/03 - Domain index support
Rem    htseng      06/30/03 - backport(3021336) when trigger body> 4000
Rem			      add function LONG2VCMAX 
Rem    lbarton     11/27/01 - better error messages
Rem    lbarton     09/10/01 - Merged lbarton_mdapi_reorg
Rem    lbarton     09/05/01 - Split off from dbmsmeta.sql
Rem

-- Types used internally by mdAPI
---------------------------------
-- Schema object audit settings are stored in tab$, etc. as a 38-byte
-- field named audit$ where each byte corresponds to a different access
-- type. This encoding is difficult for xsl to decode and process, 
-- so the function GET_AUDIT in this package unpacks the field into
-- a nested table of ku$_audobj_t objects, each of which has the setting
-- for one access type.

CREATE TYPE sys.ku$_audobj_t AS OBJECT
(
  name		VARCHAR2(31),	-- operation to be audited, e.g., ALTER
  value		CHAR(1),	-- 'S' = by session
				-- 'A' = by access
				-- '-' = no auditing
  type		CHAR(1)		-- 'S' = when successful
				-- 'F' = when not successful
)
/
GRANT EXECUTE ON sys.ku$_audobj_t TO PUBLIC;
CREATE PUBLIC SYNONYM ku$_audobj_t FOR sys.ku$_audobj_t;

CREATE TYPE sys.ku$_audit_list_t IS TABLE OF sys.ku$_audobj_t
/
GRANT EXECUTE ON sys.ku$_audit_list_t TO public;
CREATE PUBLIC SYNONYM ku$_audit_list_t FOR sys.ku$_audit_list_t;

-- UDTs for lines of source
CREATE TYPE sys.ku$_source_t AS OBJECT
(
  obj_num       number,                                     /* object number */
  line          number,                                       /* line number */
  -- The next 2 attributes are used by XSL scripts to edit the source line.
  -- E.g., in a type definition, the line might be 'type foobar as object' --
  -- 'foobar' is the object name.  Since the xsl script has already
  -- generated CREATE OR REPLACE TYPE FOOBAR, it uses 'post_name_off'
  -- to extract the useful part of the line.  If the source were
  -- create type /* this is a comment
  --  that continues on the next line */
  --  foobar
  -- which is rare but legal, the xsl script knows from 'pre_name' which
  -- lines are prior to the name and can safely be discarded.
  -- See bug 2844111 and rdbms/xml/xsl/kusource.xsl.
  pre_name      number,    /* 1 = this line is prior to line containing name */
  post_name_off number,   /* 1-based offset of 1st non-space char after name */
  source        varchar2(4000)                                /* source line */
)
/
GRANT EXECUTE ON sys.ku$_source_t TO PUBLIC
/
CREATE OR REPLACE PUBLIC SYNONYM ku$_source_t FOR sys.ku$_source_t;
CREATE TYPE ku$_source_list_t AS TABLE OF sys.ku$_source_t;
/
GRANT EXECUTE ON ku$_source_list_t TO PUBLIC
/
CREATE OR REPLACE PUBLIC SYNONYM ku$_source_list_t FOR sys.ku$_source_list_t;


CREATE OR REPLACE PACKAGE dbms_metadata_util AUTHID DEFINER AS 
------------------------------------------------------------
-- Overview
-- This pkg implements utility functions of the mdAPI.
---------------------------------------------------------------------
-- SECURITY
-- This package is owned by SYS. It runs with definers, not invokers rights
-- because it needs to access dictionary tables.

-------------
-- EXCEPTIONS
--
  invalid_argval EXCEPTION;
    PRAGMA EXCEPTION_INIT(invalid_argval, -31600);
    invalid_argval_num NUMBER := -31600;
-- "Invalid input value %s for parameter %s in function %s"
-- *Cause:  A NULL or invalid value was supplied for the parameter.
-- *Action: Correct the input value and try the call again.

  invalid_operation EXCEPTION;
    PRAGMA EXCEPTION_INIT(invalid_operation, -31601);
    invalid_operation_num NUMBER := -31601;
-- "Function %s cannot be called now that fetch has begun"
-- *Cause:  The function was called after the first call to FETCH_xxx.
-- *Action: Correct the program.

  inconsistent_args EXCEPTION;
    PRAGMA EXCEPTION_INIT(inconsistent_args, -31602);
    inconsistent_args_num NUMBER := -31602;
-- "parameter %s value \"%s\" in function %s inconsistent with %s"
-- "Value \"%s\" for parameter %s in function %s is inconsistent with %s"
-- *Cause:  The parameter value is inconsistent with another value specified
--          by the program.  It may be not valid for the the object type
--          associated with the OPEN context, or it may be of the wrong
--          datatype: a boolean rather than a text string or vice versa.
-- *Action: Correct the program.

  object_not_found EXCEPTION;
    PRAGMA EXCEPTION_INIT(object_not_found, -31603);
    object_not_found_num NUMBER := -31603;
-- "object \"%s\" of type %s not found in schema \"%s\""
-- *Cause:  The specified object was not found in the database.
-- *Action: Correct the object specification and try the call again.

  invalid_object_param EXCEPTION;
    PRAGMA EXCEPTION_INIT(invalid_object_param, -31604);
    invalid_object_param_num NUMBER := -31604;
-- "invalid %s parameter \"%s\" for object type %s in function %s"
-- *Cause:  The specified parameter value is not valid for this object type.
-- *Action: Correct the parameter and try the call again.

  inconsistent_operation EXCEPTION;
    PRAGMA EXCEPTION_INIT(inconsistent_operation, -31607);
    inconsistent_operation_num NUMBER := -31607;
-- "Function %s is inconsistent with transform."
-- *Cause:  Either (1) FETCH_XML was called when the "DDL" transform
--          was specified, or (2) FETCH_DDL was called when the
--          "DDL" transform was omitted.
-- *Action: Correct the program.

  object_not_found2 EXCEPTION;
    PRAGMA EXCEPTION_INIT(object_not_found2, -31608);
    object_not_found2_num NUMBER := -31608;
-- "specified object of type %s not found"
-- (Used by GET_DEPENDENT_xxx and GET_GRANTED_xxx.)
-- *Cause:  The specified object was not found in the database.
-- *Action: Correct the object specification and try the call again.

  stylesheet_load_error EXCEPTION;
    PRAGMA EXCEPTION_INIT(stylesheet_load_error, -31609);
    stylesheet_load_error_num NUMBER := -31609;
-- "error loading file %s from file system directory \'%s\'"
-- *Cause:  The installation script initmeta.sql failed to load
--          the named file from the file system directory into the database.
-- *Action: Examine the directory and see if the file is present
--          and can be read.

---------------------------
-- PROCEDURES AND FUNCTIONS
--
-- PUT_LINE: Does a DBMS_OUTPUT.PUT_LINE regardless of string length; i.e,
--		works with strings > 255.

  PROCEDURE put_line(stmt IN VARCHAR2);

-- PUT_BOOL: Convenience function.

  PROCEDURE put_bool(
	stmt 	IN VARCHAR2,
	value	IN BOOLEAN);


-- VSN2NUM: Convert a dot-separated version string (e.g., '8.1.6.0.0')
--   to a number (e.g., 8010600000).

  FUNCTION vsn2num (
		vsn		IN  VARCHAR2)
	RETURN NUMBER;

-- GET_COMPAT_VSN: return the compatibility version number as a number.
--       E.g., if compatibility='8.1.6', return 801060000.

  FUNCTION get_compat_vsn
	RETURN NUMBER;

-- GET_DB_VSN: return the database version number as a string
--       in the format vv.vv.vv.vv.vv, e.g., '08.01.03.00.00'

  FUNCTION get_db_vsn
	RETURN VARCHAR2;

-- GET_CANONICAL_VSN: convert the user's VERSION param to a string
--       in the format vv.vv.vv.vv.vv, e.g., '08.01.03.00.00'
-- PARAMETERS:
--      version         - The version from DBMS_METADATA.OPEN.
--              Values can be 'COMPATIBLE' (default), 'LATEST' or a specific
--              version number.

  FUNCTION get_canonical_vsn(version IN VARCHAR2)
        RETURN VARCHAR2;

-- GET_LATEST_VSN: return a number that will serve as the latest version number

  FUNCTION get_latest_vsn
	RETURN NUMBER;

-- LONG2VARCHAR: Convert a LONG column value to a VARCHAR2
-- PARAMETERS:
--      length		- length of the LONG
--	tab		- table name
--	col		- column name
--	row		- rowid of the row
-- RETURNS:	LONG value converted to VARCHAR2 if length <= 4000
--		otherwise NULL

  FUNCTION long2varchar(
		length  	IN  NUMBER,
		tab		IN  VARCHAR2,
                col     	IN  VARCHAR2,
		row     	IN  UROWID)
	RETURN VARCHAR2;


-- LONG2VCMAX: Convert a LONG column value to a VARCHAR2 and each line
--                  max length is 2000
-- PARAMETERS:
--      length          - length of the LONG
--      tab             - table name
--      col             - column name
--      row             - rowid of the row
-- RETURNS:     LONG value converted to VARCHAR2 
--              otherwise NULL


  FUNCTION long2vcmax(
                length          IN  NUMBER,
                tab             IN  VARCHAR2,
                col             IN  VARCHAR2,
                row             IN  UROWID)
        RETURN sys.ku$_vcnt;

-- LONG2VCNT: Convert a LONG column value to an array of VARCHAR2
-- PARAMETERS:
--      length		- length of the LONG
--	tab		- table name
--	col		- column name
--	row		- rowid of the row
-- RETURNS:	LONG value converted to array of VARCHAR2 if length > 4000
--		otherwise NULL

  FUNCTION long2vcnt(
		length  	IN  NUMBER,
		tab		IN  VARCHAR2,
                col     	IN  VARCHAR2,
		row     	IN  UROWID)
	RETURN sys.ku$_vcnt;

-- LONG2CLOB: Convert a LONG column value to a CLOB
-- PARAMETERS:
--      length		- length of the LONG
--	tab		- table name
--	col		- column name
--	row		- rowid of the row
-- RETURNS:	LONG value converted to temporary CLOB if length > 4000
--		otherwise NULL

  FUNCTION long2clob(
		length  	IN  NUMBER,
		tab		IN  VARCHAR2,
                col     	IN  VARCHAR2,
		row     	IN  ROWID)
	RETURN CLOB;

-- GET_SOURCE_LINES: Get records from source$ for the object
-- and annotate them to make xsl processing easier.
-- PARAMETERS:
--      obj_name        - name of object
--      obj_num         - obj# of object
--      type_num        - type# of object
-- RETURNS:     Nested table containing the source lines

  FUNCTION get_source_lines(
                obj_name        IN  VARCHAR2,
                obj_num         IN  NUMBER,
                type_num        IN  NUMBER)
        RETURN sys.ku$_source_list_t;

-- GET_DOMIDX_METADATA: Get PLSQL code from the ODCIIndexGetMetadata
-- method of a domain index's implementation type.
-- PARAMETERS:
--	index_name	- name of the domain index
--	index_schema	- schema of the domain index
--	type_name	- name of the index's implementation type
--	type_schema	- schema of the index's implementation type
--      flags           - flags
-- RETURNS:	Collection of VARCHAR2 containing a PL/SQL block
--	that creates the index metadata.

  FUNCTION get_domidx_metadata(
		index_name	IN  VARCHAR2,
		index_schema	IN  VARCHAR2,
		type_name	IN  VARCHAR2,
                type_schema     IN  VARCHAR2,
                flags           IN  NUMBER)
	RETURN sys.ku$_vcnt;


-- GET_AUDIT: Return audit information for a schema object.
-- PARAMETERS:
--	obj_num		- object number
--	type_num	- object type
-- RETURNS: nested table of audit settings

 FUNCTION get_audit(
		obj_num		IN  NUMBER,
		type_num	IN  NUMBER )
	RETURN sys.ku$_audit_list_t;


-- LOAD_STYLESHEETS: Load the XSL stylesheets into the database
-- PARAMETERS:
--	dir		- directory containing XSL scripts
--

  PROCEDURE load_stylesheets(
		dir		IN VARCHAR2);

-- SET_DEBUG: Set the internal debug switch.
-- PARAMETERS:
--	on_off		- new switch state.

  PROCEDURE set_debug(
		on_off		IN BOOLEAN);

END DBMS_METADATA_UTIL;
/
GRANT EXECUTE ON sys.dbms_metadata_util TO EXECUTE_CATALOG_ROLE;
