Rem
Rem $Header: dbmsobtk.sql 27-may-2002.13:19:06 nireland Exp $
Rem
Rem dbmsobtk.sql
Rem
Rem Copyright (c) 1997, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      dbmsobtk.sql - rDBMS OBfuscation ToolKit
Rem
Rem    DESCRIPTION
Rem      Contains the PL/SQL interface to the obfuscation toolkit
Rem
Rem    NOTES
Rem      None.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nireland    05/27/02 - Add IV support
Rem    gviswana    05/24/01 - CREATE OR REPLACE SYNONYM
Rem    htseng      04/12/01 - eliminate execute twice (remove ;).
Rem    rwessman    07/30/00 - Added routines to generate keys
Rem    rwessman    03/30/00 - Added Triple DES support
Rem    rwessman    01/13/00 - Changed to use a subtype for MD5 checksums to mak
Rem    rwessman    12/16/99 - Added function versions of the various routines
Rem    rwessman    12/15/99 - Added a VARCHAR2 version of the MD5 routines
Rem    rwessman    12/03/99 - Added MD5 procedure
Rem    sgkrishn    03/01/99 - added DES related routines
Rem    sgkrishn    02/25/99 - Creation
Rem
REM  ***************************************
REM  THIS PACKAGE MUST BE CREATED UNDER SYS
REM  ***************************************

-- Create the trusted PL/SQL callout library.
CREATE OR REPLACE LIBRARY DBMS_OBFUSCATION_LIB TRUSTED AS STATIC;
/

CREATE OR REPLACE PACKAGE dbms_obfuscation_toolkit AS
    ------------------------------- TYPES ------------------------------------
    -- Types used to make it easier for the user to reserve the correct
    -- amount of memory for a checksum.

    SUBTYPE varchar2_checksum IS VARCHAR2(16);
    SUBTYPE raw_checksum IS RAW(16);

    ----------------------------- CONSTANTS -----------------------------------
    -- Triple DES modes
    TwoKeyMode   INTEGER := 0;
    ThreeKeyMode INTEGER := 1;

    ----------------------------- EXCEPTIONS ----------------------------------
    -- Invalid mode specified for Triple DES.
    InvalidTripleDESMode EXCEPTION;
    PRAGMA EXCEPTION_INIT(InvalidTripleDESMode, -28236);

    ---------------------- FUNCTIONS AND PROCEDURES ---------------------------

    ---------------------------- KEY GENERATION ------------------------------
    -- The following routines generate encryption keys. Each takes a random
    -- value which it uses in the generation of the key. This value must be
    -- at least 80 characters long.
    -- There are two versions of each procedure and function: one for raw data
    -- and the other for strings.
    ---------------------------------------------------------------------------
    PROCEDURE DESGetKey(seed  IN     RAW,
                        key      OUT RAW);

    FUNCTION DESGetKey(seed IN RAW) RETURN RAW;

    PROCEDURE DESGetKey(seed_string IN     VARCHAR2,
                        key            OUT VARCHAR2);

    FUNCTION DESGetKey(seed_string IN VARCHAR2) RETURN VARCHAR2;

    -- For Triple DES, the mode is specified so that the key has the proper
    -- length is returned.
    PROCEDURE DES3GetKey(which IN     PLS_INTEGER DEFAULT TwoKeyMode,
                         seed  IN     RAW,
                         key      OUT RAW);

    FUNCTION DES3GetKey(which IN PLS_INTEGER DEFAULT TwoKeyMode,
                        seed  IN RAW)
        RETURN RAW;

    PROCEDURE DES3GetKey(which       IN     PLS_INTEGER DEFAULT TwoKeyMode,
                         seed_string IN     VARCHAR2,
                         key            OUT VARCHAR2);

    FUNCTION DES3GetKey(which        IN PLS_INTEGER DEFAULT TwoKeyMode,
                        seed_string  IN VARCHAR2)
        RETURN VARCHAR2;

    ---------------------------- DATA ENCRYPTION ------------------------------
    -- The following routines encrypt and decrypt data.
    -- There are two versions of each procedure and function: one for raw data
    -- and the other for strings.
    ---------------------------------------------------------------------------

    -- DES
    PROCEDURE DESEncrypt(input            IN     RAW,
                         key              IN     RAW,
                         encrypted_data      OUT RAW);

    FUNCTION DESEncrypt(input            IN  RAW,
                        key              IN  RAW)
        RETURN RAW;
                         
    PROCEDURE DESEncrypt(input_string    IN     VARCHAR2,
                        key_string       IN     VARCHAR2,
                        encrypted_string    OUT VARCHAR2);

    FUNCTION DESEncrypt(input_string     IN  VARCHAR2,
                        key_string       IN  VARCHAR2)
        RETURN VARCHAR2;

    PROCEDURE DESDecrypt(input            IN      RAW,
                         key              IN      RAW,
                         decrypted_data       OUT RAW);

    FUNCTION DESDecrypt(input            IN  RAW,
                        key              IN  RAW)
        RETURN RAW;

    PROCEDURE DESDecrypt(input_string     IN    VARCHAR2,
                         key_string       IN    VARCHAR2,
                         decrypted_string    OUT VARCHAR2);

    FUNCTION DESDecrypt(input_string     IN     VARCHAR2,
                        key_string       IN  VARCHAR2)
        RETURN VARCHAR2;

    -- Triple DES

    PROCEDURE DES3Encrypt(input          IN     RAW,
                          key            IN     RAW,
                          encrypted_data    OUT RAW,
                          which          IN     PLS_INTEGER
                                                  DEFAULT TwoKeyMode,
                          iv             IN     RAW DEFAULT NULL);

    FUNCTION DES3Encrypt(input IN RAW,
                         key   IN RAW,
                         which IN PLS_INTEGER DEFAULT TwoKeyMode,
                         iv    IN RAW DEFAULT NULL)
        RETURN RAW;
                         
    PROCEDURE DES3Encrypt(input_string     IN     VARCHAR2,
                          key_string       IN     VARCHAR2,
                          encrypted_string    OUT VARCHAR2,
                          which            IN     PLS_INTEGER
                                                    DEFAULT TwoKeyMode,
                          iv_string        IN     VARCHAR2 DEFAULT NULL);

    FUNCTION DES3Encrypt(input_string  IN VARCHAR2,
                         key_string    IN VARCHAR2,
                         which         IN PLS_INTEGER DEFAULT TwoKeyMode,
                         iv_string     IN VARCHAR2 DEFAULT NULL)
        RETURN VARCHAR2;

    PROCEDURE DES3Decrypt(input          IN     RAW,
                          key            IN     RAW,
                          decrypted_data    OUT RAW,
                          which          IN     PLS_INTEGER
                                                  DEFAULT TwoKeyMode,
                          iv             IN     RAW DEFAULT NULL);

    FUNCTION DES3Decrypt(input IN RAW,
                         key   IN RAW,
                         which IN PLS_INTEGER DEFAULT TwoKeyMode,
                         iv    IN RAW DEFAULT NULL)
        RETURN RAW;

    PROCEDURE DES3Decrypt(input_string     IN     VARCHAR2,
                          key_string       IN     VARCHAR2,
                          decrypted_string    OUT VARCHAR2,
                          which            IN     PLS_INTEGER
                                                    DEFAULT TwoKeyMode,
                          iv_string        IN VARCHAR2 DEFAULT NULL);

    FUNCTION DES3Decrypt(input_string IN VARCHAR2,
                         key_string   IN VARCHAR2,
                         which        IN PLS_INTEGER DEFAULT TwoKeyMode,
                         iv_string    IN VARCHAR2 DEFAULT NULL)
        RETURN VARCHAR2;

    -------------------------------- MD5 --------------------------------------
    -- The following routines generate MD5 hashes of data.
    -- There are two versions: one for raw data and the other for strings.
    ---------------------------------------------------------------------------

    PROCEDURE MD5(input    IN  RAW,
                  checksum OUT raw_checksum);

    FUNCTION MD5(input    IN  RAW)
        RETURN raw_checksum;

    PROCEDURE MD5(input_string    IN     VARCHAR2,
                  checksum_string    OUT varchar2_checksum);

    FUNCTION MD5(input_string    IN     VARCHAR2)
        RETURN varchar2_checksum;

END dbms_obfuscation_toolkit;
/

CREATE OR REPLACE PUBLIC SYNONYM dbms_obfuscation_toolkit
   FOR sys.dbms_obfuscation_toolkit;
GRANT EXECUTE ON dbms_obfuscation_toolkit TO public
/



