Rem
Rem $Header: dbmsxml.sql 19-apr-2002.09:58:14 jwwarner Exp $
Rem
Rem dbmsxml.sql
Rem
Rem Copyright (c) 1999, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      dbmsxml.sql - XML support 
Rem
Rem    DESCRIPTION
Rem      Implements the XML support functionality.   They are simply trusted 
Rem    callouts. See the dbmsxml.sql file for more information.
Rem
Rem    NOTES
Rem     This package is automatically converted to a fixed package and
Rem     compiled into the kernel.  
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       jwwarner 04/15/02 - add null handling choices
Rem       amanikut 10/15/01 - add convert()
Rem       amanikut 07/25/01 - add newContext(REF CURSOR)
Rem       amanikut 06/26/01 - bug 1840417
Rem       gviswana 05/24/01 - CREATE OR REPLACE SYNONYM
Rem       amanikut 06/25/01 - bug 1840147
Rem       amanikut 03/30/01 - add getXMLType
Rem       amanikut 12/22/00 - Conform DBMS_XMLGEN with Query
Rem       amanikut 11/02/00 - conform DBMS_XMLGen with DBMS_XMLQuery
Rem       mkrishna 06/27/00 - 
Rem       mkrishna 06/26/00 - add new function
Rem       mkrishna 05/18/00 - add more functions 
Rem       mkrishna 05/08/00 - change getCtx to getContext
Rem       mkrishna 05/05/00 - use AUTHID CURRENT_USER for package
Rem       mkrishna 12/28/99 - add more functions 
Rem       mkrishna 12/24/99 - DBMS_XML package
Rem                12/24/99 - Created
Rem

Rem The C version for the XML generation 

CREATE OR REPLACE PACKAGE dbms_xmlgen AUTHID CURRENT_USER AS 

  -- context handle
  SUBTYPE ctxHandle IS NUMBER;
  SUBTYPE ctxType IS NUMBER;
  SUBTYPE conversionType IS NUMBER;

  -- DTD or schema specifications
  NONE CONSTANT NUMBER := 0;
  DTD CONSTANT NUMBER := 1;
  SCHEMA CONSTANT NUMBER := 2;

  -- conversion type
  ENTITY_ENCODE CONSTANT conversionType := 0;
  ENTITY_DECODE CONSTANT conversionType := 1;

  -- constants for null handling
  DROP_NULLS CONSTANT NUMBER := 0;
  NULL_ATTR  CONSTANT NUMBER := 1;
  EMPTY_TAG  CONSTANT NUMBER := 2;

  -- procedure to create the XML document
  FUNCTION newContext(queryString IN varchar2) RETURN ctxHandle;

  FUNCTION newContext(queryString IN SYS_REFCURSOR) RETURN ctxHandle;

  -- set the row tag name
  PROCEDURE setRowTag(ctx IN ctxHandle, rowTagName IN varchar2);

  -- set the rowset tag name
  PROCEDURE setRowSetTag(ctx IN ctxHandle, rowSetTagName IN varchar2);

  PROCEDURE getXML(ctx IN ctxHandle, tmpclob IN OUT NOCOPY clob, 
                   dtdOrSchema IN number := NONE);

  FUNCTION getXML(ctx IN ctxHandle, dtdOrSchema IN number := NONE) 
    RETURN clob;
    
  FUNCTION getXML(sqlQuery IN VARCHAR2, dtdOrSchema IN NUMBER := NONE) 
    RETURN CLOB;
    
  FUNCTION getXMLType(ctx IN ctxHandle, dtdOrSchema IN number:= NONE)
        RETURN sys.XMLType;

  FUNCTION getXMLType(sqlQuery IN VARCHAR2, dtdOrSchema IN NUMBER := NONE)
        RETURN sys.XMLType;

  -- returns the number of rows processed by the last call to getXML()
  FUNCTION getNumRowsProcessed(ctx IN ctxHandle) RETURN number;

  PROCEDURE setMaxRows(ctx IN ctxHandle, maxRows IN number);
  PROCEDURE setSkipRows(ctx IN ctxHandle, skipRows IN number);

  -- This procedure sets whether you want to replace characters such as 
  -- <. > etc.. by their codes. (lt;, gt; etc..)
  PROCEDURE setConvertSpecialChars(ctx IN ctxHandle, replace IN boolean);

  -- This forces the use of the _ITEM for collectionitems. The default is to
  -- set the underlying object type name  for collection base elements.
  PROCEDURE useItemTagsForColl(ctx IN ctxHandle);

  -- reset the query to start fetching from the begining
  PROCEDURE restartQuery(ctx IN ctxHandle);

  PROCEDURE closeContext(ctx IN ctxHandle);

  -- conversion functions
  FUNCTION convert(xmlData IN varchar2, flag IN NUMBER := ENTITY_ENCODE) 
           return varchar2;

  FUNCTION convert(xmlData IN CLOB, flag IN NUMBER := ENTITY_ENCODE) 
           return CLOB;

  -- This procedure sets how you want nulls handled during generation
  PROCEDURE setNullHandling(ctx IN ctxHandle, flag IN NUMBER);

  PROCEDURE useNullAttributeIndicator(ctx IN ctxHandle,
                                      attrind IN boolean := TRUE);

END dbms_xmlgen;
/

CREATE OR REPLACE PUBLIC SYNONYM DBMS_XMLGEN FOR DBMS_XMLGEN;

GRANT EXECUTE ON DBMS_XMLGEN TO PUBLIC;
