Rem
Rem $Header: dbmsxmlp.sql 13-oct-2003.15:02:27 ataracha Exp $
Rem
Rem dbmsxmlp.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      dbmsxmlp.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ataracha    10/09/03 - add getBaseDir
Rem    njalali     08/13/02 - removing SET statements
Rem    gviswana    01/29/02 - CREATE OR REPLACE SYNONYM
Rem    spannala    12/27/01 - setup should be run as SYS
Rem    nmontoya    12/12/01 - remove set echo on 
Rem    nmontoya    09/05/01 - Merged nmontoya_plsdom2
Rem    nmontoya    08/09/01 - Created
Rem

 
create or replace package xdb.dbms_xmlparser AUTHID CURRENT_USER IS 

/**
 * Parser interface type
 */
TYPE Parser IS RECORD (id dbms_xmldom.domtype);

/**
 * Return the release version of the Oracle XML Parser for PL/SQL
 */
FUNCTION getReleaseVersion RETURN VARCHAR2;

/**
 * Parses xml stored in the given url/file and returns the built DOM Document
 */
FUNCTION parse(url VARCHAR2) RETURN dbms_xmldom.DOMDocument;

/**
 * Returns a new parser instance
 */
FUNCTION newParser RETURN Parser;

PROCEDURE freeParser(p Parser);

/**
 * Parses xml stored in the given url/file
 */
PROCEDURE parse(p Parser, url VARCHAR2);

/**
 * Parses xml stored in the given buffer
 */
PROCEDURE parseBuffer(p Parser, doc VARCHAR2);

/**
 * Parses xml stored in the given clob
 */
PROCEDURE parseClob(p Parser, doc CLOB);

/**
 * Parses the given dtd
 */
PROCEDURE parseDTD(p Parser, url VARCHAR2, root VARCHAR2);

/**
 * Parses the given dtd
 */
PROCEDURE parseDTDBuffer(p Parser, dtd VARCHAR2, root VARCHAR2);

/**
 * Parses the given dtd
 */
PROCEDURE parseDTDClob(p Parser, dtd CLOB, root VARCHAR2);

/**
 * Sets base directory used to resolve relative urls
 */
PROCEDURE setBaseDir(p Parser, dir VARCHAR2);

/**
 * Gets base directory used to resolve relative urls
 */
FUNCTION getBaseDir(p Parser) return VARCHAR2;

/**
 * Sets warnings TRUE - on, FALSE - off
 */
PROCEDURE showWarnings(p Parser, yes BOOLEAN);

/**
 * Sets errors to be sent to the specified file
 */
PROCEDURE setErrorLog(p Parser, fileName VARCHAR2);

/**
 * Sets whitespace preserving mode TRUE - on, FALSE - off
 */
PROCEDURE setPreserveWhitespace(p Parser, yes BOOLEAN);

/**
 * Sets validation mode TRUE - validating, FALSE - non validation
 */
PROCEDURE setValidationMode(p Parser, yes BOOLEAN);

/**
 * Gets validation mode
 */
FUNCTION getValidationMode(p Parser) RETURN BOOLEAN;

/**
 * Sets DTD for validation purposes - MUST be before an xml document is parsed
 */
PROCEDURE setDoctype(p Parser, dtd dbms_xmldom.DOMDocumentType);

/**
 * Gets DTD parsed - MUST be called only after a dtd is parsed
 */
FUNCTION getDoctype(p Parser) RETURN dbms_xmldom.DOMDocumentType;

/**
 * Gets DOM Document built by the parser - MUST be called only after a
 * document is parsed
 */
FUNCTION getDocument(p Parser) RETURN dbms_xmldom.DOMDocument;

end dbms_xmlparser;
/
show errors;


CREATE OR REPLACE PUBLIC SYNONYM DBMS_XMLPARSER FOR xdb.dbms_xmlparser
/
GRANT EXECUTE ON xdb.dbms_xmlparser TO PUBLIC
/
show errors;

