Rem
Rem $Header: dbmsxsch.sql 18-jul-2002.17:30:34 thoang Exp $
Rem
Rem dbmsxsch.sql
Rem
Rem Copyright (c) 2000, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      dbmsxsch.sql - XML Schema Package
Rem
Rem    DESCRIPTION
Rem      Contains package to register XML schemas with XDB.
Rem
Rem    NOTES
Rem      Must be run connected as XDB
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    thoang      07/18/02 - add csid parameter to registerSchema 
Rem    gviswana    01/29/02 - CREATE OR REPLACE SYNONYM
Rem    jwwarner    01/29/02 - make generateschema(s) embedcoll by default
Rem    spannala    12/27/01 - not switching users in xdb install
Rem    rmurthy     11/19/01 - invoke wrapped implementation
Rem    sichandr    11/20/01 - optional user name for register
Rem    sichandr    10/15/01 - add FORCE flag for register
Rem    rmurthy     10/01/01 - add genTables as separate flag
Rem    rmurthy     09/12/01 - add register schema based on URI
Rem    jwwarner    09/10/01 - Add schema location hint to generateSchemas
Rem    sichandr    10/03/01 - add compileSchema
Rem    jwwarner    08/09/01 - Add generateSchema
Rem    rmurthy     08/03/01 - add register from xmltype, uritype
Rem    tsingh      06/30/01 - XDB: XML Database merge
Rem    rmurthy     05/18/01 - add invalidate option for schema deletion
Rem    rmurthy     05/09/01 - make registration always invokers rights
Rem    bkhaladk    03/07/01 - update register schema calls..
Rem    rmurthy     02/09/01 - change functions to procedures
Rem    rmurthy     02/07/01 - add invokers rights entry points
Rem    rmurthy     01/02/01 - add register functions for clobs, bfiles
Rem    rmurthy     12/01/00 - Created
Rem



create or replace package xdb.dbms_xmlschema authid current_user is
  ---------------------------------------------
  --  OVERVIEW
  --
  --  This package provides procedures to
  --  (*) register an XML schema
  --  (*) delete a previously registered XML schema
  --  (*) re-compile a previously registered XML schema
  --  (*) generate an XML schema
  --
  ---------------------------------------------

  ------------
  -- CONSTANTS
  --
  ------------
  DELETE_RESTRICT CONSTANT NUMBER := 1;
  DELETE_INVALIDATE CONSTANT NUMBER := 2;
  DELETE_CASCADE  CONSTANT NUMBER := 3;
  DELETE_CASCADE_FORCE CONSTANT NUMBER := 4;

  ---------------------------------------------
  -- PROCEDURE - registerSchema
  -- PARAMETERS - 
  --  schemaURL 
  --     A name that uniquely identifies the schema document. 
  --  schemaDoc 
  --     a valid XML schema document
  --  local 
  --     Is this a local or global schema ? By default, all schemas 
  --     are registered as local schemas i.e. under 
  --       /sys/schemas/<username>/...
  --     If a schema is registered as global, it is added under 
  --       /sys/schemas/PUBLIC/...
  --     You need write privileges on the above directory to be 
  --     able to register a schema as global.
  --  genTypes 
  --     Should the schema compiler generate object types ? 
  --  genbean 
  --     Should the schema compiler generate Java beans ? 
  --  genTables 
  --     Should the schema compiler generate default tables ? 
  --  force
  --     Should the schema be created/stored even with errors?
  --       Setting this to TRUE will register the schema in the
  --       hierarchy even if there were compilation errors, but
  --       the schema cannot be used until it is made valid.
  --  csid
  --     Character set id of the input blob or bfile.
  --   
  -- EXCEPTIONS
  --   ORA-31001: Invalid resource handle or path name
  --   todo
  ---------------------------------------------
  procedure registerSchema(schemaURL IN varchar2,
			   schemaDoc IN VARCHAR2,
                           local IN BOOLEAN := TRUE,
                           genTypes IN BOOLEAN := TRUE,
			   genbean IN BOOLEAN := FALSE,
                           genTables IN BOOLEAN := TRUE,
                           force IN BOOLEAN := FALSE,
                           owner IN VARCHAR2 := '');

  procedure registerSchema(schemaURL IN varchar2,
			   schemaDoc IN CLOB,
                           local IN BOOLEAN := TRUE,
                           genTypes IN BOOLEAN := TRUE,
			   genbean IN BOOLEAN := FALSE,
                           genTables IN BOOLEAN := TRUE,
                           force IN BOOLEAN := FALSE,
                           owner IN VARCHAR2 := '');

  procedure registerSchema(schemaURL IN varchar2,
			   schemaDoc IN BLOB,
                           local IN BOOLEAN := TRUE,
                           genTypes IN BOOLEAN := TRUE,
			   genbean IN BOOLEAN := FALSE,
                           genTables IN BOOLEAN := TRUE,
                           force IN BOOLEAN := FALSE,
                           owner IN VARCHAR2 := '',
                           csid IN NUMBER := 0);

  procedure registerSchema(schemaURL IN varchar2,
			   schemaDoc IN BFILE,
                           local IN BOOLEAN := TRUE,
                           genTypes IN BOOLEAN := TRUE,
			   genbean IN BOOLEAN := FALSE,
                           genTables IN BOOLEAN := TRUE,
                           force IN BOOLEAN := FALSE,
                           owner IN VARCHAR2 := '',
                           csid IN NUMBER := 0);

  procedure registerSchema(schemaURL IN varchar2,
			   schemaDoc IN sys.XMLType,
                           local IN BOOLEAN := TRUE,
                           genTypes IN BOOLEAN := TRUE,
			   genbean IN BOOLEAN := FALSE,
                           genTables IN BOOLEAN := TRUE,
                           force IN BOOLEAN := FALSE,
                           owner IN VARCHAR2 := '');

  procedure registerSchema(schemaURL IN varchar2,
			   schemaDoc IN sys.UriType,
                           local IN BOOLEAN := TRUE,
                           genTypes IN BOOLEAN := TRUE,
			   genbean IN BOOLEAN := FALSE,
                           genTables IN BOOLEAN := TRUE,
                           force IN BOOLEAN := FALSE,
                           owner IN VARCHAR2 := '');


  ---------------------------------------------
  -- PROCEDURE - registerURI
  -- PARAMETERS - 
  --  schemaURL 
  --     A name that uniquely identifies the schema document. 
  --  schemaDocURI
  --     A pathname (URI) corresponding to the physical location of the 
  --     schema document. The URI path could be based on HTTP, FTP, DB or XDB 
  --     protocols. This function constructs a URIType instance using 
  --     the URIFactory - and invokes the regiserSchema function above.
  --  <all other paramaters> Same as above
  ---------------------------------------------
  procedure registerURI(schemaURL IN varchar2,
		        schemaDocURI IN varchar2,
                        local IN BOOLEAN := TRUE,
                        genTypes IN BOOLEAN := TRUE,
                        genbean IN BOOLEAN := FALSE,
                        genTables IN BOOLEAN := TRUE,
                        force IN BOOLEAN := FALSE,
                        owner IN VARCHAR2 := '');

  ---------------------------------------------
  -- PROCEDURE - deleteSchema
  -- PARAMETERS - 
  --  schemaURL : Name identifying the schema to be deleted
  --  option : one of the following 
  --    DELETE_RESTRICT ::
  --      Schema deletion fails if there are any tables or schemas that 
  --      depend on this schema.
  --    DELETE_INVALIDATE : 
  --      Schema deletion does not fail if there are any dependencies. 
  --      Instead, it simply invalidates all dependent objects.
  --    DELETE_CASCADE ::
  --      Schema deletion will also drop all default SQL types and 
  --      default tables. However the deletion fails if there are 
  --      any stored instances conforming to this schema.
  --    DELETE_CASCADE_FORCE :: 
  --      Similar to CASCADE except that it does not check for any stored 
  --      instances conforming to this schema. Also it ignores any errors.
  --
  -- EXCEPTIONS
  --   ORA-31001: Invalid resource handle or path name
  --   todo
  ---------------------------------------------
  procedure deleteSchema(schemaURL IN varchar2, 
                         delete_option IN pls_integer := DELETE_RESTRICT);

  ---------------------------------------------
  -- PROCEDURE - generateBean
  --  This procedure can be used to generate the Java bean code 
  --  corresponding to a registered XML schema.
  --  Note that there is also an option to generate the beans 
  --  as part of the registration procedure itself.
  -- PARAMETERS - 
  --  schemaURL : Name identifying a registered XML schema.
  -- EXCEPTIONS
  --   ORA-31001: Invalid resource handle or path name
  --   todo
  ---------------------------------------------
  procedure generateBean(schemaURL IN varchar2);

  ---------------------------------------------
  -- PROCEDURE - compileSchema
  --  This procedure can be used to re-compile an already registered XML
  --  schema. This is useful for bringing a schema in an invalid
  --  state to a valid state.
  -- PARAMETERS - 
  --  schemaURL : URL identifying the schema 
  -- EXCEPTIONS
  --   ORA-31001: Invalid resource handle or path name
  ---------------------------------------------
  procedure compileSchema(schemaURL IN varchar2);

  ---------------------------------------------
  -- FUNCTION - generateSchema(s)
  --  These functions generate XML schema(s) from
  --  an oracle type name.  generateSchemas returns a collection
  --  of XMLTypes, one XMLSchema document for each database schema.
  --  generateSchema inlines them all in one schema (XMLType).
  -- PARAMETERS - 
  --  schemaName  : the name of the database schema containing the type
  --  typeName    : the name of the oracle type
  --  elementName : the name of the toplevel element in the XMLSchema
  --                defaults to typeName
  --  schemaURL   : specifies base URL where schemas will be stored,
  --                needed by top level schema for import statement
  --  recurse     : whether or not to also generate schema for all types
  --                referred to by the type specified
  --  annotate    : whether or not to put the SQL annotations in the XMLSchema
  --  embedColl   : whether you want collections embedded in the type which
  --                refers to them or you want them to have a complexType
  --                created, can not be false with annotations true
  -- EXCEPTIONS
  --  TBD
  ---------------------------------------------
  function generateSchemas( schemaName IN varchar2, typeName IN varchar2,
                            elementName IN varchar2 := NULL,
                            schemaURL IN varchar2 := NULL,
			    annotate IN BOOLEAN := TRUE,
			    embedColl IN BOOLEAN := TRUE )
    return sys.XMLSequenceType;

  function generateSchema( schemaName IN varchar2, typeName IN varchar2,
                           elementName IN varchar2 := NULL,
                           recurse IN BOOLEAN := TRUE,
                           annotate IN BOOLEAN := TRUE,
			   embedColl IN BOOLEAN := TRUE ) return sys.XMLType;

end dbms_xmlschema;
/
show errors



Rem create the implementation 
@@prvtxsch.plb

CREATE OR REPLACE PUBLIC SYNONYM DBMS_XMLSCHEMA FOR xdb.DBMS_XMLSCHEMA;

GRANT EXECUTE ON DBMS_XMLSCHEMA TO PUBLIC WITH GRANT OPTION;

