Rem
Rem $Header: e0801070.sql 03-jun-2004.05:19:37 kquinn Exp $
Rem
Rem e0801070.sql
Rem
Rem Copyright (c) 2000, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      e0801070.sql - downgrade Oracle RDBMS from current release to 8.1.7
Rem
Rem    DESCRIPTION
Rem      See the README file and the Oracle Migration book for details.
Rem
Rem      This script is to be used for downgrading your database from the
Rem      current release you have installed to the 8.1.7 release.  This
Rem      script provides a direct downgrade path from your current installed
Rem      release to the 8.1.7 release.
Rem
Rem      This script performs the downgrade in the following stages:
Rem        STAGE 1: downgrade from the current release to 9.0.1;
Rem        STAGE 2: downgrade base data dictionary objects from 9.0.1 to 8.1.7
Rem                 a. remove new 9.0 system/object privileges
Rem                 b. remove new 9.0 catalog views/synonyms
Rem                    (previous release views will be recreated after)
Rem                 c. remove program units referring to new 9.0 fixed views
Rem                    or non-compiling in 8.1.7
Rem                 d. update new 9.0 columns to NULL or other values,
Rem                    delete rows from new 9.0 tables, and drop new 
Rem                    9.0 type attributes
Rem        STAGE 3: downgrade system types from 9.0 to 8.1.7
Rem
Rem    NOTES
Rem      * This script needs to be run in the current release's environment
Rem        (before installing the release to which you want to downgrade).
Rem      * This script must be run using SQL*PLUS.
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kquinn      06/03/04 - 3608307: Reset QSMQSUM_SUM_UPGRADE
Rem    rburns      05/22/02 - bug 2356117
Rem    dgagne      08/27/01 - remove catnomet and move to e0900010.sql
Rem    rburns      07/20/01 - bug-1805609, remove alter types
Rem    rburns      06/06/01 - add 9.0.1 downgrade
Rem    rburns      05/09/01 - remove RESET COMPATIBILITY
Rem    rburns      04/30/01 - trigger audit row removal and URITYPE drop
Rem    rburns      04/10/01 - remove extra drops
Rem    nshodhan    04/09/01 - drop view dba_registered_mview_groups
Rem    eyho        04/11/01 - drop RAC views from 9.0.1
Rem    rherwadk    03/21/01 - max_active_sess_target_p1 -> active_sess_pool_p1
Rem    jingliu     03/29/01 - drop table repcat$_template_targets
Rem    rburns      03/16/01 - more fixed views
Rem    tkeefe      03/09/01 - Simplify normalization of n-tier.
Rem    rburns      03/08/01 - temporary reset compatibility (for MLCTYP)
Rem    rburns      03/01/01 - drop more views and packages
Rem    dmwong      03/06/01 - rename dba_policy_ views.
Rem    yhu         03/08/01 - downgrade for secobj$.
Rem    twtong      03/13/01 - invalidate summary object
Rem    mbrey       02/15/01 - Downgrade for 9.0 changes to catsnap.sql
Rem    smuthuli    02/13/01 - rename dba_smu_extents to dba_undo_extents
Rem    rburns      01/31/01 - reset types to version 1
Rem    araghava    02/27/01 - 
Rem    araghava    02/26/01 - downgrade partitioning hibound values to 8.1.7. 
Rem                           reintroduce RPAD where necessary.
Rem    rburns      01/26/01 - move csform, java, and type downgrades
Rem    bpanchap    01/22/01 - Do not drop summary system tables
Rem    rburns      01/16/01 - more views to drop
Rem    tchou       01/12/01 - add jis support
Rem    lbarton     12/29/00 - Metadata API: delete rows from metastylesheet
Rem    rburns      12/18/00 - fix downgrade problems
Rem    dalpern     11/30/00 - privileges for kga debugger
Rem    celsbern    12/06/00 - fixing replication downgrade
Rem    bemeng      12/11/00 - change v$object_stats to v$object_usage.
Rem    clei        12/06/00 - add SELECT ANY DICTIONARY
Rem    rburns      12/06/00 - drop ULT_LOGSTBY package
Rem    jingliu     11/20/00 - review comments
Rem    rburns      11/20/00 - truncate ind$ property to ub1
Rem    bpanchap    11/30/00 - Dropping summary system tables
Rem    gkulkarn    11/14/00 - Reset spare2 in OBJ$ for LogMiner
Rem    rburns      11/10/00 - Cleanup downgrade script, remove drop columns
Rem    ctrezza     11/09/00 - Adding Data Guard downgrade
Rem    elu         11/02/00 - modify repcat$_parameter_column
Rem    liwong      10/29/00 - add def$_destination.flag
Rem    jdavison    10/23/00 - Cleanup prior edits.
Rem    celsbern    10/18/00 - fixed comment.
Rem    celsbern    10/17/00 - added downgrade of ias 9.0 replication changes
Rem    arrajara    08/31/00 - codepoint semantics: system.repcat$_repcolumn
Rem    elu         10/04/00 - Drop extension tables
Rem    slawande    10/16/00 - Downgrade for materialized view logs with seq#.
Rem    yhu         10/16/00 - add support for warning table
Rem    clei        10/04/00 - add downgrade for fixed views of VPD predicates
Rem    rvissapr    09/01/00 - removing clientid, session_cpu in aud$ downgrade
Rem    jdavison    09/20/00 - Fix 9.0 downgrade problems
Rem    kosinski    07/09/00 - Add dba_stored_settings
Rem    kosinski    06/14/00 - Persistent parameters
Rem    rwessman    08/29/00 - Fixed bugs in N-tier upgrade
Rem    svivian     09/01/00 - plan stability downgrades
Rem    nshodhan    08/31/00 - handle mlog$.oldest_new column
Rem    jdavison    08/02/00 - Add JVM upgrade/downgrade scripts.
Rem    nshodhan    08/01/00 - set snap$.rel_query to null
Rem    kumamage    07/24/00 - v$spparameter and gv$spparameter should go away
Rem    liwong      07/12/00 - add total_prop_time_latency
Rem    dmwong      07/07/00 - remove fga_log$ during downgrade.
Rem    sdizdar     07/05/00 - RMAN configuration:
Rem                         - add drop v_$rman_configuration
Rem    elu         06/26/00 - drop column ddl_num from template_objects
Rem    elu         06/23/00 - drop type hashcode column to repcat tables
Rem    liwong      06/29/00 - drop total_txn_count, total_prop_time
Rem    thoang      06/08/00 - remove 9.0 system types 
Rem    rvenkate    06/23/00 - remove username and add userid to
Rem                           repcat$_repgroup_privs
Rem    spsundar    06/21/00 - move indpart$ constraint here from d0801070.sql
Rem    kosinski    06/14/00 - Persistent parameters
Rem    bemeng      06/28/00 - remove drop of object_stats table
Rem    bemeng      06/23/00 - drop object_stats & v$object_stats
Rem    elu         06/13/00 - drop ddl_num from repcat$_ddl
Rem    thoang      06/08/00 - remove 9.0 system types 
Rem    rwessman    06/08/00 - Back out N-Tier enhancements
Rem    mmorsi      05/15/00 - SQLJ catalog changes.
Rem    rvenkate    05/31/00 - Added new index I_SNAP2.
Rem    shihliu     05/31/00 - drop resumable view
Rem    slawande    06/07/00 - Dont drop columns on downgrade.
Rem    atsukerm    05/30/00 - remove database_properties view..
Rem    liwong      05/17/00 - add_master_db w/o quiesce
Rem    dmwong      05/17/00 - downgrade rls$ and context$.
Rem    lbarton     05/22/00 - Drop dictionary tables for Metadata API
Rem    bemeng      05/24/00 - delete default temp tablespace number from props$
Rem    slawande    05/19/00 - downgrade for materialized views.
Rem    spsundar    05/10/00 - add not null constraint to dataobj# in indpart$
Rem    jdavison    05/08/00 - Add e0801070.sql for downgrade - contents moved
Rem    mmorsi      05/01/00 - Catalog downgrade for SQLJ.
Rem    dmwong      04/27/00 - remove fga$ when downgrading
Rem    apadmana    04/20/00 - Replicated Objects MV
Rem    dmwong      04/14/00 - make downgrade changes for rls and approle
Rem    wnorcott    04/12/00 - upgrade/downgrade Change Data Capture
Rem    jdavison    04/11/00 - Modify usage notes for 9.0 changes.
Rem    wnorcott    03/28/00 - Change Data Capture add'l downgrade
Rem    ayalaman    03/28/00 - additional statistics for iot with overflow
Rem    wnorcott    03/08/00 - Change Data Capture metadata
Rem    liwong      02/13/00 - drop system.repcat$_object_null_vector
Rem    gclaborn    11/22/99 - Drop dictionary tables for Metadata API
Rem    gclaborn    11/16/99 - Add removal of Metadata API
Rem    jklein      01/17/00 - row seq changes
Rem    liwong      07/31/99 - replicated objects
Rem    jdavison    05/08/00 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade from the current release to 9.0.1
Rem =========================================================================

@@e0900010

Rem =========================================================================
Rem END STAGE 1: downgrade from the current release to 9.0.1
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade dictionary from 9.0.1 to 8.1.7
Rem =========================================================================

Rem ================================================================
Rem resource_plan_directive$ column rename support
Rem ================================================================
Rem In 9.0, column "max_active_sess_target_p1" has been renamed to
Rem "active_sess_pool_p1" by adding an extra column to "active_sess_pool_p1" to
Rem resource_plan_directive$ and using that column instead of
Rem "max_active_sess_target_p1". So on a downgrade to 8.1.7, switch back to
Rem usage of "max_active_sess_target_p1".
update resource_plan_directive$
set max_active_sess_target_p1=active_sess_pool_p1;
commit
/

Rem =========================================================================
Rem BEGIN 9.0 Privilege/Audit Maps removal
Rem =========================================================================

update SYSTEM_PRIVILEGE_MAP set name='EXTENDS TYPE'
where privilege=-186;

update SYSTEM_PRIVILEGE_MAP set name='EXTENDS ANY TYPE'
where privilege=-209;

delete from SYSAUTH$             where privilege# = -213 OR 
                                 privilege# between -242 and -229;
delete from SYSTEM_PRIVILEGE_MAP where privilege = -213 OR 
                                 privilege between -242 and -229;

Rem=========================================================================
Rem Remove new object privileges here !!
Rem=========================================================================

delete from OBJAUTH$            where privilege# in (22,23,24,26);
delete from TABLE_PRIVILEGE_MAP where privilege in (22,23,24,26);

Rem=========================================================================
Rem Remove new audit options here !!
Rem=========================================================================

delete from AUDIT$                where option# between 229 and 242; 
delete from STMT_AUDIT_OPTION_MAP where option# between 229 and 242;

Rem =========================================================================
Rem END 9.0 Privilege/Audit Maps removal
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Public View/Synonym removals
Rem =========================================================================

drop public synonym CHANGE_SETS;
drop view CHANGE_SETS;

drop public synonym CHANGE_SOURCES;
drop view CHANGE_SOURCES;

drop public synonym CHANGE_TABLES;
drop view CHANGE_TABLES;

drop public synonym DATABASE_PROPERTIES;
drop view DATABASE_PROPERTIES;

drop public synonym GLOBAL_CONTEXT;
drop view GLOBAL_CONTEXT;

drop public synonym LOADER_COL_INFO;
drop view LOADER_COL_INFO;

drop public synonym PROXY_ROLES;
drop view PROXY_ROLES;

drop public synonym PROXY_USERS_AND_ROLES;
drop view PROXY_USERS_AND_ROLES;

Rem =========================================================================
Rem ALL/DBA/USER family removals
Rem =========================================================================

drop view USER_ATTRIBUTE_TRANSFORMATIONS;
drop public synonym USER_ATTRIBUTE_TRANSFORMATIONS;

drop view ALL_AUDIT_POLICIES;
drop public synonym ALL_AUDIT_POLICIES;
drop view DBA_AUDIT_POLICIES;
drop public synonym DBA_AUDIT_POLICIES;
drop view USER_AUDIT_POLICIES;
drop public synonym USER_AUDIT_POLICIES;

drop view DBA_EXTERNAL_LOCATIONS;
drop public synonym DBA_EXTERNAL_LOCATIONS;

drop view DBA_EXTERNAL_TABLES;
drop public synonym DBA_EXTERNAL_TABLES;

drop view DBA_FGA_AUDIT_TRAIL;
drop public synonym DBA_FGA_AUDIT_TRAIL;

drop view DBA_GLOBAL_CONTEXT;
drop public synonym DBA_GLOBAL_CONTEXT;

drop view ALL_INDEXTYPE_COMMENTS;
drop public synonym ALL_INDEXTYPE_COMMENTS;
drop view DBA_INDEXTYPE_COMMENTS;
drop public synonym DBA_INDEXTYPE_COMMENTS;
drop view USER_INDEXTYPE_COMMENTS;
drop public synonym USER_INDEXTYPE_COMMENTS;

drop view "_ALL_INSTANTIATION_DDL";
drop public synonym "_ALL_INSTANTIATION_DDL";

drop view ALL_JOIN_IND_COLUMNS;
drop public synonym ALL_JOIN_IND_COLUMNS;
drop view DBA_JOIN_IND_COLUMNS;
drop public synonym DBA_JOIN_IND_COLUMNS;
drop view USER_JOIN_IND_COLUMNS;
drop public synonym USER_JOIN_IND_COLUMNS;

drop view DBA_LOGSTDBY_EVENTS;
drop public synonym DBA_LOGSTDBY_EVENTS;

drop view DBA_LOGSTDBY_NOT_UNIQUE;
drop public synonym DBA_LOGSTDBY_NOT_UNIQUE;

drop view DBA_LOGSTDBY_PARAMETERS;
drop public synonym DBA_LOGSTDBY_PARAMETERS;

drop view DBA_LOGSTDBY_PROGRESS;
drop public synonym DBA_LOGSTDBY_PROGRESS;

drop view DBA_LOGSTDBY_SKIP;
drop public synonym DBA_LOGSTDBY_SKIP;

drop view DBA_LOGSTDBY_SKIP_TRANSACTION;
drop public synonym DBA_LOGSTDBY_SKIP_TRANSACTION;

drop view DBA_LOGSTDBY_UNSUPPORTED;
drop public synonym DBA_LOGSTDBY_UNSUPPORTED;

drop view ALL_LOG_GROUPS;
drop public synonym ALL_LOG_GROUPS;
drop view DBA_LOG_GROUPS;
drop public synonym DBA_LOG_GROUPS;
drop view USER_LOG_GROUPS;
drop public synonym USER_LOG_GROUPS;

drop view ALL_LOG_GROUP_COLUMNS;
drop public synonym ALL_LOG_GROUP_COLUMNS;
drop view DBA_LOG_GROUP_COLUMNS;
drop public synonym DBA_LOG_GROUP_COLUMNS;
drop view USER_LOG_GROUP_COLUMNS;
drop public synonym USER_LOG_GROUP_COLUMNS;

drop view ALL_OPERATOR_COMMENTS;
drop public synonym ALL_OPERATOR_COMMENTS;
drop view DBA_OPERATOR_COMMENTS;
drop public synonym DBA_OPERATOR_COMMENTS;
drop view USER_OPERATOR_COMMENTS;
drop public synonym USER_OPERATOR_COMMENTS;

drop view ALL_PENDING_CONV_TABLES;
drop public synonym ALL_PENDING_CONV_TABLES;
drop view DBA_PENDING_CONV_TABLES;
drop public synonym DBA_PENDING_CONV_TABLES;
drop view USER_PENDING_CONV_TABLES;
drop public synonym USER_PENDING_CONV_TABLES;

drop view ALL_PROCEDURES;
drop public synonym ALL_PROCEDURES;
drop view DBA_PROCEDURES;
drop public synonym DBA_PROCEDURES;
drop view USER_PROCEDURES;
drop public synonym USER_PROCEDURES;

drop view USER_APPLICATION_ROLES;
drop public synonym USER_APPLICATION_ROLES;
drop view DBA_APPLICATION_ROLES;
drop public synonym DBA_APPLICATION_ROLES;

drop view ALL_POLICY_GROUPS;
drop public synonym ALL_POLICY_GROUPS;
drop view DBA_POLICY_GROUPS;
drop public synonym DBA_POLICY_GROUPS;
drop view USER_POLICY_GROUPS;
drop public synonym USER_POLICY_GROUPS;

drop view ALL_POLICY_CONTEXTS;
drop public synonym ALL_POLICY_CONTEXTS;
drop view DBA_POLICY_CONTEXTS;
drop public synonym DBA_POLICY_CONTEXTS;
drop view USER_POLICY_CONTEXTS;
drop public synonym USER_POLICY_CONTEXTS;

drop public synonym "_ALL_REPEXTENSIONS";
drop view "_ALL_REPEXTENSIONS";
drop public synonym DBA_REPEXTENSIONS;
drop view DBA_REPEXTENSIONS;

drop public synonym "_ALL_REPSITES_NEW";
drop view "_ALL_REPSITES_NEW";
drop public synonym DBA_REPSITES_NEW;
drop view DBA_REPSITES_NEW;

drop public synonym DBA_RESUMABLE;
drop view DBA_RESUMABLE;
drop public synonym USER_RESUMABLE;
drop view USER_RESUMABLE;

drop view ALL_SECONDARY_OBJECTS;
drop public synonym ALL_SECONDARY_OBJECTS;
drop view DBA_SECONDARY_OBJECTS;
drop public synonym DBA_SECONDARY_OBJECTS;
drop view USER_SECONDARY_OBJECTS;
drop public synonym USER_SECONDARY_OBJECTS;

drop view DBA_UNDO_EXTENTS;
drop public synonym DBA_UNDO_EXTENTS;

drop view ALL_SOURCE_TABLES;
drop public synonym ALL_SOURCE_TABLES;
drop view DBA_SOURCE_TABLES;
drop public synonym DBA_SOURCE_TABLES;
drop view USER_SOURCE_TABLES;
drop public synonym USER_SOURCE_TABLES;

drop view ALL_SOURCE_TAB_COLUMNS;
drop public synonym ALL_SOURCE_TAB_COLUMNS;
drop view DBA_SOURCE_TAB_COLUMNS;
drop public synonym DBA_SOURCE_TAB_COLUMNS;
drop view USER_SOURCE_TAB_COLUMNS;
drop public synonym USER_SOURCE_TAB_COLUMNS;

drop view ALL_SQLJ_TYPES;
drop public synonym ALL_SQLJ_TYPES;
drop view DBA_SQLJ_TYPES;
drop public synonym DBA_SQLJ_TYPES;
drop view USER_SQLJ_TYPES;
drop public synonym USER_SQLJ_TYPES;

drop view ALL_SQLJ_TYPE_ATTRS;
drop public synonym ALL_SQLJ_TYPE_ATTRS;
drop view DBA_SQLJ_TYPE_ATTRS;
drop public synonym DBA_SQLJ_TYPE_ATTRS;
drop view USER_SQLJ_TYPE_ATTRS;
drop public synonym USER_SQLJ_TYPE_ATTRS;

drop view ALL_SQLJ_TYPE_METHODS;
drop public synonym ALL_SQLJ_TYPE_METHODS;
drop view DBA_SQLJ_TYPE_METHODS;
drop public synonym DBA_SQLJ_TYPE_METHODS;
drop view USER_SQLJ_TYPE_METHODS;
drop public synonym USER_SQLJ_TYPE_METHODS;

drop view ALL_STORED_SETTINGS;
drop public synonym ALL_STORED_SETTINGS;
drop view DBA_STORED_SETTINGS;
drop public synonym DBA_STORED_SETTINGS;
drop view USER_STORED_SETTINGS;
drop public synonym USER_STORED_SETTINGS;

drop view ALL_SUBSCRIBED_COLUMNS;
drop public synonym ALL_SUBSCRIBED_COLUMNS;
drop view DBA_SUBSCRIBED_COLUMNS;
drop public synonym DBA_SUBSCRIBED_COLUMNS;
drop view USER_SUBSCRIBED_COLUMNS;
drop public synonym USER_SUBSCRIBED_COLUMNS;

drop view ALL_SUBSCRIBED_TABLES;
drop public synonym ALL_SUBSCRIBED_TABLES;
drop view DBA_SUBSCRIBED_TABLES;
drop public synonym DBA_SUBSCRIBED_TABLES;
drop view USER_SUBSCRIBED_TABLES;
drop public synonym USER_SUBSCRIBED_TABLES;

drop view ALL_SUBSCRIPTIONS;
drop public synonym ALL_SUBSCRIPTIONS;
drop view DBA_SUBSCRIPTIONS;
drop public synonym DBA_SUBSCRIPTIONS;
drop view USER_SUBSCRIPTIONS;
drop public synonym USER_SUBSCRIPTIONS;

drop view ALL_TAB_COLS;
drop public synonym ALL_TAB_COLS;
drop view DBA_TAB_COLS;
drop public synonym DBA_TAB_COLS;
drop view USER_TAB_COLS;
drop public synonym USER_TAB_COLS;

drop view DBA_TEMPLATE_REFGROUPS;
drop public synonym DBA_TEMPLATE_REFGROUPS;

drop view DBA_TEMPLATE_TARGETS;
drop public synonym DBA_TEMPLATE_TARGETS;

drop view USER_TRANSFORMATIONS;
drop public synonym USER_TRANSFORMATIONS;

drop view ALL_TYPE_VERSIONS;
drop public synonym ALL_TYPE_VERSIONS;
drop view DBA_TYPE_VERSIONS;
drop public synonym DBA_TYPE_VERSIONS;
drop view USER_TYPE_VERSIONS;
drop public synonym USER_TYPE_VERSIONS;

drop view ALL_MVIEW_REFRESH_TIMES;
drop public synonym ALL_SNAPSHOT_REFRESH_TIMES;
drop public synonym ALL_MVIEW_REFRESH_TIMES;
drop view DBA_MVIEW_REFRESH_TIMES;
drop public synonym DBA_SNAPSHOT_REFRESH_TIMES;
drop public synonym DBA_MVIEW_REFRESH_TIMES;
drop view USER_MVIEW_REFRESH_TIMES;
drop public synonym USER_SNAPSHOT_REFRESH_TIMES;
drop public synonym USER_MVIEW_REFRESH_TIMES;

drop view ALL_MVIEW_LOGS; 
drop public synonym ALL_MVIEW_LOGS;
drop view DBA_MVIEW_LOGS;
drop public synonym DBA_MVIEW_LOGS;
drop view USER_MVIEW_LOGS;
drop public synonym USER_MVIEW_LOGS;

drop view ALL_BASE_TABLE_MVIEWS;
drop public synonym ALL_BASE_TABLE_MVIEWS;
drop view DBA_BASE_TABLE_MVIEWS;
drop public synonym DBA_BASE_TABLE_MVIEWS;
drop view USER_BASE_TABLE_MVIEWS;
drop public synonym USER_BASE_TABLE_MVIEWS;

drop view ALL_REGISTERED_MVIEWS;
drop public synonym ALL_REGISTERED_MVIEWS;
drop view DBA_REGISTERED_MVIEWS;
drop public synonym DBA_REGISTERED_MVIEWS;
drop view USER_REGISTERED_MVIEWS;
drop public synonym USER_REGISTERED_MVIEWS;

drop view DBA_MVIEW_LOG_FILTER_COLS;
drop public synonym DBA_SNAPSHOT_LOG_FILTER_COLS;
drop public synonym DBA_MVIEW_LOG_FILTER_COLS;

drop view DBA_REGISTERED_MVIEW_GROUPS;
drop public synonym DBA_REGISTERED_MVIEW_GROUPS;

drop view DBA_CACHEABLE_NONTABLE_OBJECTS;
drop public synonym DBA_CACHEABLE_NONTABLE_OBJECTS;
drop view DBA_CACHEABLE_OBJECTS_BASE;
drop public synonym DBA_CACHEABLE_OBJECTS_BASE;
drop view REPCAT_REPCOLUMN_BASE;
drop public synonym REPCAT_REPCOLUMN_BASE;
drop view REPCAT_REPFLAVOR_COLUMNS;
drop public synonym REPCAT_REPFLAVOR_COLUMNS;

drop view "_ALL_REPCOLUMN_GROUP";
drop view "_ALL_REPCONFLICT";
drop view "_ALL_REPGROUPED_COLUMN";
drop view "_ALL_REPL_NESTED_TABLE_NAMES";
drop view "_ALL_REPPARAMETER_COLUMN";
drop view "_ALL_REPRESOLUTION";
drop view "_DBA_REPL_NESTED_TABLE_NAMES";
drop view "_DEFTRANDEST";
drop view "_USER_REPL_NESTED_TABLE_NAMES";

Rem =========================================================================
Rem Fixed View Removals
Rem =========================================================================

drop view V_$ACTIVE_SESS_POOL_MTH;
drop public synonym V$ACTIVE_SESS_POOL_MTH;
drop view GV_$ACTIVE_SESS_POOL_MTH;
drop public synonym GV$ACTIVE_SESS_POOL_MTH;

drop view V_$ARCHIVE_DEST_STATUS;
drop public synonym V$ARCHIVE_DEST_STATUS;
drop view GV_$ARCHIVE_DEST_STATUS;
drop public synonym GV$ARCHIVE_DEST_STATUS;

drop view V_$ARCHIVE_GAP;
drop public synonym V$ARCHIVE_GAP;
drop view GV_$ARCHIVE_GAP;
drop public synonym GV$ARCHIVE_GAP;

drop view GV_$CLASS_CACHE_TRANSFER;
drop public synonym GV$CLASS_CACHE_TRANSFER; 

drop view V_$ENQUEUE_STAT;
drop public synonym V$ENQUEUE_STAT;
drop view GV_$ENQUEUE_STAT;
drop public synonym GV$ENQUEUE_STAT;

drop view V_$GCSHVMASTER_INFO;
drop public synonym V$GCSHVMASTER_INFO;
drop view GV_$GCSHVMASTER_INFO;
drop public synonym GV$GCSHVMASTER_INFO;

drop view V_$GCSPFMASTER_INFO;
drop public synonym V$GCSPFMASTER_INFO;
drop view GV_$GCSPFMASTER_INFO;
drop public synonym GV$GCSPFMASTER_INFO;

drop view V_$GLOBALCONTEXT;
drop public synonym V$GLOBALCONTEXT;
drop view GV_$GLOBALCONTEXT;
drop public synonym GV$GLOBALCONTEXT;

drop view V_$HVMASTER_INFO;
drop public synonym V$HVMASTER_INFO;
drop view GV_$HVMASTER_INFO;
drop public synonym GV$HVMASTER_INFO;

drop view V_$LOGMNR_CALLBACK;
drop public synonym V$LOGMNR_CALLBACK;
drop view GV_$LOGMNR_CALLBACK;
drop public synonym GV$LOGMNR_CALLBACK;

drop view V_$LOGMNR_LOGFILE;
drop public synonym V$LOGMNR_LOGFILE;
drop view GV_$LOGMNR_LOGFILE;
drop public synonym GV$LOGMNR_LOGFILE;

drop view V_$LOGMNR_PROCESS;
drop public synonym V$LOGMNR_PROCESS;
drop view GV_$LOGMNR_PROCESS;
drop public synonym GV$LOGMNR_PROCESS;

drop view V_$LOGMNR_REGION;
drop public synonym V$LOGMNR_REGION;
drop view GV_$LOGMNR_REGION;
drop public synonym GV$LOGMNR_REGION;

drop view V_$LOGMNR_SESSION;
drop public synonym V$LOGMNR_SESSION;
drop view GV_$LOGMNR_SESSION;
drop public synonym GV$LOGMNR_SESSION;

drop view V_$LOGMNR_TRANSACTION;
drop public synonym V$LOGMNR_TRANSACTION;
drop view GV_$LOGMNR_TRANSACTION;
drop public synonym GV$LOGMNR_TRANSACTION;

drop view V_$LOGSTDBY;
drop public synonym V$LOGSTDBY;
drop view GV_$LOGSTDBY;
drop public synonym GV$LOGSTDBY;

drop view V_$LOGSTDBY_APPLY;
drop public synonym V$LOGSTDBY_APPLY;
drop view GV_$LOGSTDBY_APPLY;
drop public synonym GV$LOGSTDBY_APPLY;

drop view V_$LOGSTDBY_COORDINATOR;
drop public synonym V$LOGSTDBY_COORDINATOR;
drop view GV_$LOGSTDBY_COORDINATOR;
drop public synonym GV$LOGSTDBY_COORDINATOR;

drop view V_$LOGSTDBY_STATS;
drop public synonym V$LOGSTDBY_STATS;
drop view GV_$LOGSTDBY_STATS;
drop public synonym GV$LOGSTDBY_STATS;

drop view V_$MANAGED_STANDBY;
drop public synonym V$MANAGED_STANDBY;
drop view GV_$MANAGED_STANDBY;
drop public synonym GV$MANAGED_STANDBY;

drop view V_$MVREFRESH;
drop public synonym V$MVREFRESH;
drop view GV_$MVREFRESH;
drop public synonym GV$MVREFRESH;

drop view V$OBJECT_USAGE;
drop public synonym V$OBJECT_USAGE;

drop view V_$PGASTAT;
drop public synonym V$PGASTAT;
drop view GV_$PGASTAT;
drop public synonym GV$PGASTAT;

drop view V_$QUEUEING_MTH;
drop public synonym V$QUEUEING_MTH;
drop view GV_$QUEUEING_MTH;
drop public synonym GV$QUEUEING_MTH;

drop view V_$REPLPROP;
drop public synonym V$REPLPROP;
drop view GV_$REPLPROP;
drop public synonym GV$REPLPROP;

drop view V_$REPLQUEUE;
drop public synonym V$REPLQUEUE;
drop view GV_$REPLQUEUE;
drop public synonym GV$REPLQUEUE;

drop public synonym V$RESUMABLE;
drop view V_$RESUMABLE;
drop public synonym GV$RESUMABLE;
drop view GV_$RESUMABLE;

drop view V_$RMAN_CONFIGURATION;
drop public synonym V$RMAN_CONFIGURATION;
drop view GV_$RMAN_CONFIGURATION;
drop public synonym GV$RMAN_CONFIGURATION;

drop view V_$SHARED_SERVER_MONITOR;
drop public synonym V$SHARED_SERVER_MONITOR;
drop view GV_$SHARED_SERVER_MONITOR;
drop public synonym GV$SHARED_SERVER_MONITOR;

drop view V_$SPPARAMETER;
drop public synonym V$SPPARAMETER;
drop view GV_$SPPARAMETER;
drop public synonym GV$SPPARAMETER;

drop view V_$SQL_PLAN;
drop public synonym V$SQL_PLAN;
drop view GV_$SQL_PLAN;
drop public synonym GV$SQL_PLAN;

drop view V_$SQL_REDIRECTION;
drop public synonym V$SQL_REDIRECTION;
drop view GV_$SQL_REDIRECTION;
drop public synonym GV$SQL_REDIRECTION;

drop view V_$SQL_WORKAREA;
drop public synonym V$SQL_WORKAREA;
drop view GV_$SQL_WORKAREA;
drop public synonym GV$SQL_WORKAREA;

drop view V_$SQL_WORKAREA_ACTIVE;
drop public synonym V$SQL_WORKAREA_ACTIVE;
drop view GV_$SQL_WORKAREA_ACTIVE;
drop public synonym GV$SQL_WORKAREA_ACTIVE;

drop view V_$STANDBY_LOG;
drop public synonym V$STANDBY_LOG;
drop view GV_$STANDBY_LOG;
drop public synonym GV$STANDBY_LOG;

drop view V_$TIMEZONE_NAMES;
drop public synonym V$TIMEZONE_NAMES;
drop view GV_$TIMEZONE_NAMES;
drop public synonym GV$TIMEZONE_NAMES;

drop view V_$UNDOSTAT;
drop public synonym V$UNDOSTAT;
drop view GV_$UNDOSTAT;
drop public synonym GV$UNDOSTAT;

drop view V_$VPD_POLICY;
drop public synonym V$VPD_POLICY;
drop view GV_$VPD_POLICY;
drop public synonym GV$VPD_POLICY;

drop view V_$GES_ENQUEUE;
drop public synonym V$GES_ENQUEUE;
drop view GV_$GES_ENQUEUE;
drop public synonym GV$GES_ENQUEUE;

drop view V_$GES_BLOCKING_ENQUEUE;
drop public synonym V$GES_BLOCKING_ENQUEUE;
drop view GV_$GES_BLOCKING_ENQUEUE;
drop public synonym GV$GES_BLOCKING_ENQUEUE;

drop view V_$GC_ELEMENT;
drop public synonym V$GC_ELEMENT;
drop view GV_$GC_ELEMENT;
drop public synonym GV$GC_ELEMENT;

drop view V_$CR_BLOCK_SERVER;
drop public synonym V$CR_BLOCK_SERVER;
drop view GV_$CR_BLOCK_SERVER;
drop public synonym GV$CR_BLOCK_SERVER;

drop view V_$GC_ELEMENTS_W_COLLISIONS;
drop public synonym V$GC_ELEMENTS_WITH_COLLISIONS;
drop view GV_$GC_ELEMENTS_W_COLLISIONS;
drop public synonym GV$GC_ELEMENTS_WITH_COLLISIONS;

drop view V_$FILE_CACHE_TRANSFER;
drop public synonym V$FILE_CACHE_TRANSFER;
drop view GV_$FILE_CACHE_TRANSFER;
drop public synonym GV$FILE_CACHE_TRANSFER;

drop view V_$TEMP_CACHE_TRANSFER;
drop public synonym V$TEMP_CACHE_TRANSFER;
drop view GV_$TEMP_CACHE_TRANSFER;
drop public synonym GV$TEMP_CACHE_TRANSFER;

drop view V_$CLASS_CACHE_TRANSFER;
drop public synonym V$CLASS_CACHE_TRANSFER;
drop view GV_$TEMP_CACHE_TRANSFER;
drop public synonym GV$CLASS_CACHE_TRANSFER;

drop public synonym V$GES_STATISTICS;
drop public synonym GV$GES_STATISTICS;

drop public synonym V$GES_LATCH;
drop public synonym GV$GES_LATCH;

drop public synonym V$GES_CONVERT_LOCAL;
drop public synonym GV$GES_CONVERT_LOCAL;

drop public synonym V$GES_CONVERT_REMOTE;
drop public synonym GV$GES_CONVERT_REMOTE;

drop public synonym V$GES_TRAFFIC_CONTROLLER;
drop public synonym GV$GES_TRAFFIC_CONTROLLER;

drop public synonym V$GES_RESOURCE;
drop public synonym GV$GES_RESOURCE;

Rem =========================================================================
Rem Remove OEM Monitor pseudo-fixed views
Rem =========================================================================

drop view V_$FILESTATXS;
drop public synonym V$FILESTATXS;

drop view V_$TEMPSTATXS;
drop public synonym V$TEMPSTATXS;

drop view V_$SQLXS;
drop public synonym V$SQLXS;

drop view X_$KCBFWAIT;
drop public synonym X$KCBFWAIT;

drop view X_$KSLLT;
drop public synonym X$KSLLT;

drop view X_$KSPPI;
drop public synonym X$KSPPI;

drop view X_$KSPPSV;
drop public synonym X$KSPPSV;

drop view X_$KSQST;
drop public synonym X$KSQST;

Rem =========================================================================
Rem END Public Synonym/View removals
Rem =========================================================================
Rem =========================================================================
Rem BEGIN Program Unit removals
Rem       Any program unit with a dependency on the fixed views above
Rem       must be deleted during downgrade.
Rem       Also, any new program units that will not compile in 8.1.7.
Rem =========================================================================

drop function PARTITION_POS;
drop function SERVER_ERROR_DEPTH;
drop function SERVER_ERROR_MSG;
drop function SERVER_ERROR_NUM_PARAMS;
drop function SERVER_ERROR_PARAM;
drop function SPACE_ERROR_INFO;
drop function SQL_TXT;
drop function SYS_IXMLAGG;
drop function SYS_XMLAGG;

drop operator EXISTSNODE;
drop operator EXTRACT;

drop package DBMS_APPCTX;
drop package DBMS_AQELM;
drop package DBMS_AQ_EXP_SIGNATURE_TABLES;
drop package DBMS_CDC_PUBLISH; 
drop package DBMS_CDC_SUBSCRIBE;
drop package DBMS_CDC_UTILITY;
drop package DBMS_DEBUG_JDWP;
drop package DBMS_DEFER_QUERY_UTL;
drop package DBMS_EXTENDED_TTS_CHECKS;
drop package DBMS_FGA;     
drop package DBMS_FLASHBACK;
drop package DBMS_IAS_INST_UTL_EXP;
drop package DBMS_IAS_MT_INST_INTERNAL;
drop package DBMS_IAS_TEMPLATE_INTERNAL;
drop package DBMS_IAS_TEMPLATE_UTL;
drop package DBMS_ITRIGGER_UTL;
drop package DBMS_LOGSTDBY;
drop package DBMS_LOGMNR_SESSION;
drop package DBMS_ODCI;
drop package DBMS_REDEFINITION;            
drop package DBMS_REPCAT_RGT_UTL;
drop package DBMS_REPCAT_ADD_MASTER;
drop package DBMS_REPCAT_COMMON_UTL;
drop package DBMS_REPCAT_OBJ_UTL;
drop package DBMS_REPCAT_RQ;
drop package DBMS_REPCAT_SQL_UTL;
drop package DBMS_RESUMABLE;
drop package DBMS_SQLJTYPE;
drop package DBMS_STATS_INTERNAL;
drop package DBMS_SUMADVISOR;
drop package DBMS_TRANSACTION_INTERNAL_SYS;
drop package DBMS_TRANSFORM;
drop package DBMS_TRANSFORM_EXIMP;
drop package DBMS_XMLGEN;
drop package DBMS_XRWMV;

drop package DBMSOBJG_DP;
drop package INITJVMAUX;
drop package OUTLN_EDIT_PKG;
drop package RMJVM;
drop package URIFACTORY;

drop package UTL_LOGSTDBY; 
drop package UTL_ENCODE;
drop package UTL_URL;
drop package UTL_XML;

drop package XMLINDEXOPS;

drop procedure DBMS_LOGMNR_FFVTOLOGMNRT;
drop procedure LOGMNR_GTLO3;
drop procedure LOGMNR_KRVRDLOCK;
drop procedure LOGMNR_KRVRDLUID3;
drop procedure LOGMNR_KRVRDREPDICT3;
drop procedure ODCIENVDUMP;
drop procedure ODCIINDEXCALLPROPERTYDUMP;
drop procedure ODCIINDEXINFOFLAGSDUMP;

Rem =========================================================================
Rem END Program Unit removals
Rem =========================================================================

Rem =========================================================================
Rem BEGIN New column downgrades
Rem =========================================================================

REM =========================================================================
REM BEGIN character limit removal
REM   required init.ora:  event="10619 trace name context forever, level 1" 
REM =========================================================================

Rem This script removes default values for required 9.0 information that was 
Rem left blank in 8.1.  In 9.0 every string column must have a character limit 
Rem as well as a byte limit, and string columns must know what character set 
Rem they use.  There was no concept of character limits in 8.1.  Only nchar, 
Rem nvarchar2, nclob were required to know what character set they used.

create table SYS_AF098EJSEA093MA (a varchar2(1), b nchar(1));

delete from SYS_AF098EJSEA093MA; 
insert into SYS_AF098EJSEA093MA values ('2', n'2');

REM For all char/varchar2/nchar/nvarchar2 columns,
REM Clear the CHAR SEMANTICS flag
REM CHAR with char semantics in variable-width character sets becomes VARCHAR2
REM NCHAR always become NVARCHAR2
REM Clear the char length field
update col$ 
    set property = (property - bitand(property, 8388608)), 
        type# = decode(bitand(property, 8388608), 0, type#,
                       decode(charsetform, 
                              1, decode((select length
                                         from col$ c, obj$ o 
                                         where c.obj# = o.obj#
                                         and o.name = 'SYS_AF098EJSEA093MA'
                                         and c.name = 'A'), 1, type#, 1), 
                              2, 1, 
                              1)),
        spare3 = 0
    where type# in (1, 96);
commit;

drop table SYS_AF098EJSEA093MA; 

REM ================================================================
REM END character limit removal
REM ================================================================

Rem =========================================================================
Rem BEGIN INDPART$ Table downgrade
Rem =========================================================================

Rem The column dataobj# of indpart$ and indsubpart$ are not-null in 8.1.7
update indpart$ set dataobj# = 4294967295 where dataobj# is null;
update indsubpart$ set dataobj# = 4294967295 where dataobj# is null;
commit
/
alter table indpart$ modify (dataobj# number not null)
/
alter table indsubpart$ modify (dataobj# number not null)
/

Rem =========================================================================
Rem END INDPART$ Table downgrade
Rem =========================================================================


Rem=========================================================================
Rem ========= Begin changes for LogMiner Project ==============
Rem=========================================================================

Rem Reset the SPARE2 column in OBJ$ used for storing the 
Rem "OBJECT VERSION (OBJV#)" for the dictionary object.

update sys.obj$ set spare2 = NULL;


Rem=========================================================================
Rem ========= End changes for LogMiner Project ==============
Rem=========================================================================


Rem =========================================================================
Rem BEGIN Metadata API downgrade
Rem =========================================================================

Rem In future releases, we'll only remove the rows added in that release,
Rem rather than truncating the tables as is done for this 1st release of the
Rem mdAPI. Other products like CWM may have added rows for alternate metadata
Rem models precluding us from simply dropping and recreating these tables upon
Rem each up/downgrade.

delete from metaview$
/
delete from metafilter$
/
delete from metaxslparam$
/
delete from metaxsl$
/
delete from metastylesheet
/
commit
/

Rem =========================================================================
Rem END Metadata API downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Replication downgrade
Rem =========================================================================
Rem Between here and the end of the replication downgrade, expect lots
Rem of ORA-00942 errors if replication is not installed.
Rem THESE ARE OK IF ADVANCED REPLICATION IS NOT INSTALLED
Rem
Rem delete all replicated objects of type TYPE, TYPE BODY,
Rem INDEXTYPE and OPERATOR
DELETE FROM system.repcat$_repobject
  WHERE type IN (13, 14, 32, 33)
/

COMMIT
/

ALTER TABLE system.repcat$_repobject
  DROP CONSTRAINT repcat$_repobject_type
/

ALTER TABLE system.repcat$_repobject
  ADD CONSTRAINT repcat$_repobject_type
    CHECK (type IN (-1, 1, 2, 4, 5, 7, 8, 9, 11, 12, -3,
                                      -4))
/

ALTER TABLE system.repcat$_repobject
  DROP CONSTRAINT  repcat$_repobject_status
/

ALTER TABLE system.repcat$_repobject
  ADD CONSTRAINT  repcat$_repobject_status
     CHECK (status IN (0, 1, 2, 3, 4, 5))
/

Rem delete replicated columns of TYPE
DELETE FROM system.repcat$_repcolumn
  WHERE toid IS NOT NULL
/

COMMIT
/

Rem system.repcat$_repcolumn.pos is NOT NULL
ALTER TABLE system.repcat$_repcolumn
  MODIFY (pos NUMBER NOT NULL)
/

ALTER TABLE system.repcat$_repcolumn
  ADD CONSTRAINT repcat$_repcolumn_uk
    UNIQUE (sname, oname, type, pos)
                  DEFERRABLE INITIALLY DEFERRED
/

ALTER TABLE system.repcat$_grouped_column
  DROP CONSTRAINT repcat$_grouped_column_pk
/

ALTER TABLE system.repcat$_grouped_column
  ADD CONSTRAINT repcat$_grouped_column_pk
   PRIMARY KEY (sname, oname, group_name, column_name)
/

ALTER TABLE system.repcat$_parameter_column
  DROP CONSTRAINT repcat$_parameter_column_pk
/

ALTER TABLE system.repcat$_parameter_column 
  modify parameter_column_name VARCHAR2(30)
/

ALTER TABLE system.repcat$_parameter_column
  ADD CONSTRAINT repcat$_parameter_column_pk
          PRIMARY KEY (sname,
                       oname,
                       conflict_type_id,
                       reference_name,
                       sequence_no,
                       parameter_table_name,
                       parameter_column_name,
                       parameter_sequence_no)
/

ALTER TABLE system.repcat$_template_objects
  DROP CONSTRAINT repcat$_template_objects_u1
/

DELETE FROM system.repcat$_template_objects
  WHERE object_type in (13, 14, 32, 33)
/

COMMIT
/

ALTER TABLE system.repcat$_repcatlog
  DROP CONSTRAINT repcat$_repcatlog_type
/

ALTER TABLE system.repcat$_repcatlog
  MODIFY (a_comment VARCHAR2(80))
/

ALTER TABLE system.repcat$_repcatlog
  ADD CONSTRAINT repcat$_repcatlog_type
    CHECK (type IN (-1, 0, 1, 2, 4, 5, 7, 8, 9, 11, 12, -3))
/

ALTER TABLE system.repcat$_repcatlog
  DROP CONSTRAINT repcat$_repcatlog_request
/

ALTER TABLE system.repcat$_repcatlog
  ADD CONSTRAINT repcat$_repcatlog_request
    CHECK (request IN (-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
                       11, 12, 13, 14, 15))
/

DROP INDEX system.repcat$_repprop_dblink_how
/

ALTER TABLE system.def$_calldest DROP CONSTRAINT def$_call_destination
/

ALTER TABLE system.repcat$_repschema DROP CONSTRAINT repcat$_repschema_dest
/


ALTER TABLE system.def$_destination DROP CONSTRAINT def$_destination_primary
/

UPDATE system.def$_destination SET total_txn_count = 0,
                                   total_prop_time_throughput = 0,
                                   total_prop_time_latency = 0,
                                   to_communication_size = 0,
                                   from_communication_size = 0,
                                   spare1 = 0,
                                   spare2 = 0,
                                   spare3 = 0,
                                   spare4 = 0
/

COMMIT
/

ALTER TABLE system.def$_destination ADD CONSTRAINT def$_destination_primary
      primary key (dblink)
/

ALTER TABLE system.def$_calldest ADD CONSTRAINT def$_call_destination
      FOREIGN KEY(dblink)  
      REFERENCES system.def$_destination(dblink)
/

ALTER TABLE system.repcat$_repschema ADD CONSTRAINT repcat$_repschema_dest
      FOREIGN KEY(dblink)
      REFERENCES system.def$_destination(dblink)
/

DROP TYPE system.repcat$_object_null_vector
/

Rem restore column userid to REPCAT$_REPGROUP_PRIVS. populate corresponding 
Rem data for userid from username. set username column to NULL
comment on column SYSTEM.REPCAT$_REPGROUP_PRIVS.USERID is
'Identifying number of the user'
/
UPDATE system.REPCAT$_REPGROUP_PRIVS rp set rp.userid = 
  (select u.user_id from dba_users u where u.username = rp.username)
/
DROP INDEX system.repcat$_repgroup_privs_n1
/
ALTER TABLE system.REPCAT$_REPGROUP_PRIVS drop constraint  
  repcat$_repgroup_privs_uk 
/
ALTER TABLE system.REPCAT$_REPGROUP_PRIVS add constraint  
  repcat$_repgroup_privs_uk UNIQUE (userid, gname, gowner)
/
ALTER TABLE system.REPCAT$_REPGROUP_PRIVS modify 
  (userid NOT NULL)
/
ALTER TABLE system.REPCAT$_REPGROUP_PRIVS modify 
  (username NULL)
/
CREATE INDEX system.repcat$_repgroup_privs_n1 ON
  system.repcat$_repgroup_privs(global_flag, userid)
/
UPDATE system.REPCAT$_REPGROUP_PRIVS rp set rp.username = NULL
/

DROP TABLE system.repcat$_sites_new
/

DROP TABLE system.repcat$_extension
/

UPDATE sys.mlog$ set oldest_new = NULL
/

Rem Clear Seq# bit from Materialized View Logs with Sequence Number
UPDATE sys.mlog$ SET flag = flag - 1024 WHERE bitand(flag, 1024) = 1024;
/

DROP TABLE system.repcat$_template_targets
/
DROP SEQUENCE system.template$_targets_s
/

Rem =========================================================================
Rem END Replication downgrade
Rem =========================================================================
Rem If replication is not installed, ignore ORA-00942 errors in the 
Rem replication section.
Rem ORA-00942 errors beyond this point require further scrutiny.
Rem =========================================================================


Rem =========================================================================
Rem BEGIN Materialized View downgrade
Rem =========================================================================

DELETE FROM sys.snap_objcol$
/
DROP INDEX sys.i_snap2
/
DELETE FROM sumpartlog$
/
DELETE FROM suminline$
/
DELETE FROM sumpred$
/

REM set sys.snap$.rel_query, which is a clob column, to null
UPDATE sys.snap$ SET rel_query = NULL
/

REM invalidate all summary objects after downgrade
UPDATE obj$ SET status = 5 WHERE type# = 42
/

REM reset QSMQSUM_SUM_UPGRADE bit
UPDATE sys.sum$ set mflags = mflags - 16777216 where
            bitand(mflags, 16777216) = 16777216;
/

commit
/

Rem =========================================================================
Rem END Materialized View downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Change Data Capture downgrade
Rem =========================================================================

drop trigger cdc_alter_ctable_before
/   
drop trigger cdc_create_ctable_after
/  
drop trigger cdc_create_ctable_before 
/  
drop trigger cdc_drop_ctable_before
/
delete from cdc_system$     
/
delete from cdc_change_sources$ 
/
delete from cdc_change_sets$    
/
delete from cdc_change_tables$  
/
delete from cdc_subscribers$    
/
delete from cdc_subscribed_tables$
/
delete from cdc_subscribed_columns$
/
drop sequence cdc_subscribe_seq$ 
/
delete from cdc_change_columns$   
/
drop sequence cdc_rsid_seq$ 
/

Rem =========================================================================
Rem END Change Data Capture downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Security Feature downgrade
Rem =========================================================================

DELETE FROM rls_ctx$
/

DELETE FROM rls_grp$
/

DELETE FROM approle$
/

DELETE FROM fga$
/

DELETE FROM fga_log$
/

DROP INDEX i_rls
/

ALTER TABLE rls$
modify 
(
  gname         VARCHAR2(30) NULL
)
/

CREATE UNIQUE INDEX i_rls on rls$(obj#,pname)
/

ALTER TABLE context$
modify
(
  flags         number NULL
)
/


rem Re-create a proxy$ table in the 8.1.7 format. Only use those entries which
rem specify no credential as different types are not supported in 8.1.7.
rem Cannot drop proxy$ if upgraded database; does not exist in 9.0.0 database.

delete from proxy$
/

create table proxy$
( client#       NUMBER NOT NULL,                           /* client user ID */
  proxy#        NUMBER NOT NULL,                            /* proxy user ID */
  role#         NUMBER NOT NULL,                                  /* role ID */
  flags         NUMBER NOT NULL       /* Mask flags of associated with entry */
)
/

INSERT INTO proxy$
SELECT a.client#, a.proxy#, b.role#, a.flags
  from proxy_data$ a, proxy_role_data$ b
  where credential_type# = 0 and a.client# = b.client# and a.proxy# = b.proxy#
/

Rem Delete all of the entries from the 9.0 tables. The tables cannot be
Rem dropped because because the tables are needed for warmstarting the
Rem database.

DELETE FROM proxy_data$
/
DELETE FROM proxy_role_data$
/
COMMIT
/

ALTER TABLE aud$                       
modify
(
  clientid         varchar2(64) default NULL,  
  sessioncpu       number default NULL    
)
/

Rem =========================================================================
Rem END Security Feature downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN IOT Statistics Feature downgrade
Rem =========================================================================

Rem The avgspc column of tab$ and tabpart$ is used to store the
Rem IOT overflow statistics starting 9.0. This column was not used
Rem for IOTs before 9.0. If the table is analyzed set the value to 0
Rem

update tab$ set avgspc = 0 where bitand(property, 64)!=0 and
           bitand(flags, 16)!=0;

update tabpart$ set avgspc = 0 where bitand(flags, 2) != 0 and bo# in
   (select tab$.obj# from tab$ where bitand(tab$.property, 64)!=0);

commit;

Rem =========================================================================
Rem END IOT Statistics Feature downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN SQLJ downgrade
Rem =========================================================================

DELETE FROM procedureinfo$;

DELETE FROM procedurejava$;

DELETE FROM procedurec$;

DELETE FROM vtable$;

COMMIT;

DROP INDEX i_argument2;

Rem =========================================================================
Rem END SQLJ downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Default Temporary Tablespace downgrade
Rem =========================================================================

delete from props$ where name = 'DEFAULT_TEMP_TABLESPACE'
/
commit
/

Rem =========================================================================
Rem END Default Temporary Tablespace downgrade
Rem =========================================================================
Rem =========================================================================
Rem BEGIN Persistent Parameter Settings downgrade
Rem =========================================================================

DELETE FROM settings$
/
commit
/

Rem =========================================================================
Rem END Persistent Parameter Settings downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Identifying Unused Indexes downgrade
Rem =========================================================================

Rem clean monitoring bit in ind$.flags
update ind$ set flags=flags-65536 where bitand(flags, 65536)!=0
/
commit
/

Rem =========================================================================
Rem END Identifying Unused Indexes downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Opaque Types downgrade
Rem =========================================================================

update sys.coltype$ ccol set flags = flags - 16384 + 2
  where bitand(flags,16384) = 16384 and
  exists (select null from sys.opqtype$ c where c.obj# = ccol.obj# and
  c.intcol# = ccol.intcol#);
commit
/

Rem Delete the entries from the opaque type
delete from opqtype$;
commit
/

Rem =========================================================================
Rem END Opaque Types downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Plan Stability downgrade
Rem =========================================================================

Rem Convert signatures back to exact text match
BEGIN
   DBMS_OUTLN.EXACT_TEXT_SIGNATURES;
END;
/

Rem =========================================================================
Rem BEGIN Plan Stability downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN ODCI downgrade
Rem =========================================================================

drop table odci_secobj$
/

drop table odci_warnings$
/

delete from secobj$
/
commit
/

drop type oracle_loader      FORCE;
drop type ODCIExtTableInfo   FORCE;
drop type ODCIExtTableQCInfo FORCE;
drop type ODCIColInfoList    FORCE;
drop type ODCIColInfoList2   FORCE;

drop type ODCIColInfo    FORCE;
drop type ODCIIndexInfo  FORCE;
drop type ODCICost       FORCE;
drop type ODCIArgDesc    FORCE;
drop type ODCIObjectList FORCE;
drop type ODCIObject     FORCE;

Rem =========================================================================
Rem END ODCI downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN TYPE removals
Rem =========================================================================

drop type DBUriType    FORCE;
drop type FtpUriType   FORCE;
drop type HttpUriType  FORCE;
drop type UriType      FORCE;

drop type ANYDATASET   FORCE;
drop type ANYDATA      FORCE;
drop type ANYTYPE      FORCE;

drop type GET_DEP_DT1  FORCE;
drop type GET_DEP_DT2  FORCE;

drop type AGGXMLINPUTTYPE  FORCE;
drop type AGGXMLIMP        FORCE;
drop type XMLGENFORMATTYPE FORCE;
drop type XMLTYPE          FORCE;

Rem AQ$_JMS type added in 9.0.1.3.0
drop type aq$_jms_message force;

Rem =========================================================================
Rem END TYPE removals
Rem =========================================================================

Rem =========================================================================
Rem BEGIN 9.0 IAS changes to replication tables
Rem =========================================================================
Rem The following section will raise ORA-00942 errors if Replication is 
Rem not installed.  These can be safely ignored.
Rem =========================================================================


alter table system.repcat$_refresh_templates
  drop constraint repcat$_refresh_templates_fk1
/

alter table system.repcat$_refresh_templates
  drop constraint repcat$_refresh_templates_fk2
/

alter table system.repcat$_template_objects
  drop constraint repcat$_template_objects_fk3
/

alter table system.repcat$_template_objects
  add constraint repcat$_template_objects_c1 check
  ((object_type in (-1, 1, 2, 4, 5, 6, 7, 8, 9, 10, 12, -5)) or 
  (object_type between -1018 and -1001))
/

alter table system.repcat$_template_objects
  drop constraint repcat$_template_objects_ver
/

ALTER TABLE system.repcat$_refresh_templates
DROP CONSTRAINT refresh_templates_c1
/

ALTER TABLE system.repcat$_refresh_templates
ADD CONSTRAINT refresh_templates_c1 CHECK
  ((public_template in ('Y','N','I')) or public_template is NULL)
/

ALTER TABLE system.repcat$_template_sites
  DROP CONSTRAINT repcat$_template_sites_c1
/

ALTER TABLE system.repcat$_template_sites
  ADD CONSTRAINT repcat$_template_sites_c1 CHECK
  (status in (-100,-1,0,1))
/



Rem =========================================================================
Rem END 9.0 IAS changes to replication tables
Rem =========================================================================
Rem If ORA-00942 errors are encountered after this point, they require
Rem close scrutiny.
Rem =========================================================================

Rem
Rem =========================================================================
Rem BEGIN Data Guard package downgrade
Rem
Rem =========================================================================

drop package dbms_drs
/
Rem =========================================================================
Rem END Data Guard package downgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Index property downgrade
Rem =========================================================================
Rem reset new property bits in ind$ (temporary?)
update ind$ set property=mod(property,256);
commit;

Rem =========================================================================
Rem END Index property downgrade
Rem =========================================================================

Rem =========================================================================
REM BEGIN downgrade for partition hiboundval
Rem =========================================================================
REM In 9.0.0 we nolonger generate RPAD in the highvalue bound of a partition
REM for fixed char type partitioning columns
REM If a range partitioned table or index with a fixed char partitioning
REM is created in 9.0.0, the highvalue bound needs to be updated to contain
REM the RPAD function
REM The updated hiboundval 
REM is derived from the hiboundval column using a C trusted
REM callout part817_downgrade.
REM If generation of some hiboundval values fails, then error messages are
REM generated. In any case generation of bhiboundval values may be 
REM idempotently re-requested.
SET SERVEROUTPUT ON SIZE 10000;
BEGIN
  DBMS_OUTPUT.PUT_LINE
       ('  Begin of conversion of partitioned tables and indexes');
END;
/
-- create library PART817_DOWNGRADE_LIB containing part817_downgrade
CREATE OR REPLACE LIBRARY PART817_DOWNGRADE_LIB TRUSTED AS STATIC
/

-- create type of array of data types of part columns
CREATE OR REPLACE TYPE dtypes_type AS VARRAY(16) of NUMBER;
/

CREATE OR REPLACE TYPE colwidth_type AS VARRAY(16) of NUMBER;
/

CREATE OR REPLACE TYPE csid_type AS VARRAY(16) of NUMBER;
/

-- create function part817_downgrade (supporting the trusted callback)
CREATE OR REPLACE FUNCTION part817_downgrade
 (textkey IN OUT VARCHAR2, textkeyl IN PLS_INTEGER,
  numkeycols IN PLS_INTEGER, dtypes IN dtypes_type, 
  colwidth IN colwidth_type, csid IN csid_type) RETURN PLS_INTEGER 
IS LANGUAGE C
NAME "PART_817_DOWNGRADE"
WITH CONTEXT
PARAMETERS(CONTEXT, textkey STRING, textkey INDICATOR sb2, textkey LENGTH ub2, 
           textkeyl ub2, numkeycols ub2, dtypes OCIColl, colwidth OCIColl, 
           csid OCIColl, RETURN)
LIBRARY PART817_DOWNGRADE_LIB;
/

DECLARE
  -- constants: table object, range type, IOT overflow bit in tab$
  table_object   CONSTANT NUMBER := 2;
  range_type     CONSTANT NUMBER := 1;
  overflow_table CONSTANT NUMBER := 512;
  fixedchar_type CONSTANT NUMBER := 96;
 
  -- cursor used to get info about a range/composite partitioned object:
  --   from partobj$: obj#, number of partition key columns,
  --                  spare2(sub partitioning info)
  --   from obj$: owner#, name, object type (index, table).
  -- local indexes are excluded, because they have null part keys.
  CURSOR c_obj IS
    SELECT obj$.obj#, partkeycols, partobj$.spare2, owner#, name, type#
    FROM partobj$, obj$
    WHERE parttype = range_type AND partobj$.obj# = obj$.obj#
    AND (BITAND(partobj$.flags, 1) = 0); -- exclude local indexes

  objnum      NUMBER;               -- object #
  numkeycols  PLS_INTEGER;          -- # of partition key columns

  -- cursor used to get data types, column widths and char set ids of part 
  -- columns of an object in the varray called dtypes, colwidth and csid 
  -- using loop index ix
  CURSOR c_col_table IS
    SELECT partcol$.type#, col$.length, partcol$.spare1 
    FROM partcol$, col$ 
    WHERE partcol$.obj# = objnum AND partcol$.obj# = col$.obj# AND 
    partcol$.intcol# = col$.intcol#
    ORDER by partcol$.POS#;

  CURSOR c_col_index IS
    SELECT partcol$.type#, col$.length, partcol$.spare1 
    FROM partcol$, col$, ind$ 
    WHERE partcol$.obj# = objnum AND ind$.obj# = partcol$.obj# AND
    ind$.bo# = col$.obj# AND 
    partcol$.intcol# = col$.intcol#
    ORDER by partcol$.POS#;

  -- array of data types of part cols
  dtypes      dtypes_type := dtypes_type(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  -- array of column widths of part cols
  colwidth    colwidth_type := colwidth_type(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  -- array of character set ids of part cols
  csid        csid_type := csid_type(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  ix          PLS_INTEGER;      -- index over array
  hival_upd   PLS_INTEGER;      -- did the high value get updated
  user_name   VARCHAR2(30);     -- schema user name used for reporting

  -- cursors used to select partition text key and text length
  -- of a partition, to be resubmitted as parameters for updating.
  CURSOR ct_par IS
    SELECT hiboundval, hiboundlen, part#, bobj# FROM tabpart$, tab$ 
    WHERE tab$.obj# = tabpart$.bo# AND bo# = objnum 
    AND TRUNC(MOD(tab$.property/overflow_table, 2)) = 0;
  CURSOR ctc_par IS
    SELECT hiboundval, hiboundlen, part# FROM tabcompart$ WHERE bo# = objnum
    FOR UPDATE;
  CURSOR ci_par IS
    SELECT hiboundval, hiboundlen, part# FROM indpart$
    WHERE bo# = objnum FOR UPDATE;
  hival          LONG(30000);  -- local copy of hiboundval
  hilen          PLS_INTEGER;  -- local copy of hiboundlen
  partnum        NUMBER;       -- partition number
  ov_obj         NUMBER;       -- obj# of overflow table
  overflow_flag  NUMBER;       -- 1 if overflow table of IOT, else 0
  fixedcharcol   NUMBER;

BEGIN  
  -- loop reading information about partitioned objects
  FOR r_obj IN c_obj LOOP
    BEGIN                        -- loop over partitioned objects
      objnum := r_obj.obj#;
      numkeycols := r_obj.partkeycols;

      -- loop initializing dtypes, colwidths and csid varray for current object
      ix := 1;
      fixedcharcol := 0;

      IF r_obj.type# = table_object THEN
        -- this loop will not locate any rows for overflow tables
        -- which is ok since we will update the overflow table hivalue 
        -- with the same value as that for the base table
        FOR r_col IN c_col_table LOOP
          dtypes(ix) := r_col.type#; 
          colwidth(ix) := r_col.length;
          csid(ix) := r_col.spare1;
          ix := ix + 1;

          IF r_col.type# = fixedchar_type THEN
            fixedcharcol := 1;
          END IF;
        END LOOP;
      ELSE
        FOR r_col IN c_col_index LOOP
          dtypes(ix) := r_col.type#; 
          colwidth(ix) := r_col.length;
          csid(ix) := r_col.spare1;
          ix := ix + 1;

          IF r_col.type# = fixedchar_type THEN
            fixedcharcol := 1;
          END IF;
        END LOOP;
      END IF;

      -- if there is a fixed char column, we need to call part817_downgrade
      -- and update the highbound value if necessary
      -- if part817_downgrade indicated that the highvalue was updated
      -- initialize new hiboundval and hiboundlen columns in appropriate 
      -- xxxpart$ table
      -- also update all local indexes for this table with the same
      -- hiboundval and highboundlen. 
      -- an object is composite if its spare2 column of partobj$ is non-zero
      IF fixedcharcol = 1 THEN
        IF r_obj.type# = table_object THEN
          BEGIN                 -- table
            IF r_obj.spare2 = 0 THEN   -- non composite table
              OPEN ct_par;
              LOOP
                FETCH ct_par INTO hival, hilen, partnum, ov_obj;
                EXIT WHEN ct_par%NOTFOUND;
                hival_upd := part817_downgrade(hival, hilen, numkeycols, 
                  dtypes, colwidth, csid);
                IF hival_upd = 1 THEN
                  hilen := LENGTHB(hival);
                  -- update table hibound values
                  UPDATE tabpart$ SET hiboundval = hival, hiboundlen = hilen
                  WHERE part# = partnum AND bo# = objnum;
                  -- update overflow tables for this table
                  IF ov_obj IS NOT NULL THEN
                    UPDATE tabpart$ SET hiboundval = hival, hiboundlen = hilen
                    WHERE part# = partnum AND bo# = ov_obj;
                  END IF;
                  -- update local indexes for this table
                  UPDATE indpart$ SET hiboundval = hival, hiboundlen = hilen
                  WHERE part# = partnum AND bo# IN 
                   (SELECT ind$.obj# 
                    FROM ind$, partobj$ 
                    WHERE ind$.bo# = objnum AND partobj$.obj# = ind$.obj#
                    AND bitand(partobj$.flags, 1) = 1);
                END IF;
              END LOOP;
              CLOSE ct_par;                
            ELSE                       -- composite table
              OPEN ctc_par;
              LOOP
                FETCH ctc_par INTO hival, hilen, partnum;
                EXIT WHEN ctc_par%NOTFOUND;
                hival_upd := part817_downgrade(hival, hilen, numkeycols, 
                  dtypes, colwidth, csid);
                IF hival_upd = 1 THEN
                  hilen := LENGTHB(hival);
                  UPDATE tabcompart$ 
                  SET hiboundval = hival, hiboundlen = hilen
                  WHERE CURRENT OF ctc_par;

                  -- update local indexes
                  -- no need to check for overflow since IOT's don't support
                  -- composite partitioning
                  UPDATE indcompart$ SET hiboundval = hival, hiboundlen = hilen
                  WHERE part# = partnum AND bo# IN 
                    (SELECT ind$.obj# 
                    FROM ind$, partobj$ 
                    WHERE ind$.bo# = objnum AND partobj$.obj# = ind$.obj#
                    AND bitand(partobj$.flags, 1) = 1);
                END IF;
              END LOOP;
              CLOSE ctc_par;   
            END IF;
          END;                  -- table   
        ELSE
          BEGIN                 -- index, must be global hence non composite
            OPEN ci_par;
            LOOP
              FETCH ci_par INTO hival, hilen, partnum;
              EXIT WHEN ci_par%NOTFOUND;
        
              hival_upd := part817_downgrade(hival, hilen, numkeycols, 
                dtypes, colwidth, csid);
              IF hival_upd = 1 THEN
                hilen := LENGTHB(hival);
                UPDATE indpart$ SET hiboundval = hival, hiboundlen = hilen
                 WHERE CURRENT OF ci_par;
              END IF;
            END LOOP;
            CLOSE ci_par;                
          END;                  -- index, must be global hence non composite
        END IF;
      END IF;                 -- if fixedcharcol = 1
    EXCEPTION WHEN OTHERS THEN
      SELECT name INTO user_name FROM user$ WHERE user# = r_obj.owner#;
      DBMS_OUTPUT.PUT_LINE
       ('Error ' || TO_CHAR(SQLCODE) || ': ' || SQLERRM);
      DBMS_OUTPUT.PUT_LINE
       ('Error in creating partition bhiboundval for table/index:');
      DBMS_OUTPUT.PUT_LINE
       ('  ' || user_name || '.' || r_obj.name );
    END;                         -- loop over partitioned objects
  END LOOP;

  COMMIT;
END;
/

-- drop the function, library and type used by bhiboundval column update

DROP FUNCTION part817_downgrade;

DROP LIBRARY PART817_DOWNGRADE_LIB;

DROP TYPE dtypes_type;
DROP TYPE colwidth_type;
DROP TYPE csid_type;

BEGIN
  DBMS_OUTPUT.PUT_LINE
       ('  End of conversion of partitioned tables and indexes');
END;
/
SET SERVEROUTPUT OFF;

Rem =========================================================================
REM END downgrade for partition hiboundval
Rem =========================================================================

Rem ================================================================
Rem BEGIN remove audit rows from procedure$ 
Rem ================================================================

delete from procedure$ where obj# in 
   (select obj# from obj$ where namespace = 3);
commit;

Rem ================================================================
Rem END remove audit rows from procedure$ 
Rem ================================================================

Rem =========================================================================
Rem END STAGE 2: downgrade dictionary from 9.0.1 to 8.1.7
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 3: 9.0 System Types removal
Rem =========================================================================

Rem First reset any types that have been altered 
EXECUTE dbms_type_utility.reset_all_types; 

CREATE OR REPLACE LIBRARY UPGRADE_LIB TRUSTED AS STATIC
/

CREATE OR REPLACE PROCEDURE downgrade_system_types_to_817 IS
LANGUAGE C
NAME "FROM_820"
LIBRARY UPGRADE_LIB;
/

execute downgrade_system_types_to_817();

drop procedure DOWNGRADE_SYSTEM_TYPES_TO_817;
drop package DBMS_TYPE_UTILITY;

Rem =========================================================================
Rem END STAGE 3: 9.0 System Types removal
Rem =========================================================================

Rem *************************************************************************
Rem END e0801070.sql
Rem *************************************************************************
