Rem $Header: e0900010.sql 20-apr-2006.17:10:30 hohung Exp $
Rem
Rem e0900010.sql
Rem
Rem Copyright (c) 2000, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      e0900010.sql - downgrade Oracle RDBMS from current release to 9.0.1
Rem
Rem    DESCRIPTION
Rem
Rem
Rem      This script performs the downgrade in the following stages:
Rem        STAGE 1: downgrade from the current release to 9.2.0;
Rem                 this stage is a no-op for 9.2.0 since the current release
Rem                 is 9.2.0.
Rem        STAGE 2: downgrade base data dictionary objects from 9.2.0 to 9.0.1
Rem                 a. remove new 9.2.0 system/object privileges
Rem                 b. remove new 9.2.0 catalog views/synonyms
Rem                    (previous release views will be recreated after)
Rem                 c. remove program units referring to new 9.2.0 fixed views
Rem                    or non-compiling in 9.0.1
Rem                 d. update new 9.2.0 columns to NULL or other values,
Rem                    delete rows from new 9.2.0 tables, and drop new 
Rem                    9.2.0 type attributes
Rem                 e. downgrade system types from 9.2.0 to 9.0.1
Rem
Rem    NOTES
Rem      * This script needs to be run in the current release's environment
Rem        (before installing the release to which you want to downgrade).
Rem      * This script must be run using SQL*PLUS.
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hohung      04/20/06 - drop v$kqrpd and v$kqrsd synonyms
Rem    bmccarth    04/13/04 - drop export partition template views 
Rem    mtao        06/28/04 - drop _dba_registered_archived_log 
Rem    rbollu      11/22/03 - fix bug#3197595 
Rem    nbhatt      01/29/03 - bug 2604145
Rem    rburns      08/21/02 - drop packages
Rem    aramacha    08/16/02 - Fix Rule Sub Messages.
Rem    zqiu        08/02/02 - remove aw drop trigger
Rem    ksurlake    07/22/02 - Drop Spilled tables
Rem    rburns      05/23/02 - remove drop of jms_message type
Rem    ksurlake    07/22/02 - Drop Spilled tables
Rem    rburns      04/17/02 - delete eval context objects
Rem    nbhatt      03/27/02 - move aq downgrade 
Rem    rburns      03/11/02 - more drop packages
Rem    bmccarth    03/05/02 - drop export xdb views
Rem    skabraha    02/15/02 - call proc for cleaning source$ of constructor
Rem    amanikut    02/02/02 - switch wellformed, validated flags
Rem    rburns      02/03/02 - drop more packages and views
Rem    weiwang     02/04/02 - add rules engine imp/exp internal packages
Rem    amanikut    01/30/02 - change ctors to return deterministic
Rem    dvoss       01/30/02 - Delete new rows from LOGMNR_INTERESTING_COLS
Rem    amanikut    01/25/02 - drop uritype synonyms, xmltype functions
Rem    kpatel      01/12/02 - drop dynamic sga fixed views
Rem    vmaganty    01/15/02 - drop aq$_jms_message.
Rem    rburns      01/05/02 - add java
Rem    weiwang     01/05/02 - change name of rule dictionary views
Rem    rburns      12/28/01 - more drop statements.
Rem    qcao        01/15/02 - change obj view name
Rem    bdagevil    01/24/02 - remove dbms_xplan package
Rem    amanikut    12/06/01 - LRG 82051 : fix drop ctor
Rem    amanikut    12/06/01 - LRG 82051 : fix constructor signature
Rem    wojeil      12/05/01 - downgrade script for map_object.
Rem    ayoaz       11/15/01 - reset synobj# columns
Rem    rburns      11/16/01 - drop mapping fixed views
Rem    avaliani    11/16/01 - rm change NULL to UB4MAXVAL
Rem    qyu         11/21/01 - change getxxxInfo to overload getC/Blob 
Rem    dvoss       11/13/01 - Remove logmnr code that will not compile in 9.0.1
Rem    rburns      11/09/01 - fix trigflag
Rem    rxgovind    11/07/01 - downgrade for anydata, anydataset
Rem    rherwadk    11/09/01 - #1817695: unlimit default resmgr parameter values
Rem    evoss       11/02/01 - fixing merge conflicts.
Rem    skaluska    11/02/01 - add rules engine objects
Rem    nbhatt      11/02/01 - subscriber downgrade
Rem    kmeiyyap    11/02/01 - streams downgrade
Rem    najain      10/31/01 - buffered queues downgrade
Rem    wesmith     10/31/01 - Streams downgrade
Rem    evoss       11/02/01 - fixing merge conflicts.
Rem    apadmana    11/05/01 - make index on exppkgobj$ unique
Rem    lvbcheng    11/05/01 - action line no offset
Rem    evoss       11/02/01 - fixing merge conflicts.
Rem    celsbern    10/25/01 - adding downgrade steps from LOG branch.
Rem                           Originally in d0900010.sql on LOG.
Rem    rburns      10/26/01 - remove NOT NULL from new lob columns
Rem    molagapp    10/13/01 - drop (g)v$database_incarnation view
Rem    vshukla     11/02/01 - downgrade changes for row movement.
Rem    jwwarner    11/02/01 - further xml-related fixes
Rem    vmarwah     10/18/01 - downgrade script for LOB Retention support.
Rem    rburns      10/17/01 - fix summary advisory
Rem    esoyleme    10/11/01 - esoyleme_txn100276
Rem    dmwong      10/16/01 - downgrade fga_log$ and lsqltext -> sqltext.
Rem    bdagevil    10/18/01 - fix error on merge.
Rem    jwwarner    10/18/01 - Fix XML-related downgrade
Rem    clei        10/12/01 - downgrade of synonym VPD by compatibility check
Rem    kpatel      10/09/01 - remove shared_pool_advice, library_cache_memory
Rem    bdagevil    10/10/01 - drop new fixed views  
Rem    bdagevil    10/10/01 - drop new fixed views  
Rem    rburns      09/27/01 - add more fixed views
Rem    mzait       10/05/01 - drop sql_plan_statistics*
Rem    yuli        10/03/01 - add (g)v$statistics_level
Rem    qyu         10/08/01 - drop some methods in uri type 
Rem    jwwarner    09/26/01 - downgrade changes for xml-related types
Rem    clei        09/15/01 - remove synonym specific VPD policies.
Rem    rburns      09/18/01 - obj# change for V$CLASS_CACHE_TRANSFER
Rem                           add drops for V$SQL_WORKAREA_HISTOGRAM
Rem    wnorcott    09/12/01 - drop *_published_columns views.
Rem    rburns      08/29/01 - remove component registry
Rem    akalra      08/31/01 - downgrade for flashback privileges.
Rem    yhu         09/05/01 - drop ODCIIndexInfo.
Rem    dgagne      08/27/01 - add catnomet
Rem    smcgee      08/28/01 - Drop v_$dataguard_status.
Rem    wojeil      09/04/01 - dropping file mapping data dictionary objects.
Rem    rburns      08/15/01 - drop XDBURITYPE
Rem    btao        08/13/01 - remove OBJ_VALUE column, SCHEMA, BASETABLE filter
Rem    sdizdar     08/07/01 - dromp v_$backup_spfile and gv$backup_spfile
Rem    eyho        07/02/01 - drop old view ext_to_obj
Rem    yuli        07/23/01 - remove tablespace force logging mode flag
Rem    rburns      06/16/01 - drop dbms_rcvman package
Rem    yuli        06/19/01 - add (g)v$MTTR_TARGET_ADVICE
Rem    rburns      06/07/01 - Merged rburns_setup_901_upgrade
Rem    rburns      06/06/01 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade from the current release to 9.2.0
Rem =========================================================================

Rem Nothing should be added here. For next release, uncomment the following:
Rem @@e0900020.sql

Rem =========================================================================
Rem END STAGE 1: downgrade from the current release to 9.2.0
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade dictionary from 9.2.0 to 9.0.1
Rem =========================================================================

Rem Delete all spilled queue tables here before the package gets
Rem invalidated (after the rules packages are dropped).

DECLARE
  qt_schema    VARCHAR2(30);
  qt_name      VARCHAR2(30);
  CURSOR find_qt_c IS select schema, name, flags from system.aq$_queue_tables;
BEGIN

  FOR q_rec IN find_qt_c LOOP         -- iterate all queue tables
    BEGIN
      qt_schema := q_rec.schema;                     -- get queue table schema
      qt_name   := q_rec.name;                         -- get queue table name

      -- Drop spilled table
      sys.dbms_aqadm_sys.drop_spilled_table(qt_schema, qt_name);

    EXCEPTION
      WHEN OTHERS THEN
        NULL;
    END;
  END LOOP;
END;
/

Rem  Downgrade 92 unconsumed messages for rule subscibers
Rem  to use NAMEs for switching to Pre 92 format.
BEGIN
  dbms_prvtaqis.downgrade_rulesub_msgs;
END;
/


Rem fixup aq$ tables


DECLARE
  qt_schema    VARCHAR2(30);
  qt_name      VARCHAR2(30);
  qt_flags     NUMBER;
  CURSOR find_qt_c IS select schema, name, flags from system.aq$_queue_tables;
  subtab_sql   VARCHAR2(1024);
  subrset_sql   VARCHAR2(1024);
BEGIN

  FOR q_rec IN find_qt_c LOOP         -- iterate all queue tables
    BEGIN
      qt_schema := q_rec.schema;                     -- get queue table schema
      qt_name   := q_rec.name;                         -- get queue table name
      qt_flags := q_rec.flags;


      subtab_sql := 'update ' || qt_schema || '.AQ$_' || qt_name || '_S a' || 
                    ' set a.subscriber_type = a.subscriber_type - 128 ' ||
                    ' where (bitand(a.subscriber_type, 128) = 128)';

      execute immediate subtab_sql;

      subtab_sql := 'update ' || qt_schema || '.AQ$_' || qt_name || '_S a' || 
                   ' set a.subscriber_type = a.subscriber_type - 64 ' ||
                    ' where (bitand(a.subscriber_type, 64) = 64)';

      execute immediate subtab_sql;

      subtab_sql := 'update ' || qt_schema || '.AQ$_' || qt_name || '_S a' || 
                    ' set a.subscriber_type = a.subscriber_type - 1024 ' ||
                    ' where (bitand(a.subscriber_type, 1024) = 1024)';

      execute immediate subtab_sql;

      -- downgrade subscriber table
      IF ((bitand(qt_flags, 8) = 8) AND (bitand(qt_flags, 1) = 1)) THEN
        dbms_prvtaqis.downgrade_92_90(qt_schema, qt_name);

        -- drop the expdep entries for the queue table evaluation context
        -- don't drop the evctx itself
        dbms_prvtaqis.drop_qtab_evctx(qt_schema, qt_name, TRUE);

      END IF;                            

    EXCEPTION
      WHEN OTHERS THEN
        NULL;
    END;
  END LOOP;

  BEGIN
    subtab_sql := 'update system.aq$_queues set ' ||
                  'a.properties = a.properties - 512 ' ||
                  'where (bitand(a.properties, 512) = 512)';

    execute immediate subtab_sql;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

END;
/

/* drop ruleset_name column to subscriber table */ 
DECLARE
  
 CURSOR get_old81_queue_tables_c IS
   SELECT t.schema, t.name FROM system.aq$_queue_tables t
   WHERE bitand(t.flags,8) = 8 AND   bitand(t.flags,1) = 1 ;
 old81_queue_tables  get_old81_queue_tables_c%ROWTYPE;
 drop_col_sql   VARCHAR2(300);
BEGIN
   FOR old81_queue_tables IN get_old81_queue_tables_c LOOP
     drop_col_sql := 'ALTER TABLE '  
                    || old81_queue_tables.schema || '.'
                    || 'AQ$_'|| old81_queue_tables.name ||'_S'
                    || ' DROP COLUMN ruleset_name';
     BEGIN
        EXECUTE IMMEDIATE drop_col_sql;
     EXCEPTION
       WHEN OTHERS THEN
        RAISE;
     END;


    -- drop the old rules view
    dbms_prvtaqis.drop_rules_view(old81_queue_tables.schema, 
                                  old81_queue_tables.name, TRUE);
    -- create the new rules view                                    
    dbms_prvtaqis.create_90_rules_view(old81_queue_tables.schema, 
                                       old81_queue_tables.name);

   END LOOP;
END;
/  

rem end of fixup of aq$ tables

Rem Downgrade rules engine object
Rem NOTE: this needs be run before the package dbms_rule_compatible_90
Rem       is dropped.
begin
  dbms_rule_compatible_90.downgrade_rule_objects;
end;
/

Rem Downgrade evaluation context 
Rem NOTE: this needs be run before the package dbms_rule_adm is dropped.
begin
  dbms_rule_adm.drop_evaluation_context('SYS.STREAMS$_EVALUATION_CONTEXT',
    force=>TRUE);
end;
/


Rem remove "non existent" row from obj$
delete from obj$ where name='STREAMS$_EVALUATION_CONTEXT' and type#=10;

Rem=========================================================================
Rem Delete new system privileges here 
Rem=========================================================================

delete from SYSAUTH$             where privilege# = -243;
delete from SYSTEM_PRIVILEGE_MAP where privilege  = -243;
delete from sysauth$ where privilege# in 
(-64, -65, -66, -67, -68, -245, -246, -247, -248, -249, -250, -251, -252,
 -253, -254)
/
delete from SYSTEM_PRIVILEGE_MAP where privilege in 
(-64, -65, -66, -67, -68, -245, -246, -247, -248, -249, -250, -251, -252,
 -253, -254)
/

Rem=========================================================================
Rem Delete new object privileges here 
Rem=========================================================================

delete from OBJAUTH$            where privilege# = 27;
delete from TABLE_PRIVILEGE_MAP where privilege  = 27;

Rem=========================================================================
Rem Delete new audit options here 
Rem=========================================================================

delete from AUDIT$                where option# = 243; 
delete from STMT_AUDIT_OPTION_MAP where option# = 243;

commit;

Rem=========================================================================
Rem Drop new fixed views here
Rem=========================================================================

drop public synonym V$DATABASE_BLOCK_CORRUPTION;
drop view V_$DATABASE_BLOCK_CORRUPTION;
drop public synonym GV$DATABASE_BLOCK_CORRUPTION;
drop view GV_$DATABASE_BLOCK_CORRUPTION;

drop public synonym V$BACKUP_SPFILE;
drop view V_$BACKUP_SPFILE;
drop public synonym GV$BACKUP_SPFILE;
drop view GV_$BACKUP_SPFILE;

drop public synonym V$DATAGUARD_STATUS;
drop view V_$DATAGUARD_STATUS;
drop public synonym GV$DATAGUARD_STATUS;
drop view GV_$DATAGUARD_STATUS;

drop public synonym V$MTTR_TARGET_ADVICE;
drop view V_$MTTR_TARGET_ADVICE;
drop public synonym GV$MTTR_TARGET_ADVICE;
drop view GV_$MTTR_TARGET_ADVICE;

drop public synonym V$STATISTICS_LEVEL;
drop view V_$STATISTICS_LEVEL;
drop public synonym GV$STATISTICS_LEVEL;
drop view GV_$STATISTICS_LEVEL;

Rem fixed table object# changed
drop public synonym V$CLASS_CACHE_TRANSFER;
drop view V_$CLASS_CACHE_TRANSFER;

drop public synonym V$SQL_WORKAREA_HISTOGRAM;
drop view V_$SQL_WORKAREA_HISTOGRAM;
drop public synonym GV$SQL_WORKAREA_HISTOGRAM;
drop view GV_$SQL_WORKAREA_HISTOGRAM;

drop public synonym V$LIBRARY_CACHE_MEMORY;
drop view V_$LIBRARY_CACHE_MEMORY;
drop public synonym GV$LIBRARY_CACHE_MEMORY;
drop view GV_$LIBRARY_CACHE_MEMORY;

drop public synonym V$SHARED_POOL_ADVICE;
drop view V_$SHARED_POOL_ADVICE;
drop public synonym GV$SHARED_POOL_ADVICE;
drop view GV_$SHARED_POOL_ADVICE;

drop public synonym V$SGA_CURRENT_RESIZE_OPS;
drop view V_$SGA_CURRENT_RESIZE_OPS;
drop public synonym GV$SGA_CURRENT_RESIZE_OPS;
drop view GV_$SGA_CURRENT_RESIZE_OPS;

drop public synonym V$SGA_RESIZE_OPS;
drop view V_$SGA_RESIZE_OPS;
drop public synonym GV$SGA_RESIZE_OPS;
drop view GV_$SGA_RESIZE_OPS;

drop public synonym V$SGA_DYNAMIC_COMPONENTS;
drop view V_$SGA_DYNAMIC_COMPONENTS;
drop public synonym GV$SGA_DYNAMIC_COMPONENTS;
drop view GV_$SGA_DYNAMIC_COMPONENTS;

drop public synonym V$SGA_DYNAMIC_FREE_MEMORY;
drop view V_$SGA_DYNAMIC_FREE_MEMORY;
drop public synonym GV$SGA_DYNAMIC_FREE_MEMORY;
drop view GV_$SGA_DYNAMIC_FREE_MEMORY;

drop public synonym V$PGA_TARGET_ADVICE;
drop view V_$PGA_TARGET_ADVICE;
drop public synonym GV$PGA_TARGET_ADVICE;
drop view GV_$PGA_TARGET_ADVICE;

drop public synonym V$PGA_TARGET_ADVICE_HISTOGRAM;
drop view V_$PGA_TARGET_ADVICE_HISTOGRAM;
drop public synonym GV$PGA_TARGET_ADVICE_HISTOGRAM;
drop view GV_$PGATARGET_ADVICE_HISTOGRAM;

drop public synonym V$SEGSTAT_NAME;
drop view V_$SEGSTAT_NAME;
drop public synonym GV$SEGSTAT_NAME;
drop view GV_$SEGSTAT_NAME;

drop public synonym V$SEGSTAT;
drop view V_$SEGSTAT;
drop public synonym GV$SEGSTAT;
drop view GV_$SEGSTAT;

drop public synonym V$SEGMENT_STATISTICS;
drop view V_$SEGMENT_STATISTICS;
drop public synonym GV$SEGMENT_STATISTICS;
drop view GV_$SEGMENT_STATISTICS;


drop public synonym V$LOGMNR_STATS;
drop view V_$LOGMNR_STATS;
drop public synonym GV$LOGMNR_STATS;
drop view GV_$LOGMNR_STATS;

drop public synonym V$AW_OLAP;
drop view V_$AW_OLAP;
drop public synonym GV$AW_OLAP;
drop view GV_$AW_OLAP;
drop public synonym V$AW_SESSION_INFO;
drop view V_$AW_SESSION_INFO;
drop public synonym GV$AW_SESSION_INFO;
drop view GV_$AW_SESSION_INFO;
drop public synonym V$AW_CALC;
drop view V_$AW_CALC;
drop public synonym GV$AW_CALC;
drop view GV_$AW_CALC;


drop public synonym V$SQL_PLAN_STATISTICS;
drop view V_$SQL_PLAN_STATISTICS;
drop public synonym GV$SQL_PLAN_STATISTICS;
drop view GV_$SQL_PLAN_STATISTICS;

drop public synonym V$SQL_PLAN_STATISTICS_ALL;
drop view V_$SQL_PLAN_STATISTICS_ALL;
drop public synonym GV$SQL_PLAN_STATISTICS_ALL;
drop view GV_$SQL_PLAN_STATISTICS_ALL;

Rem
Rem Drop STREAMS v$ views
Rem

drop public synonym gv$streams_apply_coordinator;
drop view gv_$streams_apply_coordinator;
drop public synonym v$streams_apply_coordinator;
drop view v_$streams_apply_coordinator;

drop public synonym gv$streams_apply_server;
drop view gv_$streams_apply_server;
drop public synonym v$streams_apply_server;
drop view v_$streams_apply_server;

drop public synonym gv$streams_apply_reader;
drop view gv_$streams_apply_reader;
drop public synonym v$streams_apply_reader;
drop view v_$streams_apply_reader;

drop public synonym gv$streams_capture;
drop view gv_$streams_capture;
drop public synonym v$streams_capture;
drop view v_$streams_capture;

Rem
Rem End: drop STREAMS v$ views
Rem 
drop view v_$kqrpd;
drop public synonym v$kqrpd;
drop view v_$kqrsd;
drop public synonym v$kqrsd;
drop view v_$map_library;
drop public synonym v$map_library;
drop view v_$map_file;
drop public synonym v$map_file;
drop view v_$map_file_extent;
drop public synonym v$map_file_extent;
drop view v_$map_element;
drop public synonym v$map_element;
drop view v_$map_ext_element;
drop public synonym v$map_ext_element;
drop view v_$map_comp_list;
drop public synonym v$map_comp_list;
drop view v_$map_subelement;
drop public synonym v$map_subelement;
drop view v_$map_file_io_stack;
drop public synonym v$map_file_io_stack;

drop view gv_$kqrpd;
drop public synonym gv$kqrpd;
drop view gv_$kqrsd;
drop public synonym gv$kqrsd;
drop view gv_$map_library;
drop public synonym gv$map_library;
drop view gv_$map_file;
drop public synonym gv$map_file;
drop view gv_$map_file_extent;
drop public synonym gv$map_file_extent;
drop view gv_$map_element;
drop public synonym gv$map_element;
drop view gv_$map_ext_element;
drop public synonym gv$map_ext_element;
drop view gv_$map_comp_list;
drop public synonym gv$map_comp_list;
drop view gv_$map_subelement;
drop public synonym gv$map_subelement;
drop view gv_$map_file_io_stack;
drop public synonym gv$map_file_io_stack;

drop public synonym V$DATABASE_INCARNATION;
drop view V_$DATABASE_INCARNATION;
drop public synonym GV$DATABASE_INCARNATION;
drop view GV_$DATABASE_INCARNATION;

Rem
Rem exp views dealing with table subpartition templates
Rem
drop view sys.exptabsubpart;
drop view sys.exptabsubpartdata_view;
drop view sys.exptabsubpartlobfrag;
drop view sys.exptabsubpartlob_view;

Rem=========================================================================
Rem Drop new ALL/DBA/USER views here
Rem=========================================================================

Rem Component Registry Views
drop public synonym ALL_REGISTRY_BANNERS;
drop view ALL_REGISTRY_BANNERS;
drop public synonym DBA_REGISTRY;
drop view DBA_REGISTRY;
drop public synonym DBA_REGISTRY_HIERARCHY;
drop view DBA_REGISTRY_HIERARCHY;
drop public synonym USER_REGISTRY;
drop view USER_REGISTRY;

Rem Logical Standby views
drop public synonym DBA_LOGSTDBY_LOG;
drop view DBA_LOGSTDBY_LOG;

Rem Change Data Capture downgrade
drop public synonym ALL_PUBLISHED_COLUMNS;
drop view ALL_PUBLISHED_COLUMNS;
drop public synonym DBA_PUBLISHED_COLUMNS;
drop view DBA_PUBLISHED_COLUMNS;
drop public synonym USER_PUBLISHED_COLUMNS;
drop view USER_PUBLISHED_COLUMNS;
Rem end of Change Data Capture downgrade

Rem
Rem drop STREAMS views
Rem 

drop public synonym DBA_PROPAGATION;
drop view DBA_PROPAGATION;

drop public synonym ALL_PROPAGATION;
drop view ALL_PROPAGATION;

drop public synonym DBA_STREAMS_GLOBAL_RULES;
drop view DBA_STREAMS_GLOBAL_RULES;

drop public synonym ALL_STREAMS_GLOBAL_RULES;
drop view ALL_STREAMS_GLOBAL_RULES;

drop public synonym DBA_STREAMS_SCHEMA_RULES;
drop view DBA_STREAMS_SCHEMA_RULES;

drop public synonym ALL_STREAMS_SCHEMA_RULES;
drop view ALL_STREAMS_SCHEMA_RULES;

drop public synonym DBA_STREAMS_TABLE_RULES;
drop view DBA_STREAMS_TABLE_RULES;

drop public synonym ALL_STREAMS_TABLE_RULES;
drop view ALL_STREAMS_TABLE_RULES;

drop public synonym DBA_CAPTURE;
drop view DBA_CAPTURE;

drop public synonym ALL_CAPTURE;
drop view ALL_CAPTURE;

drop public synonym DBA_CAPTURE_PARAMETERS;
drop view DBA_CAPTURE_PARAMETERS;

drop public synonym ALL_CAPTURE_PARAMETERS;
drop view ALL_CAPTURE_PARAMETERS;

drop public synonym DBA_CAPTURE_PREPARED_DATABASE;
drop view DBA_CAPTURE_PREPARED_DATABASE;

drop public synonym ALL_CAPTURE_PREPARED_DATABASE;
drop view ALL_CAPTURE_PREPARED_DATABASE;

drop public synonym DBA_CAPTURE_PREPARED_SCHEMAS;
drop view DBA_CAPTURE_PREPARED_SCHEMAS;

drop public synonym ALL_CAPTURE_PREPARED_SCHEMAS;
drop view ALL_CAPTURE_PREPARED_SCHEMAS;

drop public synonym DBA_CAPTURE_PREPARED_TABLES;
drop view DBA_CAPTURE_PREPARED_TABLES;

drop public synonym ALL_CAPTURE_PREPARED_TABLES;
drop view ALL_CAPTURE_PREPARED_TABLES;

drop public synonym DBA_APPLY;
drop view DBA_APPLY;

drop public synonym ALL_APPLY;
drop view ALL_APPLY;

drop public synonym DBA_APPLY_PARAMETERS;
drop view DBA_APPLY_PARAMETERS;

drop public synonym ALL_APPLY_PARAMETERS;
drop view ALL_APPLY_PARAMETERS;

drop public synonym DBA_APPLY_INSTANTIATED_OBJECTS;
drop view DBA_APPLY_INSTANTIATED_OBJECTS;

drop public synonym DBA_APPLY_KEY_COLUMNS;
drop view DBA_APPLY_KEY_COLUMNS;

drop public synonym ALL_APPLY_KEY_COLUMNS;
drop view ALL_APPLY_KEY_COLUMNS;

drop public synonym DBA_APPLY_CONFLICT_COLUMNS;
drop view DBA_APPLY_CONFLICT_COLUMNS;

drop public synonym ALL_APPLY_CONFLICT_COLUMNS;
drop view ALL_APPLY_CONFLICT_COLUMNS;

drop public synonym DBA_APPLY_DML_HANDLERS;
drop view DBA_APPLY_DML_HANDLERS;

drop public synonym ALL_APPLY_DML_HANDLERS;
drop view ALL_APPLY_DML_HANDLERS;

drop public synonym DBA_APPLY_PROGRESS;
drop view DBA_APPLY_PROGRESS;

drop public synonym ALL_APPLY_PROGRESS;
drop view ALL_APPLY_PROGRESS;

drop public synonym DBA_APPLY_ERROR;
drop view DBA_APPLY_ERROR;

drop public synonym ALL_APPLY_ERROR;
drop view ALL_APPLY_ERROR;

Rem Added in 9.2.0.6
drop view "_DBA_REGISTERED_ARCHIVED_LOG";

Rem
Rem End: drop STREAMS views
Rem

Rem
Rem  drop rules engine views
Rem 

drop public synonym dba_evaluation_context_vars
/
drop view dba_evaluation_context_vars
/
drop public synonym all_evaluation_context_vars
/
drop view all_evaluation_context_vars
/
drop public synonym user_evaluation_context_vars
/
drop view user_evaluation_context_vars
/
drop public synonym dba_evaluation_context_tables
/
drop view dba_evaluation_context_tables
/
drop public synonym all_evaluation_context_tables
/
drop view all_evaluation_context_tables
/
drop public synonym user_evaluation_context_tables
/
drop view user_evaluation_context_tables
/
drop public synonym dba_evaluation_contexts
/
drop view dba_evaluation_contexts
/
drop public synonym all_evaluation_contexts
/
drop view all_evaluation_contexts
/
drop public synonym user_evaluation_contexts
/
drop view user_evaluation_contexts
/
drop public synonym dba_rule_set_rules
/
drop view dba_rule_set_rules
/
drop public synonym all_rule_set_rules
/
drop view all_rule_set_rules
/
drop public synonym user_rule_set_rules
/
drop view user_rule_set_rules
/
drop public synonym dba_rules
/
drop view dba_rules
/
drop public synonym all_rules
/
drop view all_rules
/
drop public synonym user_rules
/
drop view user_rules
/
drop public synonym dba_rulesets
/
drop view dba_rulesets
/
drop public synonym all_rulesets
/
drop view all_rulesets
/
drop public synonym user_rulesets
/
drop view user_rulesets
/
drop public synonym dba_rule_sets
/
drop view dba_rule_sets
/
drop public synonym all_rule_sets
/
drop view all_rule_sets
/
drop public synonym user_rule_sets
/
drop view user_rule_sets
/
Rem
Rem End: drop rules engine views
Rem 

Rem
Rem Drop AQ Agent views
Rem   

drop public synonym DBA_AQ_AGENTS;
drop view  DBA_AQ_AGENTS;

drop public synonym DBA_AQ_AGENT_PRIVS;
drop view  DBA_AQ_AGENT_PRIVS;

drop public synonym USER_AQ_AGENT_PRIVS;
drop view  USER_AQ_AGENT_PRIVS;

Rem
Rem End: Drop AQ Agent views
Rem   

Rem drop export views that depend on changed 8i views
drop view EXU9CCL;
drop view EXU9CCLO;
drop view EXU9CCLU;
drop view EXU9COE;
drop view EXU9COEU;
drop view EXU9COO;
drop view EXU9COOU;
drop view EXU9REFC;
drop view EXU9REFI;
drop view EXU9XMLST;
drop view EXU9XDBUID;

Rem=========================================================================
Rem Drop new packages here
Rem       Any program unit with a dependency on the fixed views above
Rem       must be deleted during downgrade.
Rem       Also, any new program units that will not compile in 9.0.1
Rem       must also be deleted.
Rem=========================================================================

drop package INITJVMAUX;
drop package DBMS_RCVMAN;
drop package DBMS_REGISTRY;
drop package DBMS_REGISTRY_SYS;
drop package DBMS_STORAGE_MAP;
drop package DBMS_INTERNAL_LOGSTDBY;
drop package DBMS_LOGSTDBY;
drop package DBMS_LOGSTDBY_PUBLIC;
drop package DBMS_DEBUG_JDWP_CUSTOM;
drop package DBMS_HS;
drop package DBMS_HS_ALT;
drop package DBMS_HS_CHK;
drop package DBMS_HS_UTL;
drop package DBMS_LOGMNR_INTERNAL;
drop package DBMS_LOGMNR_LOGREP_DICT;
drop package LOGMNR_DICT_CACHE;
drop function LOGMNR_DPC;
drop package DBMS_CLUSTDB;
drop package DBMS_PLUGTSP;
drop package UTL_GDK;
drop function OLAP_TABLE;
drop type OLAPIMPL_T force;
drop package DBMS_AW;
drop package DBMS_AW_EXP;
drop package DBMS_AQJMS_INTERNAL;

Rem
Rem drop dbms_xplan package
Rem
drop public synonym dbms_xplan;
drop package dbms_xplan;
drop type dbms_xplan_type_table;
drop type dbms_xplan_type;

Rem
Rem drop STREAMS packages
Rem 
drop public synonym dbms_propagation_adm;
drop package dbms_propagation_adm;
drop public synonym dbms_streams;
drop package dbms_streams;
drop public synonym dbms_streams_adm;
drop package dbms_streams_adm;
drop package dbms_streams_adm_utl;

drop public synonym dbms_apply_adm;
drop package dbms_apply_adm;
drop package dbms_apply_adm_internal;
drop package dbms_apply_process;
drop package dbms_apply_error;

drop public synonym dbms_capture_adm;
drop package dbms_capture_adm;
drop package dbms_capture_adm_internal;
drop package dbms_capture_process;
drop package dbms_logrep_exp;
drop package dbms_logrep_imp;
drop package dbms_logrep_imp_internal;
drop package dbms_logrep_def_proc;
drop package dbms_logrep_def_proc_utl;
drop package dbms_logrep_util;

Rem
Rem End: drop STREAMS packages
Rem 

Rem
Rem drop rules engine packages
Rem 
drop package dbms_rule
/
drop package dbms_rule_adm
/
drop package dbms_rule_eximp
/
drop package DBMS_RULEADM_INTERNAL
/
drop public synonym dbms_rule_imp_obj
/
drop package dbms_rule_imp_obj
/
drop public synonym dbms_rule_exp_rules
/
drop package dbms_rule_exp_rules
/
drop public synonym dbms_rule_exp_rule_sets
/
drop package dbms_rule_exp_rule_sets
/
drop public synonym dbms_rule_exp_ev_ctxs
/
drop package dbms_rule_exp_ev_ctxs
/
drop public synonym dbms_rule_exp_ec_internal
/
drop package dbms_rule_exp_ec_internal
/
drop public synonym dbms_rule_exp_rs_internal
/
drop package dbms_rule_exp_rs_internal
/
drop public synonym dbms_rule_exp_rl_internal
/
drop package dbms_rule_exp_rl_internal
/
drop package dbms_rule_exp_utl
/
drop public synonym dbms_rule_compatible_90
/
drop package dbms_rule_compatible_90
/
Rem
Rem End: drop rules engine packages
Rem 

Rem
Rem Begin: drop new Logminer procedures
Rem

drop procedure dbms_logmnr_octologmnrt;
drop procedure logmnr_krvrda_test_apply;

Rem
Rem End: drop new Logminer procedures
Rem

Rem 
Rem Begin: drop OLAP Service related system trigger and procedure
Rem

drop trigger aw_drop_trg;
drop procedure aw_drop_proc;

Rem 
Rem End: drop OLAP Service related system trigger and procedure
Rem

Rem=========================================================================
Rem Remove changes to sql.bsq dictionary tables here 
Rem=========================================================================

Rem =========================================================================
Rem Reset synobj# columns to null (no type synonyms)
Rem =========================================================================

update coltype$ set synobj# = NULL;
update collection$ set synobj# = NULL;
update attribute$ set synobj# = NULL;
update parameter$ set synobj# = NULL;
update result$ set synobj# = NULL;
update subcoltype$ set synobj# = NULL;
commit
/

Rem ================================================================
Rem resource_plan_directive$ column default value changes
Rem ================================================================
update resource_plan_directive$
set    parallel_degree_limit_p1=1000000
where  parallel_degree_limit_p1=4294967295
/
update resource_plan_directive$
set    active_sess_pool_p1=1000000
where  active_sess_pool_p1=4294967295
/
update resource_plan_directive$
set    queueing_p1=1000000
where  queueing_p1=4294967295
/
update resource_plan_directive$
set    switch_time=1000000
where  switch_time=4294967295
/
update resource_plan_directive$
set    max_est_exec_time=1000000
where  max_est_exec_time=4294967295
/
update resource_plan_directive$
set    undo_pool=1000000
where  undo_pool=4294967295
/
commit
/


Rem downgrade file mapping data dictionary objects

delete from sys.map_file$
/
delete from sys.map_file_extent$
/
delete from sys.map_subelement$
/
delete from sys.map_element$
/
delete from sys.map_extelement$
/
delete from sys.map_complist$
/
delete from sys.map_object
/
drop public synonym map_object
/
commit
/
Rem========================================================================
Rem Reset data in trigger$ column actionlineno
Rem=========================================================================
update sys.trigger$ set actionlineno = NULL;
commit;
/
Rem=========================================================================
Rem Remove source in source$ belonging to triggers 
Rem=========================================================================
delete from sys.source$ s where s.obj# in (select t.obj# from sys.trigger$ t);
commit;
/
Rem    Clear the FORCE LOGGING bit in the dflogging field, which cannot be
Rem    understood by 9.0.1.
UPDATE sys.ts$ SET dflogging = 1 WHERE dflogging = 3;
UPDATE sys.ts$ SET dflogging = 0 WHERE dflogging = 2;

Rem previous release doesn't support synonym specific policies
Rem and base object must not have duplicate policy name
drop index i_rls;
create unique index i_rls on rls$(obj#, gname, pname);

Rem Restore fga_log$ sqltxt column from 9.2 to 9.1 style
update fga_log$ set sqltext = to_nchar(lsqltext);

Rem    updating the LOB$ table (LOB Retention downgrade)
UPDATE sys.lob$ SET retention = 0
/
UPDATE sys.lob$ SET freepools = 65535
/
ALTER TABLE sys.lob$ MODIFY (retention NULL, freepools NULL);
COMMIT;

Rem
Rem truncate STREAMS dictionary tables
Rem 

truncate table streams$_capture_process;
truncate table streams$_apply_process;
truncate table streams$_propagation_process;
truncate table streams$_process_params;
truncate table streams$_prepare_object;
truncate table streams$_prepare_ddl;
truncate table streams$_apply_milestone;
truncate table streams$_apply_progress;
truncate table streams$_key_columns;
truncate table streams$_def_proc;
truncate table streams$_rules;
truncate table apply$_source_obj;
truncate table apply$_source_schema;
truncate table apply$_dest_obj;
truncate table apply$_dest_obj_cmap;
truncate table apply$_dest_obj_ops;
truncate table apply$_error;
truncate table apply$_error_handler;
truncate table apply$_conf_hdlr_columns;

Rem
Rem End: truncate STREAMS dictionary table
Rem 

Rem
Rem delete from exppkgobj$ for rules engine objects
Rem 

delete from sys.exppkgobj$ 
where package = 'DBMS_RULE_EXP_EV_CTXS'
or    package = 'DBMS_RULE_EXP_RULE_SETS'
or    package = 'DBMS_RULE_EXP_RULES'
/

Rem
Rem End: delete from exppkgobj$ for rules engine objects
Rem 

Rem
Rem AQ 
Rem 

truncate table sys.aq$_replay_info;

Rem
Rem End: AQ 
Rem 

Rem clear out "has_rowmovement" bit from tab$ when downgrading
UPDATE tab$ SET trigflag = trigflag - 2097152
WHERE bitand(trigflag, 2097152) = 2097152;

Rem=========================================================================
Rem Remove changes to other SYS dictionary objects here 
Rem=========================================================================

drop view EXT_TO_OBJ_VIEW;
drop public synonym EXT_TO_OBJ;

drop type XDBURITYPE force;

Rem delete components from registry
delete from registry$;

drop type ODCIIndexInfo force;

Rem delete 9.2 additions to logmnr_interesting_cols
delete from logmnr_interesting_cols
   where oname in ('INDCOMPART$','INDPART$','INDSUBPART$','LOBFRAG$') ;

Rem ================================================================
Rem make index on exppkgobj$ unique
Rem ================================================================

drop index i_objtype
/
delete from sys.exppkgobj$
where package = 'DBMS_RULE_EXP_EV_CTXS'
or    package = 'DBMS_RULE_EXP_RULE_SETS'
or    package = 'DBMS_RULE_EXP_RULES'
/
create unique index i_objtype on exppkgobj$(type#)
/

Rem ================================================================
Rem End: make index on exppkgobj$ unique
Rem ================================================================

Rem  XMLSequence-related changes
drop public synonym XMLSequence;
drop operator XMLSequence;
drop function XMLCONCAT;
drop function XMLSequenceFromXMLType;
drop function XMLSequenceFromRefCursor2;
drop function XMLSequenceFromRefCursor;
drop type XMLSeqCur_Imp_t;
drop type XMLSeqCur2_Imp_t;
drop type XMLSEQ_IMP_T;
drop type XMLSEQUENCETYPE;

Rem  Changes for XMLType
drop public synonym xmltype;

alter type sys.XMLType
  DROP STATIC FUNCTION createXML (xmlData IN clob, schema IN varchar2,
                 validated IN number := 0, wellformed IN number := 0) 
                 return sys.XMLType deterministic,
  DROP STATIC FUNCTION createXML (xmlData IN varchar2, schema IN varchar2,
                 validated IN number := 0, wellformed IN number := 0) 
                 return sys.XMLType deterministic,
  DROP STATIC FUNCTION createXML (xmlData IN "<ADT_1>",
                 schema IN varchar2 := NULL, element IN varchar2 := NULL,
                 validated IN NUMBER := 1)
    return sys.XMLType deterministic,
  DROP STATIC FUNCTION createXML (xmlData IN SYS_REFCURSOR,
                 schema in varchar2 := NULL, element in varchar2 := NULL, 
                 validated in number := 1) 
     return sys.XMLType deterministic,
  -- new versions of extract and existsnode with nsmap
  DROP MEMBER FUNCTION extract(xpath IN varchar2, nsmap IN VARCHAR2)
    return sys.XMLType deterministic,
  DROP MEMBER FUNCTION existsNode(xpath in varchar2, nsmap in varchar2)
    return number deterministic,
  -- transform function
  DROP member function transform(xsl IN sys.XMLType,
                                parammap in varchar2 := NULL)
    return sys.XMLType deterministic,
  -- conversion functions
  DROP MEMBER PROCEDURE toObject(SELF in sys.XMLType, object OUT "<ADT_1>",
                                schema in varchar2 := NULL,
                                element in varchar2 := NULL),
  -- schema related functions
  DROP MEMBER FUNCTION isSchemaBased return number deterministic,
  DROP MEMBER FUNCTION getSchemaURL return varchar2 deterministic,
  DROP MEMBER FUNCTION getRootElement return varchar2 deterministic,
  -- create schema and nonschema based
  DROP MEMBER FUNCTION createSchemaBasedXML(schema IN varchar2 := NULL)
     return sys.XMLType deterministic,
  -- creates a non schema based document from self
  DROP MEMBER FUNCTION createNonSchemaBasedXML return sys.XMLType
    deterministic,
  DROP member function getNamespace return varchar2 deterministic,
  -- validates schema based document if VALIDATED flag is false
  DROP member procedure schemaValidate(self IN OUT NOCOPY XMLType),
  -- returns the value of the VALIDATED flag of the document; tells if
  -- a schema based doc. has been actually validated against its schema.
  DROP member function isSchemaValidated return NUMBER deterministic,
  -- sets the VALIDATED flag to user desired value
  DROP member procedure setSchemaValidated(self IN OUT NOCOPY XMLType, 
                                      flag IN BINARY_INTEGER := 1),
  -- checks if doc is conformant to a specified schema; non mutating
  DROP member function isSchemaValid(schurl IN VARCHAR2 := NULL, 
                         elem IN VARCHAR2 := NULL) return NUMBER deterministic,
  -- constructors
  DROP constructor function XMLType(xmlData IN clob,
                schema IN varchar2 := NULL, validated IN number := 0,
                wellformed IN number := 0) 
    return self as result deterministic,
  DROP constructor function XMLType(xmlData IN varchar2, 
                schema IN varchar2 := NULL, validated IN number := 0,
                wellformed IN number := 0) 
    return self as result deterministic,
  DROP constructor function XMLType (xmlData IN "<ADT_1>",
                schema IN varchar2 := NULL, element IN varchar2 := NULL,
                validated IN number := 1) 
    return self as result deterministic,
  DROP constructor function XMLType(xmlData IN SYS_REFCURSOR,
                schema in varchar2 := NULL, element in varchar2 := NULL, 
                validated in number := 1) 
    return self as result deterministic
CASCADE;

alter type sys.XMLType replace
  authid current_user as opaque varying (*) 
  using library xmltype_lib 
( 
  static function createXML (xmlData IN clob) return XMLType deterministic,
  static function createXML (xmlData IN varchar2) return XMLType deterministic,
  member function extract(xpath IN varchar2) return XMLType deterministic,
  member function existsNode(xpath IN varchar2) return number deterministic,
  member function isFragment return number deterministic,
  member function getClobVal return CLOB deterministic,
  member function getStringVal return varchar2 deterministic,
  member function getNumberVal return number deterministic
);

Rem  Changes for XMLGenFormatType
drop public synonym xmlformat;

alter type sys.XMLGenFormatType
  DROP CONSTRUCTOR FUNCTION XMLGenFormatType (
     enclTag IN varchar2 := 'ROWSET',
     schemaType IN varchar2 := 'NO_SCHEMA',
     schemaName IN varchar2 := null,
     targetNameSpace IN varchar2 := null,
     dbUrlPrefix IN varchar2 := null, 
     processingIns IN varchar2 := null) RETURN SELF AS RESULT
CASCADE;

alter type sys.XMLGenFormatType replace
  as object
(
  enclTag varchar2(4000),
  schemaType varchar2(100),
  schemaName varchar2(4000),
  targetNameSpace varchar2(4000),
  dbUrlPrefix varchar2(4000),
  processingIns varchar2(4000),
  STATIC FUNCTION createFormat(
     enclTag IN varchar2 := 'ROWSET',
     schemaType IN varchar2 := 'NO_SCHEMA',
     schemaName IN varchar2 := null,
     targetNameSpace IN varchar2 := null,
     dburlPrefix IN varchar2 := null, 
     processingIns IN varchar2 := null) RETURN XMLGenFormatType,
  MEMBER PROCEDURE genSchema (spec IN varchar2),
  MEMBER PROCEDURE setSchemaName(schemaName IN varchar2),
  MEMBER PROCEDURE setTargetNameSpace(targetNameSpace IN varchar2),
  MEMBER PROCEDURE setEnclosingElementName(enclTag IN varchar2), 
  MEMBER PROCEDURE setDbUrlPrefix(prefix IN varchar2),
  MEMBER PROCEDURE setProcessingIns(pi IN varchar2)
);

Rem  CHANGES FOR URI TYPES

drop public synonym uritype;
drop public synonym DBUritype;
drop public synonym FTPUritype;
drop public synonym XDBUritype;
drop public synonym HttpUritype;


Rem  Changes for ftpuritype
alter type sys.FtpUriType
  DROP overriding member function getXML return sys.XMLType,
  DROP constructor function FtpUriType(url in varchar2) return self
                                  as result,
  DROP overriding member function getContentType RETURN varchar2,
  DROP overriding member function getClob(content OUT varchar2)
    RETURN clob,
  DROP overriding member function getBlob(content OUT varchar2)
    RETURN blob,
  DROP overriding member function getXML(content OUT varchar2)
    RETURN sys.XMLType
CASCADE;

alter type sys.FtpUriType replace
  authid current_user under sys.UriType
(
  overriding member function getExternalUrl return varchar2,
  overriding member function getUrl return varchar2,
  overriding member function getClob RETURN clob,
  overriding member function getBlob RETURN blob,
  static function createFtpUri(ftpurl in varchar2) return ftpuritype
);

Rem  Changes for httpuritype
alter type sys.HttpUriType
  DROP overriding member function getXML return sys.XMLType,
  DROP constructor function HttpUriType(url in varchar2)
    return self as result,
  DROP overriding member function getContentType RETURN varchar2,
  DROP overriding member function getClob(content OUT varchar2)
    RETURN clob,
  DROP overriding member function getBlob(content OUT varchar2)
    RETURN blob,
  DROP overriding member function getXML(content OUT varchar2)
    RETURN sys.XMLType
CASCADE;

alter type sys.HttpUriType replace
  authid current_user under sys.UriType 
(
  overriding member function getExternalUrl return varchar2,
  overriding member function getUrl return varchar2,
  overriding member function getClob RETURN clob,
  overriding member function getBlob RETURN blob,
  static function createUri(httpuri in varchar2) return httpuritype
);

Rem  Changes for dburitype
alter type sys.DBUriType
  DROP overriding member function getXML return sys.XMLType,
  DROP constructor function DBUriType(url in varchar2, spare in raw := null)
    return self as result,
  DROP overriding member function getContentType RETURN varchar2,
  DROP overriding member function getClob(content OUT varchar2)
    RETURN clob,
  DROP overriding member function getBlob(content OUT varchar2)
    RETURN blob,
  DROP overriding member function getXML(content OUT varchar2)
    RETURN sys.XMLType
CASCADE;

alter type sys.DBUriType replace
  authid current_user under sys.UriType 
(
  spare raw(2000),
  overriding member function getExternalUrl return varchar2,
  overriding member function getUrl return varchar2,
  overriding member function getClob RETURN clob,
  overriding member function getBlob RETURN blob,
  static function createuri(dburi in varchar2) return dburitype
);

Rem  Changes for uritype
alter type sys.UriType
  DROP member function getXML return sys.XMLType,
  DROP member function getContentType RETURN varchar2,
  DROP member function getClob(content OUT varchar2) RETURN clob,
  DROP member function getBlob(content OUT varchar2) RETURN blob,
  DROP member function getXML(content OUT varchar2) RETURN sys.XMLType
CASCADE;

alter type sys.UriType replace
 authid current_user as object
(
  url varchar2(4000),
  not instantiable member function getClob RETURN clob,
  member function getExternalUrl RETURN varchar2,
  member function getUrl RETURN varchar2,
  not instantiable member function getBlob RETURN blob
) not final not instantiable;

Rem Changes for AnyType, AnyData, AnyDataSet
drop public synonym AnyType;

drop public synonym AnyData;

drop public synonym AnyDataSet;

alter type SYS.AnyData
  DROP STATIC FUNCTION ConvertTimestamp(ts IN TIMESTAMP) return AnyData,
  DROP STATIC FUNCTION ConvertTimestampTZ(ts IN TIMESTAMP WITH TIME ZONE)
        return AnyData,
  DROP STATIC FUNCTION ConvertTimestampLTZ
                          (ts IN TIMESTAMP WITH LOCAL TIME ZONE)
        return AnyData,
  DROP STATIC FUNCTION ConvertIntervalYM(inv IN INTERVAL YEAR TO MONTH)
        return AnyData,
  DROP STATIC FUNCTION ConvertIntervalDS(inv IN INTERVAL DAY TO SECOND)
        return AnyData,
  DROP STATIC FUNCTION ConvertNchar(nc IN NCHAR) return AnyData,
  DROP STATIC FUNCTION ConvertNVarchar2(nc IN NVARCHAR2) return AnyData,
  DROP STATIC FUNCTION ConvertNClob(nc IN NCLOB) return AnyData,
  DROP MEMBER PROCEDURE SetTimestamp(self IN OUT NOCOPY AnyData,
            ts IN TIMESTAMP, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetTimestampTZ(self IN OUT NOCOPY AnyData, 
                    ts IN TIMESTAMP WITH TIME ZONE,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetTimestampLTZ(self IN OUT NOCOPY AnyData,
                    ts IN TIMESTAMP WITH LOCAL TIME ZONE,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetIntervalYM(self IN OUT NOCOPY AnyData,
                    inv IN INTERVAL YEAR TO MONTH,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetIntervalDS(self IN OUT NOCOPY AnyData,
                    inv IN INTERVAL DAY TO SECOND,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetNchar(self IN OUT NOCOPY AnyData,
                    nc IN NCHAR, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetNVarchar2(self IN OUT NOCOPY AnyData,
                    nc IN NVarchar2, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetNClob(self IN OUT NOCOPY AnyData,
                    nc IN NClob, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER FUNCTION GetTimestamp(self IN AnyData, ts OUT NOCOPY TIMESTAMP)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION GetTimestampTZ(self IN AnyData, 
       ts OUT NOCOPY TIMESTAMP WITH TIME ZONE) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetTimestampLTZ(self IN AnyData,
       ts OUT NOCOPY TIMESTAMP WITH LOCAL TIME ZONE) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetIntervalYM(self IN AnyData,
       inv IN OUT NOCOPY INTERVAL YEAR TO MONTH) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetIntervalDS(self IN AnyData,
       inv IN OUT NOCOPY INTERVAL DAY TO SECOND) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetNchar(self IN AnyData, nc OUT NOCOPY NCHAR)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION GetNVarchar2(self IN AnyData, nc OUT NOCOPY NVARCHAR2)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION GetNClob(self IN AnyData, nc OUT NOCOPY NCLOB)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION AccessNumber(self IN AnyData) return NUMBER,
  DROP MEMBER FUNCTION AccessDate(self IN AnyData) return DATE,
  DROP MEMBER FUNCTION AccessChar(self IN AnyData) return CHAR,
  DROP MEMBER FUNCTION AccessVarchar(self IN AnyData) return VARCHAR,
  DROP MEMBER FUNCTION AccessVarchar2(self IN AnyData) return VARCHAR2,
  DROP MEMBER FUNCTION AccessRaw(self IN AnyData) return RAW,
  DROP MEMBER FUNCTION AccessBlob(self IN AnyData) return BLOB,
  DROP MEMBER FUNCTION AccessClob(self IN AnyData) return CLOB,
  DROP MEMBER FUNCTION AccessBfile(self IN AnyData) return BFILE,
  DROP MEMBER FUNCTION AccessTimestamp(self IN AnyData) return TIMESTAMP,
  DROP MEMBER FUNCTION AccessTimestampTZ(self IN AnyData)
         return TIMESTAMP WITH TIME ZONE,
  DROP MEMBER FUNCTION AccessTimestampLTZ(self IN AnyData)
         return TIMESTAMP WITH LOCAL TIME ZONE,
  DROP MEMBER FUNCTION AccessIntervalYM(self IN AnyData)
         return INTERVAL YEAR TO MONTH,
  DROP MEMBER FUNCTION AccessIntervalDS(self IN AnyData)
         return INTERVAL DAY TO SECOND,
  DROP MEMBER FUNCTION AccessNchar(self IN AnyData) return NCHAR,
  DROP MEMBER FUNCTION AccessNVarchar2(self IN AnyData) return NVARCHAR2,
  DROP MEMBER FUNCTION AccessNClob(self IN AnyData) return NCLOB
CASCADE;

ALTER TYPE SYS.AnyData REPLACE
as OPAQUE VARYING (*)
USING library DBMS_ANYDATA_LIB
(
  /* CONSTRUCTION */
  /* There are 2 ways to construct an AnyData. The Convert*() calls
     enable construction of the AnyData in its entirity with a single call.
     They serve as explicit CAST functions from any type in the Oracle ORDBMS
     to SYS.AnyData.
  */
  STATIC FUNCTION ConvertNumber(num IN NUMBER) return AnyData,
  STATIC FUNCTION ConvertDate(dat IN DATE) return AnyData,
  STATIC FUNCTION ConvertChar(c IN CHAR) return AnyData,
  STATIC FUNCTION ConvertVarchar(c IN VARCHAR) return AnyData,
  STATIC FUNCTION ConvertVarchar2(c IN VARCHAR2) return AnyData,
  STATIC FUNCTION ConvertRaw(r IN RAW) return AnyData,
  STATIC FUNCTION ConvertBlob(b IN BLOB) return AnyData,
  STATIC FUNCTION ConvertClob(c IN CLOB) return AnyData,
  STATIC FUNCTION ConvertBfile(b IN BFILE) return AnyData,
  STATIC FUNCTION ConvertObject(obj IN "<ADT_1>") return AnyData,
  STATIC FUNCTION ConvertObject(obj IN "<OPAQUE_1>") return AnyData,
  STATIC FUNCTION ConvertRef(rf IN REF "<ADT_1>") return AnyData,
  STATIC FUNCTION ConvertCollection(col IN "<COLLECTION_1>") return AnyData,
  /* The 2nd way to construct an AnyData is a piece by piece approach. The 
     BeginCreate() call begins the construction process and
     EndCreate() call finishes the construction process..
     In between these 2 calls, the individual attributes of an Object Type or
     the elements of a Collection can be set using Set*()calls.
     For piece by piece access of the attributes of Objects and elements of
     Collections, the PieceWise() call should be invoked prior to
     Get*() calls.
     Note: The AnyData has to be constructed or accessed sequentially starting
     from its first attribute(or collection element).
     The BeginCreate() call automatically begins the construction in a
     piece-wise mode. There is no need to call PieceWise() immediately
     after BeginCreate().
     EndCreate should be called to finish the construction
     process (before which no access calls can be made).
  */ 
  /* NAME
         BeginCreate
     DESCRIPTION
         Begins creation process on a new AnyData.
     PARAMETERS
         dtype - The Type of the AnyData. (should correspond to
                                           OCI_TYPECODE_OBJECT or
                                           a Collection typecode.)
         adata - AnyData being constructed.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
           dtype is invalid (not fully constructed etc.).
     NOTE
         There is NO NEED to call PieceWise() immediately after this
     call. Automatically the construction process begins in a piece-wise
     manner.
  */
  STATIC PROCEDURE BeginCreate(dtype IN OUT NOCOPY AnyType,
                               adata OUT NOCOPY AnyData),
  /* NAME
         PieceWise.
     DESCRIPTION
         This call sets the MODE of access of the current data value to
         be an attribute at a time (if the data value is of TYPECODE_OBJECT).
         It sets the MODE of access of the data value to be a
         collection element at a time (if the data value is of
         collection TYPE). Once this call has been made, subsequent
         Set*'s and Get*'s will sequentially obtain
         individual attributes or collection elements.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
         - DBMS_TYPES.incorrect_usage
           On incorrect usage.
     NOTE
         The current data value must be of an OBJECT or COLLECTION type before
         this call can be made.
         Piece-wise construction and access of nested attributes that are of
         object or collection types is not supported. 
  */
  MEMBER PROCEDURE PieceWise(self IN OUT NOCOPY AnyData),
  /* NAME
         SetNumber, SetDate etc.
     DESCRIPTION
         Sets the current data value.
         This is a list of procedures that should be called depending on the
         type of the current data value.
         The type of the data value should be the type of the attribute at the
         current position during the piece-wise construction process.
         NOTE - When BeginCreate() is called, construction has already
                begun in a piece-wise fashion. Subsequent calls to
                Set*() will set the successive attribute values.
                If the AnyData is a standalone collection, the
                Set*() call will set the successive collection
                elements.
     PARAMETERS
         num - The Number that needs to be set. etc.
         last_elem - This parameter is relevant only if AnyData represents a
                     a collection.
                     Set to TRUE if it is the last element of the collection,
                     FALSE otherwise.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
           Invalid Parameters (if it is not appropriate to add a number
                               at this point in the creation process).
         - DBMS_TYPES.incorrect_usage
           Incorrect usage
         - DBMS_TYPES.type_mismatch
           When the expected type is different from the passed in type.
     NOTE
         Sets the current data value.
  */
  MEMBER PROCEDURE SetNumber(self IN OUT NOCOPY AnyData, num IN NUMBER,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetDate(self IN OUT NOCOPY AnyData, dat IN DATE,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetChar(self IN OUT NOCOPY AnyData, c IN CHAR,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetVarchar(self IN OUT NOCOPY AnyData, c IN VARCHAR,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetVarchar2(self IN OUT NOCOPY AnyData,
                    c IN VARCHAR2, last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetRaw(self IN OUT NOCOPY AnyData, r IN RAW,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetBlob(self IN OUT NOCOPY AnyData, b IN BLOB,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetClob(self IN OUT NOCOPY AnyData, c IN CLOB,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetBfile(self IN OUT NOCOPY AnyData, b IN BFILE,
                    last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetObject(self IN OUT NOCOPY AnyData,
                    obj IN "<ADT_1>", last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetObject(self IN OUT NOCOPY AnyData,
                    obj IN "<OPAQUE_1>", last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetRef(self IN OUT NOCOPY AnyData,
                    rf IN REF "<ADT_1>", last_elem IN boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetCollection(self IN OUT NOCOPY AnyData,
                    col IN "<COLLECTION_1>", last_elem IN boolean DEFAULT FALSE),
  /*
     NAME
          EndCreate
     DESCRIPTION
          Ends Creation of a AnyData. Other creation functions cannot be
          called after this call.
  */
  MEMBER PROCEDURE EndCreate(self IN OUT NOCOPY AnyData),
  /* ----------------------------------------------------------------------- */
  /* ACCESSORS */
  /* ----------------------------------------------------------------------- */
  /* 
     NAME
          GetTypeName
     DESCRIPTION
          Get the fully qualified Type Name for the AnyData.
          If the AnyData is based on a builtin, this function will return
          NUMBER etc.
          If it is based on a user defined type, this function will return 
          <schema_name>.<type_name>. e.g. SCOTT.FOO.
          If it is based on a transient anonymous type, this function will
          return NULL.     
     RETURNS
          Type name of the AnyData.
  */
  MEMBER FUNCTION GetTypeName(self IN AnyData) return VARCHAR2,
  /* NAME
         GetType
     DESCRIPTION
         Gets the Type of the AnyData.
     PARAMETERS
         typ (OUT) - The AnyType corresponding to the AnyData. May be NULL
                     if it does not represent a user-defined type.
     RETURNS
         The typecode corresponding to the type of the AnyData.
     EXCEPTIONS
  */
  MEMBER FUNCTION GetType(self IN AnyData, typ OUT NOCOPY AnyType)
      return PLS_INTEGER,
  /* NAME
         Get*()
     DESCRIPTION
         Gets the current data value (which should be of appropriate type)
         The type of the current data value depends on the MODE with which
         we are accessing (Depending on whether we have invoked the
         PieceWise() call).
         If PieceWise() has NOT been called, we are accessing the
         AnyData in its entirety and the type of the data value should match
         the type of the AnyData.
         If PieceWise() has been called, we are accessing the
         AnyData piece wise. The type of the data value should match the type
         of the attribute (or collection element) at the current position.
     PARAMETERS
         num - The Number that needs to be got. etc.
     RETURNS
         DBMS_TYPES.SUCCESS or DBMS_TYPES.NO_DATA
         The return value is relevant only if PieceWise
         has been already called (for a collection). In such a case,
         DBMS_TYPES.NO_DATA signifies the end of the collection when all
         elements have been accessed.
     EXCEPTIONS
         - DBMS_TYPES.type_mismatch
           When the expected type is different from the passed in type.
         - DBMS_TYPES.invalid_parameters
           Invalid Parameters (if it is not appropriate to add a number
                               at this point in the creation process).
         - DBMS_TYPES.incorrect_usage
           Incorrect usage.
  */
  MEMBER FUNCTION GetNumber(self IN AnyData, num OUT NOCOPY NUMBER)
              return PLS_INTEGER,
  MEMBER FUNCTION GetDate(self IN AnyData, dat OUT NOCOPY DATE)
              return PLS_INTEGER,
  MEMBER FUNCTION GetChar(self IN AnyData, c OUT NOCOPY CHAR)
              return PLS_INTEGER,
  MEMBER FUNCTION GetVarchar(self IN AnyData, c OUT NOCOPY VARCHAR)
              return PLS_INTEGER,
  MEMBER FUNCTION GetVarchar2(self IN AnyData, c OUT NOCOPY VARCHAR2)
              return PLS_INTEGER,
  MEMBER FUNCTION GetRaw(self IN AnyData, r OUT NOCOPY RAW)
              return PLS_INTEGER,
  MEMBER FUNCTION GetBlob(self IN AnyData, b OUT NOCOPY BLOB)
              return PLS_INTEGER,
  MEMBER FUNCTION GetClob(self IN AnyData, c OUT NOCOPY CLOB)
              return PLS_INTEGER,
  MEMBER FUNCTION GetBfile(self IN AnyData, b OUT NOCOPY BFILE)
              return PLS_INTEGER,
  MEMBER FUNCTION GetObject(self IN AnyData, obj OUT NOCOPY "<ADT_1>")
              return PLS_INTEGER,
  MEMBER FUNCTION GetObject(self IN AnyData, obj OUT NOCOPY "<OPAQUE_1>")
              return PLS_INTEGER,
  MEMBER FUNCTION GetRef(self IN AnyData, rf OUT NOCOPY REF "<ADT_1>")
              return PLS_INTEGER,
  MEMBER FUNCTION GetCollection(self IN AnyData,
                                col OUT NOCOPY "<COLLECTION_1>") 
                                return PLS_INTEGER
);

alter type SYS.AnyDataSet
  DROP MEMBER PROCEDURE SetTimestamp(self IN OUT NOCOPY AnyDataSet,
                    ts IN TIMESTAMP,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetTimestampTZ(self IN OUT NOCOPY AnyDataSet, 
                    ts IN TIMESTAMP WITH TIME ZONE,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetTimestampLTZ(self IN OUT NOCOPY AnyDataSet,
                    ts IN TIMESTAMP WITH LOCAL TIME ZONE,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetIntervalYM(self IN OUT NOCOPY AnyDataSet,
                    inv IN INTERVAL YEAR TO MONTH,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetIntervalDS(self IN OUT NOCOPY AnyDataSet,
                    inv IN INTERVAL DAY TO SECOND,
                    last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetNchar(self IN OUT NOCOPY AnyDataSet,
                    nc IN NCHAR, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetNVarchar2(self IN OUT NOCOPY AnyDataSet,
                    nc IN NVarchar2, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER PROCEDURE SetNClob(self IN OUT NOCOPY AnyDataSet,
                    nc IN NClob, last_elem IN boolean DEFAULT FALSE),
  DROP MEMBER FUNCTION GetTimestamp(self IN AnyDataSet,ts OUT NOCOPY TIMESTAMP)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION GetTimestampTZ(self IN AnyDataSet, 
       ts OUT NOCOPY TIMESTAMP WITH TIME ZONE) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetTimestampLTZ(self IN AnyDataSet,
       ts OUT NOCOPY TIMESTAMP WITH LOCAL TIME ZONE) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetIntervalYM(self IN AnyDataSet,
       inv IN OUT NOCOPY INTERVAL YEAR TO MONTH) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetIntervalDS(self IN AnyDataSet,
       inv IN OUT NOCOPY INTERVAL DAY TO SECOND) return PLS_INTEGER,
  DROP MEMBER FUNCTION GetNchar(self IN AnyDataSet, nc OUT NOCOPY NCHAR)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION GetNVarchar2(self IN AnyDataSet,nc OUT NOCOPY NVARCHAR2)
       return PLS_INTEGER,
  DROP MEMBER FUNCTION GetNClob(self IN AnyDataSet, nc OUT NOCOPY NCLOB)
       return PLS_INTEGER
CASCADE;

ALTER TYPE SYS.AnyDataSet REPLACE
as OPAQUE VARYING (*)
USING library DBMS_ANYDATASET_LIB
(
/* CONSTRUCTION */
  /* NOTE - The AnyDataSet needs to be contructed value by value sequentially. 
            For each data instance (of the type of the AnyDataSet),
            the AddInstance() function need to be invoked.
            This adds a new data instance to the AnyDataSet.
            Subsequently, Set*() can be called to set each value
            in its entirety.
            The MODE of construction/access can be changed to attribute/
            collection element wise by making calls to PieceWise()
             - If the type of the AnyDataSet is TYPECODE_OBJECT,
               individual attributes will be set with subsequent
               Set*() calls. Likewise on access.
             - If the type of the current data value is a collection type
               individual collection elements will be set with subsequent
               Set*() calls. Likewise on access.
            This call is very similar to AnyData.PieceWise() call defined for
            the type SYS.AnyData.
            NOTE - There is no support for piecewise construction and access
                   of nested (not top level) attributes that are of object
                   types or collection types.
            EndCreate should be called to finish the construction
            process (before which no access calls can be made).
  */
  /* NAME
         BeginCreate
     DESCRIPTION
         Creates a new AnyDataSet which can be used to create a Set of data
         values of the given ANYTYPE.
     PARAMETERS
         typecode - the typecode for the type of the AnyDataSet
         dtype - The Type of the data values. This parameter is a must for
                 user-defined types like TYPECODE_OBJECT, Collection typecodes
                 etc.
         aset - The AnyDataSet being constructed.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
           dtype is invalid (not fully constructed etc.).
  */
  STATIC PROCEDURE BeginCreate(typecode IN PLS_INTEGER,
           rtype IN OUT NOCOPY AnyType, aset OUT NOCOPY AnyDataSet),
  /* NAME
         AddInstance.
     DESCRIPTION
         Add a new data instance to a AnyDataSet.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
         - DBMS_TYPES.incorrect_usage
           On incorrect usage.
     NOTE
         The data instances have to be added sequentially. The previous data
         instance must be fully constructed (or set to null) before a new one
         can be added.
         This call DOES NOT automatically set the mode of construction to be
         piece-wise. The user has to explicitly call PieceWise() if a
         piece-wise construction of the instance is intended.
  */
  MEMBER PROCEDURE AddInstance(self IN OUT NOCOPY AnyDataSet),
  /* NAME
         PieceWise.
     DESCRIPTION
         This call sets the MODE of construction, access of the data value to
         be an attribute at a time (if the data value is of TYPECODE_OBJECT).
         It sets the MODE of construction, access of the data value to be a
         collection element at a time (if the data value is of
         collection TYPE). Once this call has been made, subsequent
         Set*'s and Get* will sequentially obtain
         individual attributes or collection elements.
    EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
         - DBMS_TYPES.incorrect_usage
           On incorrect usage.
    NOTE
         The current data value must be of an OBJECT or COLLECTION type before
         this call can be made. There is no support for piece-wise
         construction or access of embedded object type attributes (or nested
         collections).
  */
  MEMBER PROCEDURE PieceWise(self IN OUT NOCOPY AnyDataSet),
  /* NAME
         Set*.
     DESCRIPTION
         Sets the current data value.
         The type of the current data value depends on the MODE with which
         we are constructing (Depending on how we have invoked the
         PieceWise() call).
         The type of the current data should be the type of the
         AnyDataSet if PieceWise() has NOT been called. The type
         should be the type of the attribute at the current position if
         PieceWise() has been called.
     PARAMETERS
         num - The Number that needs to be set. etc.
         last_elem - This parameter is relevant only if PieceWise()
                     has been already called (for a collection).
                     Set to TRUE if it is the last element of the collection,
                     FALSE otherwise.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
           Invalid Parameters (if it is not appropriate to add a number
                               at this point in the creation process).
         - DBMS_TYPES.incorrect_usage
           Incorrect usage.
         - DBMS_TYPES.type_mismatch
           When the expected type is different from the passed in type.
     NOTE
         Sets the current data value.
  */
  MEMBER PROCEDURE SetNumber(self IN OUT NOCOPY AnyDataSet,
             num IN NUMBER, last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetDate(self IN OUT NOCOPY AnyDataSet,
             dat IN DATE, last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetChar(self IN OUT NOCOPY AnyDataSet, c IN CHAR,
             last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetVarchar(self IN OUT NOCOPY AnyDataSet,
             c IN VARCHAR, last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetVarchar2(self IN OUT NOCOPY AnyDataSet,
             c IN VARCHAR2, last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetRaw(self IN OUT NOCOPY AnyDataSet, r IN RAW,
             last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetBlob(self IN OUT NOCOPY AnyDataSet, b IN BLOB,
             last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetClob(self IN OUT NOCOPY AnyDataSet, c IN CLOB,
             last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetBfile(self IN OUT NOCOPY AnyDataSet,
             b IN BFILE, last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetObject(self IN OUT NOCOPY AnyDataSet,
             obj IN "<ADT_1>", last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetObject(self IN OUT NOCOPY AnyDataSet,
             obj IN "<OPAQUE_1>", last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetRef(self IN OUT NOCOPY AnyDataSet,
             rf IN REF "<ADT_1>", last_elem boolean DEFAULT FALSE),
  MEMBER PROCEDURE SetCollection(self IN OUT NOCOPY AnyDataSet,
             col IN "<COLLECTION_1>", last_elem boolean DEFAULT FALSE),
  /*
     NAME
          EndCreate
     DESCRIPTION
          Ends Creation of a AnyDataSet. Other creation functions cannot be
          called after this call.
  */
  MEMBER PROCEDURE EndCreate(self IN OUT NOCOPY AnyDataSet),
  /* ----------------------------------------------------------------------- */
  /* ACCESSORS */
  /* ----------------------------------------------------------------------- */
  /* 
     NAME
          GetTypeName
     DESCRIPTION
          Get the fully qualified Type Name for the AnyDataSet.
          If the AnyDataSet is based on a builtin, this function will return
          NUMBER etc.
          If it is based on a user defined type, this function will return 
          <schema_name>.<type_name>. e.g. SCOTT.FOO.
          If it is based on a transient anonymous type, this function will
          return NULL.
     RETURNS
          Type name of the AnyDataSet.
  */
  MEMBER FUNCTION GetTypeName(self IN AnyDataSet) return VARCHAR2,
  /* NAME
         GetType
     DESCRIPTION
         Gets the AnyType describing the type of the data instances in an
         AnyDataSet.
     PARAMETER
         typ (OUT) - The AnyType corresponding to the AnyData. May be NULL
                     if it does not represent a user-defined type.
     RETURNS
         The typecode corresponding to the type of the AnyData. 
     EXCEPTIONS
  */
  MEMBER FUNCTION GetType(self IN AnyDataSet, typ OUT NOCOPY AnyType)
           return PLS_INTEGER,
  /* NAME
         GetInstance
     DESCRIPTION
         Get's the next instance in an AnyDataSet. Only sequential access to
         the instances in an AnyDataSet is allowed. After this function has
         been called, the Get*() functions can be invoked on the
         AnyDataSet to access the current instance. If PieceWise() is called
         before doing the Get*() calls, the individual attributes
         (or collection elements) can be accessed. It is an error to invoke
          this function before the AnyDataSet is fully created.
     PARAMETERS
         self (IN OUT )   - The AnyDataSet being accessed.
         return          - DBMS_TYPES.SUCCESS or DBMS_TYPES.NO_DATA. 
                           DBMS_TYPES.NO_DATA signifies the end of the
                           AnyDataSet when all instances have been accessed.
     NOTE
         This function should be called even before accessing the 1st
         instance.
  */
  MEMBER FUNCTION GetInstance(self IN OUT NOCOPY AnyDataSet)
            return PLS_INTEGER,
  /* NAME
         Get*.
     DESCRIPTION
         Gets the current data value (which should be of appropriate type)
         The type of the current data value depends on the MODE with which
         we are accessing (Depending on how we have invoked the
         PieceWise() call).
         If PieceWise() has NOT been called, we are accessing the
         instance in its entirety and the type of the data value should match
         the type of the AnyDataSet.
         If PieceWise() has been called, we are accessing the
         instance piece wise. The type of the data value should match the type
         of the attribute (or collection element) at the current position.
     PARAMETERS
         num - The Number that needs to be got. etc.
     RETURNS
         DBMS_TYPES.SUCCESS or DBMS_TYPES.NO_DATA
         The return value is relevant only if PieceWise
         has been already called (for a collection). In such a case,
         DBMS_TYPES.NO_DATA signifies the end of the collection when all
         elements have been accessed.
     EXCEPTIONS
         - DBMS_TYPES.invalid_parameters
           Invalid Parameters (if it is not appropriate to add a number
                               at this point in the creation process).
         - DBMS_TYPES.incorrect_usage
           Incorrect usage.
         - DBMS_TYPES.type_mismatch
           When the expected type is different from the passed in type.
  */
  MEMBER FUNCTION GetNumber(self IN AnyDataSet, num OUT NOCOPY NUMBER)
              return PLS_INTEGER,
  MEMBER FUNCTION GetDate(self IN AnyDataSet, dat OUT NOCOPY DATE)
              return PLS_INTEGER,
  MEMBER FUNCTION GetChar(self IN AnyDataSet, c OUT NOCOPY CHAR)
              return PLS_INTEGER,
  MEMBER FUNCTION GetVarchar(self IN AnyDataSet, c OUT NOCOPY VARCHAR)
              return PLS_INTEGER,
  MEMBER FUNCTION GetVarchar2(self IN AnyDataSet, c OUT NOCOPY VARCHAR2)
              return PLS_INTEGER,
  MEMBER FUNCTION GetRaw(self IN AnyDataSet, r OUT NOCOPY RAW)
              return PLS_INTEGER,
  MEMBER FUNCTION GetBlob(self IN AnyDataSet, b OUT NOCOPY BLOB)
              return PLS_INTEGER,
  MEMBER FUNCTION GetClob(self IN AnyDataSet, c OUT NOCOPY CLOB)
              return PLS_INTEGER,
  MEMBER FUNCTION GetBfile(self IN AnyDataSet, b OUT NOCOPY BFILE)
              return PLS_INTEGER,
  MEMBER FUNCTION GetObject(self IN AnyDataSet, obj OUT NOCOPY "<ADT_1>")
              return PLS_INTEGER,
  MEMBER FUNCTION GetObject(self IN AnyDataSet, obj OUT NOCOPY "<OPAQUE_1>")
              return PLS_INTEGER,
  MEMBER FUNCTION GetRef(self IN AnyDataSet, rf OUT NOCOPY REF "<ADT_1>")
              return PLS_INTEGER,
  MEMBER FUNCTION GetCollection(self IN AnyDataSet,
              col OUT NOCOPY "<COLLECTION_1>") return PLS_INTEGER,
  /* NAME
         GetCount
     DESCRIPTION
         Gets the number of data instances in a AnyDataSet.
     PARAMETERS
     EXCEPTIONS
         None.
  */
  MEMBER FUNCTION GetCount(self IN AnyDataSet) return PLS_INTEGER
);
show errors

Rem
Rem drop STREAMS types
Rem 

drop type lcr$_row_unit force;
drop type lcr$_row_list force;
drop type lcr$_row_record force;
drop type lcr$_ddl_record force;
drop type lcr$_procedure_parameter force;
drop type lcr$_parameter_list force;
drop type lcr$_procedure_record force;

Rem Drop LDAP packages
drop library DBMS_LDAP_API_LIB;
drop package DBMS_LDAP_API_FFI;
drop package DBMS_LDAP;
drop public synonym DBMS_LDAP;
drop package DBMS_LDAP_UTL;
drop public synonym DBMS_LDAP_UTL;


Rem
Rem End: drop STREAMS types
Rem 

Rem
Rem drop rules engine types/tables
Rem 
drop type sys.re$rule_hit_list force
/
drop type sys.re$rule_hit force
/
drop type sys.re$attribute_value_list force
/
drop type sys.re$attribute_value force
/
drop type sys.re$variable_value_list force
/
drop type sys.re$variable_value force
/
drop type sys.re$column_value_list force
/
drop type sys.re$column_value force
/
drop type sys.re$table_value_list force
/
drop type sys.re$table_value force
/
drop type sys.re$variable_type_list force
/
drop type sys.re$variable_type force
/
drop type sys.re$table_alias_list force
/
drop type sys.re$table_alias force
/
truncate table sys.rec_var$
/
truncate table sys.rec_tab$ 
/
truncate table sys.rule_ec$
/
truncate table sys.rule_map$
/
drop table sys.rule$ force
/
truncate table sys.rule_set$
/
drop type sys.re$nv_list force
/
drop type sys.re$nv_array force
/
drop type sys.re$nv_node force
/

Rem
Rem End: drop rules engine types/tables
Rem 

Rem =========================================================================
Rem BEGIN Metadata API downgrade
Rem =========================================================================

Rem Remove Metadata API views, types, synonyms, rows in catalog tables, etc.
@@catnomet

Rem =========================================================================
Rem END Metadata API downgrade
Rem =========================================================================

Rem=========================================================================
Rem Remove changes to SYSTEM objects here 
Rem=========================================================================

Rem Summary Advisor downgrade
delete from system.mview$_adv_info;
commit;

Rem =========================================================================
Rem END STAGE 2: downgrade dictionary from 9.2.0 to 9.0.1
Rem =========================================================================
Rem =========================================================================
Rem BEGIN STAGE 3: 9.2 Clean up Types
Rem =========================================================================

Rem Clean up source$ by removing CONSTRUCTOR and associated keywords

EXECUTE dbms_type_utility.Delete_Constructor_Keyword; 

Rem Delete removed evaluation context objects (cause SMON ORA-00600: [16224])
delete from obj$ where type#=10 and name like 'AQ$_%_V';
commit;
 
Rem =========================================================================
Rem END STAGE 3: 9.0 System Types removal
Rem =========================================================================

Rem *************************************************************************
Rem END e0900010.sql
Rem *************************************************************************
