Rem $Header: f0801070.sql 21-aug-2002.08:57:56 rburns Exp $
Rem
Rem f0801070.sql
Rem
Rem Copyright (c) 1999, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      f0801070.sql - downgrade components from current release to 8.1.7
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      08/21/02 - drop new 901 queues
Rem    rburns      05/28/02 - bug 2293968 - CATJAVA downgrade
Rem    rburns      02/21/02 - remove non-integrated components
Rem    rburns      12/07/01 - add more components
Rem    rburns      11/14/01 - add RAC
Rem    shwong      10/26/01 - add OLS
Rem    rburns      10/17/01 - remove jis and jsp
Rem    rburns      09/27/01 - revise conditional scripts
Rem    rburns      09/25/01 - conditional scripts
Rem    rburns      06/06/01 - add 9.0.1 downgrade
Rem    rburns      05/05/01 - more dropjava
Rem    rburns      05/03/01 - add dropjava for rdbms features
Rem    btao        05/04/01 - Drop java classes for QSMA
Rem    wnorcott    04/30/01 - Drop java for CDC.
Rem    nbhatt      04/30/01 - add rmaqhp.sql 
Rem    rburns      02/08/01 - add xml removal script
Rem    rburns      01/31/01 - Merged rburns_java_downgrade
Rem    rburns      01/26/01 - Created

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade from the current release to 9.0.1
Rem =========================================================================

@@f0900010

Rem =========================================================================
Rem END STAGE 1: downgrade from the current release to 9.0.1
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade from 9.0.1 to 8.1.7
Rem =========================================================================

Rem =========================================================================
Rem BEGIN drop Java classes for 9.0 features
Rem =========================================================================

BEGIN
   IF dbms_registry.status('CATJAVA') NOT IN ('REMOVED') THEN
      dbms_registry.downgrading('CATJAVA');
--    If CATJAVA is installed, then drop new 9.0 classes
--    Drop QSMA classes
      EXECUTE IMMEDIATE 'call sys.dbms_java.dropjava(''-s rdbms/jlib/qsma.jar'')';
--    Drop CDC classes
      EXECUTE IMMEDIATE 'call sys.dbms_java.dropjava(''-s rdbms/jlib/CDC.jar'')';
--    Drop SQLJ classes
      EXECUTE IMMEDIATE 
         'call sys.dbms_java.dropjava(''-s rdbms/jlib/sqljtype.jar'')';
--    Drop XDB classes
      EXECUTE IMMEDIATE 
         'call sys.dbms_java.dropjava(''-s rdbms/jlib/xdb_g.jar'')';
      EXECUTE IMMEDIATE 
         'call sys.dbms_java.dropjava(''-s rdbms/jlib/OraDbUri.jar'')';
--    Drop APP CTX classes
      EXECUTE IMMEDIATE 
          'call sys.dbms_java.dropjava(''-s rdbms/jlib/appctxapi.jar'')';
--    Rem Drop the aqhttp propagation classes
      EXECUTE IMMEDIATE 
          'call sys.dbms_java.dropjava(''-s rdbms/jlib/aqprop.jar'')';
      dbms_registry.downgraded('CATJAVA','8.1.7.0.0');
   END IF;
END;
/

Rem =========================================================================
Rem END drop Java classes for 9.0 features
Rem =========================================================================

Rem ================================================================
Rem BEGIN drop new 901 AQ objects 
Rem       (before 920 AQ types are dropped in RDBMS downgrade)
Rem ================================================================

BEGIN
  dbms_aqadm.drop_queue_table('AQ_EVENT_TABLE', TRUE);
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE = -24002 THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
   dbms_aqadm.drop_queue_table('AQ_SRVNTFN_TABLE', TRUE);
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE = -24002 THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

Rem ================================================================
Rem END drop new 901 AQ objects
Rem ================================================================

Rem =========================================================================
Rem BEGIN Component downgrade scripts
Rem =========================================================================

Rem Downgrade XML
SELECT dbms_registry.script('XML','xmle817.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade JAVAVM
SELECT dbms_registry.script('JAVAVM','jvme817.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade OLS
SELECT dbms_registry.script('OLS','olse817.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade RAC (no dictionary objects)
BEGIN
   IF dbms_registry.status('RAC') IS NOT NULL THEN
      dbms_registry.downgraded('RAC','8.1.7.0.0');
   END IF;
END;
/

Rem =========================================================================
Rem END Component downgrade scripts
Rem =========================================================================

Rem =========================================================================
Rem END STAGE 2: downgrade from 9.0.1 to 8.1.7
Rem =========================================================================

Rem *************************************************************************
Rem END f0801070.sql
Rem *************************************************************************

