Rem $Header: f0900010.sql 28-may-2002.10:35:15 rburns Exp $
Rem
Rem f0900010.sql
Rem
Rem Copyright (c) 1999, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      f0900010.sql - downgrade components from current release to 9.0.1
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      05/28/02 - bug 2293968 and OWM downgrade
Rem    rburns      02/13/02 - change OWM downgrade, add AMD
Rem    rburns      02/06/02 - add MGW component
Rem    rburns      12/07/01 - add more components
Rem    rburns      11/14/01 - add RAC
Rem    shwong      10/26/01 - add OLS downgrade
Rem    rburns      10/17/01 - remove jis and jsp
Rem    rburns      09/29/01 - revise conditional tests
Rem    rburns      09/25/01 - use conditional tests
Rem    rburns      06/07/01 - Merged rburns_setup_901_upgrade
Rem    rburns      06/06/01 - Created

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade from the current release
Rem =========================================================================

Rem For next release, uncomment the following:
Rem @@f0902000.sql

Rem =========================================================================
Rem END STAGE 1: downgrade from the current release
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade from 9.2.0 to 9.0.1
Rem =========================================================================

Rem =========================================================================
Rem BEGIN drop Java classes for new 9.2.0 RDBMS features
Rem =========================================================================

BEGIN
   IF dbms_registry.status('CATJAVA') NOT IN ('REMOVED') THEN
      dbms_registry.downgrading('CATJAVA');
--    Drop SQLJ classes - need to reload with JIS in 901
      EXECUTE IMMEDIATE 
         'call sys.dbms_java.dropjava(''-s rdbms/jlib/sqljtype.jar'')';
--    Drop AQJMS 
      EXECUTE IMMEDIATE 
        'call sys.dbms_java.dropjava(''-s rdbms/jlib/aqapi.jar'')';
      EXECUTE IMMEDIATE 
        'call sys.dbms_java.dropjava(''-s rdbms/jlib/jmscommon.jar'')';
--    Drop Cartridge Services
      EXECUTE IMMEDIATE 
        'call sys.dbms_java.dropjava(''-s rdbms/jlib/CartridgeServices.jar'')';
      EXECUTE IMMEDIATE 
        'call sys.dbms_java.dropjava(''-s rdbms/jlib/ODCI.jar'')';
      dbms_registry.downgraded('CATJAVA','9.0.1.0.0');
   END IF;
END;
/

Rem =========================================================================
Rem END drop Java classes for new 9.2.0 RDBMS features
Rem =========================================================================

Rem =========================================================================
Rem BEGIN Component downgrade scripts
Rem =========================================================================

Rem Downgrade XDK for Java
SELECT dbms_registry.script('XML','xmle901.sql') AS file_name FROM DUAL;
@@&comp_file
drop procedure XMLVALIDATE;

Rem Downgrade OLS
SELECT dbms_registry.script('OLS', 'olse901.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade Messaging Gateway
SELECT dbms_registry.script('MGW','mgwe901.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade OWM 
SELECT dbms_registry.script('OWM','owme901.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade JServer (Last real downgrade)
SELECT dbms_registry.script('JAVAVM','jvme901.sql') AS file_name FROM DUAL;
@@&comp_file

Rem Downgrade RAC (no dictionary objects)
BEGIN
   IF dbms_registry.status('RAC') IS NOT NULL THEN
      dbms_registry.downgraded('RAC','9.0.1.0.0');
   END IF;
END;
/

Rem Downgrade ODM (no change for 901 downgrade)
BEGIN
   IF dbms_registry.status('ODM') IS NOT NULL THEN
      dbms_registry.downgraded('ODM','9.0.1.0.0');
   END IF;
END;
/

Rem Downgrade OLAP Catalog (no downgrade for OLAP catalog)
BEGIN
   IF dbms_registry.status('AMD') IS NOT NULL THEN
      dbms_registry.downgraded('AMD','9.0.1.0.0');
   END IF;
END;
/

Rem =========================================================================
Rem END Component downgrade scripts
Rem =========================================================================

Rem =========================================================================
Rem END STAGE 2: downgrade from 9.2.0 to 9.0.1
Rem =========================================================================

Rem *************************************************************************
Rem END f0900010.sql
Rem *************************************************************************

