Rem
Rem $Header: olspatch.sql 08-dec-2004.11:37:18 cchui Exp $
Rem
Rem olspatch.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      olspatch.sql - Oracle Label Security patch script
Rem
Rem    DESCRIPTION
Rem      This script is used to apply bugfixes to the OLS component.It is run 
Rem      in the context of catpatch.sql, after the RDBMS catalog.sql and 
Rem      catproc.sql scripts are run. It is run with a special EVENT set which
Rem      causes CREATE OR REPLACE statements to only recompile objects if the 
Rem      new source is different than the source stored in the database.
Rem      Tables, types, and public interfaces should not be changed here.
Rem
Rem    NOTES
Rem      Called from catpatch.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cchui       12/08/04 - Backport 3936531: use validate_ols 
Rem    srtata      08/21/02 - call olsdap.sql
Rem    srtata      08/15/02 - call catols.sql
Rem    srtata      07/08/02 - srtata_bug-2434758
Rem    srtata      06/26/02 - Created
Rem

-- catdap.sql will drop and reapply RLS policies on tables with 
-- read_control ,check_control policy options.
@@olsdap.sql

WHENEVER SQLERROR EXIT;

DECLARE
  compat         VARCHAR2(30);
BEGIN

-- Check compatible parameter
   select value into compat from v$parameter
   where name='compatible';
   if substr(compat,1,5) < '8.1.7' then
      RAISE_APPLICATION_ERROR(-20000,
  'Compatibile init file parameter ' || compat ||
  ' must be >= 8.1.7 for OLS');
   end if;
END;
/

WHENEVER SQLERROR CONTINUE;

-- add OLS to the registry
EXECUTE DBMS_REGISTRY.LOADING('OLS', 'Oracle Label Security', 'validate_ols','LBACSYS');

-- Load LBAC framework packages.
@@catlbac

-- Load SA policy packages.
@@catsa
@@catlabel

BEGIN
  dbms_registry.loaded('OLS', dbms_registry.release_version,
            'Oracle Label Security Release ' ||
            dbms_registry.release_version    ||
            ' - ' || dbms_registry.release_status);
  SYS.validate_ols;
END;
/
commit;
