Rem
Rem $Header: olsrelod.sql 08-dec-2004.11:38:35 cchui Exp $
Rem
Rem olsrelod.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      olsrelod.sql - Oracle Label Security RELOaD script.
Rem
Rem    DESCRIPTION
Rem      This script is used to reload OLS packages after a downgrade. 
Rem      The dictionary objects are reset to the old release by the "e" script,
Rem      this reload script processes the "old" scripts to reload the 
Rem      "old" version of the component using the "old" server.
Rem
Rem    NOTES
Rem      Called from catrelod.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cchui       12/08/04 - Backport 3936531: use validate_ols 
Rem    srtata      12/23/02 - srtata_backport_9.2.0.2.0_2625076
Rem    srtata      10/16/02 - Created
Rem

-- add OLS to the registry
EXECUTE DBMS_REGISTRY.LOADING('OLS', 'Oracle Label Security', 'validate_ols','LBACSYS');

-- Load LBAC framework packages.
@@catlbac

-- Load SA policy packages.
@@catsa
@@catlabel

BEGIN
  dbms_registry.loaded('OLS', dbms_registry.release_version,
            'Oracle Label Security Release ' ||
            dbms_registry.release_version    ||
            ' - ' || dbms_registry.release_status);
  SYS.validate_ols;
END;
/
commit;

