Rem
Rem   HISTORY
Rem     mmuppago    04/18/06 -  Account for 10.1.2.x versions
Rem     mmuppago    03/02/05 -  Backup and patch owa packages in DB
Rem     mmuppago    06/30/05 -  For the version equal to or above 9.0.4.0.3
Rem                             no patching needed
Rem

variable owa_message     varchar2(1000);
variable owa_file_name   varchar2(200);

begin :owa_file_name := ''; end;
/

begin :owa_message := ''; end;
/

declare
     

    installed_owa_version  VARCHAR2(80);
    dir_number             number := 30;
    new_line               VARCHAR2(4)  := '
';


 --
 FUNCTION get_next_int_and_advance(str IN OUT varchar2)
      RETURN PLS_INTEGER is
  loc pls_integer;
  ans pls_integer;
 BEGIN
  loc := instr(str, '.', 1);
  if (loc > 0) then
   ans := to_number(substr(str, 1, loc - 1));
   str := substr(str, loc + 1, length(str) - loc);
  else
   ans := to_number(str);
   str := '';
  end if;
  return ans;
 END;

 --
 FUNCTION get_owa_dirnumber(p_version IN varchar2)
      RETURN NUMBER is
    ans            NUMBER;
   l_version      VARCHAR2(32);

 BEGIN

   -- Convert string to a number
   l_version := p_version;
   ans := 0;
   FOR i in 1..2 LOOP
     ans := 10 * ans + get_next_int_and_advance(l_version);
   END LOOP;

   RETURN ans;

 END;


  FUNCTION get_installed_owa_version RETURN VARCHAR2 IS
    owa_version VARCHAR2(80);
    l_cursor    INTEGER;
    l_stmt      VARCHAR2(256);
    l_status    INTEGER;
  BEGIN

    l_stmt := 'select OWA_UTIL.get_version from dual';
    l_cursor := dbms_sql.open_cursor;
    dbms_sql.parse(l_cursor, l_stmt, dbms_sql.native);
    dbms_sql.define_column( l_cursor, 1, owa_version, 80 );
    l_status := dbms_sql.execute(l_cursor);

    loop
       if dbms_sql.fetch_rows (l_cursor) > 0 then
          dbms_sql.column_value(l_cursor, 1, owa_version);
       else
          exit;
       end if;
    end loop;
    dbms_sql.close_cursor(l_cursor);

    return owa_version;

  EXCEPTION
    WHEN OTHERS THEN
     if dbms_sql.is_open(l_cursor) then
         dbms_sql.close_cursor(l_cursor);
     end if;
     return NULL;
  END;



begin

 -- Get the version of OWA packages installed in the database
 installed_owa_version := get_installed_owa_version;

 -- Format a message for display
 IF (installed_owa_version is NULL) THEN
    :owa_message := 'No older OWA packages detected or OWA packages too old';
    -- DBMS_OUTPUT.PUT_LINE( 'No older OWA packages detected or OWA packages too old');

    -- In this case we default to owa_version: '3.0.0.0.0'
    -- so that we install latest of 3.0 version owa packages.
    :owa_file_name := '?/rdbms/admin/owainst.sql';
    :owa_message := :owa_message || new_line ||  'OWALOAD File: ' ||  :owa_file_name ;
 ELSE
    -- :owa_message := 'Installed OWA version is: ' || installed_owa_version;
    dir_number := get_owa_dirnumber(installed_owa_version);
    if dir_number >= 101 then
        :owa_file_name := '?/rdbms/admin/owa/101/owainst.sql';
    elsif dir_number = 90 then
        :owa_file_name := '?/rdbms/admin/owa/90/owainst.sql';
    else 
        :owa_file_name := '?/rdbms/admin/owainst.sql';
    end if;
    :owa_message := :owa_message || new_line ||  'OWALOAD File: ' ||  :owa_file_name ;
    -- DBMS_OUTPUT.PUT_LINE( 'Running : ' ||  :owa_file_name );
 END IF;

       exception
	   -- 
	   when  OTHERS  then
	          dbms_output.put_line('Error patching OWA packages ');

end;
/


print :owa_message;

COLUMN :owa_file_name NEW_VALUE owa_file_var NOPRINT;
SELECT :owa_file_name FROM DUAL;

@@&owa_file_var;

