Rem
Rem $Header: u0900010.sql 15-dec-2004.06:59:47 rburns Exp $
Rem
Rem u0900010.sql
Rem
Rem Copyright (c) 1999, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      u0900010.sql - upgrade Oracle RDBMS from 9.0.1 to the new release
Rem
Rem    DESCRIPTION
Rem     This script is to be used for upgrading a 9.0.1 database to the
Rem     new release.  This script provides a direct upgrade path from 9.0.1
Rem     to the new Oracle release.
Rem
Rem      The upgrade is partitioned into the following 4 stages:
Rem        STAGE 1: call i0900010.sql:
Rem			This loads all tables that are necessary
Rem			to perform basic sql commands.
Rem	   STAGE 2: call utlip.sql to invalidate views, procedures, packages...
Rem        STAGE 3: call c0900010.sql:
Rem			This performs all necessary dictionary 
Rem			upgrade to bring the db from 9.0.1 to the
Rem			new release.
Rem        STAGE 4: call a0900010.sql:
Rem			This performs all necessary upgrade using
Rem			anonymous blocks.
Rem
Rem    NOTES
Rem	 WARNING:  DO NOT TOUCH THIS FILE!!!!! PUT ANY NECESSARY
Rem		   CHANGES INTO i0900010.sql, c0900010.sql, or a0900010.sql
Rem
Rem      * This script needs to be run in the new release's environment
Rem        (after installing the release to which you want to upgrade).
Rem      * This script must be run using SQL*PLUS.
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      12/15/04 - check for non-SYS user 
Rem    rburns      03/20/02 - check nls_length_semantics
Rem    tbgraves    02/04/02 - add server version check
Rem    rburns      12/06/01 - add doc
Rem    celsbern    10/25/01 - merging LOG into MAIN
Rem    rburns      10/18/01 - remove java scripts
Rem    rburns      09/27/01 - check for OPEN MIGRATE
Rem    rburns      08/26/01 - run utlip
Rem    najain      08/11/01 - Merged najain_qapi_enh
Rem    rburns      08/02/01 - rename initjvmaux and add BYTE semantics
Rem    rburns      06/07/01 - Merged rburns_setup_901_upgrade
Rem    rburns      06/05/01 - Created
Rem

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;        

DOC 
###################################################################### 
###################################################################### 
    The following statement will cause an "ORA-01722: invalid number" 
    error and terminate the SQLPLUS session if the user is not SYS.  
    Disconnect and reconnect with AS SYSDBA. 
###################################################################### 
###################################################################### 
# 
 
SELECT TO_NUMBER('MUST_BE_AS_SYSDBA') FROM DUAL 
WHERE USER != 'SYS'; 

Rem The TO_NUMBER function will raise an error if the script is being
Rem run by the wrong server version.
Rem =========================================================================
/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database server version is not 9.2.0.
  Shutdown ABORT and use a different script or a different server.
#######################################################################
#######################################################################

*/
SELECT TO_NUMBER('MUST_BE_920') FROM v$instance
WHERE substr(version,1,5) != '9.2.0';

Rem =========================================================================
Rem The TO_NUMBER function will raise an error if the database status is not
Rem open for migration.
Rem =========================================================================
/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database has not been opened for MIGRATE.  

  Perform a "SHUTDOWN ABORT"  and 
  restart using MIGRATE.
#######################################################################
#######################################################################
*/
SELECT TO_NUMBER(status) FROM v$instance
WHERE status != 'OPEN MIGRATE';

/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the nls_length_semantics initialization parameter is CHAR

  Perform a "SHUTDOWN ABORT" and set the value to BYTE for the upgrade
#######################################################################
#######################################################################
*/
SELECT TO_NUMBER(value) FROM v$parameter 
WHERE name='nls_length_semantics' AND value != 'BYTE'; 

Rem =========================================================================
Rem Check the Database Character Set for use of AL24UTFFSS (not supported)
Rem Terminate the upgrade script if it is in use - the database must be 
Rem converted to a supported character set prior to upgrading.
Rem The to_number function will raise an error if there is an AL24UTFFSS value
Rem in the v$nls_parameters view.
Rem =========================================================================

SELECT to_number(value) as no_AL24UTFFSS_upgrade 
FROM v$nls_parameters 
WHERE parameter = 'NLS_CHARACTERSET' AND value = 'AL24UTFFSS'; 

Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;  

Rem =========================================================================
Rem BEGIN STAGE 1: load dictionary changes necessary for basic sql processing
Rem =========================================================================

@@i0900010

Rem =========================================================================
Rem END STAGE 1: load dictionary changes necessary for basic sql processing
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: invalidate all non-Java objects
Rem =========================================================================

@@utlip

Rem =========================================================================
Rem END STAGE 2: invalidate all non-Java objects
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 3: dictionary upgrade
Rem =========================================================================

@@c0900010

Rem =========================================================================
Rem END STAGE 3: dictionary upgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 4: upgrade using anonymous pl/sql blocks
Rem =========================================================================

@@a0900010

Rem =========================================================================
Rem END STAGE 4: upgrade using anonymous pl/sql blocks
Rem =========================================================================

Rem *************************************************************************
Rem END u0900010.sql
Rem *************************************************************************
