Rem
Rem $Header: xdbpatch.sql 19-oct-2005.20:50:27 smalde Exp $
Rem
Rem xdbpatch.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbpatch.sql - Xml DB PATCH to 9.2.0.3
Rem
Rem    DESCRIPTION
Rem      Patches an XML DB instance from either 9.2.0.1 or 9.2.0.2
Rem      so that it may be used in a 9.2.0.3 database.
Rem
Rem    NOTES
Rem      The old contents of this file were moved to xdbu920.sql.
Rem      This file now peforms upgrades from both 9.2.0.1 and 9.2.0.2.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pnath       10/19/05 - bug 4440611 
Rem    vkapoor     04/28/05 - bug 4335066. xdbptrl1 getting called twice
Rem    petam       03/14/05 - added the call to xdbu9206.sql for version 9206
Rem    spannala    07/16/04 - adding /sys/apps folder 
Rem    alakshmi    11/17/03 - load xdbu9204.sql 
Rem    sidicula    05/01/03 - 9203 to 9204 upgrade
Rem    njalali     01/02/03 - making generic for 9.2.0.3
Rem    nmontoya    10/28/02 - fix acl/ace/flags byte ordering problem
Rem    njalali     10/16/02 - making file rerunnable if out of memory occurs
Rem    njalali     10/02/02 - granting select to public on config table
Rem    njalali     09/12/02 - making this file re-runnable
Rem    njalali     09/09/02 - annotation complexType has empty attribute varray
Rem    spannala    09/23/02 - spannala_main_merge_code
Rem    sichandr    09/04/02 - LCR XML schema upgrade
Rem    njalali     09/04/02 - migration tweaks
Rem    njalali     08/15/02 - Resource sticky flag inverted
Rem    njalali     08/14/02 - changing binary XML resources to NSB
Rem    njalali     08/13/02 - updating XDB version number in registry
Rem    njalali     08/13/02 - removing SET statements
Rem    sichandr    08/12/02 - grant execute to types
Rem    njalali     08/08/02 - setting refcount to zero for root resource
Rem    njalali     08/01/02 - simplecontent alter type CASCADE
Rem    sichandr    07/29/02 - re-organize root schema migration
Rem    njalali     07/27/02 - njalali_9202_migr
Rem    njalali     07/25/02 - calling xdbrelod.sql
Rem    sichandr    07/24/02 - migration for root schema changes
Rem    fge         07/10/02 - resource_view/path_view migration
Rem    njalali     07/10/02 - Created
Rem

Rem Setup component script filename variable
COLUMN :script_name NEW_VALUE comp_file NOPRINT
VARIABLE script_name VARCHAR2(50)

Rem Setup xdbrelod.sql
COLUMN :relod_name NEW_VALUE relod_file NOPRINT
VARIABLE relod_name VARCHAR2(50)

Rem Select upgrade script to run
Rem Also select relod script to run
Rem
BEGIN
  :relod_name  := '@xdbrelod.sql';
IF substr(dbms_registry.version('XDB'),1,7)='9.2.0.1' THEN
  :script_name := '@xdbu920.sql';
  :relod_name  := '@xdbrlu.sql';
ELSIF substr(dbms_registry.version('XDB'),1,7)='9.2.0.2' THEN
  :script_name := '@xdbu9202.sql';
ELSIF substr(dbms_registry.version('XDB'),1,7)='9.2.0.3' THEN
  :script_name := '@xdbu9203.sql';
ELSIF substr(dbms_registry.version('XDB'),1,7)='9.2.0.4' THEN
  :script_name := '@xdbu9204.sql';
ELSIF substr(dbms_registry.version('XDB'),1,7)='9.2.0.5' THEN
  :script_name := '@xdbu9205.sql';
ELSIF substr(dbms_registry.version('XDB'),1,7)='9.2.0.6' THEN
  :script_name := '@xdbu9206.sql';
ELSIF substr(dbms_registry.version('XDB'),1,7)='9.2.0.7' THEN
  :script_name := '@xdbu9207.sql';
ELSE
  :script_name := '?/rdbms/admin/nothing.sql';
END IF;
END;
/

SELECT :script_name FROM DUAL;
@&comp_file

Rem Now reload all packages
SELECT :relod_name FROM DUAL;
@&relod_file

execute sys.dbms_regxdb.validatexdb();
