Rem
Rem $Header: xdbrlu.sql 03-may-2005.16:53:02 spannala Exp $
Rem
Rem xdbrlu.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbrlu.sql - Xml DB RELOaD packages except ptrl1
Rem
Rem    DESCRIPTION
Rem      Replaces all XDB-related packages with the current versions.
Rem      Does not run xdbptrl1.sql
Rem
Rem    NOTES
Rem      None
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    spannala    05/03/05 - spannala_backport_9.2.0.6.0_2884318
Rem    vkapoor     05/02/05 - bug 4335066. xdbptrl1 getting called twice 
Rem

alter system flush shared_pool;
-- Some implementations have these operators defined, and some don't.
-- Regardless, they are unused in 9.2.0.2 and should be dropped.
begin
  execute immediate 'drop indextype xdb.path_index';
exception
  when others then
    commit;
end;
/
begin
  execute immediate 'drop operator xdb.xdbpi_noop';
exception
  when others then
    commit;
end;
/

Rem Reload the XML DB packages.  This is the main step.
@@dbmsxsch.sql
@@xdbptrl2.sql

Rem Clean up invalidated objects
alter package xdb.dbms_regxdb compile;
alter package xdb.DBMS_XMLSCHEMA compile;


Rem Compile all invalid schemas, useful for compiling users schemas which
Rem are now invalid
declare
  cur             INTEGER;
  rc              INTEGER;
  sch_url         VARCHAR2(2000);
  stmt            VARCHAR2(2000);
begin
  cur := dbms_sql.open_cursor;
  dbms_sql.parse(
    cur, 
  'select x.qual_schema_url from dba_xml_schemas x, dba_objects o where o.object_type = ''XML SCHEMA'' and o.status != ''VALID'' and o.object_name = x.int_objname',
    dbms_sql.native);
  dbms_sql.define_column(cur, 1, sch_url, 2000);
  rc := dbms_sql.execute(cur);
  LOOP
    IF dbms_sql.fetch_rows(cur) > 0 THEN
      dbms_sql.column_value(cur, 1, sch_url);
      stmt := 'call dbms_xmlschema.compileschema(''' || sch_url || ''')';
      execute immediate stmt;
    ELSE
      exit;
    END IF;
  END LOOP;
  dbms_sql.close_cursor(cur);
  commit;
end;
/

Rem Migrate the path index trigger
call dbms_xdbz0.migrate_pitrig();

Rem Compile all invalid triggers, this is useful for compiling
Rem the resource view triggers
declare
  cur             INTEGER;
  rc              INTEGER;
  obj_name        VARCHAR2(2000);
  stmt            VARCHAR2(2000);
begin
  cur := dbms_sql.open_cursor;
  dbms_sql.parse(
    cur, 
    'select object_name from dba_objects where owner = ''XDB'' and status != ''VALID'' and object_type = ''TRIGGER''',
    dbms_sql.native);
  dbms_sql.define_column(cur, 1, obj_name, 2000);
  rc := dbms_sql.execute(cur);
  LOOP
    IF dbms_sql.fetch_rows(cur) > 0 THEN
      dbms_sql.column_value(cur, 1, obj_name);
      stmt := 'alter trigger XDB."' || obj_name || '" compile';
      execute immediate stmt;
    ELSE
      exit;
    END IF;
  END LOOP;
  dbms_sql.close_cursor(cur);
  commit;
end;
/


Rem Reset XDB version
execute dbms_registry.loaded('XDB');

Rem Set XDB to a valid state.
Rem We cannot use xdb.dbms_regxdb.validatexdb() because 
Rem resource_view is unusable until the DB is restarted.
execute sys.dbms_registry.valid('XDB');

alter package xdb.dbms_xdbz0 compile;
alter package xdb.dbms_xdbz compile;
alter trigger xdb.XDB_PI_TRIG compile;
alter package xdb.DBMS_XDBUTIL_INT compile;

alter procedure xdb.xdb$patchupdeleteschema compile;
