Rem
Rem $Header: xdbs9203.sql 09-dec-2004.15:58:26 spannala Exp $
Rem
Rem xdbs9203.sql
Rem
Rem Copyright (c) 2003, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbs9203.sql - XDB bootstrap Schema upgrade from 9203 to 9204
Rem
Rem    DESCRIPTION
Rem      XDB bootstrap Schema upgrade from 9203 to 9204
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    petam       12/09/04 - call xdbs9204.sql at the end 
Rem    sidicula    05/13/03 - sidicula_backport_9.2.0.3.0_2602197
Rem    sidicula    05/01/03 - Created
Rem

-- ACL Schema Upgrade
declare
  schema_ref     REF SYS.XMLTYPE;
  st_ref         REF SYS.XMLTYPE;
  pf_ref         REF SYS.XMLTYPE;
  col_ref        REF SYS.XMLTYPE;
  ACL_NUMPROPS   CONSTANT INTEGER := 32;
  numprops       INTEGER;
begin
  select s.xmldata.num_props into numprops from xdb.xdb$schema s where 
    s.xmldata.schema_url='http://xmlns.oracle.com/xdb/acl.xsd';
  if (numprops < ACL_NUMPROPS) then
   select ref(s) into schema_ref from xdb.xdb$schema s where 
     s.xmldata.schema_url='http://xmlns.oracle.com/xdb/acl.xsd';

   insert into xdb.xdb$simple_type e (e.xmlextra, e.xmldata) values
    (SYS.XMLTYPEEXTRA(SYS.XMLTYPEPI(
     '4E0020687474703A2F2F7777772E77332E6F72672F323030312F584D4C536368656D61', 
     '500003786462001B687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F786462',
     '50000678646261636C0023687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F7864622F61636C2E787364'), SYS.XMLTYPEPI('523030')),
     XDB.XDB$SIMPLE_T(XDB.XDB$RAW_LIST_T('130200000106'), schema_ref,
     NULL, '00',XDB.XDB$SIMPLE_DERIVATION_T(XDB.XDB$RAW_LIST_T('330008020000118B8003'),
     NULL, XDB.XDB$QNAME('00', 'string'), NULL, NULL, NULL, NULL, NULL, NULL, 
     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
     XDB.XDB$FACET_LIST_T(XDB.XDB$FACET_T(XDB.XDB$RAW_LIST_T('130200000102'),
     NULL, 'ShortName', '00', NULL), XDB.XDB$FACET_T(XDB.XDB$RAW_LIST_T('130200000102'), NULL, 'DistinguishedName', '00', NULL), 
      XDB.XDB$FACET_T(XDB.XDB$RAW_LIST_T('130200000102'), NULL, 'GUID', '00', NULL)), NULL, NULL), NULL, NULL, NULL, NULL)) 
  returning ref(e) into st_ref;

  insert into xdb.xdb$attribute e (e.xmlextra, e.xmldata) values
  (SYS.XMLTYPEEXTRA(SYS.XMLTYPEPI(
   '4E0020687474703A2F2F7777772E77332E6F72672F323030312F584D4C536368656D61', 
   '500003786462001B687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F786462', 
   '50000678646261636C0023687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F7864622F61636C2E787364'), SYS.XMLTYPEPI('523030')),
  XDB.XDB$PROPERTY_T(XDB.XDB$RAW_LIST_T('439A3828020000041913010809181B03150B0C0D07'),
   schema_ref, xdb.xdb$propnum_seq.nextval, 'principalFormat', NULL, NULL, 
   '0103', '00', '00', NULL, 'principalFormat', 'XDB$ENUM_T', 'XDB', NULL,
   NULL, st_ref, st_ref, NULL, NULL, XDB.XDB$USECHOICE('00'), NULL, '00', NULL,
   NULL, NULL, '00',   XDB.XDB$TRANSIENTCHOICE('01'), NULL, '00')) 
  returning ref(e) into pf_ref;

  insert into xdb.xdb$attribute e (e.xmlextra, e.xmldata) values
  (SYS.XMLTYPEEXTRA(SYS.XMLTYPEPI(
   '4E0020687474703A2F2F7777772E77332E6F72672F323030312F584D4C536368656D61',
   '500003786462001B687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F786462',
   '50000678646261636C0023687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F7864622F61636C2E787364'), SYS.XMLTYPEPI('523030')),
  XDB.XDB$PROPERTY_T(XDB.XDB$RAW_LIST_T('43B81828020000040519130809181B03150B0C07'),
   schema_ref, xdb.xdb$propnum_seq.nextval, 'collection', 
   XDB.XDB$QNAME('00', 'boolean'), NULL, 'FC', '00', '00', NULL, 'collection', 
   'RAW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, XDB.XDB$USECHOICE('00'), 
   NULL, '00', NULL, NULL, NULL, '00', XDB.XDB$TRANSIENTCHOICE('01'), 
   NULL, '00')) returning ref(e) into col_ref;

   update xdb.xdb$complex_type c
    set c.xmldata.attributes=XDB.XDB$XMLTYPE_REF_LIST_T(col_ref, pf_ref),
      c.xmldata.sys_xdbpd$=XDB.XDB$RAW_LIST_T('330801060000038880020D0E131112')
   where ref(c)=(select e.xmldata.property.type_ref from xdb.xdb$element e 
                where e.xmldata.property.name='ace' and 
                e.xmldata.property.parent_schema=schema_ref);

   update xdb.xdb$schema s set s.xmldata.num_props=ACL_NUMPROPS
     where s.xmldata.schema_url='http://xmlns.oracle.com/xdb/acl.xsd';

   commit;
  end if;
end;
/

@@xdbs9204.sql