Rem
Rem $Header: xdbs9206.sql 06-apr-2006.18:07:58 ncramesh Exp $
Rem
Rem xdbs9206.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbs9206.sql - XDB xdbconfig Schema upgrade from 9206 to 9207
Rem
Rem    DESCRIPTION
Rem       XDB xdbconfig Schema upgrade from 9204 to 9205
Rem       Modified xdbconfig.xml schema to add ftp-welcome-message into 
Rem       the ftpconfig element
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ncramesh    04/06/06 - fix for lrg 1958789: loading the dbmsxdb and 
Rem                           dbmsxsch packages. These are needed by the 9204 
Rem                           data upgrade. The patchupschema signature has 
Rem                           changed going from 9204 to 9208 
Rem    petam       12/09/04 - Created
Rem

-- Create a procedure to get the type name and schema given schema url
-- and element name

create or replace procedure element_type(schema_url IN varchar2, element_name IN
    varchar2, type_owner out varchar2, type_name out varchar2) as
qelnm varchar2(32);
qsurl varchar2(4000);
qry varchar2(4000);
cur integer;
rc integer;
begin

  qelnm := '''' || element_name || '''';
  qsurl := '''' || schema_url   || '''';

  qry   := 
    'select e.xmldata.property.sqlschema, e.xmldata.property.sqltype ' ||
    'from xdb.xdb$element e, xdb.xdb$schema s where '                  ||
    'e.xmldata.property.name=' || qelnm                                ||
    ' and e.xmldata.property.parent_schema = ref(s) and '              ||
    's.xmldata.schema_url=' || qsurl;

  cur := dbms_sql.open_cursor;
  dbms_sql.parse(cur, qry, dbms_sql.native);
  dbms_sql.define_column(cur, 1, type_owner, 30);
  dbms_sql.define_column(cur, 2, type_name, 30);
  rc := dbms_sql.execute(cur);
  IF dbms_sql.fetch_rows(cur) > 0 THEN
    dbms_sql.column_value(cur, 1, type_owner);
    dbms_sql.column_value(cur, 2, type_name);
  ELSE
    dbms_sql.close_cursor(cur);
    RETURN;
  END IF;
  dbms_sql.close_cursor(cur);

END;
/

create or replace procedure alt_type_add_attribute(type_owner IN varchar2,
     type_name IN varchar2, attr_string IN varchar2) as
cur integer;
rc  integer;
begin
  cur := dbms_sql.open_cursor;
  dbms_sql.parse(
    cur,
    'alter type "' || type_owner || '"."' || type_name ||
    '" add attribute (' || attr_string || ') cascade',
    dbms_sql.native);
  rc := dbms_sql.execute(cur);
  dbms_sql.close_cursor(cur);
end;
/

create or replace procedure upgrade_config_schema as
  config_schema_ref      REF XMLTYPE;
  config_schema_url      VARCHAR2(100);
  ftp_welcome_count      INTEGER; 
  elem_ref_ftp_welcome   REF XMLTYPE;
  ftpcf_seq_ref          REF XMLTYPE;
  ftpconf_type           varchar2(100);
  ftpconf_type_owner     varchar2(100);
  elem_arr               XDB.XDB$XMLTYPE_REF_LIST_T;
begin
  config_schema_url := 'http://xmlns.oracle.com/xdb/xdbconfig.xsd';

  select ref(s) into config_schema_ref from xdb.xdb$schema s where
         s.xmldata.schema_url = config_schema_url;

  -- check if ftp-welcome-message exists
  -- We check it here because we can't have http2-port 
  -- but not ftp-welcome-message
  select count(e.xmldata.property.name) into ftp_welcome_count 
     from xdb.xdb$element e, xdb.xdb$schema s
     where s.xmldata.schema_url = 'http://xmlns.oracle.com/xdb/xdbconfig.xsd' 
     and e.xmldata.property.parent_schema = ref(s) 
     and e.xmldata.property.name = 'ftp-welcome-message'; 

  if ftp_welcome_count = 0 then 
    -- select the element type corresponding to http config and add
    -- the two new elements to it
    insert into xdb.xdb$element e (e.xmlextra, e.xmldata) values(
XMLTYPEEXTRA(XMLTYPEPI('4E0020687474703A2F2F7777772E77332E6F72672F323030312F584D4C536368656D61', '500004786462630029687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F7864622F786462636F6E6669672E787364', '500003786462001B687474703A2F2F786D6C6E732E6F7261636C652E636F6D2F786462'), XMLTYPEPI('523030')),
XDB.XDB$ELEMENT_T(XDB.XDB$PROPERTY_T(XDB.XDB$RAW_LIST_T('83B818200080030C000000040532330809181B23262A343503150B0C07272928'), config_schema_ref, xdb.xdb$propnum_seq.nextval, 'ftp-welcome-message', XDB.XDB$QNAME('00', 'string'), NULL, '01', '00', '00', NULL, 'ftp-welcome-message', 'VARCHAR2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '00', NULL, NULL, NULL,'00', NULL, NULL, '00'), NULL, NULL, '00', NULL, NULL, '00', '01', '01', '01', '01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '1', '00', '01', NULL, NULL, NULL, NULL, NULL, NULL))
      returning ref(e) into elem_ref_ftp_welcome;

    -- select the sequence kid corresponding to the ftpconfig type
    select c.xmldata.sequence_kid into ftpcf_seq_ref from 
      xdb.xdb$complex_type c where ref(c)=
        (select e.xmldata.cplx_type_decl from xdb.xdb$element e
          where e.xmldata.property.name='ftpconfig' and
          e.xmldata.property.parent_schema = config_schema_ref);

    -- select the sequence elements
    select m.xmldata.elements into elem_arr from xdb.xdb$sequence_model m
     where ref(m) = ftpcf_seq_ref;
  
    -- extend it to add the three elements just created
    elem_arr.extend(1);
    elem_arr(elem_arr.last)   := elem_ref_ftp_welcome;

    -- update the table with the extended sequence and new pd
    update xdb.xdb$sequence_model m
       set m.xmldata.elements = elem_arr,
           m.xmldata.sys_xdbpd$ = XDB.XDB$RAW_LIST_T('230200000081800807')
      where ref(m) = ftpcf_seq_ref;

    -- Insert ftp-welcome-message into schema if none found
    element_type(config_schema_url, 'ftpconfig', ftpconf_type_owner,
                 ftpconf_type);

    alt_type_add_attribute(ftpconf_type_owner, ftpconf_type,
                           '"ftp-welcome-message" VARCHAR2(4000 CHAR)');
  end if;
  commit;
end; 
/

show errors;
-- Upgrade config schema from the 9202 version
call upgrade_config_schema();

drop procedure upgrade_config_schema;
drop procedure alt_type_add_attribute;
drop procedure element_type;

Rem needs to be loaded before the dbmsxsch package below
@@dbmsxdb.sql
@@prvtxdb.plb

Rem contains the new definition for patchupschema
@@dbmsxsch.sql























