Rem
Rem $Header: xdbu920.sql 09-dec-2004.15:37:32 spannala Exp $
Rem
Rem xdbu920.sql
Rem
Rem Copyright (c) 2003, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbu920.sql - XDB Upgrade to 9.2.0.2
Rem
Rem    DESCRIPTION
Rem      Performs XDB Schema, PD, and extras migration for 9.2.0.1 to 9.2.0.2
Rem
Rem    NOTES
Rem      This file was created from the existing xdbpatch.sql, which 
Rem      needed to be made more generic in 9.2.0.3 to allow for upgrades 
Rem      coming directly from 9.2.0.2.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    petam       12/09/04 - split out schema changes to xdbs9201.sql 
Rem    sidicula    05/01/03 - 9203 to 9204 ACL schema upgrade
Rem    nmontoya    02/27/03 - bug# 2818136: update xdb$resource instead of PV
Rem    nmontoya    02/11/03 - GRANT ALL privileges ON xdb$config TO xdbadmin
Rem    nmontoya    02/11/03 - SET NEW DEFAULT contentype TO 9201 folders 
Rem    nmontoya    02/14/03 - SET attributes TO null IN schema FOR schemas
Rem    nmontoya    02/14/03 - drop public synonym XMLConcat 
Rem    nmontoya    02/11/03 - move xdb$patchupdeleteschema compile TO xdbrelod
Rem    njalali     01/07/03 - njalali_backport_9.2.0.2.0_2611590
Rem    njalali     01/02/03 - bug 2607128: flushing SGA shared pool
Rem    njalali     01/02/03 - Created from xdbpatch.sql
Rem

@@xdbs9201.sql

UPDATE xdb.xdb$acl a
  SET VALUE(a) = updatexml(VALUE(a), '/acl/ace[flags!="0"]/flags/text()',1)
  WHERE existsnode(VALUE(a), '/acl/ace[flags!="0"]')=1;

grant all on xdb.xdb$config to xdbadmin;

update xdb.xdb$resource r 
  set r.xmldata.contype = 'application/octet-stream'
  where r.xmldata.contype = 'text/plain' AND 
       (r.xmldata.dispname = 'log' or
        r.xmldata.dispname = 'xdb' or
        r.xmldata.dispname = 'xmlns.oracle.com' or
        r.xmldata.dispname = 'PUBLIC' or
        r.xmldata.dispname = 'schemas' or
        r.xmldata.dispname = 'sys' or
        r.xmldata.dispname = '2001' or
        r.xmldata.dispname = 'www.w3.org' or
        r.xmldata.dispname = 'acls' or
        r.xmldata.dispname = 'public');


drop public synonym XMLConcat;

@@xdbu9202.sql




