Rem
Rem $Header: xdbu9204.sql 16-dec-2004.15:30:16 spannala Exp $
Rem
Rem xdbu9204.sql
Rem
Rem Copyright (c) 2003, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbu9204.sql - XDB Upgrade from 9.2.0.4
Rem
Rem    DESCRIPTION
Rem      Migrates XDB from 9.2.0.4 to 9.2.0.5
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    petam       12/16/04 - moving lcr upgrade to here
Rem    spannala    07/16/04 - adding 9205 patch
Rem    alakshmi    12/08/03 - alakshmi_backport_9.2.0.4.0_3197273 
Rem    alakshmi    11/17/03 - Created
Rem

Rem Currently we just need to upgrade the LCR schema
@@xdbs9204.sql

Rem
Rem Upgrade LCR schema
Rem

-- This function returns true if the upgrade is necessary, false otherwise.
create or replace function lcr_needupg(schema_url IN VARCHAR2)
  return boolean as
  m integer;
begin
  SELECT count(*) into m
  FROM xdb.xdb$element e, xdb.xdb$schema s 
  WHERE s.xmldata.schema_url = schema_url AND
        ref(s) = e.xmldata.property.parent_schema AND 
        e.xmldata.property.name = 'ddl_text' AND 
        e.xmldata.property.sqltype = 'CLOB'; 

  if m > 0 then
    return FALSE;
  else
    return TRUE;
  end if;
end;
/

Rem Load catxlcr1.sql
@@catxlcr1.sql

create or replace procedure upgrade_lcr as
  lcr_schema_url  varchar2(60);
  cnt             integer;
begin

  lcr_schema_url := lcr$_xml_schema.CONFIGURL;
  select count(*) into cnt from xdb.xdb$schema s
  where s.xmldata.schema_url = lcr_schema_url;

  if cnt > 0 and lcr_needupg(lcr_schema_url) then

    -- Drop the existing schema. This is going to fail if there are
    -- dependent tables/schemas in which case users have to upgrade using
    -- dbms_streams_xml_lcr_utl.upgrade_schema.
    dbms_xmlschema.DeleteSchema(lcr$_xml_schema.CONFIGURL,
                                dbms_xmlschema.DELETE_RESTRICT);

    -- Register new schema
    dbms_xmlschema.registerSchema(schemaURL => lcr$_xml_schema.CONFIGURL,
                                  schemaDoc => lcr$_xml_schema.CONFIGXSD_90205,
                                  local => FALSE,
                                  genTypes => TRUE,
                                  genBean => FALSE,
                                  genTables => FALSE,
                                  force => FALSE);


  end if;
end;
/

call upgrade_lcr();
-- drop the upgrade procedures
drop function lcr_needupg;
drop procedure upgrade_lcr;

Rem Call 9205 upgrade
@@xdbu9205.sql
