Rem
Rem $Header: xdbu9207.sql 20-oct-2005.18:35:25 smalde Exp $
Rem
Rem xdbu9207.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xdbu9207.sql - XDB Upgrade from 9.2.0.7
Rem
Rem    DESCRIPTION
Rem      Migrates XDB from 9.2.0.7 to 9.2.0.8
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smalde      10/20/05 - smalde_backport_9.2.0.8.0_4440611
Rem    vkapoor     10/19/05 - bug 4440611 
Rem

declare
  cur             INTEGER;
  rc              INTEGER;
  colname_ftp     VARCHAR2(100);
  colname_http    VARCHAR2(100);
begin

  dbms_xdbz.disable_hierarchy('XDB', 'XDB$CONFIG');

  select c.name into colname_ftp from col$ c, obj$ o, attrcol$ a where
    c.obj#=o.obj# and
    o.name='XDB$CONFIG' and
    o.owner#=(select user# from user$ where name='XDB') and
    c.intcol#=a.intcol# and
    a.obj#=o.obj# and
    a.name='"XMLDATA"."sysconfig"."protocolconfig"."ftpconfig"."ftp-port"';

  select c.name into colname_http from col$ c, obj$ o, attrcol$ a where
    c.obj#=o.obj# and
    o.name='XDB$CONFIG' and
    o.owner#=(select user# from user$ where name='XDB') and
    c.intcol#=a.intcol# and
    a.obj#=o.obj# and
    a.name='"XMLDATA"."sysconfig"."protocolconfig"."httpconfig"."http-port"';

  cur := dbms_sql.open_cursor;
   dbms_sql.parse(
    cur,
    'update xdb.xdb$config c set c.' || colname_http || ' = 0, ' ||
    'c.' || colname_ftp || ' = 0',
    dbms_sql.native);

  rc := dbms_sql.execute(cur);
  dbms_sql.close_cursor(cur);

  dbms_xdbz.enable_hierarchy('XDB', 'XDB$CONFIG');
end;
/

execute dbms_registry.loaded('XDB');

