Rem
Rem imchk.sql
Rem
Rem Copyright (c) 1998, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imchk.sql - InterMedia CHecK script
Rem
Rem    DESCRIPTION
Rem      This scrpit check the installation of interMedia
Rem      components and prints it's status.
Rem
Rem    NOTES
Rem      Before running this script user must be connected as 
Rem      ORDSYS.
Rem     
Rem      ORDPLUGINS package bodies are not checked because they are 
Rem      not visible from ORDSYS
Rem
Rem

REM This script tests the interMedia components installation

REM -----------------------------------------------------------------------
REM Welcome to the Oracle interMedia Installation Check Utility.
REM This script tests the interMedia installation
REM -----------------------------------------------------------------------

declare
  expected_status VARCHAR2(30);
  actual_status VARCHAR2(30);
  is_cartridge_valid VARCHAR2(30);
begin
  -- The order of check is in the following order
  -- 1. Check common
  -- 2. Check images
  -- 3. Check Audio
  -- 4. Check Video 

  Cartridge.Clear_Component_Status('ORDIM');

  expected_status:='VALID';
  -- check common error handling package
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMERRORCODES', 'PACKAGE','ORDIMERRORCODES Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMERRORCODES', 'PACKAGE BODY',
        'ORDIMERRORCODES Internal Package Body',
        expected_status, actual_status);
  -- check source first
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDSOURCE', 'TYPE', 'ORDSOURCE Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDSOURCE', 'TYPE BODY', 'ORDSOURCE Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDSOURCEEXCEPTIONS', 'PACKAGE',
        'ORDSOURCEEXCEPTIONS Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_HTTP_SOURCE', 'PACKAGE','ORDX_HTTP_SOURCE Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_FILE_SOURCE', 'PACKAGE','ORDX_FILE_SOURCE Internal Package',
        expected_status, actual_status);


  -- check image status
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMLIBS', 'LIBRARY','ORDIMLIBS Internal Library',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMG_PKG', 'PACKAGE','ORDIMG_PKG Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMG_PKG', 'PACKAGE BODY', 'ORDIMG_PKG Internal Package Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'IM', 'PACKAGE','IM Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'IM', 'PACKAGE BODY', 'IM Internal Package Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGE', 'TYPE', 'ORDIMAGE Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGE', 'TYPE BODY', 'ORDIMAGE Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGB', 'TYPE', 'ORDIMGB Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGB', 'TYPE BODY', 'ORDIMGB Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGF', 'TYPE', 'ORDIMGF Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGF', 'TYPE BODY', 'ORDIMGF Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGEEXCEPTIONS', 'PACKAGE','ORDIMAGEEXCEPTIONS Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGECONSTANTS', 'PACKAGE','ORDIMAGECONSTANTS Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGEXTCODEC_PKG', 'PACKAGE',
        'ORDIMGEXTCODEC_PKG Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGEXTCODEC_PKG', 'PACKAGE BODY',
        'ORDIMGEXTCODEC_PKG Internal Package Body',
        expected_status, actual_status);

  -- check image (cbr) status
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'ORDIMAGESIGNATURE', 'TYPE', 'ORDIMAGESIGNATURE Type',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'ORDIMAGESIGNATURE', 'TYPE BODY', 'ORDIMAGESIGNATURE Type Body',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGSIG_PKG', 'PACKAGE','ORDIMGSIG_PKG Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGSIG_PKG', 'PACKAGE BODY',
        'ORDIMGSIG_PKG Internal Package Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMLIBT', 'LIBRARY','ORDIMLIBT Trusted Internal Library',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'ORDIMAGEINDEX', 'INDEXTYPE', 'ORDIMAGEINDEX IndexType',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'ORDIMGIDXMETHODS', 'TYPE', 'ORDIMGIDXMETHODS Type',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'ORDIMGIDXMETHODS', 'TYPE BODY', 'ORDIMGIDXMETHODS Type Body',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'SCOREFUNC', 'FUNCTION', 'SCOREFUNC Function',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'SIMILARFUNC', 'FUNCTION', 'SIMILARFUNC Function',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'IMGSCORE', 'OPERATOR', 'IMGSCORE Operator',
	expected_status, actual_status);
  Cartridge.Check_Component_Status(
	'ORDIM', 'ORDSYS',
	'IMGSIMILAR', 'OPERATOR', 'IMGSIMILAR Operator',
	expected_status, actual_status);

  -- check audio status
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIO_PKG', 'PACKAGE','ORDAUDIO_PKG Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIO_PKG', 'PACKAGE BODY', 'ORDAUDIO_PKG Internal Package Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIO', 'TYPE', 'ORDAUDIO Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIO', 'TYPE BODY', 'ORDAUDIO Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIOEXCEPTIONS', 'PACKAGE','ORDAUDIOEXCEPTIONS Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_AIFC_AUDIO', 'PACKAGE','ORDX_AIFC_AUDIO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_AIFF_AUDIO', 'PACKAGE','ORDX_AIFF_AUDIO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_AUFF_AUDIO', 'PACKAGE','ORDX_AUFF_AUDIO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_DEFAULT_AUDIO', 'PACKAGE','ORDX_DEFAULT_AUDIO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_WAVE_AUDIO', 'PACKAGE','ORDX_WAVE_AUDIO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_MPGA_AUDIO', 'PACKAGE','ORDX_MPGA_AUDIO Internal Package',
        expected_status, actual_status);

  -- check video status
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEO_PKG', 'PACKAGE','ORDVIDEO_PKG Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEO_PKG', 'PACKAGE BODY', 'ORDVIDEO_PKG Internal Package Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEO', 'TYPE', 'ORDVIDEO Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEO', 'TYPE BODY', 'ORDVIDEO Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEOEXCEPTIONS', 'PACKAGE','ORDVIDEOEXCEPTIONS Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_MOOV_VIDEO', 'PACKAGE','ORDX_MOOV_VIDEO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_AVI_VIDEO', 'PACKAGE','ORDX_AVI_VIDEO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_RMFF_VIDEO', 'PACKAGE','ORDX_RMFF_VIDEO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_MPEG_VIDEO', 'PACKAGE','ORDX_MPEG_VIDEO Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_DEFAULT_VIDEO', 'PACKAGE','ORDX_DEFAULT_VIDEO Internal Package',
        expected_status, actual_status);

  -- check doc status

  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDDOC', 'TYPE', 'ORDDOC Type',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDDOC', 'TYPE BODY', 'ORDDOC Type Body',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDDOCEXCEPTIONS', 'PACKAGE','ORDDOCEXCEPTIONS Internal Package',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDPLUGINS',
        'ORDX_DEFAULT_DOC', 'PACKAGE','ORDX_DEFAULT_DOC Internal Package',
        expected_status, actual_status);

 
-- CHECKER:----------------------------------------------------.
-- CHECKER:           Grant Check Section' );
-- CHECKER:----------------------------------------------------.

  -- check ORDSource grants 
  expected_status := 'PUBLIC';
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDSOURCE', 'GRANT', 'ORDSOURCE Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDSOURCEEXCEPTIONS', 'GRANT', 'ORDSOURCEEXCEPTIONS Public Grant',
        expected_status, actual_status);


  -- check image grants
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGE', 'GRANT', 'ORDIMAGE Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGESIGNATURE', 'GRANT', 
	'ORDIMAGESIGNATURE PUBLIC GRANT',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGB', 'GRANT', 'ORDIMGB Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGF', 'GRANT', 'ORDIMGF Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMERRORCODES', 'GRANT', 'ORDIMERRORCODES Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'IM', 'GRANT', 'IM Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMG_PKG', 'GRANT', 'ORDIMG_PKG Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGEEXCEPTIONS', 'GRANT', 'ORDIMAGEEXCEPTIONS Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGECONSTANTS', 'GRANT', 'ORDIMAGECONSTANTS Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGSIG_PKG', 'GRANT', 'ORDIMGSIG_PKG Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMAGEINDEX', 'GRANT', 'ORDIMAGEINDEX Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGIDXMETHODS', 'GRANT', 'ORDIMGIDXMETHODS Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'IMGSIMILAR', 'GRANT', 'IMGSIMILAR Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'IMGSCORE', 'GRANT', 'IMGSCORE Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'SIMILARFUNC', 'GRANT', 'SIMILARFUNC Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'SCOREFUNC', 'GRANT', 'SCOREFUNC Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDIMGEXTCODEC_PKG', 'GRANT', 'ORDIMGEXTCODEC_PKG Public Grant',
        expected_status, actual_status);


  -- check audio grants
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIO', 'GRANT', 'ORDAUDIO Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIOEXCEPTIONS', 'GRANT', 'ORDAUDIOEXCEPTIONS Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDAUDIO_PKG', 'GRANT', 'ORDAUDIO_PKG Public Grant',
        expected_status, actual_status);

  -- check video grants 
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEO', 'GRANT', 'ORDVIDEO Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEOEXCEPTIONS', 'GRANT', 'ORDVIDEOEXCEPTIONS Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDVIDEO_PKG', 'GRANT', 'ORDVIDEO_PKG Public Grant',
        expected_status, actual_status);

 -- check doc grants
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDDOC', 'GRANT', 'ORDDOC Public Grant',
        expected_status, actual_status);
  Cartridge.Check_Component_Status(
        'ORDIM', 'ORDSYS',
        'ORDDOCEXCEPTIONS', 'GRANT', 'ORDDOCEXCEPTIONS Public Grant',
        expected_status, actual_status);





-- at this point all components except RPC have been checked.

-- print common component status
  select decode(count(1),0,'VALID','INVALID')
  into is_cartridge_valid
  from ORD_CARTRIDGE_COMPONENTS
  where short_name = 'ORDIM' AND
    status != 'VALID';

  Cartridge.Set_Install_Status('ORDIM',is_cartridge_valid);

end;
/

-- COMMON COMPONENTS

REM ---------------------------------------------------------------------
REM Summary:
REM Oracle interMedia Common Description
REM ---------------------------------------------------------------------

select  name "Cartridge", version, installation_status  "Status"
from ordsys.ord_installations
where short_name='ORDIM';

REM ---------------------------------------------------------------------
REM Oracle interMedia Common Components and Statuses
REM ---------------------------------------------------------------------

column "Component" format a50;
select description "Component", status  "Status"
from ordsys.ord_cartridge_components
where short_name='ORDIM' order by 1;
column "Component" clear;


REM ---------------------------------------------------------------------
REM Oracle interMedia Common Installation Check is complete
REM ---------------------------------------------------------------------

