REM You must connect as ORDSYS prior to running this script
REM

REM Internal installation script for interMedia - steps that must be executed
REM as ORDSYS.

REM Create Libraries
create or replace library ORDIMLIBS as '%IM_SHLIB%';
/
create or replace library ORDIMLIBT trusted as static;
/

REM Install interMedia common error handling components
@@ordiersp.sql
@@ordierbd.plb

REM Apply Grants
grant execute on ORDIMErrorCodes to public with grant option;
grant execute on IM to public with grant option;

REM Install ORDSource Components
@@ordascex.sql
@@ordsrcsp.sql
@@ordsrcbd.plb

REM Apply Grants to ORDSource Components
grant execute on ORDSourceExceptions to public with grant option;
grant execute on ORDSource to public with grant option;

REM Install Oracle8i interMedia Image Components
@@ordispec.sql
@@ordibody.plb
@@ordimspc.sql
@@ordimbdy.plb
@@ordimops.plb

REM Apply Grants
grant execute on ORDSYS.ORDIMGB to PUBLIC with grant option;
grant execute on ORDSYS.ORDIMGF to PUBLIC with grant option;
grant execute on ORDSYS.ORDImage to PUBLIC with grant option;
grant execute on ORDSYS.ORDIMG_PKG to PUBLIC with grant option;
grant execute on ORDSYS.ORDImageExceptions to PUBLIC with grant option;
grant execute on ORDSYS.ORDImageConstants to PUBLIC with grant option;
grant execute on ORDSYS.ORDImageSignature to PUBLIC with grant option;
grant execute on ORDSYS.ORDImgSig_Pkg to PUBLIC with grant option;
grant execute on ORDSYS.ORDImageIndex to PUBLIC with grant option;
grant execute on ORDSYS.ORDImgIdxMethods to PUBLIC with grant option;
grant execute on ORDSYS.IMGSimilar to PUBLIC with grant option;
grant execute on ORDSYS.IMGScore to PUBLIC with grant option;
grant execute on ORDSYS.SimilarFunc to PUBLIC with grant option;
grant execute on ORDSYS.ScoreFunc to PUBLIC with grant option;
grant execute on ORDSYS.ORDImgExtCodec_Pkg to PUBLIC with grant option;
grant execute on ORDSYS.ORDImageIndexStats to PUBLIC with grant option;

REM Install Oracle8i interMedia Audio Components

REM Install annotations
@@ordanots.sql
@@ordanotb.plb
 
REM Install audio
REM  audio package and audio object reference each other
@@ordaspec.sql
@@ordapksp.sql
@@ordabody.plb
@@ordapkbd.plb

REM Apply Grants
grant execute on ORDAnnotationsExceptions to public with grant option;
grant execute on ORDAnnotation to public with grant option;
grant execute on ORDAnnotationList to public with grant option;
grant execute on ORDAudioExceptions to public with grant option;
grant execute on ORDAudio_Pkg to public with grant option;
grant execute on ORDAudio to public with grant option;

REM Install interMedia Video Components

REM Install video
REM  video package and video object reference each other
@@ordvspec.sql
@@ordvpksp.sql
@@ordvbody.plb
@@ordvpkbd.plb

REM Apply Grants
grant execute on ORDVideoExceptions to public with grant option;
grant execute on ORDVideo_Pkg to public with grant option;
grant execute on ORDVideo to public with grant option;

REM  doc error package and doc object reference each other
@@orddspec.sql
@@orddpksp.sql
@@orddbody.plb

REM Apply Grants
grant execute on ORDDocExceptions to public with grant option;
grant execute on ORDDoc to public with grant option;



REM load java classes needed
set serveroutput on size 10000;
execute dbms_java.set_output(10000);
execute dbms_java.loadjava('-force -synonym -schema ORDSYS -resolve -grant PUBLIC ord/jlib/ordimsvr.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS -resolve -grant PUBLIC ord/jlib/ordimann.jar');

execute dbms_java.loadjava('-force -synonym -schema ORDSYS -definer ord/jlib/jai_core.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS          ord/jlib/jpeg_codec.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS -definer ord/jlib/jai_codec.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS          ord/jlib/ordimimg.jar');

execute dbms_java.loadjava('-resolve -grant PUBLIC -schema ORDSYS ord/jlib/jai_core.jar ord/jlib/jpeg_codec.jar ord/jlib/jai_codec.jar ord/jlib/ordimimg.jar');

REM load NCOMP jarfiles
REM comment out the following lines to disable NCOMP usage (currently enabled)

REM create reset procedure
create or replace procedure java_reset(value IN NUMBER)
as LANGUAGE JAVA
name 'oracle.ord.media.img.ImgDBUtils.sessionReset(java.lang.Integer)';
/

create or replace procedure reset_jvm(value IN NUMBER) is
begin
  java_reset(value);
  exception
    when others then
      if sqlcode not in (-29515) then raise; end if;
end;
/

execute reset_jvm(0);
execute dbms_java.loadjava('-force -resolve -schema ORDSYS ord/jlib/jai_core_depl.jar');

execute reset_jvm(0);
execute dbms_java.loadjava('-force -resolve -schema ORDSYS ord/jlib/jai_codec_depl.jar');

execute reset_jvm(0);
execute dbms_java.loadjava('-force -resolve -schema ORDSYS ord/jlib/ordimimg_depl.jar');

execute reset_jvm(0);
drop procedure reset_jvm;
drop procedure java_reset;

REM end of section to load NCOMP jarfiles

set serveroutput off


REM Now that Java and NCOMP load are completed, we can drop related privs
revoke JAVA_DEPLOY from ORDSYS;


REM REGISTER interMedia HERE

begin
  ORDSYS.Cartridge.Register(
    'ORDIM',
    'Oracle interMedia',
    '9.2.0.1.0',
    'Oracle interMedia',
    'INVALID'
  );
end;
/
