REM 
REM Internal installation script for interMedia 
REM   Load Java classes under ORDSYS schema.
REM

set serveroutput on size 10000;
execute dbms_java.set_output(10000);

execute dbms_java.loadjava('-force -synonym -schema ORDSYS -resolve -grant PUBLIC ord/jlib/ordimsvr.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS -resolve -grant PUBLIC ord/jlib/ordimann.jar');

execute dbms_java.loadjava('-force -synonym -schema ORDSYS -definer ord/jlib/jai_core.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS          ord/jlib/jpeg_codec.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS -definer ord/jlib/jai_codec.jar');
execute dbms_java.loadjava('-force -synonym -schema ORDSYS          ord/jlib/ordimimg.jar');

execute dbms_java.loadjava('-resolve -grant PUBLIC -schema ORDSYS ord/jlib/jai_core.jar ord/jlib/jpeg_codec.jar ord/jlib/jai_codec.jar ord/jlib/ordimimg.jar');

REM load NCOMP jarfiles
REM comment out the following lines to disable NCOMP usage (currently enabled)

REM create reset procedure
create or replace procedure java_reset(value IN NUMBER)
as LANGUAGE JAVA
name 'oracle.ord.media.img.ImgDBUtils.sessionReset(java.lang.Integer)';
/

create or replace procedure reset_jvm(value IN NUMBER) is
begin
  java_reset(value);
  exception
    when others then
      if sqlcode not in (-29515) then raise; end if;
end;
/

execute reset_jvm(0);
execute dbms_java.loadjava('-force -resolve -schema ORDSYS ord/jlib/jai_core_depl.jar');

execute reset_jvm(0);
execute dbms_java.loadjava('-force -resolve -schema ORDSYS ord/jlib/jai_codec_depl.jar');

execute reset_jvm(0);
execute dbms_java.loadjava('-force -resolve -schema ORDSYS ord/jlib/ordimimg_depl.jar');

execute reset_jvm(0);
drop procedure reset_jvm;
drop procedure java_reset;

REM end of section to load NCOMP jarfiles

set serveroutput off

REM Now that Java and NCOMP load are completed, we can drop related privs
revoke JAVA_DEPLOY from ORDSYS;

REM
REM drop OrdSourceServer class in ORDPLUGINS schema if present
REM
declare
 cnt number;
begin
 select count(object_name) into cnt
   from all_objects,javasnm
   where owner = 'ORDPLUGINS' and
   object_type = 'JAVA CLASS' and
   short(+) = object_name and
   nvl(longname, object_name) = 'oracle/ord/media/source/OrdSourceSvr';
 if cnt > 0 then
   execute immediate 'drop java class ORDPLUGINS."oracle/ord/media/source/OrdSourceSvr"';
 end if;
end;
/
