
//Title:       Oracle8i Locator Demo
//Version:     
//Copyright:   Copyright (c) 1998
//Author:      Frank Wang
//Company:     Oracle
//Description: Interactive Geocoding Demo
import java.awt.*;
import java.awt.event.*;
import borland.jbcl.control.*;
import borland.jbcl.layout.*;

public class Frame1 extends DecoratedFrame {
  BorderLayout borderLayout1 = new BorderLayout();
  XYLayout xYLayout1 = new XYLayout();
  BevelPanel bevelPanel1 = new BevelPanel();
  StatusBar statusBar = new StatusBar();
  GroupBox groupBoxIn = new GroupBox();
  XYLayout xYLayout2 = new XYLayout();
  TextField strInAddr = new TextField();
  Label label1 = new Label();
  Label label2 = new Label();
  Label label3 = new Label();
  Label label4 = new Label();
  TextField strInCity = new TextField();
  TextField strInState = new TextField();
  TextField strInZip = new TextField();
  Button OK = new Button();
  Button Clear = new Button();
  GroupBox groupBoxOut = new GroupBox();
  XYLayout xYLayout3 = new XYLayout();
  TextArea strOutAddr = new TextArea();
  TextField strOutCoord = new TextField();
  public Locator1 lctr;
  Button Quit = new Button();
  GridControl gridControl1 = new GridControl();
  Label label5 = new Label();
  TextField strInDist = new TextField();
  LabelControl labelControl1 = new LabelControl();

  public Frame1(Locator1 locator) {
    try {
      jbInit();
      statusBar.setText("Ready");
      lctr = locator;
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public void jbInit() throws Exception{
    this.setLayout(borderLayout1);
    this.setSize(new Dimension(695, 851));
    this.setTitle("Geocoder Interactive Demo");
    statusBar.setText("");
    groupBoxIn.setLayout(xYLayout2);
    groupBoxIn.setLabel("Input");
    label1.setText("Address");
    label2.setText("City");
    label3.setText("State");
    label4.setText("Zip");
    OK.setLabel("OK");
    OK.addActionListener(new Frame1_OK_actionAdapter(this));
    Clear.setLabel("Clear");
    Clear.addActionListener(new Frame1_Clear_actionAdapter(this));
    groupBoxOut.setLayout(xYLayout3);
    groupBoxOut.setLabel("Output");
    strOutAddr.setEditable(false);
    strOutCoord.setEditable(false);
    Quit.setLabel("Ouit");
    gridControl1.setAutoAppend(true);
    gridControl1.setColumnCaptions(new String[] {"Company", "Address", "City", "Phone"});
    gridControl1.setDefaultColumnWidth(150);
    gridControl1.setEditInPlace(false);
    gridControl1.setItems(new String[][] {{"", "", "", ""},});
//    gridControl1.setReadOnly(true);
    gridControl1.setResizableRows(false);
    gridControl1.setRowHeaderVisible(false);
    gridControl1.setSortOnHeaderClick(true);
    label5.setText("Distance");
    labelControl1.setText("Miles");
    Quit.addActionListener(new Frame1_Quit_actionAdapter(this));
    bevelPanel1.setLayout(xYLayout1);
    this.add(statusBar, BorderLayout.SOUTH);
    this.add(bevelPanel1, BorderLayout.CENTER);
    bevelPanel1.add(groupBoxIn, new XYConstraints(23, 22, 635, 251));
    groupBoxIn.add(strInAddr, new XYConstraints(72, 25, 297, 27));
    groupBoxIn.add(label1, new XYConstraints(16, 21, 53, 29));
    groupBoxIn.add(label2, new XYConstraints(16, 77, 40, 21));
    groupBoxIn.add(label3, new XYConstraints(16, 121, 41, -1));
    groupBoxIn.add(label4, new XYConstraints(205, 121, 46, -1));
    groupBoxIn.add(strInCity, new XYConstraints(72, 74, 298, 27));
    groupBoxIn.add(strInState, new XYConstraints(72, 121, 111, 27));
    groupBoxIn.add(strInZip, new XYConstraints(259, 121, 111, 27));
    groupBoxIn.add(OK, new XYConstraints(118, 173, 114, 33));
    groupBoxIn.add(Clear, new XYConstraints(301, 173, 114, 33));
    groupBoxIn.add(Quit, new XYConstraints(461, 172, 114, 33));
    groupBoxIn.add(label5, new XYConstraints(405, 122, 53, 19));
    groupBoxIn.add(strInDist, new XYConstraints(468, 121, 61, 24));
    groupBoxIn.add(labelControl1, new XYConstraints(539, 122, 44, 19));
    bevelPanel1.add(groupBoxOut, new XYConstraints(25, 284, 635, 131));
    groupBoxOut.add(strOutAddr, new XYConstraints(9, 7, 305, 85));
    groupBoxOut.add(strOutCoord, new XYConstraints(353, 36, 239, 25));
    bevelPanel1.add(gridControl1, new XYConstraints(40, 420, 605, 353));
  }

  void OK_actionPerformed(ActionEvent e) {
    String addr, lastline;
    double x, y;
    String status;

    statusBar.setText("OK");
    lctr.geocode(strInAddr.getText(), strInCity.getText(), strInState.getText(), strInZip.getText());
    status = lctr.getOutStatus();
    statusBar.setText(status);
    addr = lctr.getOutAddr();
    lastline = lctr.getOutLastline();
    x = lctr.getOutLon();
    y = lctr.getOutLat();
    strOutAddr.setText(addr + "\n" + lastline);
    strOutCoord.setText("(" + x + ", " + y + ")");

    if ((!strInDist.getText().equals("")) && (x != 0.0) && (y != 0.0))
    {
      lctr.distanceSQL(strInAddr.getText(), strInCity.getText(), strInState.getText(), strInZip.getText(), strInDist.getText());
    }
  }

  void Clear_actionPerformed(ActionEvent e) {
    strInAddr.setText("");
    strInCity.setText("");
    strInState.setText("");
    strInZip.setText("");
    strInDist.setText("");
    strOutAddr.setText("");
    strOutCoord.setText("");
    statusBar.setText("Ready");
  }

  void Quit_actionPerformed(ActionEvent e) {
    lctr.quit();
  }
}

class Frame1_AboutBox extends Dialog implements ActionListener {
  Panel panelMain = new Panel();
  BevelPanel bevelPanel = new BevelPanel();
  Panel panelButton = new Panel();
  Panel panelImage = new Panel();
  Panel panelCenter = new Panel();
  BorderLayout layoutMain = new BorderLayout();
  BorderLayout layoutBevel = new BorderLayout();
  GridBagLayout layoutButton = new GridBagLayout();
  GridBagLayout layoutCenter = new GridBagLayout();
  GridBagLayout layoutImage = new GridBagLayout();
  ImageControl imageControl = new ImageControl();
  Button buttonOK = new Button();
  Label labelProduct = new Label();
  Label labelVersion = new Label();
  Label labelCopyright = new Label();
  Label labelComments = new Label();
  String stringProduct = "Oracle8i Locator Demo";
  String stringVersion = "";
  String stringCopyright = "Copyright (c) 1998";
  String stringComments = "Interactive Geocoding Demo";

  public Frame1_AboutBox(Frame parent) {
    super(parent);
    try {
      jbInit();
    } catch (Exception e) {
      e.printStackTrace();
    }
    pack();
  }

  void jbInit() throws Exception{
    this.setTitle("About");
    this.setResizable(false);
    this.add(panelMain, null);
    panelCenter.setLayout(layoutCenter);
    labelProduct.setText(stringProduct);
    labelVersion.setText(stringVersion);
    labelCopyright.setText(stringCopyright);
    labelComments.setText(stringComments);
    panelCenter.add(labelProduct, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
    panelCenter.add(labelVersion, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 10, 0, 10), 0, 0));
    panelCenter.add(labelCopyright, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 10, 0, 10), 0, 0));
    panelCenter.add(labelComments, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 10, 10, 10), 0, 0));
    panelImage.setLayout(layoutImage);
    imageControl.setImageName("");
    panelImage.add(imageControl, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));
    bevelPanel.setLayout(layoutBevel);
    bevelPanel.add(panelCenter, BorderLayout.CENTER);
    bevelPanel.add(panelImage, BorderLayout.WEST);
    panelButton.setLayout(layoutButton);
    buttonOK.setLabel("OK");
    buttonOK.addActionListener(this);
    panelButton.add(buttonOK, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));
    panelMain.setLayout(layoutMain);
    panelMain.add(bevelPanel, BorderLayout.CENTER);
    panelMain.add(panelButton, BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == buttonOK) {
    setVisible(false);
    dispose();
    }
  }
}

class Frame1_OK_actionAdapter implements java.awt.event.ActionListener{
  Frame1 adaptee;

  Frame1_OK_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.OK_actionPerformed(e);
  }
}

class Frame1_Clear_actionAdapter implements java.awt.event.ActionListener{
  Frame1 adaptee;

  Frame1_Clear_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.Clear_actionPerformed(e);
  }
}

class Frame1_Quit_actionAdapter implements java.awt.event.ActionListener{
  Frame1 adaptee;

  Frame1_Quit_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.Quit_actionPerformed(e);
  }
}
