
//Title:       Oracle8i Locator Demo
//Version:     
//Copyright:   Copyright (c) 1998
//Author:      Frank Wang
//Company:     Oracle
//Description: Interactive Geocoding Demo

import java.sql.*;
import java.math.*;
import oracle.jdbc.driver.*;

public class Locator1 {

  static {
    try {
        DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
    }
    catch (SQLException e)
    {
      e.printStackTrace();
    }
  };

  public Frame1 mainFrame;
  Connection conn;
  CallableStatement cs;

  public Locator1() {
    mainFrame = new Frame1(this);
    mainFrame.show();
    try {
      conn = DriverManager.getConnection("jdbc:oracle:oci8:@frontier", "herman", "vampire");
      cs = conn.prepareCall(
         "{call geocode('decloan-22/scripts/geoservice.dll', null, null, null, ?,?,?,?,?,?,?)}");
    }
    catch (SQLException e)
    {
      e.printStackTrace();
    }

  }

  public static void main(String[] args) {
    new Locator1();
  }

  public String outAddr;
  public String outLastline;
  public String status;
  public double x, y;

  public void geocode(String inAddr, String inCity, String inState, String inZip)
  {
    try {
      cs.setString(1, inAddr);
      cs.setString(2, inCity + ',' + inState + ' ' + inZip);
      cs.registerOutParameter(3, Types.VARCHAR);
      cs.registerOutParameter(4, Types.DOUBLE);
      cs.registerOutParameter(5, Types.DOUBLE);
      cs.registerOutParameter(6, Types.VARCHAR);
      cs.registerOutParameter(7, Types.VARCHAR);
      cs.executeUpdate();
      status = cs.getString(3);
      outAddr = cs.getString(6);
      outLastline = cs.getString(7);
      x = cs.getDouble(4);
      y = cs.getDouble(5);
    }
    catch (SQLException e)
    {
      e.printStackTrace();
    }

  }

  public void distanceSQL(String inAddr, String inCity, String inState, String inZip, String inDist)
  {
    try {
      Statement stmt;
      ResultSet rset;
      String Company;
      String Address;
      String City;
      String Phone;
      String sql;

      stmt = conn.createStatement();
      sql = "select company,address,city,phone from nh_computer_stores where "+
            "mdsys.locator_within_distance(location,"+
            "(select mdsys.geocoder('"+inAddr+"','"+inCity+","+inState+" "+inZip+"') from dual),'distance="+inDist+" units=mile')='TRUE'";
      mainFrame.gridControl1.removeAllRows();
//      System.out.println(sql);
      rset = stmt.executeQuery(sql);
      int count = 0;
      while (rset.next())
      {
        Company = rset.getString(1);
        Address = rset.getString(2);
        City = rset.getString(3);
        Phone = rset.getString(4);
        mainFrame.gridControl1.addRow();
        mainFrame.gridControl1.set(count,0, Company);
        mainFrame.gridControl1.set(count,1, Address);
        mainFrame.gridControl1.set(count,2, City);
        mainFrame.gridControl1.set(count,3, Phone);
        count++;
      }
      stmt.close();

    }
    catch (SQLException e)
    {
      e.printStackTrace();
    }

  }

  public String getOutStatus()
  {
    return status;
  }

  public String getOutAddr()
  {
    return outAddr;
  }

  public String getOutLastline()
  {
    return outLastline;
  }

  public double getOutLon()
  {
    return x;
  }

  public double getOutLat()
  {
    return y;
  }

  public void quit()
  {
    try {
      conn.close();
    }
    catch (SQLException e)
    {
      e.printStackTrace();
    }
    System.exit(0);
  }

}