Rem
Rem $Header: wk0inst.sql 22-nov-2004.15:37:41 syang Exp $
Rem
Rem wk0inst.sql
Rem
Rem Copyright (c) 1999, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      wk0inst.sql - WK Install
Rem
Rem    DESCRIPTION
Rem      This moudle installs all packages needed by intermedia search  
Rem      
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    syang       11/22/04 - bug 3936668 backport 
Rem    wechin      07/09/02 - change the version to 9.2.0.2.0
Rem    wechin      03/11/02 - fix bug 2259949
Rem    wechin      02/20/02 - use dbms_registry.release_version
Rem    wechin      02/15/02 - update version number in component registry
Rem    syang       02/18/02 - accept LAUNCH_ANYWHERE parameter
Rem    dczhang     01/30/02 - DO NOT SPOOL
Rem    wechin      01/09/02 - component registry
Rem    dczhang     07/09/01 - remove word "isearch"
Rem    syang       07/13/01 - add agent_location
Rem    syang       03/14/01 - no default language for wk0pref.sql
Rem    dczhang     11/17/00 - remove unnecessary exit at the end
Rem    chsin       09/15/00 - add wk0obj.sql
Rem    syang       09/14/00 - use define variables to avoid sqlplus bug
Rem    jshang      08/23/00 - Add data type creation for Query API wrapper
Rem    jechow      08/01/00 - cut the class path
Rem    ymatsuda    03/28/00 - training data dir, config file path
Rem    ymatsuda    03/20/00 -
Rem    syang       03/01/00 - create default schedule
Rem    ymatsuda    02/16/00 - multi instance
Rem    echee       02/07/00 - adding seed data population to flow
Rem    syang       02/02/00 - create default web source
Rem    dyu         01/13/00 - Fix classpath too long for sqlplus argument
Rem    syang       01/05/00 - report error gracefully
Rem    swkuo       11/22/99 - create wk0init.sql to initizlize the crawler table
Rem    syang       11/22/99 - add explanation for parameters needed
Rem    swkuo       11/18/99 - pass crawler config parameters
Rem    ymatsuda    11/17/99 - add wk0util
Rem    swkuo       11/11/99 - initialize the WK$CRAWLER table
Rem    swkuo       11/09/99 - use a utility program to load java classes
Rem    syang       11/05/99 - add wk0ddl package
Rem    syang       11/04/99 - crawler seed coulmn type change
Rem    swkuo       11/02/99 - Add the language column
Rem    swkuo       11/01/99 - Created
Rem


set feedback off verify off

PROMPT ==============  Ultra Search Installation ==============
PROMPT

whenever sqlerror exit;
set heading off

PROMPT This script must be run as WKSYS. This script will exit
PROMPT below if run as any other user.

select 'User is WKSYS' from dual
where 1 = decode(USER,'WKSYS',1,'NOT');
set heading on
whenever sqlerror continue;

REM ========================================================================
REM Registry to installing state
REM ========================================================================

execute dbms_registry.loading('WK', 'Oracle Ultra Search', 'VALIDATE_WK', 'WKSYS');

PROMPT ... creating tables
@@wk0tabs.sql 

PROMPT ... creating objects
@@wk0transqapi.sql
@@wk0obj.sql

PROMPT ... populating all seed data
@@wk0popl.sql 

PROMPT ... loading package headers
@@wk0pkh.sql

PROMPT ... loading package bodies
@@wk0plb.sql

PROMPT ... populating the WK$CRAWLER_CONFIG_DEFAULT table
Rem Use define variable here as passing argument here will
Rem cause file not found on wk0init.sql when caller of this
Rem script is not in the same directory as wk0inst.sql

Rem arg1 is isearch data directory
Rem arg2 is Inso filter path
Rem arg3 is java execute directory
Rem arg4 is jdbc database connect string
Rem arg5 is java agent path for extensible crawler
define data_location = "&1"
define cthx_location = "&2"
define java_location = "&3"
define jdbc_location = "&4"
define agent_location = "&5"
define install_type = "&6"
define launch_any    = "&7"
@@wk0init.sql
undefine data_location
undefine cthx_location
undefine java_location
undefine jdbc_location
undefine agent_location
undefine launch_any

PROMPT ... creating preferences
@@wk0pref.sql 

REM ========================================================================
REM Registry to installed state
REM ========================================================================

declare
  ver varchar2(80);
  l_inst_type varchar2(80);
begin
  l_inst_type := '&install_type';

  -- determine if it is Database installation or iAS installation
  if (upper(l_inst_type) = 'DATABASE') then
    ver := dbms_registry.release_version;  
  else
    ver := '9.2.0.7.0';
  end if;

  dbms_registry.loaded('WK', ver,
		       'Oracle Ultra Search Release '||ver||' - Production');
  -- validate the installation
  wk_util.valid;

end;
/
