Rem
Rem $Header: wk0plb.sql 15-sep-2003.13:05:11 vnimani Exp $
Rem
Rem wk0plb.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      wk0plb.sql
Rem
Rem    DESCRIPTION
Rem      loads the ultrasearch package bodies and grants privs. on them
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vnimani     09/15/03 - add wk1ous_adm.pkb 
Rem    wechin      01/28/02 - create 'or replace' synonym
Rem    chsin       01/09/02 - change optimize index time format
Rem    ymatsuda    08/02/01 - add wk0snapshot
Rem    dczhang     08/08/01 - load new query package
Rem    wechin      08/08/01 - remove wk$before_ins_proc
Rem    ymatsuda    07/26/01 - add change tracking triggers
Rem    echee       07/19/01 - add portal specific packages
Rem    wechin      06/22/01 - add wk_meta package
Rem    syang       06/08/01 - do not look up mid to replace ds id
Rem    syang       04/19/01 - handle file ds url insertion
Rem    wechin      03/23/01 - update before_ins_proc
Rem    syang       02/28/01 - create OPTIMIZE_INDEX under ctxsys
Rem    syang       02/20/01 - use wk_job.update_status in optimize_index
Rem    ymatsuda    02/05/01 - remove wk_qutil_w
Rem    dczhang     01/05/01 - continue on error
Rem    jshang      12/12/00 - Remove Query API wrapper wk0transqapi.plb
Rem    syang       12/04/00 - no ds id lookup
Rem    jshang      09/20/00 - Use wk_qutil_w.pkb first as wk_qutil_w.plb 
Rem                           does not exist
Rem    chsin       09/15/00 - add wk_qutil_w.plb
Rem    jshang      09/07/00 - Change wk0transapi package to plb file
Rem    jechow      08/29/00 - removed mailing list table join
Rem    jechow      08/24/00 - added trigger case for mail url
Rem    swkuo       08/23/00 - Add package compilation for Query API wrapper
Rem    jshang      07/20/00 - Add wk0queryexp.plb file
Rem    chsin       06/16/00 - add timing info for ji_error
Rem    ymatsuda    05/24/00 - extract body of before_ins_trig
Rem    jshang      04/19/00 - Add query API compilation
Rem    ymatsuda    03/02/00 - synonyms and grants
Rem    ymatsuda    02/16/00 - multi instance
Rem    echee       02/14/00 - adding new package for query administration
Rem    dyu         01/13/00 - pkb and plb load sql files
Rem    dyu         01/13/00 - Created
Rem


set feedback off
set verify off

PROMPT ================== Package Installation ==========================

REM =====================================================================
REM Package bodies
REM =====================================================================

PROMPT ...... wk0util.plb
@@wk0util.plb
show errors

PROMPT ...... wk0adm.plb
@@wk0adm.plb
show errors

PROMPT ...... wk0crw.plb
@@wk0crw.plb
show errors

PROMPT ...... wk0ds.plb
@@wk0ds.plb
show errors

PROMPT ...... wk0job.plb
@@wk0job.plb
show errors

PROMPT ...... wk0sgp.plb
@@wk0sgp.plb
show errors

PROMPT ...... wk0ddl.plb
@@wk0ddl.plb
show errors

PROMPT ...... wkierr.plb
@@wkierr.plb
show errors


PROMPT ...... wk0qadm.plb
@@wk0qadm.plb
show errors

PROMPT ...... wk0queryutil.plb
@@wk0queryutil.plb
show errors

PROMPT ...... wk0queryexp.plb
@@wk0queryexp.plb
show errors

PROMPT ...... wk0qapi.plb
@@wk0qapi.plb
show errors
  
PROMPT ...... wk0qry.plb
@@wk0qry.plb
show errors

PROMPT ...... wk0meta.plb
@@wk0meta.plb
show errors

PROMPT ...... wk1ous_adm.plb
@@wk1ous_adm.plb
show errors

PROMPT ...... wk0portal.plb
@@wk0portal.plb
show errors

PROMPT ...... wk0snapshot.plb
@@wk0snapshot.plb
show errors

whenever sqlerror continue;

REM =====================================================================
REM Package synonyms and grants
REM =====================================================================

create or replace public synonym wk_def for wksys.wk_def;
grant execute on wk_def to public;

create or replace public synonym wk_util for wksys.wk_util;
grant execute on wk_util to public;

create or replace public synonym wk_adm for wksys.wk_adm;
grant execute on wk_adm to public;

create or replace public synonym wk_crw for wksys.wk_crw;
grant execute on wk_crw to public;

create or replace public synonym wkds_adm for wksys.wkds_adm;
grant execute on wkds_adm to public;

create or replace public synonym wk_job for wksys.wk_job;
grant execute on wk_job to public;

create or replace public synonym wk_sgp for wksys.wk_sgp;
grant execute on wk_sgp to public;

create or replace public synonym wk_query_adm for wksys.wk_query_adm;
grant execute on wk_query_adm to public;

create or replace public synonym wk_ddl for wksys.wk_ddl;
grant execute on wk_ddl to public;

create or replace public synonym wk_err for wksys.wk_err;
grant execute on wk_err to public;

create or replace public synonym wk_qutil for wksys.wk_qutil;
grant execute on wk_qutil to public;

create or replace public synonym wk_queryapi for wksys.wk_queryapi;
grant execute on wk_queryapi to public;

create or replace public synonym wk_qry for wksys.wk_qry;
grant execute on wk_qry to public;

create or replace public synonym wk_meta for wksys.wk_meta;
grant execute on wk_meta to public;

create or replace public synonym wk_portal for wksys.wk_portal;
grant execute on wk_portal to public;

create or replace public synonym wk_snapshot for wksys.wk_snapshot;
grant execute on wk_snapshot to public;

create or replace public synonym ous_adm for wksys.ous_adm;
grant execute on ous_adm to public;



PROMPT ... creating procedure WK$PRE_OPTIMIZE_INDEX
CREATE OR REPLACE PROCEDURE WK$PRE_OPTIMIZE_INDEX(
  INST_ID IN NUMBER,
  JOB_ID  IN NUMBER,
  MAXTIME OUT NUMBER,
  DB_LOCK OUT VARCHAR2
) 
AS
  lv_maxtime number;
  err varchar2(2000);
  lk varchar2(128);
  rc number;
  launch_msg varchar2(4000);
  append_msg boolean := true;
BEGIN
  wk_adm.use_instance(inst_id);

  dbms_lock.allocate_unique('WK$OPTIMIZE_LOCK_'||inst_id,lk);
  rc := dbms_lock.request(lk, timeout=>0);
  if rc = 0 then
    select ji_maxtime into lv_maxtime from wk$job_info where ji_id = job_id;

    -- start optimizing index 
    launch_msg := wk_err.get_error_mesg(WKSYS.WKIG.DJ_JOB_RUNNING,
                                 to_char(SYSDATE,'DD Mon RRRR HH24:MI:SS'));
    wk_job.update_status(job_id, launch_msg, WKSYS.WK_JOB.PROCESS_RUNNING,
                         append_msg);

    maxtime := lv_maxtime;
    db_lock := lk;
    -- ctx_ddl.optimize_index(sch||'.WK$DOC_PATH_IDX','FULL', maxtime);
  elsif rc <> 1 then
    wk_err.push_internal('optimize_index','requesting a lock',rc);
    raise wk_def.isearch_error;
  end if;
EXCEPTION
  when wk_def.isearch_error then
    commit;
    err := wk_err.get_stack;
    goto report;
  when others then
    err := substrb(sqlerrm,1,2000);
  <<report>>
    begin
      launch_msg := wk_err.get_error_mesg(WKSYS.WKIG.DJ_JOB_ERROR_AT,err,
                           to_char(SYSDATE,'DD Mon RRRR HH24:MI:SS'));
      wk_job.update_status(job_id, launch_msg, WKSYS.WK_JOB.FAILED,
                         append_msg);
    exception
      when others then 
        raise wk_def.isearch_error;
    end;
END;
/
GRANT EXECUTE ON WK$PRE_OPTIMIZE_INDEX TO PUBLIC;


PROMPT ... creating procedure WK$POST_OPTIMIZE_INDEX
CREATE OR REPLACE PROCEDURE WK$POST_OPTIMIZE_INDEX(
  JOB_ID  IN NUMBER,
  DB_LOCK IN VARCHAR2
)
AS
  maxtime number;
  err varchar2(2000);
  rc number;
  launch_msg varchar2(4000);
  append_msg boolean := true;
BEGIN
  -- ctx_ddl.optimize_index(sch||'.WK$DOC_PATH_IDX','FULL', maxtime);

  launch_msg := wk_err.get_error_mesg(WKSYS.WKIG.DJ_JOB_SUCCESS);
  wk_job.update_status(job_id, launch_msg || '    '||
                  to_char(SYSDATE,'DD Mon RRRR HH24:MI:SS'),
                   WKSYS.WK_JOB.PROCESS_DONE, append_msg);


  rc := dbms_lock.release(db_lock);
  if rc<>0 then
    wk_err.push_internal('optimize_index','releasing a lock',rc);
    raise wk_def.isearch_error;
  end if;
EXCEPTION
  when wk_def.isearch_error then
    commit;
    err := wk_err.get_stack;
    goto report;
  when others then
    err := substrb(sqlerrm,1,2000);
  <<report>>
    begin
      launch_msg := wk_err.get_error_mesg(WKSYS.WKIG.DJ_JOB_ERROR_AT,err,
                           to_char(SYSDATE,'DD Mon RRRR HH24:MI:SS'));
      wk_job.update_status(job_id, launch_msg, WKSYS.WK_JOB.FAILED, append_msg);
    exception
      when others then 
        raise wk_def.isearch_error;
    end;
END;
/
GRANT EXECUTE ON WK$POST_OPTIMIZE_INDEX TO PUBLIC;

Rem ----------------------------------------------------------------------
Rem Change Tracking Triggers
Rem
Rem NOTE: No dictionary table should be created after this line
Rem ----------------------------------------------------------------------

PROMPT ... creating procedure WK$UPD_INST

CREATE OR REPLACE PROCEDURE WK$UPD_INST
AS
  ID NUMBER := SYS_CONTEXT('WK$CONTEXT','INST_ID');
  IMODE VARCHAR2(30) := SYS_CONTEXT('WK$CONTEXT','INST_MODE');
  ISNAP VARCHAR2(30) := SYS_CONTEXT('WK$CONTEXT','INST_SNAPSHOT');
BEGIN
  IF ID IS NULL THEN
    WK_ERR.PUSH(WKIG.AC_NO_INSTANCE_SELECTED);
    RAISE WK_DEF.ISEARCH_ERROR;
  END IF;

  IF IMODE = 'READ ONLY' THEN
    WK_ERR.PUSH(WKIG.AC_READONLY_INSTANCE);
    RAISE WK_DEF.ISEARCH_ERROR;
  ELSIF (IMODE = 'DROPPING' OR ISNAP IS NOT NULL) THEN
    NULL; -- do nothing
  ELSE
    -- double-check the mode
    UPDATE WK$INSTANCE SET INST_LASTMOD = SYSDATE
      WHERE INST_ID = ID AND INST_MODE = 'UPDATABLE';
    IF SQL%ROWCOUNT = 0 THEN
      WK_ERR.PUSH(WKIG.AC_READONLY_INSTANCE);
      RAISE WK_DEF.ISEARCH_ERROR;
    END IF;
  END IF;
END;
/

PROMPT ... creating change tracking triggers

DECLARE
  TEMPLATE VARCHAR2(4000) :=
    'create or replace trigger WK$UPD_INST_TRG%(N)'||
    ' before insert or delete or update ON %(TAB)'||
    ' begin wksys.wk$upd_inst; end;';
  STMT VARCHAR2(4000);
  N NUMBER := 1;
BEGIN
  FOR C IN (SELECT TABLE_NAME FROM DBA_TABLES
              WHERE OWNER = 'WKSYS' AND
                    TABLE_NAME LIKE 'WK$\_%' ESCAPE '\' AND
                    TABLE_NAME NOT IN ('WK$_TRACE', 'WK$_CRAWLER_STAT'))
  LOOP
    STMT := REPLACE(REPLACE(TEMPLATE, '%(N)', N), '%(TAB)', C.TABLE_NAME);
    EXECUTE IMMEDIATE STMT;
    N := N + 1;
  END LOOP;
EXCEPTION
  WHEN OTHERS THEN
    WK_ERR.TEXT_ON_STACK(sqlerrm);
    WK_ERR.PUSH(WKIG.IE_INTERNAL_ERROR, '['|| STMT || ']');
    WK_ERR.RAISE;    
END;
/
