Rem
Rem $Header: wk0pref.sql 16-sep-2002.17:05:46 syang Exp $
Rem
Rem wk0pref.sql
Rem
Rem Copyright (c) 1999, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      wk0pref.sql - index preference
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    syang       09/16/02 - bug 2569663: unsupported Inso output charset JA16_EUC
Rem    wechin      03/27/02 - bug 2287318 Mimetype field section
Rem    syang       10/15/01 - bug2054828: utf8 not supported by ctxhx
Rem    syang       07/18/01 - correct promtp to prompt
Rem    dczhang     07/12/01 - drop preferences before creating them
Rem    wechin      07/11/01 - add new zone and field sections
Rem    chsin       07/10/01 - fix bug 1851726 (increase buffer size for lang variable)
Rem    syang       06/22/01 - correct charset name for null filter
Rem    syang       04/11/01 - change storage initial extent size to 5M
Rem    syang       04/06/01 - add storage preference
Rem    syang       03/14/01 - one lexer for all single byte language
Rem    echee       01/23/01 - comment out substring index
Rem    syang       09/22/00 - more charsets that use null filter
Rem    ymatsuda    03/28/00 - cleanup
Rem    syang       02/18/00 - add more lexers
Rem    ymatsuda    02/16/00 - multi instance
Rem    syang       01/20/00 - no explicit file path
Rem    ymatsuda    01/20/00 - remove section definitions
Rem    ymatsuda    01/13/00 - remove HL section
Rem    ymatsuda    12/08/99 - add US7ASCII
Rem    jbai        12/07/99 - correct a typo
Rem    swkuo       11/23/99 - Create iSearch index
Rem    ymatsuda    11/23/99 - filter pref
Rem    ymatsuda    10/06/99 - Created
Rem

set feedback off
set verify off
  
begin
  ctx_ddl.drop_preference('wk_lexer');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_basic_lexer');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_japanese_lexer');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_chinese_lexer');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_korean_lexer');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_wordlist');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_storage');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_stoplist('wk_stoplist');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_section_group('wk_section_group');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_filter');
exception
  when others then
    null;
end;
/

begin
  ctx_ddl.drop_preference('wk_datastore');
exception
  when others then
    null;
end;
/
  
prompt  ...... creating lexer preference

begin
  ctx_ddl.create_preference('wk_basic_lexer','basic_lexer');
  ctx_ddl.set_attribute('wk_basic_lexer','base_letter','yes');
  --ctx_ddl.set_attribute('wk_basic_lexer','index_themes','yes');
end;
/
begin
  ctx_ddl.create_preference('wk_japanese_lexer','japanese_vgram_lexer');
end;
/
begin
  ctx_ddl.create_preference('wk_chinese_lexer','chinese_vgram_lexer');
end;
/
begin
  ctx_ddl.create_preference('wk_korean_lexer','korean_lexer');
end;
/
declare
  lang    varchar2(100);
  charset varchar2(30);
begin
  lang := userenv('language');
  charset := upper(substr(lang,instr(lang,'.')+1));
  ctx_ddl.create_preference('wk_lexer','multi_lexer');
  ctx_ddl.add_sub_lexer('wk_lexer','default','wk_basic_lexer');
  if (charset in ('JA16EUC', 'JA16SJIS', 'UTF8')) then
    ctx_ddl.add_sub_lexer('wk_lexer','ja','wk_japanese_lexer');
  end if;
  -- same lexer for both simplified and trad. Chinese
  if (charset in ('ZHS16CGB231280', 'ZHS16GBK', 'ZHT32EUC',
      'ZHT16BIG5', 'ZHT32TRIS', 'AL24UTFFSS', 'UTF8')) then
    ctx_ddl.add_sub_lexer('wk_lexer','zhs','wk_chinese_lexer','zh');
    ctx_ddl.add_sub_lexer('wk_lexer','zht','wk_chinese_lexer');
  end if;
  if (charset in ('KO16KSC5601', 'UTF8')) then
    ctx_ddl.add_sub_lexer('wk_lexer','ko','wk_korean_lexer');
  end if;
end;
/

prompt  ...... creating wordlist preference

begin
  ctx_ddl.create_preference('wk_wordlist','basic_wordlist');
  ctx_ddl.set_attribute('wk_wordlist','stemmer','auto');
  ctx_ddl.set_attribute('wk_wordlist','fuzzy_match','auto');
  -- ctx_ddl.set_attribute('wk_wordlist','substring_index','yes');
end;
/

prompt  ...... creating storage preference
begin
  ctx_ddl.create_preference('wk_storage','basic_storage');
  ctx_ddl.set_attribute('wk_storage','I_TABLE_CLAUSE','storage (INITIAL 5M NEXT 50M PCTINCREASE 1)');
  ctx_ddl.set_attribute('wk_storage','I_INDEX_CLAUSE','storage (INITIAL 5M NEXT 50M PCTINCREASE 1)');
end;
/

prompt  ...... creating stoplist

begin
  ctx_ddl.create_stoplist('wk_stoplist');

  ctx_ddl.add_stopword('wk_stoplist', 'of');
  ctx_ddl.add_stopword('wk_stoplist', 'to');
  ctx_ddl.add_stopword('wk_stoplist', 'a');
  ctx_ddl.add_stopword('wk_stoplist', 'in');
  ctx_ddl.add_stopword('wk_stoplist', 'and');
  ctx_ddl.add_stopword('wk_stoplist', 's');
  ctx_ddl.add_stopword('wk_stoplist', 'the');
  ctx_ddl.add_stopword('wk_stoplist', 'for');
  ctx_ddl.add_stopword('wk_stoplist', 'that');
  ctx_ddl.add_stopword('wk_stoplist', 'is');
  ctx_ddl.add_stopword('wk_stoplist', 'it');
  ctx_ddl.add_stopword('wk_stoplist', 'on');
  ctx_ddl.add_stopword('wk_stoplist', 'at');
  ctx_ddl.add_stopword('wk_stoplist', 'as');
  ctx_ddl.add_stopword('wk_stoplist', 'with');
  ctx_ddl.add_stopword('wk_stoplist', 'by');
  ctx_ddl.add_stopword('wk_stoplist', 'from');
  ctx_ddl.add_stopword('wk_stoplist', 'mr');
  ctx_ddl.add_stopword('wk_stoplist', 'mz');
  ctx_ddl.add_stopword('wk_stoplist', 'mrs');
  ctx_ddl.add_stopword('wk_stoplist', 'ms');
  ctx_ddl.add_stopword('wk_stoplist', 'its');
  ctx_ddl.add_stopword('wk_stoplist', 'be');
  ctx_ddl.add_stopword('wk_stoplist', 'he');
  ctx_ddl.add_stopword('wk_stoplist', 'she');
  ctx_ddl.add_stopword('wk_stoplist', 'was');
  ctx_ddl.add_stopword('wk_stoplist', 'an');
  ctx_ddl.add_stopword('wk_stoplist', 'are');
  ctx_ddl.add_stopword('wk_stoplist', 'has');
  ctx_ddl.add_stopword('wk_stoplist', 'but');
  ctx_ddl.add_stopword('wk_stoplist', 'will');
  ctx_ddl.add_stopword('wk_stoplist', 'have');
  ctx_ddl.add_stopword('wk_stoplist', 'or');
  ctx_ddl.add_stopword('wk_stoplist', 'about');
  ctx_ddl.add_stopword('wk_stoplist', 'this');
  ctx_ddl.add_stopword('wk_stoplist', 'which');
  ctx_ddl.add_stopword('wk_stoplist', 'they');
  ctx_ddl.add_stopword('wk_stoplist', 'more');
  ctx_ddl.add_stopword('wk_stoplist', 'would');
  ctx_ddl.add_stopword('wk_stoplist', 'one');
  ctx_ddl.add_stopword('wk_stoplist', 'says');
  ctx_ddl.add_stopword('wk_stoplist', 'who');
  ctx_ddl.add_stopword('wk_stoplist', 'than');
  ctx_ddl.add_stopword('wk_stoplist', 'his');
  ctx_ddl.add_stopword('wk_stoplist', 'her');
  ctx_ddl.add_stopword('wk_stoplist', 'up');
  ctx_ddl.add_stopword('wk_stoplist', 'their');
  ctx_ddl.add_stopword('wk_stoplist', 'inc');
  ctx_ddl.add_stopword('wk_stoplist', 'been');
  ctx_ddl.add_stopword('wk_stoplist', 'also');
  ctx_ddl.add_stopword('wk_stoplist', 'had');
  ctx_ddl.add_stopword('wk_stoplist', 'were');
  ctx_ddl.add_stopword('wk_stoplist', 'corp');
  ctx_ddl.add_stopword('wk_stoplist', 'other');
  ctx_ddl.add_stopword('wk_stoplist', 'some');
  ctx_ddl.add_stopword('wk_stoplist', 'last');
  ctx_ddl.add_stopword('wk_stoplist', 'we');
  ctx_ddl.add_stopword('wk_stoplist', 'if');
  ctx_ddl.add_stopword('wk_stoplist', 'out');
  ctx_ddl.add_stopword('wk_stoplist', 'co');
  ctx_ddl.add_stopword('wk_stoplist', 'not');
  ctx_ddl.add_stopword('wk_stoplist', 'all');
  ctx_ddl.add_stopword('wk_stoplist', 'after');
  ctx_ddl.add_stopword('wk_stoplist', 'over');
  ctx_ddl.add_stopword('wk_stoplist', 'when');
  ctx_ddl.add_stopword('wk_stoplist', 'because');
  ctx_ddl.add_stopword('wk_stoplist', 'there');
  ctx_ddl.add_stopword('wk_stoplist', 'can');
  ctx_ddl.add_stopword('wk_stoplist', 'such');
  ctx_ddl.add_stopword('wk_stoplist', 'could');
  ctx_ddl.add_stopword('wk_stoplist', 'no');
  ctx_ddl.add_stopword('wk_stoplist', 'only');
  ctx_ddl.add_stopword('wk_stoplist', 'so');
  ctx_ddl.add_stopword('wk_stoplist', 'most');
  ctx_ddl.add_stopword('wk_stoplist', 'into');
  ctx_ddl.add_stopword('wk_stoplist', 'any');
end;
/

prompt  ...... creating section group
begin
  ctx_ddl.create_section_group('wk_section_group', 'html_section_group');
end;
/

prompt  ...... creating zone sections
begin
 for x in 0..99 loop
   ctx_ddl.add_zone_section('wk_section_group', 
     wk_meta.STRING_SEC_NAME_PREFIX||to_char(x), 'WKASTR'||to_char(x));
 end loop;
end;
/

prompt  ...... creating field sections
begin
  ctx_ddl.add_field_section('wk_section_group', wk_meta.MIMETYPE_SEC_NAME, 'WKMIMETYPE');
  ctx_ddl.add_field_section('wk_section_group', wk_meta.DS_SEC_NAME, 'WKDATASOURCE');
  ctx_ddl.add_field_section('wk_section_group', wk_meta.BIN_SEC_NAME, 'WKABIN');
end;
/


prompt  ...... creating filter preference
declare
  lang    varchar2(100);
  charset varchar2(30);
begin
  lang := userenv('language');
  charset := upper(substr(lang,instr(lang,'.')+1));

  -- this part needs to be consistent with the cache char set. (wk0init.sql)
  if (charset in ('JA16SJIS', 'US7ASCII', 'WE8ISO8859P1',
                  'EE8ISO8859P2','SE8ISO8859P3','NEE8ISO8859P4','CL8ISO8859P5',
                  'AR8ISO8859P6','EL8ISO8859P7', 'IW8ISO8859P8','WE8ISO8859P9',
                  'ZHS16CGB231280','ZHT16BIG5','KO16KSC5601'))
  then
    ctx_ddl.create_preference('wk_filter','null_filter');
  else
    ctx_ddl.create_preference('wk_filter','charset_filter');
    ctx_ddl.set_attribute('wk_filter','charset','UTF16AUTO');
  end if;
end;
/

prompt  ...... creating datastore preference
begin
  ctx_ddl.create_preference('wk_datastore','file_datastore');
end;
/

