Rem
Rem $Header: wk0tabs.sql 31-jan-02.23:11:04 yuyang Exp $
Rem
Rem  wk0tabs.sql
Rem
Rem Copyright (c) 1999, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      wk0tabs.sql
Rem
Rem    DESCRIPTION
Rem      Definitions of iSearch URL table, Docment table and dictionary tables
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yuyang      01/31/02 - grant IAS_ADMIN sysadmin privileges
Rem    wechin      01/28/02 - create 'or replace' synonym
Rem    wechin      01/22/02 - add wk$sys_config table
Rem    chsin       01/09/02 - add job process status
Rem    ymatsuda    11/14/01 - subscriber
Rem    syang       11/02/01 - ST_JAR_FILE can be null for default type
Rem    syang       11/01/01 - set default DS_CRAWLING_MODE value
Rem    syang       11/01/01 - set ST_CLASS as not null
Rem    wechin      10/01/01 - create or replace views
Rem    ymatsuda    08/29/01 - add sys_admin_list view
Rem    ymatsuda    08/17/01 - add wk$sys_priv
Rem    wechin      08/16/01 - change wk$group_ds_mapping primary key
Rem    echee       08/16/01 - Change rootfolder_url to url_base
Rem    wechin      08/10/01 - remove sequence wk$data_source_type_seq
Rem    wechin      08/08/01 - add unique constraint on wk$attr_mapping
Rem    wechin      08/03/01 - remove wk$attribute
Rem    syang       08/01/01 - add crawling mode column to wk$crawler_sched
Rem    wechin      08/01/01 - remove wk$attr_mapping_new
Rem    ymatsuda    08/01/01 - snapshot support
Rem    ymatsuda    07/26/01 - add lastmod and mode to wk$instance
Rem    wechin      07/23/01 - fix wk$doc_attr unique constraint
Rem    echee       07/17/01 - add Portal related tables
Rem    wechin      07/11/01 - add foreign key on wk$attr_usage table
Rem    wechin      07/10/01 - add wk$attr_mapping_new for migration purpose
Rem    syang       07/17/01 - change ds_type to ds_type_id
Rem    wechin      07/03/01 - add _TL tables
Rem    wechin      06/28/01 - change WK$SEARCH_ATTR_SEQ
Rem    wechin      06/25/01 - update wk$attr_usage
Rem    ymatsuda    06/26/01 - remove table source related cols from data_source
Rem    syang       06/21/01 - add DS_TYPE_ID sequence
Rem    wechin      06/20/01 - add WK$SEARCH_ATTR table
Rem    wechin      06/18/01 - add new tables
Rem    ymatsuda    06/04/01 - passwd encryption
Rem    ymatsuda    05/30/01 - convert VPD to views
Rem    syang       05/04/01 - remove IOT from inst_admin due to IOT bug
Rem    syang       04/05/01 - extend cc_pvalue size to 4000
Rem    wechin      03/23/01 - add LPRIMARY column to WK$MAILLIST
Rem    dczhang     03/14/01 - add instance id column in crawler_stat
Rem    dczhang     03/07/01 - create wk$crawler_stat table
Rem    dczhang     03/06/01 - additions for crawler statistics
Rem    ymatsuda    02/09/01 - add langcol to data_source
Rem    echee       12/11/00 - basic authentication support
Rem    syang       12/05/00 - remove ds_id foreign key constrain from ATTR_MAPPING
Rem    echee       11/14/00 - fix_bug_1474977
Rem    echee       11/10/00 - fix_bug_1497052
Rem    ymatsuda    10/10/00 - table datasource log table
Rem    syang       09/28/00 - increase err column to 4k
Rem    echee       09/20/00 - grant select on crawler_config_default
Rem    echee       09/20/00 - Lengthen the CS_ERROR column in the WKCRAWLER_SCH
Rem    syang       09/14/00 - expand cc_pvalus column width
Rem    jechow      08/29/00 - added datasource id to mailing list table
Rem    echee       08/20/00 - multiple crawler support
Rem    chsin       08/10/00 - add TERRITORY_TAG column
Rem    chsin       08/02/00 -
Rem    jechow      07/26/00 - added wk$maillist table
Rem    syang       07/06/00 - create public synonym for wk$trace
Rem    ymatsuda    05/22/00 - fix sysinfo
Rem    ymatsuda    05/04/00 - add grant view
Rem    syang       04/24/00 - change wk$lang schema
Rem    ymatsuda    04/06/00 - grant wk$is_admin to public
Rem    syang       03/14/00 - fix insert before trigger
Rem    syang       03/07/00 - fix insert before trigger pattern matching
Rem    echee       02/21/00 - changing tabs to spaces
Rem    syang       02/18/00 - add wklang
Rem    ymatsuda    02/14/00 - multi instance
Rem    syang       02/10/00 - remove wk$CRAWER_SCHED_DS_ID_IDX
Rem    syang       02/09/00 - ds_src_url begins with http
Rem    echee       02/07/00 - adding tables for mimetypes and character set
Rem    syang       02/03/00 - add wk$schedule_mapping
Rem    syang       02/01/00 - data_source schema change
Rem    syang       01/17/00 - add cache_file_path, trace table
Rem    ymatsuda    01/12/00 - add wk$attribute
Rem    syang       01/03/00 - add CS_STATE to WK$CRAWLER_SCHED
Rem    jbai        12/14/99 - add wk$sys_admin table
Rem    swkuo       11/29/99 - Enlarge the size of DS_STATUS in wk$data_source
Rem    swkuo       11/24/99 - Create the seed table
Rem    swkuo       11/22/99 - Move the table initialization to wk0init.sql
Rem    ymatsuda    11/22/99 - fix del trig
Rem    syang       11/22/99 - add explanation for parameters needed
Rem    swkuo       11/18/99 - initialize the crawler table
Rem    ymatsuda    11/19/99 - remove crawler param from ds
Rem    ymatsuda    11/18/99 - source group mapping trigger
Rem    ymatsuda    11/16/99 - ds_id trigger, foreign key const.
Rem    swkuo       11/16/99 - Change the wk$crawler table schema
Rem    syang       11/15/99 - source group schema under 1 web ds
Rem    swkuo       11/12/99 - Add default settings for the mapping and collect
Rem    swkuo       11/11/99 - change the WK$CRAWLER table schema
Rem    syang       11/04/99 - support multiple seeds in data source table
Rem    syang       11/01/99 - add DATASOURCE_ID column to wk$crawler
Rem    swkuo       10/28/99 - create the WK$CRAWLER table
Rem    ymatsuda    10/22/99 - job/schedule tables
Rem    syang       10/21/99 - need to execute create type statement
Rem    syang       10/13/99 - create wk$source_group table
Rem    syang       10/11/99 - create wk$data_source and WK$DS_ID_SEQ
Rem    ymatsuda    09/22/99 - created

Rem 6 parameters needed for default crawler configuration
Rem CC_CACHE_DIRECTORY &1 e.g., /private/syang/crawl_cache
Rem CC_FILTER_PATH     &2 e.g., /vobs/ctx/bin/ctxhx
Rem CC_PASSWORD        &3 e.g., wksys
Rem CC_JAVA_EXEC_PATH  &4 e.g., /bin/java
Rem CC_JAVA_CLASS_PATH &5, &6, &7 e.g., 
Rem /net/stnfs1/sw4/packages/jdk1.1.5/lib/classes.zip:/vobs/ctx/lib/ctxutil.jar:
Rem /vobs/ctx/lib/crawler.jar:/vobs/ctx/lib/crawler_res.jar:
Rem /vobs/dbjava/lib/classes111.zip:/vobs/ctx/bin/
Rem CC_DATABASE        &8 e.g., syang-sun:5521:javadbms

PROMPT ... creating table WK$INSTANCE
CREATE TABLE WK$INSTANCE (
  INST_ID     NUMBER PRIMARY KEY,
  INST_NAME   VARCHAR2(100) NOT NULL,
  INST_SCHEMA VARCHAR2(30) NOT NULL,
  INST_USERID NUMBER NOT NULL,
  INST_MODE   VARCHAR2(30) NOT NULL,
  INST_LASTMOD DATE NOT NULL,
  UNIQUE (INST_NAME),
  UNIQUE (INST_SCHEMA)
);

CREATE SEQUENCE WK$INST_SEQ START WITH 1 NOMAXVALUE NOCYCLE;

PROMPT ... creating table WK$SYS_PRIV
CREATE TABLE WK$SYS_PRIV (
  SP_USERID   NUMBER,
  SP_USER     VARCHAR2(100),
  SP_OPTIONS  VARCHAR2(10),
  PRIMARY KEY (SP_USERID, SP_USER)
);

PROMPT ... creating table WK$SUBSCRIBER
CREATE TABLE WK$SUBSCRIBER (
  SU_ID   NUMBER,
  SU_NAME VARCHAR2(100),
  PRIMARY KEY (SU_ID),
  UNIQUE (SU_NAME)
);

CREATE SEQUENCE WK$SUBSCRIBER_SEQ START WITH 3 NOMAXVALUE NOCYCLE;

PROMPT ... creating table WK$INST_ADMIN
CREATE TABLE WK$INST_ADMIN (
  IA_INST_ID  NUMBER,
  IA_USER     VARCHAR2(100),
  IA_USERID   NUMBER NOT NULL,
  IA_OPTIONS  VARCHAR2(10),
  PRIMARY KEY (IA_INST_ID, IA_USERID, IA_USER),
  FOREIGN KEY (IA_INST_ID) REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE
);

PROMPT ... creating view WK$INST_ADMIN_LIST
CREATE OR REPLACE VIEW WK$INST_ADMIN_LIST AS
  SELECT * FROM WK$INST_ADMIN
    WHERE IA_INST_ID = to_number(sys_context('WK$CONTEXT','INST_ID')) AND
          INSTR(SYS_CONTEXT('WK$CONTEXT','OPTIONS'),'G') > 0;
CREATE OR REPLACE PUBLIC SYNONYM WK$INST_ADMIN_LIST
  FOR WKSYS.WK$INST_ADMIN_LIST;
GRANT SELECT ON WK$INST_ADMIN_LIST TO PUBLIC;

PROMPT ... creating function WK$USER
CREATE OR REPLACE FUNCTION WK$USER
  RETURN VARCHAR2
AS
BEGIN
  return nvl(sys_context('WK$CONTEXT', 'USER'),
             sys_context('USERENV', 'SESSION_USER'));
END;
/

PROMPT ... creating function WK$USERID
CREATE OR REPLACE FUNCTION WK$USERID
  RETURN NUMBER
AS
  FUNCTION GET_DATABASE_USERID RETURN VARCHAR2 AS
    ID NUMBER;
  BEGIN
    SELECT USER# INTO ID FROM SYS.USER$
      WHERE NAME = SYS_CONTEXT('USERENV','SESSION_USER');
    RETURN ID;
  END;
BEGIN
  RETURN NVL(TO_NUMBER(SYS_CONTEXT('WK$CONTEXT','USERID')),
             GET_DATABASE_USERID);
END;
/

PROMPT ... creating function WK$IS_ADMIN
CREATE OR REPLACE FUNCTION WK$IS_ADMIN(
  WITH_OPTION IN VARCHAR2 DEFAULT NULL
)
  RETURN NUMBER
AS
  CUSER VARCHAR2(200) := WK$USER;
  CUID  NUMBER := WK$USERID;
BEGIN
  IF (CUID >= 0 AND CUSER IN ('WKSYS', 'SYS')) THEN
    IF (WITH_OPTION IS NULL OR INSTR('G', WITH_OPTION) > 0) THEN
      RETURN 1;
    END IF;
  ELSIF (CUID = -2 AND CUSER IN ('IAS_ADMIN')) THEN
    IF (WITH_OPTION IS NULL OR INSTR('G', WITH_OPTION) > 0) THEN
      RETURN 1;
    END IF;
  ELSE
    FOR C IN (SELECT SP_USERID FROM WK$SYS_PRIV
                WHERE SP_USER = CUSER AND SP_USERID = CUID AND
                      (WITH_OPTION IS NULL OR
                       INSTR(SP_OPTIONS, WITH_OPTION) > 0))
    LOOP
      RETURN 1;
    END LOOP;
  END IF;
  RETURN 0;
END;
/
GRANT EXECUTE ON WK$IS_ADMIN TO PUBLIC;

PROMPT ... creating view WK$INST_LIST
CREATE OR REPLACE VIEW WK$INST_LIST AS
  SELECT INST_ID, INST_NAME, INST_SCHEMA, INST_MODE FROM WK$INSTANCE
    WHERE (INST_SCHEMA = SYS_CONTEXT('USERENV', 'SESSION_USER') and
           WK$USERID >= 0) OR
          WK$IS_ADMIN = 1 OR
          EXISTS(SELECT * FROM WK$INST_ADMIN
                 WHERE IA_INST_ID = INST_ID AND
                       IA_USER = WK$USER AND IA_USERID = WK$USERID);
CREATE OR REPLACE PUBLIC SYNONYM WK$INST_LIST FOR WKSYS.WK$INST_LIST;
GRANT SELECT ON WK$INST_LIST TO PUBLIC;

PROMPT ... creating view WK$SYS_ADMIN_LIST
CREATE OR REPLACE VIEW WK$SYS_ADMIN_LIST AS
  SELECT * FROM WK$SYS_PRIV WHERE WK$IS_ADMIN = 1;
CREATE OR REPLACE PUBLIC SYNONYM WK$SYS_ADMIN_LIST
  FOR WKSYS.WK$SYS_ADMIN_LIST;
GRANT SELECT ON WK$SYS_ADMIN_LIST TO PUBLIC;

PROMPT ... creating table WK$SYSINFO
CREATE TABLE WK$_SYSINFO (
  WK$IID   NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                  REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  SI_NAME   VARCHAR2(30),
  SI_VALUE  VARCHAR2(4000),
  SI_MODIFIED DATE,
  PRIMARY KEY (WK$IID, SI_NAME)
)
ORGANIZATION INDEX OVERFLOW;
CREATE OR REPLACE VIEW WK$SYSINFO AS
  SELECT * FROM WK$_SYSINFO
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

PROMPT ... creating table WK$SYS_CONFIG
CREATE TABLE WK$SYS_CONFIG (
  SC_NAME   VARCHAR2(30),
  SC_VALUE  VARCHAR2(4000),
  SC_MODIFIED DATE,
  PRIMARY KEY (SC_NAME)
);
CREATE OR REPLACE PUBLIC SYNONYM WK$SYS_CONFIG FOR WKSYS.WK$SYS_CONFIG;
GRANT SELECT ON WK$SYS_CONFIG TO PUBLIC;
GRANT UPDATE ON WK$SYS_CONFIG TO DBA;


Rem 
Rem  System administration table
Rem

PROMPT ... creating table WK$SYS_ADMIN
CREATE TABLE WK$_SYS_ADMIN
(
  WK$IID   NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                  REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  SA_NAME  VARCHAR2(30),
  SA_VALUE VARCHAR2(500)
);
CREATE OR REPLACE VIEW WK$SYS_ADMIN AS
  SELECT * FROM WK$_SYS_ADMIN
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$SYS_ADMIN FOR WKSYS.WK$SYS_ADMIN;
GRANT SELECT ON WK$SYS_ADMIN TO PUBLIC;

PROMPT ... creating table WK$DATA_SOURCE_TYPE
CREATE TABLE WK$_DATA_SOURCE_TYPE
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  ST_ID          NUMBER,
  ST_NAME        VARCHAR2(1000) NOT NULL,
  ST_CLASS       VARCHAR2(4000),
  ST_JAR_FILE    VARCHAR2(4000),
  ST_DESCRIPTION VARCHAR2(4000),
  PRIMARY KEY(WK$IID, ST_ID),
  UNIQUE(WK$IID, ST_NAME)
);

PROMPT ... creating sequence WK$DSTYPE_ID_SEQ 
Rem  type id 1-100 is reserved for predefined ds types
CREATE SEQUENCE WK$DSTYPE_ID_SEQ START WITH 101 NOMAXVALUE;

CREATE OR REPLACE VIEW WK$DATA_SOURCE_TYPE AS
  SELECT * FROM WK$_DATA_SOURCE_TYPE
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$DATA_SOURCE_TYPE 
  FOR WKSYS.WK$DATA_SOURCE_TYPE;
GRANT SELECT ON WK$DATA_SOURCE_TYPE TO PUBLIC;


CREATE INDEX WK$DATA_SOURCE_TYPE_IDX ON WK$_DATA_SOURCE_TYPE(ST_ID);

PROMPT ... creating table WK$DATA_SOURCE
CREATE TABLE WK$_DATA_SOURCE
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  DS_ID          NUMBER,
  DS_NAME        VARCHAR2(100) NOT NULL,
  DS_TYPE_ID     NUMBER,
  DS_DEFLANG     VARCHAR2(30) DEFAULT 'ENGLISH',
  DS_SRC_URL     VARCHAR2(740),
  DS_STATUS      VARCHAR2(100),
  DS_CRAWLING_MODE  CHAR(1) DEFAULT 'R',
  DS_LAST_CRAWL  DATE,
  PRIMARY KEY (WK$IID, DS_ID),
  FOREIGN KEY (WK$IID, DS_TYPE_ID)
    REFERENCES WK$_DATA_SOURCE_TYPE(WK$IID, ST_ID),
  UNIQUE (WK$IID, DS_NAME)
);
CREATE OR REPLACE VIEW WK$DATA_SOURCE AS
  SELECT * FROM WK$_DATA_SOURCE
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$DATA_SOURCE FOR WKSYS.WK$DATA_SOURCE;
GRANT SELECT ON WK$DATA_SOURCE TO PUBLIC;

PROMPT ... creating table WK$TDS_LOG
CREATE TABLE WK$_TDS_LOG
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  TL_DS_ID       NUMBER,
  TL_TABLE       VARCHAR2(32) NOT NULL,
  PRIMARY KEY (WK$IID, TL_DS_ID),
  FOREIGN KEY (WK$IID, TL_DS_ID) REFERENCES WK$_DATA_SOURCE(WK$IID, DS_ID)
    ON DELETE CASCADE
);
CREATE OR REPLACE VIEW WK$TDS_LOG AS
  SELECT * FROM WK$_TDS_LOG
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$TDS_LOG FOR WKSYS.WK$TDS_LOG;
GRANT SELECT ON WK$TDS_LOG TO PUBLIC;

PROMPT ... creating sequence WK$DS_ID_SEQ 
CREATE SEQUENCE WK$DS_ID_SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating sequence WK$SG_ID_SEQ 
CREATE SEQUENCE WK$SG_ID_SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating table WK$SOURCE_GROUP
CREATE TABLE WK$_SOURCE_GROUP
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  SG_ID          NUMBER,
  SG_NAME        VARCHAR2(100) NOT NULL,
  PRIMARY KEY (WK$IID, SG_ID),
  UNIQUE (WK$IID, SG_NAME)
)
ORGANIZATION INDEX;
CREATE OR REPLACE VIEW WK$SOURCE_GROUP AS
  SELECT * FROM WK$_SOURCE_GROUP
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$SOURCE_GROUP FOR WKSYS.WK$SOURCE_GROUP;
GRANT SELECT ON WK$SOURCE_GROUP TO PUBLIC;

PROMPT ... creating table WK$SOURCE_GROUP_TL
CREATE TABLE WK$_SOURCE_GROUP_TL
(
  WK$IID           NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                          REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  SGT_SG_ID        NUMBER,
  SGT_LANG         VARCHAR2(5),
  SGT_DISPLAY_NAME VARCHAR2(500),
  PRIMARY KEY (WK$IID, SGT_SG_ID, SGT_LANG),
  FOREIGN KEY (WK$IID, SGT_SG_ID) REFERENCES WK$_SOURCE_GROUP(WK$IID, SG_ID)
    ON DELETE CASCADE
)
ORGANIZATION INDEX;
CREATE OR REPLACE VIEW WK$SOURCE_GROUP_TL AS
  SELECT * FROM WK$_SOURCE_GROUP_TL
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$SOURCE_GROUP_TL
  FOR WKSYS.WK$SOURCE_GROUP_TL;
GRANT SELECT ON WK$SOURCE_GROUP_TL TO PUBLIC;


PROMPT ... creating table WK$GROUP_DS_MAPPING
CREATE TABLE WK$_GROUP_DS_MAPPING
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  DS_ID          NUMBER,
  SG_ID          NUMBER,
  PRIMARY KEY (WK$IID, DS_ID, SG_ID),
  FOREIGN KEY (WK$IID, SG_ID) REFERENCES WK$_SOURCE_GROUP(WK$IID, SG_ID)
    ON DELETE CASCADE,
  FOREIGN KEY (WK$IID, DS_ID) REFERENCES WK$_DATA_SOURCE(WK$IID, DS_ID)
    ON DELETE CASCADE
)
ORGANIZATION INDEX;
CREATE OR REPLACE VIEW WK$GROUP_DS_MAPPING AS
  SELECT * FROM WK$_GROUP_DS_MAPPING
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$GROUP_DS_MAPPING
  FOR WKSYS.WK$GROUP_DS_MAPPING;
GRANT SELECT ON WK$GROUP_DS_MAPPING TO PUBLIC;

PROMPT ... creating sequence WK$JOB_ID_SEQ 
CREATE SEQUENCE WK$JOB_ID_SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating table WK$JOB_INFO
CREATE TABLE WK$_JOB_INFO
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  JI_ID          NUMBER,
  JI_TYPE        NUMBER,
  JI_JOB_NO      NUMBER,
  JI_INTERVAL    VARCHAR2(30),
  JI_MAXTIME     NUMBER,
  JI_ERROR       VARCHAR2(4000),
  JI_PROCESS_STATUS VARCHAR2(100),
  JI_PROCESS_START DATE DEFAULT NULL,
  JI_PROCESS_END   DATE DEFAULT NULL,
  PRIMARY KEY (WK$IID, JI_ID)
);
CREATE OR REPLACE VIEW WK$JOB_INFO AS
  SELECT * FROM WK$_JOB_INFO
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$JOB_INFO FOR WKSYS.WK$JOB_INFO;
GRANT SELECT ON WK$JOB_INFO TO PUBLIC;

PROMPT ... creating sequence WK$SCHED_ID_SEQ 
CREATE SEQUENCE WK$SCHED_ID_SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating table WK$CRAWLER_SCHED
CREATE TABLE WK$_CRAWLER_SCHED
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  CS_ID          NUMBER,
  CS_NAME        VARCHAR2(100) NOT NULL,
  CS_INTERVAL    VARCHAR2(30),
  CS_LAST_RUN    DATE default NULL,
  CS_NEXT        DATE,
  CS_STATE       VARCHAR2(100),
  CS_ERROR       VARCHAR2(4000),
  CS_LOG_NAME    VARCHAR2(100),
  CRAWLER_ID     NUMBER,
  RUN_REMOTE     NUMBER DEFAULT 0,  
  FORCE_RECRAWL  NUMBER DEFAULT 0,  
  CS_CRAWL_MODE  VARCHAR2(30) DEFAULT 'REGULAR',
  PRIMARY KEY (WK$IID, CS_ID),
  UNIQUE (WK$IID, CS_NAME)
);
CREATE OR REPLACE VIEW WK$CRAWLER_SCHED AS
  SELECT * FROM WK$_CRAWLER_SCHED
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$CRAWLER_SCHED FOR WKSYS.WK$CRAWLER_SCHED;
GRANT SELECT ON WK$CRAWLER_SCHED TO PUBLIC;

PROMPT ... creating table WK$SCHED_MAPPING
CREATE TABLE WK$_SCHED_MAPPING
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  SM_SCHED_ID    NUMBER NOT NULL,
  SM_DS_ID       NUMBER,
  PRIMARY KEY (WK$IID, SM_DS_ID),
  FOREIGN KEY (WK$IID, SM_SCHED_ID) REFERENCES WK$_CRAWLER_SCHED(WK$IID, CS_ID)
    ON DELETE CASCADE,
  FOREIGN KEY (WK$IID, SM_DS_ID) REFERENCES WK$_DATA_SOURCE(WK$IID, DS_ID)
    ON DELETE CASCADE
);
CREATE OR REPLACE VIEW WK$SCHED_MAPPING AS
  SELECT * FROM WK$_SCHED_MAPPING
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$SCHED_MAPPING FOR WKSYS.WK$SCHED_MAPPING;
GRANT SELECT ON WK$SCHED_MAPPING TO PUBLIC;

PROMPT ... creating sequence for multiple crawler instances WK$CRAWLERID_SEQ
Rem make sure that the starting sequence number is equal (or greater than) to the constant WK_CRW.REMOTE_CRAWLER_MINID
CREATE SEQUENCE WK$CRAWLERID_SEQ START WITH 1000 NOMAXVALUE;

PROMPT ... creating table WK$CRAWLER_CONFIG
CREATE TABLE WK$_CRAWLER_CONFIG
(
  WK$IID              NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                             REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  CC_CW_ID            number,
  CC_PNAME            varchar2(30),
  CC_PVALUE           varchar2(4000)
);
CREATE OR REPLACE VIEW WK$CRAWLER_CONFIG AS
  SELECT * FROM WK$_CRAWLER_CONFIG
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$CRAWLER_CONFIG 
  FOR WKSYS.WK$CRAWLER_CONFIG;
GRANT SELECT ON WK$CRAWLER_CONFIG TO PUBLIC;

CREATE INDEX WK$CC_IDX ON WK$_CRAWLER_CONFIG(WK$IID, CC_PNAME);

PROMPT ... creating table WK$CRAWLER_CONFIG_DEFAULT
CREATE TABLE WK$CRAWLER_CONFIG_DEFAULT
(
  CCD_CW_ID           number,
  CCD_PNAME           varchar2(30),
  CCD_PVALUE          varchar2(4000)
);
CREATE OR REPLACE PUBLIC SYNONYM WK$CRAWLER_CONFIG_DEFAULT
  FOR WKSYS.WK$CRAWLER_CONFIG_DEFAULT;
GRANT SELECT ON WK$CRAWLER_CONFIG_DEFAULT TO PUBLIC;

PROMPT ... creating table WK$TRACE
CREATE TABLE WK$_TRACE
(
  WK$IID              NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                             REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  EVENT               number,
  SOURCE              varchar2(50),
  ACTION              varchar2(50),
  DESCRIPTION         varchar2(4000),
  TIME_STAMP          date,
  PRIMARY KEY(WK$IID, EVENT)
);
CREATE OR REPLACE VIEW WK$TRACE AS
  SELECT * FROM WK$_TRACE
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$TRACE FOR WKSYS.WK$TRACE;
GRANT SELECT ON WK$TRACE TO PUBLIC;

PROMPT ... creating sequence WK$TRACE_SEQ 
CREATE SEQUENCE WK$TRACE_SEQ START WITH 11 NOMAXVALUE;

PROMPT ... creating table WK$SEARCH_ATTR
CREATE TABLE WK$_SEARCH_ATTR
(
 WK$IID            NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                            REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
 ATT_ID            NUMBER,
 ATT_NAME          VARCHAR2(128) NOT NULL,
 ATT_UNAME         VARCHAR2(128) NOT NULL,
 ATT_DATATYPE_ID   NUMBER        NOT NULL,
 ATT_SEARCHABLE    CHAR(1)       NOT NULL,
 PRIMARY KEY (WK$IID, ATT_ID),
 UNIQUE (WK$IID, ATT_UNAME, ATT_DATATYPE_ID)
)
ORGANIZATION INDEX;
CREATE OR REPLACE VIEW WK$SEARCH_ATTR AS
  SELECT * FROM WK$_SEARCH_ATTR
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$SEARCH_ATTR FOR WKSYS.WK$SEARCH_ATTR;
GRANT SELECT ON WK$SEARCH_ATTR TO PUBLIC;

PROMPT ... creating sequence WK$SEARCH_ATTR_SEQ
CREATE SEQUENCE WK$SEARCH_ATTR_SEQ START WITH 100 NOMAXVALUE NOCYCLE;


PROMPT ... creating table WK$SEARCH_ATTR_TL
CREATE TABLE WK$_SEARCH_ATTR_TL
(
 WK$IID            NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                            REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
 SAT_ATT_ID        NUMBER,
 SAT_LANG          VARCHAR2(5),
 SAT_DISPLAY_NAME  VARCHAR2(500),
 FOREIGN KEY (WK$IID, SAT_ATT_ID) REFERENCES WK$_SEARCH_ATTR(WK$IID, ATT_ID)
   ON DELETE CASCADE,
 PRIMARY KEY (WK$IID, SAT_ATT_ID, SAT_LANG)
)
ORGANIZATION INDEX;
CREATE OR REPLACE VIEW WK$SEARCH_ATTR_TL AS
  SELECT * FROM WK$_SEARCH_ATTR_TL
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$SEARCH_ATTR_TL 
  FOR WKSYS.WK$SEARCH_ATTR_TL;
GRANT SELECT ON WK$SEARCH_ATTR_TL TO PUBLIC;


PROMPT ... creating table WK$DOC_ATTR
CREATE TABLE WK$_DOC_ATTR
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  DAT_ID         NUMBER,
  DAT_UNAME      VARCHAR2(128) NOT NULL,
  DAT_DATATYPE_ID  NUMBER        NOT NULL, 
  PRIMARY KEY (WK$IID, DAT_ID),
  UNIQUE (WK$IID, DAT_UNAME, DAT_DATATYPE_ID)
)
ORGANIZATION INDEX;
CREATE OR REPLACE VIEW WK$DOC_ATTR AS
  SELECT * FROM WK$_DOC_ATTR
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$DOC_ATTR FOR WKSYS.WK$DOC_ATTR;
GRANT SELECT ON WK$DOC_ATTR TO PUBLIC;

PROMPT ... creating sequence WK$DOC_ATTR_SEQ
CREATE SEQUENCE WK$DOC_ATTR_SEQ START WITH 1 NOMAXVALUE NOCYCLE;


PROMPT ... creating table WK$ATTR_USAGE
CREATE TABLE WK$_ATTR_USAGE
(
 WK$IID            NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                            REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
 AU_DS_ID          NUMBER,
 AU_DOC_ATTR_ID    NUMBER,
 AU_SEARCH_ATTR_ID NUMBER,
 AU_SYNC_POLICY    CHAR(1) DEFAULT 'A',
 PRIMARY KEY (WK$IID, AU_DS_ID, AU_DOC_ATTR_ID),
 FOREIGN KEY (WK$IID, AU_DS_ID) REFERENCES WK$_DATA_SOURCE(WK$IID, DS_ID)
   ON DELETE CASCADE,
 FOREIGN KEY (WK$IID, AU_SEARCH_ATTR_ID)
   REFERENCES WK$_SEARCH_ATTR(WK$IID, ATT_ID)
)
ORGANIZATION INDEX;

CREATE OR REPLACE VIEW WK$ATTR_USAGE AS
  SELECT * FROM WK$_ATTR_USAGE
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$ATTR_USAGE FOR WKSYS.WK$ATTR_USAGE;
GRANT SELECT ON WK$ATTR_USAGE TO PUBLIC;



PROMPT ... creating table WK$DATA_SOURCE_PARAM
CREATE TABLE WK$_DATA_SOURCE_PARAM
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  PA_ST_ID       NUMBER        NOT NULL,
  PA_ID          NUMBER        NOT NULL,
  PA_NAME        VARCHAR2(100) NOT NULL,
  PA_ENCRYPT     CHAR(1)       NOT NULL,
  PA_DESCRIPTION VARCHAR2(4000),
  PRIMARY KEY(WK$IID, PA_ID),
  UNIQUE(WK$IID, PA_ST_ID, PA_NAME),
  FOREIGN KEY (WK$IID, PA_ST_ID) REFERENCES WK$_DATA_SOURCE_TYPE(WK$IID, ST_ID)
    ON DELETE CASCADE
);
CREATE OR REPLACE VIEW WK$DATA_SOURCE_PARAM AS
  SELECT * FROM WK$_DATA_SOURCE_PARAM
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

PROMPT ... creating sequence WK$DSPARAM_ID_SEQ 
CREATE SEQUENCE WK$DSPARAM_ID_SEQ START WITH 1 NOMAXVALUE;

CREATE OR REPLACE PUBLIC SYNONYM WK$DATA_SOURCE_PARAM 
  FOR WKSYS.WK$DATA_SOURCE_PARAM;
GRANT SELECT ON WK$DATA_SOURCE_PARAM TO PUBLIC;

PROMPT ... creating sequence WK$DATA_SOURCE_PARAM_SEQ
CREATE SEQUENCE WK$DATA_SOURCE_PARAM_SEQ START WITH 1 NOMAXVALUE NOCYCLE;

CREATE INDEX WK$DATA_SOURCE_PARAM_IDX ON WK$_DATA_SOURCE_PARAM(PA_ST_ID, PA_ID);


PROMPT ... creating table WK$DATA_SOURCE_PARAM_VAL
CREATE TABLE WK$_DATA_SOURCE_PARAM_VAL
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  PV_DS_ID       NUMBER           NOT NULL, 
  PV_PA_ID       NUMBER           NOT NULL, 
  PV_VALUE       VARCHAR2(4000),
  FOREIGN KEY (WK$IID, PV_PA_ID)
    REFERENCES WK$_DATA_SOURCE_PARAM(WK$IID, PA_ID)
    ON DELETE CASCADE,
  FOREIGN KEY (WK$IID, PV_DS_ID) REFERENCES WK$_DATA_SOURCE(WK$IID, DS_ID)
    ON DELETE CASCADE
);

CREATE OR REPLACE VIEW WK$DATA_SOURCE_PARAM_VAL AS
  SELECT * FROM WK$_DATA_SOURCE_PARAM_VAL
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$DATA_SOURCE_PARAM_VAL
  FOR WKSYS.WK$DATA_SOURCE_PARAM_VAL;
GRANT SELECT ON WK$DATA_SOURCE_PARAM_VAL TO PUBLIC;

CREATE INDEX WK$DATA_SOURCE_PARAM_VAL_IDX ON WK$_DATA_SOURCE_PARAM_VAL(PV_DS_ID, PV_PA_ID);

PROMPT ... creating table WK$ATTR_MAPPING
CREATE TABLE WK$_ATTR_MAPPING
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  AM_DS_ID       NUMBER NOT NULL,
  AM_DOC_ATTR_ID NUMBER NOT NULL,
  AM_FIELD       VARCHAR2(256) NOT NULL,
  AM_TYPE        VARCHAR2(30) NOT NULL,
  UNIQUE (WK$IID, AM_DS_ID, AM_FIELD),
  UNIQUE (WK$IID, AM_DS_ID, AM_DOC_ATTR_ID),
  FOREIGN KEY (WK$IID, AM_DS_ID) REFERENCES WK$_DATA_SOURCE (WK$IID, DS_ID)
    ON DELETE CASCADE,
  CONSTRAINT WK$AM_TYPE_CONST CHECK
    (AM_TYPE IN ('COLUMN', 'META TAG', 'FIELD TAG', 'ZONE TAG'))
);
CREATE OR REPLACE VIEW WK$ATTR_MAPPING AS
  SELECT * FROM WK$_ATTR_MAPPING
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$ATTR_MAPPING FOR WKSYS.WK$ATTR_MAPPING;
GRANT SELECT ON WK$ATTR_MAPPING TO PUBLIC;

CREATE INDEX WK$ATTR_MAPPING_IDX ON WK$_ATTR_MAPPING(AM_DS_ID, AM_doc_ATTr_ID);

PROMPT ... creating sequence WK$MIMETYPES_SEQ
CREATE SEQUENCE WK$MIMETYPES_SEQ START WITH 1 NOMAXVALUE NOCYCLE;

PROMPT ... creating table WK$MIMETYPES
CREATE TABLE WK$MIMETYPES
(
  ID            NUMBER NOT NULL,
  DESCRIPTOR    VARCHAR2(256) NOT NULL,
  MEDIA_TYPE    VARCHAR2(256) NOT NULL,
  EXTENSIONS    VARCHAR2(256) NOT NULL, 
  MSG_ID        NUMBER UNIQUE
);

CREATE OR REPLACE PUBLIC SYNONYM WK$MIMETYPES FOR WKSYS.WK$MIMETYPES;
GRANT SELECT ON WK$MIMETYPES TO PUBLIC;

CREATE INDEX WK$MIMETYPES_IDX ON WK$MIMETYPES(ID);



PROMPT ... creating sequence WK$CHARSET_SEQ
CREATE SEQUENCE WK$CHARSET_SEQ START WITH 1 NOMAXVALUE NOCYCLE;

PROMPT ... creating table WK$CHARSET
CREATE TABLE WK$CHARSET
(
  ID        NUMBER NOT NULL,
  NAME      VARCHAR2(256) NOT NULL,
  ENCODING  VARCHAR2(256) NOT NULL,  
  MSG_ID        NUMBER UNIQUE
);

CREATE OR REPLACE PUBLIC SYNONYM WK$CHARSET FOR WKSYS.WK$CHARSET;
GRANT SELECT ON WK$CHARSET TO PUBLIC;

CREATE INDEX WK$CHARSET_IDX ON WK$CHARSET(ID);

PROMPT ... creating table WK$AUTHBASIC
CREATE TABLE WK$_AUTHBASIC
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  HOST           VARCHAR2(256)
  , REALM        VARCHAR2(470)
  , USERNAME     VARCHAR2(4000)
  , PASSWORD     VARCHAR2(4000)
  , PRIMARY KEY (WK$IID, HOST, REALM)
)
ORGANIZATION INDEX OVERFLOW;
CREATE OR REPLACE VIEW WK$AUTHBASIC AS
  SELECT * FROM WK$_AUTHBASIC
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$AUTHBASIC FOR WKSYS.WK$AUTHBASIC;
GRANT SELECT ON WK$AUTHBASIC TO PUBLIC;

PROMPT ... creating table WK$LANG
CREATE TABLE WK$LANG
(
  NLS_NAME      VARCHAR2(30) PRIMARY KEY,
  LANG_TAG      VARCHAR2(2),
  TERRITORY_TAG VARCHAR2(2),
  MSG_ID        NUMBER UNIQUE
);

CREATE OR REPLACE PUBLIC SYNONYM WK$LANG FOR WKSYS.WK$LANG;
GRANT SELECT ON WK$LANG TO PUBLIC;

PROMPT ... creating table WK$MAILLIST
CREATE TABLE WK$_MAILLIST
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  LID    INTEGER,
  LNAME  VARCHAR2(100),
  LDESC  VARCHAR2(200),
  LSEQ   INTEGER,
  LCOUNT INTEGER,
  LDSID  INTEGER,
  LPRIMARY VARCHAR2(1),
  PRIMARY KEY (WK$IID, LID),
  UNIQUE (WK$IID, LNAME)
);
CREATE OR REPLACE VIEW WK$MAILLIST AS
  SELECT * FROM WK$_MAILLIST
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$MAILLIST FOR WKSYS.WK$MAILLIST;
GRANT SELECT ON WK$MAILLIST TO PUBLIC;
GRANT INSERT ON WK$MAILLIST TO PUBLIC;
GRANT UPDATE ON WK$MAILLIST TO PUBLIC;

PROMPT ... creating sequence WK$MAILLIST$SEQ
CREATE SEQUENCE WK$MAILLIST$SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating table WK$CRAWLER_STAT
CREATE TABLE WK$_CRAWLER_STAT
(
  WK$IID          NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                         REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  ID              NUMBER,
  STAT_NAME       VARCHAR2(20) NOT NULL,
  STAT_VALUE      VARCHAR2(40) NOT NULL,
  PRIMARY KEY (WK$IID, ID, STAT_NAME)
);
CREATE OR REPLACE VIEW WK$CRAWLER_STAT AS
  SELECT * FROM WK$_CRAWLER_STAT
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;

CREATE OR REPLACE PUBLIC SYNONYM WK$CRAWLER_STAT FOR WKSYS.WK$CRAWLER_STAT;
GRANT SELECT ON WK$CRAWLER_STAT TO PUBLIC;

Rem
Rem Access Control
Rem

PROMPT ... creating context WK$CONTEXT
CREATE CONTEXT WK$CONTEXT USING WKSYS.WK_ADM;

Rem ----------------------------------------------------------------------
Rem BEGIN: Portal related objects
Rem ----------------------------------------------------------------------

PROMPT ... creating sequence WK$UNIQUE_STRINGID_SEQ 
CREATE SEQUENCE WK$UNIQUE_STRINGID_SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating sequence WK$PT_ID_SEQ 
CREATE SEQUENCE WK$PT_ID_SEQ START WITH 1 NOMAXVALUE;

PROMPT ... creating table WK$PORTAL
CREATE TABLE WK$_PORTAL
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  PT_ID          NUMBER,
  PT_NAME        VARCHAR2(740) NOT NULL,
  PT_URLBASE     VARCHAR2(740),
  PRIMARY KEY (WK$IID, PT_ID),
  UNIQUE (WK$IID, PT_NAME)
);
CREATE OR REPLACE VIEW WK$PORTAL AS
  SELECT * FROM WK$_PORTAL
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;
CREATE OR REPLACE PUBLIC SYNONYM WK$PORTAL FOR WKSYS.WK$PORTAL;
GRANT SELECT ON WK$PORTAL TO PUBLIC;

PROMPT ... creating table WK$PORTAL_DS_MAP
CREATE TABLE WK$_PORTAL_DS_MAP
(
  WK$IID         NUMBER DEFAULT SYS_CONTEXT('WK$CONTEXT','INST_ID')
                        REFERENCES WK$INSTANCE(INST_ID) ON DELETE CASCADE,
  PT_ID          NUMBER NOT NULL,
  DS_ID          NUMBER NOT NULL, 
  PRIMARY KEY (WK$IID, PT_ID, DS_ID)
);
CREATE OR REPLACE VIEW WK$PORTAL_DS_MAP AS
  SELECT * FROM WK$_PORTAL_DS_MAP
    WHERE WK$IID = SYS_CONTEXT('WK$CONTEXT','INST_ID')
  WITH CHECK OPTION;
CREATE OR REPLACE PUBLIC SYNONYM WK$PORTAL_DS_MAP FOR WKSYS.WK$PORTAL_DS_MAP;
GRANT SELECT ON WK$PORTAL_DS_MAP TO PUBLIC;

Rem ----------------------------------------------------------------------
Rem END: Portal related objects
Rem ----------------------------------------------------------------------

Rem -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Rem
Rem WARNING: No Dictionary Table should be created after this line
Rem
Rem -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

Rem ----------------------------------------------------------------------
Rem snapshot support views and temp tables
Rem ----------------------------------------------------------------------

prompt ... creating shanpshot supporting views
DECLARE
  TEMPLATE VARCHAR2(4000) :=
    'CREATE OR REPLACE VIEW %(V) AS'||
    ' SELECT * FROM %(T)'||
    '  WHERE WK$IID = SYS_CONTEXT(''WK$CONTEXT'', ''INST_SNAPSHOT'')'||
    ' WITH CHECK OPTION';
  VNAME VARCHAR2(100);
  STMT VARCHAR2(4000);
BEGIN
  FOR C IN (SELECT TABLE_NAME FROM DBA_TABLES
              WHERE OWNER = 'WKSYS' AND
                    TABLE_NAME LIKE 'WK$\_%' ESCAPE '\' AND
                    TABLE_NAME NOT IN ('WK$_TRACE', 'WK$_CRAWLER_STAT',
                                       'WK$_JOB_INFO', 'WK$_SYSINFO'))
  LOOP
    VNAME := REPLACE(C.TABLE_NAME, 'WK$_', 'WK$$');
    STMT := TEMPLATE;
    STMT := REPLACE(STMT, '%(T)', C.TABLE_NAME);
    STMT := REPLACE(STMT, '%(V)', VNAME);
    EXECUTE IMMEDIATE STMT;
    EXECUTE IMMEDIATE
      REPLACE('GRANT INSERT ON %(V) TO PUBLIC', '%(V)', VNAME);
  END LOOP;
END;
/

prompt ... creating shapshot supporting temporary tables

CREATE GLOBAL TEMPORARY TABLE WK$SNP_TAB
(
  TAB  VARCHAR2(100),
  RANK NUMBER
)
ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE WK$SNP_DEP
(
  PTAB VARCHAR2(100),
  FTAB VARCHAR2(100)
)
ON COMMIT DELETE ROWS;
