Rem
Rem $Header: wk0upgrade.sql 18-feb-2005.13:08:06 surman Exp $
Rem
Rem wk0upgrade.sql
Rem
Rem Copyright (c) 2001, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      wk0upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      02/18/05 - 4192910: Version to 9.2.0.7 
Rem    syang       11/29/04 - bug 3936668: validate_wk as validation proc 
Rem    wechin      07/09/02 - change version to 9.2.0.2.0
Rem    wechin      04/08/02 - bug 2310979
Rem    wechin      02/20/02 - bug 2233950 remove the dependency on env var
Rem    wechin      02/20/02 - change version to 9.2.0
Rem    syang       02/19/02 - set FALSE for LAUNCH_ANYWHERE argument
Rem    wechin      02/15/02 - update version number in component registry
Rem    wechin      01/09/02 - component registry
Rem    wechin      11/20/01 - change path for xmlparserv2
Rem    wechin      11/15/01 - drop wk_upgrade package body
Rem    wechin      11/08/01 - 
Rem    wechin      10/31/01 - version checking
Rem    wechin      10/29/01 - add more logging info
Rem    wechin      10/26/01 - 
Rem    wechin      10/22/01 - 
Rem    wechin      10/19/01 - 
Rem    wechin      10/18/01 - 
Rem    wechin      10/03/01 - 
Rem    wechin      10/02/01 - 
Rem    wechin      10/01/01 - 
Rem    wechin      09/28/01 - Created
Rem

PROMPT
PROMPT ==========  Ultra Search 9.2.0 Upgrade (In-place approach)  ===========
PROMPT

set feedback off verify off
set serveroutput on

spool wk0upgrade.log

rem parameters
define SYSPW                    = "&1"
define WKSYSPW                  = "&2"
define HOST			= "&3"
define PORT			= "&4"
define ORACLE_SID		= "&5"
define WK_TABLESPACE            = "&6"
define WK_TEMPTABLESPACE        = "&7"
define CONN_STRING              = "&8"
define ORACLE_HOME              = "&9"
define JAVA_EXE_PATH            = "&10"
define PATH_SEPARATOR		= "&11"

rem install specific variables
define PSEP			= &PATH_SEPARATOR
define JDBCDRIVER_PATH          = &ORACLE_HOME/jdbc/lib/classes12.zip
define JDBCNLS_PATH             = &ORACLE_HOME/jdbc/lib/nls_charset12.zip
define CTXHX                    = &ORACLE_HOME/bin/ctxhx.exe

rem other derived variables

define JAR_EXT			= jar
define JAVA_DBLINK              = &HOST:&PORT:&ORACLE_SID
define ISEARCHBIN               = &ORACLE_HOME/ultrasearch/bin
define ISEARCHLIB               = &ORACLE_HOME/ultrasearch/lib
define ISEARCHDATA              = &ORACLE_HOME/ultrasearch/data/
define ISEARCH_AGENT_PATH       = &ISEARCHLIB/agent/
define ISEARCH_PATH_1		= &ISEARCHLIB/ultrasearch.&JAR_EXT
define ISEARCH_PATH_2		= &ISEARCHLIB/ultrasearch_db.&JAR_EXT
define ISEARCH_PATH_3		= &ORACLE_HOME/lib/mail.&JAR_EXT
define ISEARCH_PATH_4		= &ORACLE_HOME/lib/activation.&JAR_EXT
define ISEARCH_PATH_5		= &ISEARCHLIB/jgl3.1.0.&JAR_EXT
define ISEARCH_PATH_6		= &ORACLE_HOME/lib/xmlparserv2.&JAR_EXT
define ISEARCH_PATH_7   	= &ORACLE_HOME/lib/xschema.&JAR_EXT


PROMPT 
PROMPT connect to the database as SYSDBA
PROMPT
connect SYS/&SYSPW@'&CONN_STRING' as sysdba

grant execute on SYS.DBMS_REGISTRY to WKSYS;
@@wkvalid.sql

PROMPT 
PROMPT connect to the database as 'WKSYS'
PROMPT
connect WKSYS/&WKSYSPW@'&CONN_STRING'

whenever sqlerror exit

PROMPT
PROMPT ... check the Ultra Search version 

declare
  l_version varchar2(20);
begin
  l_version := wk_util.get_version;
  if (substr(l_version,1,5) != '9.0.1') and
     (substr(l_version,1,5) != '1.0.3') then
    dbms_output.put_line('ERROR: this script can not migrate Ultra Search version '||l_version);
    raise wk_def.isearch_error;
  end if;
  dbms_output.put_line('The current Ultra Search version is '||l_version); 
end;
/

REM ========================================================================
REM Registry to upgrading state
REM ========================================================================

execute dbms_registry.upgrading('WK', 'Oracle Ultra Search', 'VALIDATE_WK', 'WKSYS');

whenever sqlerror continue

PROMPT ... start backup user instances data
declare
  l_stmt varchar2(4000);
  l_schema varchar2(100);
  l_name varchar2(100);  
begin
  for inst in (select inst_schema, inst_name from wk$instance) loop
    l_schema := inst.inst_schema;
    l_name := inst.inst_name;

    dbms_output.put_line('... backup user instance "'||l_name||'"');

    -- rename wk$url to wk$url_tmp
    l_stmt := 'alter table '||l_schema||'.wk$url rename to wk$url_tmp';
    execute immediate l_stmt;

    -- rename wk$url_sig_idx index
    l_stmt := 'alter index '||l_schema||'.WK$URL_SIG_IDX rename to '
	   || ' WK$URL_SIG_IDX_tmp';
    execute immediate l_stmt;

    -- rename wk$url_dsid_status_idx index
    l_stmt := 'alter index '||l_schema||'.WK$URL_DSID_STATUS_IDX rename to '
	   || ' WK$URL_DSID_STATUS_IDX_tmp';
    execute immediate l_stmt;

    -- drop triggers
    l_stmt := 'drop trigger '||l_schema||'.WK$INS_TRIG';
    execute immediate l_stmt;

    l_stmt := 'drop trigger '||l_schema||'.WK$del_TRIG';
    execute immediate l_stmt;

    l_stmt := 'drop trigger '||l_schema||'.WK$upd_TRIG';
    execute immediate l_stmt;

    l_stmt := 'drop trigger '||l_schema||'.WK$before_ins_TRIG';
    execute immediate l_stmt;

    -- drop wk$doc_path_idx index
    l_stmt := 'drop index '||l_schema||'.wk$doc_path_idx';
    execute immediate l_stmt;

    -- drop wk$doc table
    l_stmt := 'drop table '||l_schema||'.wk$doc';
    execute immediate l_stmt;
   
    -- rename wk$statistic to wk$statistic_tmp
    l_stmt := 'alter table '||l_schema||'.wk$statistic rename to '
	   || ' wk$statistic_tmp';
    execute immediate l_stmt;

    -- rename wk$statistic_n1 index
    l_stmt := 'alter index '||l_schema||'.WK$STATISTIC_N1 rename to '
	   || ' WK$STATISTIC_N1_tmp';
    execute immediate l_stmt;

    -- rename wk$statistic_n2 index
    l_stmt := 'alter index '||l_schema||'.WK$STATISTIC_N2 rename to '
	   || ' WK$STATISTIC_N2_tmp';
    execute immediate l_stmt;

    -- drop sequence wk$statistic_seq
    l_stmt := 'drop sequence '||l_schema||'.wk$statistic_seq';
    execute immediate l_stmt;

  end loop;
end;
/
PROMPT ... backup user instances completed

whenever sqlerror continue

PROMPT ... dropping 9.0.1 PL/SQL packages
drop package wk_def;
drop package wk_util;
drop package wk_adm;
drop package wk_crw;
drop package wkds_adm;
drop package wk_job;
drop package wk_sgp;
drop package wk_query_adm;
drop package wk_ddl;
drop package wk_err;
drop package wk_qutil;
drop package wk_queryapi;
drop package wkig;
drop package wk_queryexp;

PROMPT ... dropping 9.0.1 stored procedures
drop procedure WK$PRE_OPTIMIZE_INDEX;
drop procedure WK$POST_OPTIMIZE_INDEX;
drop procedure WK$BEFORE_INS_PROC;

PROMPT ... dropping 9.0.1 context 'wk$context'
drop context wk$context;

PROMPT ... dropping 9.0.1 user roles
drop role wkuser;
drop role wkadmin;

PROMPT ... dropping 9.0.1 table synonyms
drop public synonym wk$inst_admin_list;
drop public synonym wk$inst_list;
drop public synonym wk$sys_admin;
drop public synonym wk$data_source;
drop public synonym wk$tds_log;
drop public synonym wk$source_group;
drop public synonym wk$group_ds_mapping;
drop public synonym wk$job_info;
drop public synonym wk$crawler_sched;
drop public synonym wk$sched_mapping;
drop public synonym wk$crawler_config;
drop public synonym wk$crawler_config_default;
drop public synonym wk$attribute;
drop public synonym wk$attr_mapping;
drop public synonym wk$mimetypes;
drop public synonym wk$charset;
drop public synonym wk$lang;
drop public synonym wk$trace;
drop public synonym wk$maillist;
drop public synonym wk$crawler_stat;

PROMPT ... dropping 9.0.1 stored package synonyms
drop public synonym wk_def;
drop public synonym wk_util;
drop public synonym wk_adm;
drop public synonym wk_crw;
drop public synonym wkds_adm;
drop public synonym wk_job;
drop public synonym wk_sgp;
drop public synonym wk_query_adm;
drop public synonym wk_ddl;
drop public synonym wk_err;
drop public synonym wk_qutil;
drop public synonym wk_queryapi;

PROMPT ... dropping 9.0.1 database sequences
drop sequence wk$inst_seq;
drop sequence wk$ds_id_seq;
drop sequence wk$sg_id_seq; 
drop sequence wk$job_id_seq;     
drop sequence wk$crawlerid_seq;
drop sequence wk$trace_seq; 
drop sequence wk$attr_seq; 
drop sequence wk$maillist$seq;
drop sequence wk$CHARSET_SEQ;
drop sequence WK$SCHED_ID_SEQ;
drop sequence WK$MIMETYPES_SEQ;

PROMPT ... clean up Oracle Text dictionary
begin
  ctxsys.ctx_adm.recover;
end;
/

PROMPT ... dropping 9.0.1 VPD policy
declare
  type namelist is varray(100) of varchar2(30);
  tab namelist := namelist('WK$ATTRIBUTE',
                           'WK$ATTR_MAPPING',
                           'WK$CRAWLER_CONFIG',
                           'WK$CRAWLER_SCHED',
                           'WK$DATA_SOURCE',
                           'WK$TDS_LOG',
                           'WK$GROUP_DS_MAPPING',
                           'WK$JOB_INFO',
			   'WK$MAILLIST',
                           'WK$SCHED_MAPPING',
                           'WK$SOURCE_GROUP',
                           'WK$SYS_ADMIN',
                           'WK$TRACE',
			   'WK$CRAWLER_STAT');
  sch  varchar2(30) := 'WKSYS';
  pol  varchar2(30) := 'WK$INSTADMIN_POL';
begin
  for i in 1..tab.count loop
    dbms_rls.drop_policy(sch, tab(i), pol);
  end loop;
  -- drop vpd policy for wk$sysinfo
  dbms_rls.drop_policy(sch, 'WK$SYSINFO', 'WK$SYSINFO_POL');
end;
/

PROMPT ... dropping 9.0.1 table constraints
alter table wk$attr_mapping drop constraint WK$AM_TYPE_CONST;

PROMPT ... dropping 9.0.1 database triggers
drop trigger wk$attr_trig;
drop trigger wk$attr_mapping_trig;

PROMPT ... backup 9.0.1 dictionary tables
rename wk$instance         to wk$instance_tmp;
rename wk$inst_admin	   to wk$inst_admin_tmp;
rename wk$sysinfo	   to wk$sysinfo_tmp;
rename wk$sys_admin        to wk$sys_admin_tmp;
rename wk$data_source      to wk$data_source_tmp;
rename wk$tds_log	   to wk$tds_log_tmp;
rename wk$source_group	   to wk$source_group_tmp;
rename wk$group_ds_mapping to wk$group_ds_mapping_tmp;
rename wk$job_info         to wk$job_info_tmp;
rename wk$crawler_sched	   to wk$crawler_sched_tmp;
rename wk$sched_mapping	   to wk$sched_mapping_tmp;
rename wk$crawler_config   to wk$crawler_config_tmp;
rename wk$trace	           to wk$trace_tmp;
rename wk$attribute	   to wk$attribute_tmp;
rename wk$attr_mapping	   to wk$attr_mapping_tmp;
rename wk$maillist	   to wk$maillist_tmp;
rename wk$crawler_stat     to wk$crawler_stat_tmp;
rename wk$crawler_config_default to wk$crawler_config_default_tmp;

PROMPT ... backup 9.0.1 dictionary table indexes
alter index WK$CC_IDX           rename to WK$CC_IDX_tmp;
alter index WK$ATTR_MAPPING_IDX rename to WK$ATTR_MAPPING_IDX_tmp;


PROMPT ... dropping 9.0.1 seed data tables
drop table wk$lang;
drop table wk$mimetypes;
drop table wk$charset;

PROMPT
PROMPT =======  start install 9.2.0 database objects  =======
PROMPT

PROMPT 
PROMPT connect to the database as SYSDBA
PROMPT
connect SYS/&SYSPW@'&CONN_STRING' as sysdba

PROMPT ... setup 9.2.0 system privilege
@&ORACLE_HOME/ultrasearch/admin/wk0csys.sql SYS &SYSPW &WKSYSPW &WK_TABLESPACE &WK_TEMPTABLESPACE

PROMPT 
PROMPT connect to the database as 'WKSYS'
PROMPT
connect WKSYS/&WKSYSPW@'&CONN_STRING'

PROMPT ... loading 9.2.0 java stored packages
@&ORACLE_HOME/ultrasearch/admin/wk0loadjava.sql &ISEARCHLIB

PROMPT ... loading other 9.2.0 database objects
@&ORACLE_HOME/ultrasearch/admin/wk0inst.sql &ISEARCHDATA &CTXHX &JAVA_EXE_PATH &JAVA_DBLINK &ISEARCH_AGENT_PATH HARDCODED FALSE

@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &JDBCDRIVER_PATH
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&JDBCNLS_PATH 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_1 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_2 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_3 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_4 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_5 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_6 
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCH_PATH_7
@&ORACLE_HOME/ultrasearch/admin/wk0addcpath.sql &PSEP&ISEARCHBIN 

PROMPT ... creating temporary migration tables
create table wk$ds_migration
(
  wk$iid    number,
  old_ds_id number,
  new_ds_id number
);

whenever sqlerror exit

PROMPT ... loading the upgrade package 'WK_UPGRADE'
@@wk0upgrade.pkh
@@wk0upgrade.plb
show errors

whenever sqlerror continue

PROMPT ... creating the database context for data migration
create context wk$migrate_context using wksys.wk_upgrade;

whenever sqlerror exit
set serveroutput on

PROMPT
PROMPT =======  start user data migration  =======
PROMPT

PROMPT ... migrating default crawler configuration
exec wk_upgrade.migrate_default_crawler_config;

PROMPT ... re-creating all of the user instances
exec wk_upgrade.recreate_instances;

PROMPT ... migrating system administration configuration
exec wk_upgrade.migrate_data('SYS_ADMIN');

PROMPT ... migrating data sources
exec wk_upgrade.migrate_data('DATA_SOURCE');

PROMPT ... migrating data source groups
exec wk_upgrade.migrate_data('DATA_GROUP');

PROMPT ... migrating attributes
exec wk_upgrade.migrate_data('ATTRIBUTE');

PROMPT ... migrating crawler configuration
exec wk_upgrade.migrate_data('CRAWLER_CONFIG');

PROMPT ... migrating crawling schedules
exec wk_upgrade.migrate_data('CRAWLER_SCHEDULE');

PROMPT ... migrating trace logs
exec wk_upgrade.migrate_data('TRACE');

PROMPT ... migrating email mailing list
exec wk_upgrade.migrate_data('MAIL_LIST');

PROMPT ... migrating table data source logging
exec wk_upgrade.migrate_data('TDS_LOG');

PROMPT ... migrating query statistics
exec wk_upgrade.migrate_data('QUERY_STAT');

PROMPT ... migrating URL table
exec wk_upgrade.migrate_data('URL');

PROMPT
PROMPT ======= end of user data migration  =======
PROMPT

set serveroutput off

whenever sqlerror continue

PROMPT ... dropping the upgrade package
drop package body wk_upgrade;
drop package wk_upgrade;

PROMPT ... dropping temporary migration tables
drop table wk$ds_migration;

PROMPT ... dropping 9.0.1 instance tables
declare
  l_stmt varchar2(4000);
  l_schema varchar2(100);
begin
  -- drop 9.0.1 instance tables for each of the user instance
  for inst in (select inst_schema from wk$instance_tmp) loop
    l_schema := inst.inst_schema;

    -- drop wk$url_tmp table
    l_stmt := 'drop table '||l_schema||'.wk$url_tmp';
    execute immediate l_stmt;

    -- drop wk$statistic_tmp table
    l_stmt := 'drop table '||l_schema||'.wk$statistic_tmp';
    execute immediate l_stmt;

  end loop;
end;
/

PROMPT ... dropping 9.0.1 dictionary tables

drop table wk$inst_admin_tmp;
drop table wk$sysinfo_tmp;
drop table wk$sys_admin_tmp;
drop table wk$tds_log_tmp;
drop table wk$group_ds_mapping_tmp;
drop table wk$job_info_tmp;
drop table wk$sched_mapping_tmp;
drop table wk$crawler_sched_tmp;
drop table wk$crawler_config_tmp;
drop table wk$trace_tmp;
drop table wk$attr_mapping_tmp;
drop table wk$attribute_tmp;
drop table wk$maillist_tmp;
drop table wk$crawler_stat_tmp;
drop table wk$crawler_config_default_tmp;
drop table wk$source_group_tmp;
drop table wk$data_source_tmp;
drop table wk$instance_tmp;

PROMPT ... dropping the migration context
drop context wk$migrate_context;

REM ========================================================================
REM Registry to upgraded state
REM ========================================================================
declare
  ver varchar2(80);
begin
  ver := '9.2.0.7.0';
  dbms_registry.upgraded('WK', ver, 
                         'Oracle Ultra Search Release '||ver||' - Production');
end;
/

PROMPT
PROMPT ==============  End of Upgrade  ==============
PROMPT

spool off

set feedback off verify on

exit

