Rem
Rem $Header: wkpatch.sql 01-apr-2005.15:13:56 surman Exp $
Rem
Rem wkpatch.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      wkpatch.sql - patch script for 9.2.0.2 release
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      04/01/05 - 4066157: Grant sysadmin to orcladmin 
Rem    syang       11/22/04 - 3936668 backport: validate_wk
Rem    wechin      08/21/02 - add loadjava and grant statements
Rem    wechin      07/15/02 - wechin_add_upgrade_patch_020709
Rem    wechin      07/09/02 - Created
Rem

PROMPT ... granting privileges to WKSYS
grant select on SYS.GV_$INSTANCE to WKSYS;
grant select on SYS.V_$DATABASE to WKSYS;

Rem Create validate_wk procedure under SYS
@@wkvalid.sql

alter session set current_schema = WKSYS;

PROMPT ==========  Updating sys.registry$ (running as SYS)  ==========
PROMPT

update sys.registry$ set invoker#=0 where cid='WK';
commit;
/

PROMPT ==============  Loading Ultra Search components  ==============
PROMPT

execute dbms_registry.loading('WK', 'Oracle Ultra Search', 'VALIDATE_WK', 'WKSYS');

PROMPT ... loading Ultra Search Java stored packages
declare
  lib_path varchar2(1000);
begin
  select ccd_pvalue into lib_path
    from wk$crawler_config_default 
    where ccd_pname = 'CC_DS_AGENT_PATH';
  lib_path := substr(lib_path,1,instr(lib_path,'lib')+3);
  sys.dbms_java.loadjava('-schema WKSYS -v -f -r -synonym -grant PUBLIC ' ||
    lib_path || 'ultrasearch_db.jar', '((* wksys) (* public))');
end;
/

PROMPT ... loading Ultra Search PL/SQL package headers
@@wk0pkh.sql

PROMPT ... loading Ultra Search PL/SQL package bodies
@@wk0plb.sql

PROMPT ... granting sysadmin privileges to ORCLADMIN user
begin
  wk_adm.grant_sysadmin('orcladmin', 1, 'G', 'DEFAULT COMPANY');
end;
/

REM ========================================================================
REM Registry to installed state
REM ========================================================================

declare
  ver varchar2(80);
begin
  -- ver := '9.2.0.7.0';
  dbms_registry.loaded('WK');
end;
/

alter session set current_schema = SYS;
execute SYS.VALIDATE_WK;
